#!/bin/bash
# Copyright © 2016 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.

OUTPUT=/var/log/Lenovo_Support/guihelp.dat
OUTPUT_FOLDER=/var/log/Lenovo_Support/
GREP=grep
SUSE_PATH=/etc/SuSE-release
RHEL_PATH=/etc/redhat-release
ISSUE_PATH=/etc/issue
MCP_PATH=/etc/system-release
OSR_PATH=/etc/os-release

OS_PATH=""
OS_ID=
DIR_PATH=""
ID=""
PROCESS_COUNT="0"
DISK_INFO=""

INSTALLER=install300
#INSTALLER=test1223

USAGE="Usage: guihelper.sh [[--kill process_name]||[[--pc process_count]--isrunning process_name]||[--delete file_name]]"

# This number should be same as uxspi\src\dsa\client\uxlite\OSArchType.h  !!!
function get_OS_ID()
{
	case $1 in
	7)
		OS_ID=209
		;;
	8)
		OS_ID=212
		;;
	9)
		OS_ID=214
		;;
	12)
		OS_ID=210
		;;
	15)
		OS_ID=211
		;;
	*)
		OS_ID=-1
		;;
	esac
}

function get_usb_devices() {
    local usb_device_label=""
    local usb_device_labels=""
    local usb_device=""
    local usb_devices=""

    usb_device_labels=`ls /proc/scsi/usb-storage 2>/dev/null`

    if [ "${usb_device_labels}" == "" ] ; then
        usb_devices="NULL"
    else
        for usb_device_label in ${usb_device_labels} ; do
            usb_device="/dev/"`ls /sys/class/scsi_device/\
${usb_device_label}\:0\:0\:0/device/block/ 2>/dev/null`
            if echo $usb_device|grep "[0-9]$" >/dev/null 2>&1;then
                continue
            fi
            usb_devices=${usb_devices}${usb_device}";"
        done
    fi

    DISK_INFO="${usb_devices}"

    return 0
}

function get_exe_path() {
	CUR_PATH=`pwd`

# This compare is useless!!! $DIR_NAME can't be empty!!!
	if [ "$DIR_NAME" = "" ]
	then
		echo "Can't Get Directory path, It run by PATH!!!"
		exit 1
	fi

	IS_DOT=`echo $DIR_NAME | cut -c 1`
	if [ "$IS_DOT" = "." ]
	then
		if [ "$DIR_NAME" = "." ]
		then
			DIR_PATH=$CUR_PATH
		else
			DIR_WITHOUT_DOT=`echo $DIR_NAME |sed 's/^\.\(.*\)/\1/g'`
			DIR_PATH=$CUR_PATH$DIR_WITHOUT_DOT
		fi
	else
		DIR_PATH=$DIR_NAME
	fi
}

function print_proxy() {
	if [ $# -ne 2 ]
	then
		echo "Usage: print_info output_path current_bash_name"
		return 1	
	fi

	proxy_content=$(env |grep "http_proxy")
	#it will cause some errors if we only use this env to make a decision
	#if [ "${proxy_content}" = "" ] 
	if true
	then 
		echo  "IBM_PROXY_ENABLED=NO" >>$1
		echo  "IBM_PROXY_ADDRESS=NULL" >>$1
		echo  "IBM_PROXY_PORT=NULL" >>$1
		echo  "IBM_PROXY_USERNAME=NULL" >>$1
		echo  "IBM_PROXY_PASSWORD=NULL" >>$1
	else
		echo  "IBM_PROXY_ENABLED=YES" >>$1
		proxy_userpass=$(echo -n "${http_proxy}" | grep -o "http://.*@")
		#proxy_addrport=$(echo -n "${http_proxy}" | grep -o "^@
		if [ "${proxy_userpass}" = "" ]
		then
			#@ not found, only address and port present, extract them
			
			proxy_addr=$(echo -n "${http_proxy}"|sed 's/\(http:\/\/.*\):.*/\1/g')
			proxy_port=$(echo -n "${http_proxy}"|sed 's/.*:\(.*\)/\1/g')
			
			echo -n "IBM_PROXY_ADDRESS="  >>$1
			echo "${proxy_addr}" >>$1
			echo -n "IBM_PROXY_PORT=" >>$1
			echo "${proxy_port}" >>$1
			
			echo  "IBM_PROXY_USERNAME=NULL" >>$1
			echo  "IBM_PROXY_PASSWORD=NULL" >>$1
		else
			#extract all 4 fields ..... format: http://username:pass@ip(url):port
			proxy_userpass=$(echo -n "${proxy_userpass}" |sed 's/http:\/\/\(.*\)\@/\1/g')
			proxy_addrport=$(echo -n "${http_proxy}"|sed 's/.*@//g')

			proxy_addrport="http://""${proxy_addrport}"
			
			proxy_user=$(echo -n "${proxy_userpass}" |sed 's/\(.*\):.*/\1/g')
			proxy_password=$(echo -n "${proxy_userpass}" |sed 's/.*:\(.*\)/\1/g')
			proxy_addr=$(echo -n "${proxy_addrport}"|sed 's/\(http:\/\/.*\):.*/\1/g')
			proxy_port=$(echo -n "${proxy_addrport}"|sed 's/.*:\(.*\)/\1/g')
			
			echo -n "IBM_PROXY_ADDRESS="  >>$1
			echo "${proxy_addr}" >>$1
			echo -n "IBM_PROXY_PORT=" >>$1
			echo "${proxy_port}" >>$1
			echo -n "IBM_PROXY_USERNAME=" >>$1
			echo  "${proxy_user}" >> $1
			echo -n "IBM_PROXY_PASSWORD=" >>$1
			echo  "${proxy_password}" >>$1
		fi
	fi
}

function getMt()
{
	echo "Get machine type from the outputs of \"dmidecode\" command."
	local MT_STR_LENGTH=4
	echo "Parse \"Product Name\" field."
	local product_name=`dmidecode | grep -w -A 10 "DMI type 1" | grep "Product Name"`
	MTID=`echo ${product_name} | sed -e 's/.*\[\([0-9a-zA-Z]\{4\}\).*\].*/\1/'`
	if [ ${#MTID} -eq ${MT_STR_LENGTH} ]
	then
		return 0
	fi

	echo "Cannot get machine type from \"Product Name\" field."
	echo "Try to parse \"SKU Number\" field."
	local sku_number=`dmidecode | grep -w -A 10 "DMI type 1" | grep "SKU Number"`
	MTID=`echo ${sku_number} | sed -e 's/SKU Number: \([0-9a-zA-Z]\{4\}\).*/\1/'`
	if [ ${#MTID} -eq ${MT_STR_LENGTH} ]
	then
		return 0
	fi

	echo "Failed to get machine type."
	MTID="NONE"
	return 1
}

function print_info() {
	if [ $# -ne 2 ]
	then
		echo "Usage: print_info output_path current_bash_name"
		return 1	
	fi

	# get exe path, &  save it in DIR_PATH
	get_exe_path
	# get machine type
	MTID="NONE"
	getMt
	echo "Machine type: ${MTID}"

	echo -n "IBM_SYSTEM_MT=" >$1
	echo $MTID >> $1

# output operating system type
	if [ -e ${SUSE_PATH} ]
	then 
		OS_PATH=${SUSE_PATH}
	    OSID=`cat ${OS_PATH}|sed '2,$d' |sed 's/[^0-9]* \([0-9][0-9]*\).*/\1/' |awk '{print $1}'`
	elif [ -e ${RHEL_PATH} ]
	then
		OS_PATH=${RHEL_PATH}
	    OSID=`cat ${OS_PATH}|sed '2,$d' |sed 's/[^0-9]* \([0-9][0-9]*\).*/\1/' |awk '{print $1}'`
	elif [ -e ${OSR_PATH} ]
	then
        OS_PATH=${OSR_PATH}
        OSID=`cat ${OS_PATH} |grep "^VERSION="|sed -e 's/VERSION="\([0-9]*\).*/\1/g'`
	else
		echo "Can't find OS info file!"
		exit 1
	fi
	get_OS_ID $OSID	
	echo "IBM_SYSTEM_OS=$OS_ID" >> $1
	#echo $1
		
	#cat $OS_PATH|sed '2d' >> $1

# print the architecture of OS
	print_osArch $1

# output exe path 
	echo -n "IBM_SYSTEM_DIR=" >> $1
	echo $DIR_PATH>> $1

# output Disk list
#	echo -n "IBM_SYSTEM_USBDISK=" >>$1
#	diskInfo=$(fdisk -l |grep "Disk"|awk 'BEGIN{ORS=""} {print $2}' |sed 's/:/;/g')
#	echo "${diskInfo}" >>$1
	echo -n "IBM_SYSTEM_USBDISK=" >>$1
	get_usb_devices
	echo "${DISK_INFO}" >> $1
  	
# ouput proxy setting
	print_proxy $1 $2

	#echo $IBM_SYSTEM_ANYOS
	#cgc_modify
	echo -n "IBM_SYSTEM_ANYOS=">>$1	
	if [ -e ${ISSUE_PATH} ]
	then 
	    ANYOS=`cat ${ISSUE_PATH}|sed 's/[^0-9]* \([0-9][0-9]*\).*/\1/'`
	    echo $ANYOS>> $1
	else
	    echo "anyos">>$1
	fi  

# out put process permissions
	echo -n "IBM_SYSTEM_ADMIN=">>$1
	if [ ${EUID} -eq 0 ]
	then
	    echo "YES" >> $1
	else
	    echo "NO">>$1
	fi  
}

function print_running_info()
{
	# echo "start print_running_info() 301"
	# output if installer is running 
	if [ $# -eq 4 ] 
	then
		PC=$4
	elif [ $# -eq 3 ]
	then
		PC=""
	else
		echo "Usage: print_running_info process_name current_bash_name output_path process_count"
		return 1	
	fi

	echo -n "IBM_SYSTEM_RUNNING=" >>$3
	#echo "Check if Process["$1"] is running..."
	#ID=`ps -ef |grep "\/$1" |grep -v "${GREP}" |awk '{print $2}' `
	#ID=`ps -ef |grep "$1$" |grep -v "${GREP}"|grep -v "$2"|awk '{print $2}'`
	ID=`ps -ef |grep "$1" |grep -v "${GREP}"|grep -v "$2"|awk '{print $2}'`
	#echo "$ID"

	PC_RES=$(echo "$ID" | wc -l )
	if [ "$ID" != "" ] &&  [ -z $PC ]
	then 
		echo "${1}" >>$3
	elif [ "$ID" != "" ] && [ $PC -le $PC_RES ] 
	then
		echo "${1}" >>$3
	else
	  echo "NULL" >>$3
		#echo "Process["$1"] is not running!!!"
	fi
}

function kill_process()
{
	# echo "start kill_process() 355"
	# output if installer is running 
	if [ $# -ne 2 ]
	then
		echo "Usage: kill_process process_name current_bash_name"
		return 1	
	fi

	#ps -ef |grep "$1"
	#ID=`ps -ef |grep "\/$1" |grep -v "${GREP}" |awk '{print $2}' `
	ID=`ps -ef |grep "$1" |grep -v "${GREP}"|grep -v "$2"|awk '{print $2}'`
	#echo "$ID"

	if [ "$ID" != "" ]
	then
		#echo "Prepare kill Process["$1"] with PID:"$ID
		#kill   $ID
		#count=$(echo "$ID"|wc -l)
		#if [ $count -eq 2 ]
		#then
			kill `echo "$ID" | sed '$!d' `
		#fi
	#else
		#echo "Can not find Process["$1"] with PID:"$ID
	fi

	#if [ $? -ne 0 ]
	#then
	#	echo "Kill process["$1"] with PID:"$ID" failed!"
	#else
	#	echo "Kill process["$1"] with PID:"$ID" sucess!"
	#fi
}
function delete_file()
{
	# echo "start delete_file() 369"
	if [ $# -ne 1 ]
	then
		echo "Usage: delete_file file_name"
		return 1
	fi

	rm -rf $1
}

function print_osArch()
{
	# echo "start print_osArch(): 389"
	echo -n "IBM_SYSTEM_ARCH=" >> $1
	arch=`uname -m | grep 64`
	if [ $? -ne 0 ]
	then
		echo "32" >>$1
	else
		echo "64" >>$1
	fi
}

function parse_parm ()
{
# Test parameter
	# if [ $# -gt 4 ] || [ $# -eq 1 ] || [ $# -eq 3 ]
	if [ $# -ne 4 ] && [ $# -ne 6 ]
 	then
		echo ${USAGE}
		# echo "ERROR 396"
		exit 1
	fi
	
	# echo $1
	# echo $2
	# echo $3
	# echo $4
	# echo $5
	# echo $6
	if [ $# -eq 4 ] && [ "$1" == "--dir" ]
	then
		# echo "parameter number is 4, 421"
		OUTPUT_FOLDER=$2
		OUTPUT=$2$4
	elif [ $# -eq 6 ] && [ "$3" == "--dir" ]
	then
		# echo "parameter number is 6, 425"
		OUTPUT_FOLDER=$4
		OUTPUT=$4$6
	else
		# echo "default case, 428"
		OUTPUT_FOLDER=/var/log/Lenovo_Support/
		OUTPUT=/var/log/Lenovo_Support/guihelp.dat
	fi

	echo ${OUTPUT}
	mkdir -p $OUTPUT_FOLDER >/dev/null 2>/dev/null
	# mkdir -p /var/log/Lenovo_Support >/dev/null 2>/dev/null

# Get installer name & directory path
	BASH_NAME=`basename ${0}`
	DIR_NAME=`dirname ${0}`
	echo $BASH_NAME
	echo $DIR_NAME
	
	if [ "$BASH_NAME" =  "" ]
	then 
		echo "Can't get installer name, exit!"
		exit 1
	fi

	if [ "$DIR_NAME" = "" ]
	then
		echo "Can't get directory path, exit!"
		exit 1
	fi
	
# Print system info
	if [ $# -eq 4 ]
	then
		# echo "go into query path"
		print_info ${OUTPUT} $BASH_NAME
		exit 0
	fi

# Print system info & installer running info
	if [ "$1" = "--delete" ]
	then
		# echo "go into delete path"
		delete_file $2
		exit 0
	elif [ "$1" = "--kill" ]
	then
		# echo "go into kill path"
		print_info ${OUTPUT} $BASH_NAME
		kill_process $2 $BASH_NAME
		PROCESS_COUNT=2
		print_running_info $2 $BASH_NAME ${OUTPUT} $PROCESS_COUNT
		exit 0
	elif [ "$1" = "--pc" ] && [ $# -eq 4 ] && [ "$3" = "--isrunning" ]
	then
		PROCESS_COUNT=$2
		tmp_var=`expr $PROCESS_COUNT : "[0-9]*$"`
		if [ $tmp_var -eq 0 ]
		then
			echo ${USAGE}
			exit 1
		fi
		print_info ${OUTPUT} $BASH_NAME
		print_running_info $4 $BASH_NAME ${OUTPUT} $PROCESS_COUNT
		exit 0
	elif [ "$1" = "--isrunning" ]
	then
		# echo "go into isrunning path"
		PROCESS_COUNT=1;
		print_info ${OUTPUT} $BASH_NAME
		print_running_info $2 $BASH_NAME ${OUTPUT} $PROCESS_COUNT
		exit 0
	else 
		echo "NULL" ${USAGE}
		exit 1
	fi
}

# Begin of the script
parse_parm $@ 


#########################
#df -l |sed '1d'|awk  'BEGIN{ORS=":"};{print $1}; END{ORS=""; print "\n"}' >> $1
#ps -ef |grep "${INSTALLER}" |awk 'BEGIN{isGet=1};{if(NR>1 && isGet) {isGet=0; c=$2;}}; END{if(c) print "'${INSTALLER}':"c}' >> ${OUTPUT}
#ID=$(ps -ef |grep "${INSTALLER}" |awk 'BEGIN{isGet=1};{if(NR>1 && isGet) {isGet=0; c=$2; }}; END{if(c) {print "'${INSTALLER}':"c >>"'${OUTPUT}'"; print c}}')
#ID=` ps -ef |grep "${INSTALLER}" |awk '{print $2}' |sort |awk '{if (NR>1) {print id; exit}; id=$1}'` 

#------------------------------------------
# output if installer is running 
#echo -n "IBM_SYSTEM_RUNNING=" >>$1
#ID=`ps -ef |grep "\/${INSTALLER}" |grep -v "${GREP}" |awk '{print $2}' `
#ID=`ps -ef |grep "\/${INSTALLER}" |grep -v "${GREP}"|grep -v "$2"|awk '{print $2}' `
#echo $ID
#if [ "$ID" != "" ]
#then 
#	echo -n "${INSTALLER}" >>$1
#fi
#------------------------------------------
	# change the output data
	#echo -n "IBM_SYSTEM_RUNNING=" >>$3
	#if [ "$ID" != "" ]
	#then 
	#	echo -n "${1}" >>$3
	#fi
#------------------------------------------
	#test $ID > 1 && echo -n "${INSTALLER}" >>$3
#------------------------------------------

#########################
