// Copyright © 2015 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
#ifndef _REPO_RGLOBAL_H
#define _REPO_RGLOBAL_H

#include <string>

#if defined(R_ARCH) && (R_ARCH == 1)
#define R_HAS_FUSIONIO
#define R_HAS_MELLANOX
#ifdef R_PREBOOT
#define R_HAS_INTELNIC
#define R_HAS_NVIDIA
#endif
#endif

#define LIBREPO_BEGIN_NAMESPACE \
    namespace onecli {          \
    namespace repository {
#define LIBREPO_END_NAMESPACE \
    }                         \
    }

#ifdef _WIN32
#ifdef LIBREPO_STATIC
#define LIBREPO_API
#else
#ifdef LIBREPO_EXPORTS
#define LIBREPO_API __declspec(dllexport)
#else
#define LIBREPO_API __declspec(dllimport)
#endif
#endif
#define LIBREPO_LOAD_SYMBOL GetProcAddress
#define LIBREPO_FREE FreeLibrary
#else
#if __GNUC__ >= 4
#define LIBREPO_API __attribute__((visibility("default")))
#else
#define LIBREPO_API
#endif
#define LIBREPO_LOAD_SYMBOL dlsym
#define LIBREPO_FREE dlclose
#endif

#ifdef _WIN32
#pragma warning(disable: 4996)
#ifndef _DLL /* msvc assumed */
#error CRT dynamic link is required.
#endif
#endif

LIBREPO_BEGIN_NAMESPACE

/** String pair */
typedef std::pair<std::string, std::string> RStringPair;
/** Callback for running inventory */
typedef void (*RInventoryCallback)(const std::string &type, const std::string &display);

/*for each case, inventory has different XML schema for it, which it  means different XML report, HTML report*/
enum RInventoryCase {
    IB_WINDOWS = 0,
    IB_SLES,
    IB_RHEL,
    IB_PREBOOT,
    OOB_CASE,
    ESXI_CASE,
    CMM_CASE,
    SMM_CASE,
    THINK_SERVER_WIN,
    THINK_SERVER_SLES,
    THINK_SERVER_RHEL,
    AMD_WIN,
    AMD_SLES,
    AMD_RHEL,
    ST5X_WIN,
    ST5X_SLES,
    ST5X_RHEL,
    IB_UBUNTU,
    CFC_WIN,
    CFC_RHEL,
    CFC_SLES,
    CFC_OOB,
    INVENTORY_CASE_MAX
};

LIBREPO_END_NAMESPACE

#endif
