#!/bin/bash
# install.sh
# Update HDD firmware on all LSI IR/MR attached drives
file="/proc/distro_id"
BOMC="NO"

if [ -e "$file" ]; then
   cat /proc/distro_id | grep -q mcp
   rc=$?

   if [ $rc -eq 0 ]; then
	  BOMC="YES"
   fi
fi
#
# Check for the architecture
#
if [ `uname -p` == "x86_64" ]; then
	arch=64
else
	echo "This OS architecture is not supported".
    exit 171
fi

if [ ! -d /var/log/Lenovo_Support ]; then
	mkdir /var/log/Lenovo_Support
fi

LOGPATH=/var/log/Lenovo_Support/ssdcli_$(date +%Y%m%d%H%M%S).log

#
# Check for the library dependency
#
if ldd storelibir-3.so.64-6 | grep -q "libstdc++.so.6" | grep -q "not found"; then
	lib=5
else
	lib=6
fi
#
# There is no libstdc++5 LSX_NvmeLib.so so we don't copy it.
# There is no support in Linux versions for NVMe in RHEL 6 and below.
#
cp -f storelibir-2.so.64-$lib storelibir-2.so
cp -f storelibir-3.so.64-$lib storelibir-3.so
#
# Copy the files to standardize the names for the tool
#

if [ $BOMC == "YES" ]; then
    echo Running under MCP in offline mode.
    echo "DEBUGLEVEL=2" > storelibconf.ini
    echo "OVERWRITE=0" >> storelibconf.ini
    echo "DEBUGDIR=." >> storelibconf.ini
else
	echo Running under OS in online mode.
	echo Running in $arch mode.
fi

./ssdcli smart --log $LOGPATH
  rc=$?
exit $rc