// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
const ipcRenderer = require('electron').ipcRenderer;

function runProgram(args, workingDirectory, callback, msgs) {
  process.env["LD_PRELOAD"] = "";
  var cmd = args[0];
  args.shift();
  if(workingDirectory==null) {
    workingDirectory = path.dirname(cmd);
  }
  var options = {cwd: workingDirectory, maxBuffer: 2048000000};
  var execFile = require('@electron/remote').require('child_process').execFile;
  var subProcess = execFile(cmd, args, options, function(error, stdout, stderr) {
      if (error) {
        if(callback) {
          callback(false, error, stdout, stderr);
        }
        return error.code;
      }
      if(callback) {
        callback(true);
      }
      return 0;
  });
  if (top.getSystemFile("oneCli") == cmd) gl_onecli_process = subProcess;
  subProcess.stdout.on('data', (data) => {
    var data_string = data.toString();
    console.log(data_string);
    if(msgs && msgs.length != 0)
    {
      msgs.forEach(msg => {
        if(data_string.indexOf(msg) != -1)
        {
          if (confirm(msg)) {
            subProcess.stdin.write("yes\n");
          } else {
            subProcess.stdin.write("no\n");
          }
        }
      });
    }
  });
  subProcess.stderr.on('data', (data) => {
    var data_string = data.toString();
    console.log(data_string);
    if(msgs && msgs.length != 0)
    {
      msgs.forEach(msg => {
        if(data_string.indexOf(msg) != -1)
        {
          if (confirm(msg)) {
            subProcess.stdin.write("yes\n");
          } else {
            subProcess.stdin.write("no\n");
          }
        }
      });
    }
  });
}

function del_knowhostskey() {
  if (top.gl_current_os.indexOf('win') != -1) {
    var exec_drive = path.dirname(process.execPath).substring(0, 3);
    var dir_to_del = exec_drive + 'knowhostskey';
    top.del_dir(dir_to_del);
  } 
}

function refine_onecli_update_acquire_command(args) {
  // OneCLI command replacement with "<LXCE OneCLI>"
  args[0] = "<LXCE OneCLI>";

  if (top.gl_isProxy) {
    // Hidden the OOB password with "***".
    // OOB password locator pattern - "--proxy"
    hidden_oob_passwd(args, "--proxy");
  }
}

function refine_onecli_update_flash_command(args, is_oob) {
  // remove "--comparexml" parameter and value
  var index = args.indexOf("--comparexml");
  if (index > -1) {
    args.splice(index, 2);
  }

  // OneCLI command replacement with "<LXCE OneCLI>"
  args[0] = "<LXCE OneCLI>";

  if (is_oob) {
    // Hidden the OOB password with "***".
    // OOB password locator pattern - "--imm" and "--sftp"
    // add: "--https" and "--ftp"
    hidden_oob_passwd(args, "--imm");
    hidden_oob_passwd(args, "--sftp");
    hidden_oob_passwd(args, "--https");
    hidden_oob_passwd(args, "--ftp");
    hidden_oob_passwd(args, "--http");
  } else {
    // Hidden the inband password with "***".
    // Inband password locator pattern. - "--bmc-password"
    hidden_inband_passwd(args);
  }
}

function hidden_oob_passwd(args, type_str) {
  var index = args.indexOf(type_str);
  if (index > -1) {
    args[index+1] = args[index+1].replace(/(?<=:).*(?=@)/, "***");
  }
}

function hidden_inband_passwd(args) {
  var index = args.indexOf("--bmc-password");
  if (index > -1) {
    args[index+1] = "***";
  }
}

function refine_onecli_misc_raid_command(args) {
  // OneCLI command replacement with "<LXCE OneCLI>"
  args[0] = "<LXCE OneCLI>";

  // Hidden the OOB password with "***".
  // OOB password locator pattern - "--bmc"
  hidden_oob_passwd(args, "--bmc");
}

function store_onecli_command(args) {
  var command_type_index = 2;
  var is_oob = top.gl_OOB_Params.Enabled;

  if (args[command_type_index] == "acquire") {
    top.gl_acquireCommandArray = 0;
    top.gl_acquireCommandArray = args.slice();

    refine_onecli_update_acquire_command(top.gl_acquireCommandArray);
  } else if (args[command_type_index] == "flash") {
    top.gl_flashCommandArray.length = 0;
    top.gl_flashCommandArray = args.slice();

    refine_onecli_update_flash_command(top.gl_flashCommandArray, is_oob);
  } else if (args[command_type_index] == "raid") {
    top.gl_raidCommandArray = 0;
    top.gl_raidCommandArray = args.slice();

    refine_onecli_misc_raid_command(top.gl_raidCommandArray);
  }
}

function reboot_decode(value) {
  switch(value) {
    case '0':
      return 'No reboot required';
    case '1':
      return 'Reboot Forced by Update';
    case '2':
      return 'Reboot Required Immediately after update';
    case '3':
      return 'Reboot Required to take effect';
    case '4':
      return 'Logoff Required to take effect';
    default:
      return value;
  }
}

function get_bomc_config_content() {
  if (!top.fileExists('/tmp/bomc.config')) return;
  try {
    var bomc_config_content = top.readTextFile('/tmp/bomc.config');
  } catch(e) {
    return;
  }
  var bomc_config_array = bomc_config_content.split('\n');
  for (var i = 0; i < bomc_config_array.length; i++) {
    if (bomc_config_array[i].indexOf('IBM_SYSTEM_MEDIALABEL=') != -1) {
      top.gl_descriptive_name = bomc_config_array[i].replace('IBM_SYSTEM_MEDIALABEL=', '');
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_UNATTENDED=') != -1) {
      top.gl_is_unattend = ('NULL' != bomc_config_array[i].replace('IBM_SYSTEM_UNATTENDED=', ''));
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_REBOOT_BMC=') != -1) {
      top.gl_reboot_bmc = ('YES' == bomc_config_array[i].replace('IBM_SYSTEM_REBOOT_BMC=', ''));
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_AUTORUN=') != -1) {
      top.gl_autorun = ('NULL' != bomc_config_array[i].replace('IBM_SYSTEM_AUTORUN=', ''));
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_USB_KEY=') != -1) {
      top.gl_usb_key = bomc_config_array[i].replace('IBM_SYSTEM_USB_KEY=', '');
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_PXE_FILE=') != -1) {
      top.gl_pxe_file = bomc_config_array[i].replace('IBM_SYSTEM_PXE_FILE=', '');
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_MACHINETYPE=') != -1) {
      top.gl_mt_array = bomc_config_array[i].replace('IBM_SYSTEM_MACHINETYPE=', '').split(',');
    } 
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_FORCE_ID=') != -1
            &&bomc_config_array[i].replace('IBM_SYSTEM_FORCE_ID=', '') != 'NULL') {
      top.gl_bomc_force_list = bomc_config_array[i].replace('IBM_SYSTEM_FORCE_ID=', '').split(',');
    } 
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_COPY_TO_RAMDISK=') != -1) {
      top.gl_copy_ramdisk = ('YES' == bomc_config_array[i].replace('IBM_SYSTEM_COPY_TO_RAMDISK=', ''));
    }
  }
}

function get_descriptive_name()
{
  return top.gl_descriptive_name;
}

function is_unattend() {
  return top.gl_is_unattend;
}

function is_reboot_bmc() {
  return top.gl_reboot_bmc;
}

function is_autorun() {
  return top.gl_autorun;
}

function in_ramdisk() {
  return top.gl_copy_ramdisk;
}

// return true if it requires bootable updatexpress to copy payloads
// return false if it need not copy payloads
function need_copy() {
  return (top.gl_usb_key == 'NULL' && top.gl_pxe_file == 'NULL');
}

function getMTFromImage() {
  return top.gl_mt_array;
}

function getBomcForceList() {
  return top.gl_bomc_force_list;
}

// function is_red(mt) {
//   if (!isPurley(mt) && !is_blue(mt)) {
//     return true;
//   } else {
//     return false;
//   }
// }

function isAmd(mt) {
  if (!mt) {
    if (top.gl_OOB_Params.Enabled) {
      mt = top.gl_OOB_Params.MT;
    } else {
      mt = top.gl_current_mt_d;
    }
  }
  for (var i = 0; i < top.gl_amd_mt_list.length; i++) {
    if (mt == top.gl_amd_mt_list[i]) {
      return true;
    }
  }
  return false;
}

function isCFC(mt) {
  if (!mt) {
    if (top.gl_OOB_Params.Enabled) {
      mt = top.gl_OOB_Params.MT;
    } else {
      mt = top.gl_current_mt_d;
    }
  }
  for (var i = 0; i < top.gl_cfc_mt_list.length; i++) {
    if (mt == top.gl_cfc_mt_list[i]) {
      return true;
    }
  }
  return false;
}

function isGrantly(mt) {
  if (!mt) {
    if (top.gl_OOB_Params.Enabled) {
      mt = top.gl_OOB_Params.MT;
    } else {
      mt = top.gl_current_mt_d;
    }
  }
  for (var i = 0; i < top.gl_grantly_mt_list.length; i++) {
    if (mt == top.gl_grantly_mt_list[i]) {
      return true;
    }
  }
  return false;
}

function is_blue(mt) {
  if (!mt) {
    if (top.gl_OOB_Params.Enabled) {
      mt = top.gl_OOB_Params.MT;
    } else {
      mt = top.gl_current_mt_d;
    }
  }
  for (var i = 0; i < top.gl_bl_mt_list.length; i++) {
    if (mt == top.gl_bl_mt_list[i]) {
      return true;
    }
  }
  return false;
}

// function isPurley(mt) {
//   if (mt) {
//     for (var i = 0; i < mt.length; i++) {
//       if (isNaN(mt[i])) return true;
//     }
//     return false;
//   } else {
//     if (top.gl_OOB_Params.Enabled) {
//       mt = top.gl_OOB_Params.MT;
//     } else {
//       mt = top.gl_current_mt_d;
//     }
//     for (var i = 0; i < mt.length; i++) {
//       if (isNaN(mt[i])) return true;
//     }
//     return false;
//   }
// }

function saveMetaToLocal() {
  var acRltPath = top.getSupportFile('acquireResult');
  if (top.fileExists(acRltPath)) {
    var ac_Content = top.readTextFile(acRltPath);
    var acRltMetaPath = top.getSupportFile('acResultMeta');
    if (top.fileExists(acRltMetaPath)) {
      top.deleteFile(acRltMetaPath);
    }
    top.writeTextFile(acRltMetaPath, ac_Content);
  }
  var acRlt2Path = top.getSupportFile('acquireResult2');
  if (top.fileExists(acRlt2Path)) {
    var ac2_Content = top.readTextFile(acRlt2Path);
    var acRlt2MetaPath = top.getSupportFile('acResult2Meta');
    if (top.fileExists(acRlt2MetaPath)) {
      top.deleteFile(acRlt2MetaPath);
    }
    top.writeTextFile(acRlt2MetaPath, ac2_Content);
  }
}

function getPackageType(updateId) {
  var compareCheck = getSupportFile("compareResult", "oneCli");
  var compareContent;
  if (top.fileExists(compareCheck)) {
    compareContent = top.readTextFile(compareCheck);
  }
  if (!compareContent) return "bmu";
  else {
    var domCheck = ezJsLib.XmlDom.parse(compareContent);
    var tagPackageArray = domCheck.getElementsByTagName("PACKAGE");
    for (var i = 0; i < tagPackageArray.length; i++) {
      if (ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", tagPackageArray[i]) == updateId) {
        var childupdates;
        try {
          childupdates = tagPackageArray[i].getElementsByTagName("CHILDUPDATES");
          childupdates = childupdates[0].getElementsByTagName("CHILDUPDATE");
        } catch(e) {
          childupdates = new Array();
        }
        if (childupdates.length == 0) {
          var agentlessValue;
          try {
            agentlessValue = ezJsLib.XmlDom.getValueByTagFromNode("AGENTLESSSUPPORT", tagPackageArray[i]);
          } catch (e) {
            agentlessValue = 0;
          }
          if (agentlessValue == 0) {
            return "bmu";
          } else {
            return "OOB";
          }
        } else {
          var isBmu = false;
          for (var i = 0; i < childupdates.length; i++) {
            var category;
            try {
              category = ezJsLib.XmlDom.getValueByTagFromNode("CCATEGORY", childupdates[i]);
            } catch(e) {
              category = "Legacy Option";
            }
            if (category.toLowerCase().indexOf("legacy option") != -1) {
              var isBmu = true;
              break;
            }
          }
          if (isBmu) {
            return "bmu";
          } else {
            return "OOB";
          }
        }
      }
    }
  }
}

function getPackageTypeBak(updateId) {
	var contentCheck = "";
	var fileCheck = path.join(top.gl_workingDir, updateId+".xml");
	if (top.fileExists(fileCheck)) {
		contentCheck = top.readTextFile(fileCheck);
	}
	if (!contentCheck) return false;
	var domCheck = ezJsLib.XmlDom.parse(contentCheck);
	var tagPropertyArray = domCheck.getElementsByTagName("PROPERTY");
	for (var i = 0; i < tagPropertyArray.length; i++) {
		if (tagPropertyArray[i].outerHTML.indexOf("category") != -1) {
      var valueCategory = tagPropertyArray[i].children[0].innerHTML;
      if (valueCategory == "IMM2" || valueCategory == "IMM2-BACKUP" || valueCategory == "UEFI" || valueCategory == "UEFI-BACKUP" || valueCategory == "Diagnostics" || valueCategory == "TDM" || valueCategory == "XCC" || valueCategory == "XCC_BACKUP" || valueCategory == "LEPT" || valueCategory == "DRVLN" || valueCategory == "DRVWN" || valueCategory == "LXPM") {
        return "OOB";
      } else {
        var compareCheck = getSupportFile("compareResult", "oneCli");
        var compareContent;
        if (top.fileExists(compareCheck)) {
          compareContent = top.readTextFile(compareCheck);
        }
        // if there is no compare result file, updatexpress will not get the package type of this updateid, but it will try OOB update
        if (!compareContent) return "OOB";
        else {
          var domCheck = ezJsLib.XmlDom.parse(compareContent);
          var tagPackageArray = domCheck.getElementsByTagName("PACKAGE");
          for (var i = 0; i < tagPackageArray.length; i++) {
            if (ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", tagPackageArray[i]) == updateId) {
              // var pldmValue;
              var agentlessValue;
              try {
                // pldmValue = ezJsLib.XmlDom.getValueByTagFromNode("pldmSupport", tagPackageArray[i]);
                agentlessValue = ezJsLib.XmlDom.getValueByTagFromNode("AGENTLESSSUPPORT", tagPackageArray[i]);
              } catch (e) {
                // pldmValue = null;
                agentlessValue = 0;
              }
              // if (pldmValue == "" || pldmValue == 0 || pldmValue == null) return "bmu";
              // else return "OOB";
              if (agentlessValue == 0) return "bmu";
              else if (agentlessValue == 1) return "OOB";
            }
          }
        }
      }
		}
	}
} 

function getSystemFile(fileId) {
  var commands = require("./settings/system_files.json");
  var baseDir = path.dirname(process.execPath);
  if(commands[fileId].win == undefined && commands[fileId].linux == undefined) {
    return path.join(baseDir, commands[fileId].toString());
  }
  if(top.OSTYPE == "windows") {
    return path.join(baseDir, commands[fileId].win.toString());
  } else {
    return path.join(baseDir, commands[fileId].linux.toString());
  }
}

// function getSupportDir() {
//   if (top.OSTYPE == 'windows') {
//     return path.join(top.gl_base_path, 'Lenovo_Support');
//   } else {
//     return '/var/log/Lenovo_Support';
//   }
// }

function getSupportDir() {
  if (top.OSTYPE == "windows") {
    return path.join(top.gl_base_path, "Lenovo_Support\\");
  } else {
    return path.join(top.gl_base_path, "Lenovo_Support/");
  }
}

function getVarLogDir() {
  return "/var/log/Lenovo_Support/";
}

function getVarLogFile(fileId, type) {
  var files = require("./settings/support_files.json");
  var baseDir = getVarLogDir();
  if(type) {
    return path.join(baseDir, files[fileId][type].toString());
  } else {
    return path.join(baseDir, files[fileId].toString());
  }
}

function getSupportFile(fileId, type) {
  var files = require("./settings/support_files.json");
  var baseDir = getSupportDir(); 
  if(type) {
    return path.join(baseDir, files[fileId][type].toString());
  } else {
    return path.join(baseDir, files[fileId].toString());
  }
}

function getSupportFileBySeries(fileId, seriesId, type) {
  var file = getSupportFile(fileId, type);
  return file.replace(".xml", seriesId+".xml");
}

// gets the value of an environment variable
// name: string - name of variable
// returns: string - value of variable
//          undefined - variable is not defined
function getEnv(name) {
  return process.env[name];
}

function closeNw(success) {
  if (success) {
    require("nw.gui").Window.get().close(true);
  } else {
    alert("OneCli is not stopped. Please try again. ");
    return false;
  }
}

// showPrompt: boolean - Determines if an "Are you sure you want to exit" dialog will be shown
// returns void
function Exit(showPrompt) {
  require('@electron/remote').getGlobal("sharedObject").showPrompt = showPrompt;
  window.close();
  /*
  if (typeof showPrompt == "boolean" && showPrompt == true) {
    if (confirm($.i18n.prop("Common.ConfirmExit")) == false) {
      return false;
    }
  }
  try {
    window.close();
  } catch (e) {
    alert($.i18n.prop("Common.ExitError"));
  }
  */
  // Rarely called when debugging and refresh windows.
  // require('nw.gui').Window.get().close();
}

function parsePropertiesFile(filename) {
  var prop = require("./js/libs/String.prototype.codePointAt-0.2.0/index.js");
  return prop.read(filename);
}

function getGenericOSType() {
    var osName = os.type().toLowerCase();
    if (osName.indexOf("windows")>=0){
        return "windows";
    }
    return "unix";
}

function getOS() {
    return  os.type() + " " +  os.release();
}

/**
 * write user's selections (MT & OS) to hard disk
 */
function writeConfigFile() {
    if (!top.gl_store_os && !top.gl_store_mt)
        return;
    var root = "<?xml version=\"1.0\"?>";
    root += "<root>\n";
    root += "<timestamp>";
    root += top.gl_configlist_time_stamp;
    root += "</timestamp>\n";
    for (var i = 0; i < top.gl_config_list.length; i++) {
        var a = top.gl_config_list[i];
        root += "\t<system>";
        root += "<xname>" + a[0] + "</xname>";
        root += "<machineType>" + a[1] + "</machineType>";
        root += "<selected>" + a[2] + "</selected>";
        root += "<noUXSP>" + a[3] + "</noUXSP>";
        root += "</system>\n";
    }
    for (i = 0; i < top.gl_os_list.length; i++) {
        //for OS agnostic update support
        //if (top.gl_os_list[i] != "none" || top.gl_isNoneSelected) {
            root += "<OS>" + top.gl_os_list[i] + "</OS>\n";
        //}
    }

    root += "</root>";
    top.writeTextFile(top.getSupportFile("configList"), root);
}

// Build proxy uri: userid:password@ip:port
function buildProxyUri(userid, password, ip, port) {
    var uri = top.gl_proxyType + "://";
    if(gl_proxy_account) uri += (userid + ":" + password + "@");
    uri += ((ip[0] != "[" && ip.indexOf(":") != -1)?("[" + ip + "]"):(ip));
    if(port!="") uri += (":" + port);
    return uri;
}

function add_proxy_para()
{
  var args = new Array();
  if(top.gl_url_custom) {
    if (top.gl_url_insecure) {
      args.push("--insecure");
    }
    else if (top.gl_url_specify_cert) {
      args.push("--cacert");
      args.push(top.gl_url_cert);
    }
  }
  if (top.gl_isProxy) {
    var proxyUri = buildProxyUri(top.gl_proxy_username, top.gl_proxy_password, top.gl_proxy_address, top.gl_proxy_port);
    args.push("--proxy");
    args.push(proxyUri);
    if(top.gl_proxy_custom) {
      if (top.gl_proxy_insecure) {
        args.push("--proxy-insecure");
      }
      else if (top.gl_proxy_specify_cert) {
        args.push("--proxy-cacert");
        args.push(top.gl_proxy_cert);
      }
    }
  }
  return args;
}

function add_output_log5()
{
  var args = new Array();
  args.push("--output");
  args.push(top.getSupportDir());
  args.push("--log");
  args.push("5");
  return args;
}

//for unattend mode
function uxlite_alert(text) {
    if (top.getEnv("BOMC_UNATTENDED_MODE")) {
        top.Exit(false);
    } else {
        alert(text);
    }

}

function getComErrMsg() {
  if (top.OSTYPE == "windows")
    return $.i18n.prop("Common.UnknownFailWin");
  else
    return $.i18n.prop("Common.UnknownFailLinux");
}

function setWorkingDir(eleId, iFlag)
{
  var path = ipcRenderer.sendSync('showOpenDialog', '');
  if(path && path[0]){
    var dir = path[0];
    document.getElementById(eleId).value = dir;
    if(iFlag)
      top.gl_workingDir = dir;
    console.log(dir);
  }
}

function openFileDirectory(eleId, callback, filterType){
  var _defaultPath = "";
  if(eleId)
      _defaultPath = document.getElementById(eleId).value;
  var _filterType = [];
  if(filterType)
      _filterType = filterType;
  else
      _filterType = [{ name: 'All Files', extensions: ['*'] }];
  var path = ipcRenderer.sendSync('showOpenDialogFile', _defaultPath, _filterType);
  if(path && path[0]){
      var dir = path[0];
      document.getElementById(eleId).value = dir;
      if(callback)
          callback(dir);
      console.log(dir);
  }
}

function checkSupportMachineType(mt)
{
  var supportMTList = getSupportMachineTypeList();
  var found = false;
  for(var i=0; i<supportMTList.length; i++)
  {
    if(supportMTList[i]==mt)
    {
      found = true;
      break;
    }
  }
  return found;
}

function hasPurleyOrOther(mt){
  var purley = false;
  var prepurley = false;
  if(mt){
    for (var i = 0; i < mt.length; i++) {
      if (isNaN(mt[i])){
        purley = true;
      }else{
        prepurley = true;
      }
    }
  }
  if(purley && !prepurley){
    return "purley";
  }else if(!purley && prepurley){
    return "prepurley";
  }else{
    return "muti";
  }
}

function getSupportMachineTypeList()
{
  var machineTypeList = new Array();
  var supportListFile = null;
  try
  {
    supportListFile = top.readTextFile(top.getSupportFile("configList"));
    if (supportListFile == null)
    {
      throw $.i18n.prop("MachineType.NoFile");
    }
  }
  catch (e)             //load config sys file failed, load default one
  {
    supportListFile = top.readTextFile(top.getSystemFile("mtList"));
  }
  
  if(supportListFile!=null)
  {
    var dom = ezJsLib.XmlDom.parse(supportListFile);
    var allSystems = dom.documentElement.getElementsByTagName("system");
    for (var i=0; i<allSystems.length; i++)
    {
      var mt = allSystems.item(i).childNodes[1].firstChild.nodeValue;
      machineTypeList.push(mt);
    }
  }
  return machineTypeList; 
}

function use_preview_server(args) {
  // ACQUIRE_SERVER_URL=http://10.122.11.55:9092/services/ContentService/SearchDrivers
  var onecli_config = top.getSystemFile('oneCliConfig');
  if (!top.fileExists(onecli_config)) {
    console.log('oneCliConfig file does not existing')
    return;
  }
  var onecli_config_content;
  try {
    onecli_config_content = top.readTextFile(onecli_config);
  } catch(e) {
    console.log('fail reading oneCliConfig file')
    return;
  }
  var config_arr = onecli_config_content.split('\n');
  var url_path = '';
  for (var i = 0; i < config_arr.length; i++) {
    if (config_arr[i].indexOf('ACQUIRE_SERVER_URL=') == 0) {
      url_path = config_arr[i].replace('ACQUIRE_SERVER_URL=', '').trim();
      break;
    }
  }
  if (url_path != 'NONE') {
    args.push("--preview");
    args.push("--previewusername");
    args.push("espftp");
    args.push("--previewpassword");
    args.push('2345.wert');
  }
}

// function setPreviewParams(args) {
//     var previewFile = getSupportFile("preview");
//     if(require("fs").existsSync(previewFile))
//     {
//         var content = require("fs").readFileSync(previewFile);
//         if (content[0] === 0xEF && content[1] === 0xBB && content[2] === 0xBF) {
//             content = content.slice(3);
//         }
//         var previewParams = JSON.parse(content.toString('utf-8'));
//         args.push("--preview");
//         args.push("--previewusername");
//         args.push(previewParams.username);
//         args.push("--previewpassword");
//         args.push(previewParams.password);
//     }
// }

function alert(msg)
{
    ipcRenderer.sendSync('alertMsg', msg);
}

function confirm(msg)
{
    return 0==ipcRenderer.sendSync('confirmMsg', msg);
}

function quit(msg)
{
    ipcRenderer.sendSync('quitMsg', msg);
}

function SplitFullConnInfo() {
    if (top.gl_OOB_Params.IMM_Address.indexOf(":") != -1) {
      if(top.gl_OOB_Params.IMM_Port != "") {
        return (gl_OOB_Params.IMM_UserName + ":" + gl_OOB_Params.IMM_Password + "@[" + gl_OOB_Params.IMM_Address + "]:" + top.gl_OOB_Params.IMM_Port);
      } else {
        return (gl_OOB_Params.IMM_UserName + ":" + gl_OOB_Params.IMM_Password + "@[" + gl_OOB_Params.IMM_Address + "]");
      }
    } else {
      if(top.gl_OOB_Params.IMM_Port != "") {
        return (gl_OOB_Params.IMM_UserName + ":" + gl_OOB_Params.IMM_Password + "@" + gl_OOB_Params.IMM_Address + ":" + top.gl_OOB_Params.IMM_Port);
      } else {
        return (gl_OOB_Params.IMM_UserName + ":" + gl_OOB_Params.IMM_Password + "@" + gl_OOB_Params.IMM_Address);
      }
    }
}
