// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
function createDirectory(dirpath) {
	if (!fs.existsSync(dirpath)) {
        var pathtmp;
        dirpath.split(path.sep).forEach(function(dirname) {
            if(dirname.length>0) {
                if (pathtmp) {
                    pathtmp = path.join(pathtmp, dirname);
                }
                else {
                    pathtmp = dirname;
                }
                if (!fs.existsSync(pathtmp)) {
                    if (!fs.mkdirSync(pathtmp)) {
                        return false;
                    }
                }
            } else {
                if(pathtmp)
                    pathtmp = path.join(pathtmp, path.sep);
                else
                    pathtmp = path.sep;
            }
        });
    }
    return true;
}

function fileExists(fileName) {
    return fs.existsSync(fileName);
}

function directoryExists(directory) {
    return fileExists(directory);
}

function deleteFile(file) {
    if (fileExists(file)) {
    	fs.unlinkSync(file);
    }
    return true;
}

function del_dir(dir_path) {
    if (top.directoryExists(dir_path)) {
        fs.rmdirSync(dir_path);
    }
}

// read an external file
// fileName: string - full native file name or URL
// returns: string - contents of file if readable, null otherwise
function readTextFile(fileName, charset) {
	if (fileName == null || !fileExists(fileName))
		return null;
	if (!charset)
		charset = "utf8"
	if (charset == "null")
		charset = null
	return fs.readFileSync(fileName, charset);
}

// write a text file
// fileName: string - full native file name
// text:  string - content of text file
// append: boolean - true = append text to end of file,  false = overwrite existing file
// returns: true if file was written successfully, false otherwise
function writeTextFile(fileName, fileContent, append) {
	if (!fileContent) {
		console.error("No fileContent.");
		return false;
	}
	if (append && fileExists(fileName)) {
		fs.appendFileSync(fileName, fileContent);
	} else {
		fs.writeFileSync(fileName, fileContent);
	}
	return true;
}

function validatePath(path) {
    if ($.trim(path) == "")
        return "Common.InputDir";
    //support non-English,
    var regExp = null;
    var regExpNet = null;
    if (top.OSTYPE == "windows") //for windows
    {
        //regExp = /^[a-zA-Z]\:(\\[a-zA-Z0-9_ -.]+)*\\{0,1}$/gi;
        regExp = /^[a-zA-Z]\:(\\.+)*\\{0,1}$/gi;
        regExpNet = /^\\\\((2[0-4]\d|25[0-5]|[01]?\d\d?)\.){3}(2[0-4]\d|25[0-5]|[01]?\d\d?)(\\.+)*\\{0,1}$/gi;
    } else //for linux
    //regExp = /^\/|(\/[a-zA-Z0-9_ -.]+)+\/{0,1}$/gi;
        regExp = /^\/|(\/.+)+\/{0,1}$/gi;
    if (!path.match(regExp) && !path.match(regExpNet))
        return "Common.InvalidPath";
    else if (!directoryExists(path))
        return "Common.UnavailablePath";
    else
        return "success"
}

function getNowFormatDate() {
	var date = new Date();
	var seperator1 = "-";
	var seperator2 = ":";
	var month = date.getMonth() + 1<10? "0"+(date.getMonth() + 1):date.getMonth() + 1;
    var strDate = date.getDate()<10? "0" + date.getDate():date.getDate();
    var strHour = date.getHours()<10? "0" + date.getHours():date.getHours();
    var strMinute = date.getMinutes()<10? "0" + date.getMinutes():date.getMinutes();
    var strSecond = date.getSeconds()<10? "0" + date.getSeconds():date.getSeconds();

	var currentdate = date.getFullYear() + seperator1 + month + seperator1 + strDate
			+ " " + strHour + seperator2 + strMinute + seperator2 + strSecond;
	return currentdate;
}

function getCallerFileNameAndLine(){
    function getException() {
            try {
                throw Error('');
            } catch (err) {
                return err;
            }
        }
        
    const err = getException();

    const stack = err.stack;
    const stackArr = stack.split('\n');
    let callerLogIndex = 0;
    for (let i = 0; i < stackArr.length; i++) {
        if (stackArr[i].indexOf("at printLog") > 0 && i + 1 < stackArr.length) {
            callerLogIndex = i + 1;
            break;
        }
    }

    if (callerLogIndex !== 0) {
        const callerStackLine = stackArr[callerLogIndex];
        return `[${callerStackLine.substring(callerStackLine.lastIndexOf("/") + 1, callerStackLine.lastIndexOf(':'))}]`;
    } else {
        return '[-]';
    }
}

function printLog(level, msg)
{
    logFile.write(getNowFormatDate() + " [" + level + "]" + getCallerFileNameAndLine() +msg + "\n");
}

function passwordCode(password)
{
    var a = "";
    for(var i = 0; i < password.length; ++i)
    {
        a+="*";
    }
    return a;
}

function getRunProgramCommend(args)
{
    var argsCommend = "";
    var isPassword = false;
    var isUrl = false;
    for(var i = 0; i < args.length ; ++i)
    {
        argsCommend += " ";
        if(isPassword)
        {
            argsCommend += passwordCode(args[i]);
        }
        else if(isUrl && args[i].indexOf("@"))
        {
            var startPos = args[i].indexOf(":");
            var stopPos = args[i].lastIndexOf("@");
            var url = startPos>stopPos?args[i]:args[i].substring(0,startPos+1) + passwordCode(args[i].substring(startPos+1,stopPos)) + args[i].substring(stopPos);
            argsCommend += url;
        }
        else
        {
            argsCommend += args[i];
        }
        isPassword = ("--bmc-password" == args[i] || "--password" == args[i]);
        isUrl = ("--imm" == args[i] || "--bmc" == args[i] || "--sftp" == args[i] || "--proxy" == args[i] || "--https" == args[i] || "--ftp" == args[i] || "--http" == args[i]);
    }
    return argsCommend;
}