// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
function querySystemInfo(callback) {
    var outputFilename = top.getSupportFile("guiHelper");
    if(top.fileExists(outputFilename)) {
        top.deleteFile(outputFilename);
    }
    var args = [];
    args.push(top.getSystemFile("guiHelper"));
    args.push('--dir');
    args.push(top.getSupportDir());
    args.push("--file");
    args.push(path.basename(top.getSupportFile("guiHelper")));
    runProgram(args, null, function(success) {
        if(success && top.fileExists(outputFilename)) {
            top.gl_properties_info = top.parsePropertiesFile(outputFilename);
            if(callback) {
                callback(true);
            }
        } else {
            if(callback) {
                callback(false);
            }
        }
    });
}

function killOneCli() {
    if(top.gl_onecli_process != null) top.gl_onecli_process.kill();
    /*var args = new Array();
    args.push(top.getSystemFile("guiHelper"));
    args.push("--kill");
    args.push(path.basename(top.getSystemFile("oneCli")));
    args.push('--dir');
    args.push(top.getSupportDir());
    args.push("--file");
    args.push(path.basename(top.getSupportFile("guiHelperKillOneCLI")));
    return runProgram(args, null, function(success) {
        if(callback) {
            callback(success);
        }
    });*/
}

function isOneCliRunning(callback) {
    var outputFilename = top.getSupportFile("guiHelper");
    var oneCliProgramName = path.basename(top.getSystemFile("oneCli"));
    if(top.fileExists(outputFilename)) {
        top.deleteFile(outputFilename);
    }
    var args = new Array();
    args.push(top.getSystemFile("guiHelper"));
    args.push("--isrunning");
    args.push(oneCliProgramName);
    args.push('--dir');
    args.push(top.getSupportDir());
    args.push("--file");
    args.push(path.basename(top.getSupportFile("guiHelper")));
    runProgram(args, null, function(success) {
        if(success && top.fileExists(outputFilename)) {
            var temp_properties_info = top.parsePropertiesFile(outputFilename);
            if(temp_properties_info["IBM_SYSTEM_RUNNING"] != oneCliProgramName) {
                console.log("OneCli is not running.");
                if(callback) {
                    callback(false);
                }
            } else {
                console.log("OneCli is running.");
                if(callback) {
                    callback(true);
                }
            }
        } else {
            console.log("Can't get OneCli running status.");
            if(callback) {
                callback(true);
            }
        }
    });
}