// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
OOB_Setting = function(){
	var userCanceled = false;
	var isGettingMachineType = false;
	var statusImg = "<img src=\"images/statusInformation.png\" border=\"0\" style=\"vertical-align:middle;\">";
	// var certIMMTempFile = "";
	// var certRemoteTempFile = "";
	// var certIMMSaveFile = '';
	// var certRemoteSaveFile = '';
	var certIMMTempFile = '';
	var certRemoteTempFile = '';
	var certIMMSaveFile = '';
	var certRemoteSaveFile = '';
	var certIMMTempContent;
	var certRemoteTempContent;
	var certIMMSaveContent;
	var certRemoteSaveContent;
	var certNewIMM = false;
	var certNewRemote = false;
	// var certGot = false;
	var scan_status = "";
	// var certAccepted = false;
	// scan_status value:
	// init
	// bmc_success
	// bmc_fail
	// ssh_success
	// ssh_fail

	var tagCheckDefault = false;

	function checkDefault() {
		tagCheckDefault = document.getElementById("acceptCertDefault").checked;
		printLog("INFO","check box 'Accept BMC server's certificate and remote server's key fingerprint by default.' " + (tagCheckDefault?"checked.":"unchecked."));
	}

	function oob_init(){
		printLog("INFO","Setting page init.");
		tagCheckDefault = document.getElementById("acceptCertDefault").checked;
		// certGot = false;	
		scan_status = "init";
		certNewIMM = false;
		certNewRemote = false;
		certIMMTempFile = path.join(top.getSupportDir(), "IMM_Cert.txt");
		certRemoteTempFile = path.join(top.getSupportDir(), "Remote_Cert.txt");
		var newShowStep = top.gl_steps_current;
		if (!top.gl_uxlite_bootable) {
			if (top.gl_configRaid) {
				// do nothing since the steps has already configed
			} else {
				if (top.bCheckForLatest) {
		    		newShowStep = [Welcome, Proxy_Setting, Obtain_Latest_Version, Update_Task, OOB_Setting, Update_Location, Update_Type, Update_Comparison, Update_Execution, Finish];
		    	} else {
		    		newShowStep = [Welcome, Update_Task, OOB_Setting, Update_Location, Update_Type, Update_Comparison, Update_Execution, Finish];
		    	}
			} 
	    	configSteps(newShowStep);
		}

		// reset element
		$('#SepRemoteProtocolOpt option[value="SFTP"]').show();
		$('#SepRemoteProtocolOpt option[value="HTTP"]').show();
		$('#CFCMustEnableExternalRemote').hide();
		$("#enableBackupDiv").hide();
		if (top.gl_uxlite_bootable) {	// bootable case
			top.gl_Inband_Params.Enabled = true;
			if (top.is_blue(top.gl_current_mt)) {
				$("#inbandBMC").show();
				$('#inband_port_input').hide();
				$("#enableForceDiv").hide();
			} else if (top.isAmd(top.gl_current_mt)) {
				$("#inbandBMC").hide();
				$('#inband_port_input').show();
				$("#enableForceDiv").show();
			} else {
				$('#inband_port_input').show();
				$("#enableForceDiv").show();
			}
			$("#enableExternalRemoteDiv").hide();
			$("#OOBBMC").hide();
			$("#OOBRemote").hide();
			$("#SepRemoteProtocolOpt").hide();
			$("#certDefaultSection").hide();
			$("#showNoAdaptersDiv").show();
			top.gl_showNoAdapters = $("#showNoAdaptersCheckbox").prop("checked");
			if(top.isCFC(top.gl_current_mt)) {
				$('#CFCMustEnableExternalRemote').show();
				$("#OOBRemote").show();
				$("#SepRemoteProtocolOpt").show();
				$('#SepRemoteProtocolOpt option[value="SFTP"]').hide();
				$('#SepRemoteProtocolOpt option[value="HTTP"]').hide();
				if ($('#SepRemoteProtocolOpt').prop("value")=="SFTP" || $('#SepRemoteProtocolOpt').prop("value")=="HTTP") {
					$('#SepRemoteProtocolOpt option[value="HTTPS"]').prop("selected", true);
				}
				checkRemoteProtocolOpt();
			}
		} else {	// normal case
			if (top.gl_configRaid) {
				$("#OOBBMC").show();
	    		$("#OOBRemote").hide();
				$("#SepRemoteProtocolOpt").hide();
	    		$("#enableExternalRemoteDiv").hide();
	    		$("#enableExternalRemoteCheckbox").attr("checked", false);
				toggleEnableExternalRemote();
	    		$("#inbandBMC").hide();
				$("#enableForceDiv").hide();
				$("#certDefaultSection").show();
				$('#oob_port_input').show();
			} else {
				if (top.gl_OOB_Params.Enabled) {
					$('#oob_port_input').show();
		    		$("#OOBBMC").show();
		    		$("#inbandBMC").hide();
		    		$("#enableExternalRemoteDiv").show();
		    		$("#certDefaultSection").show();
					toggleEnableExternalRemote();
		    		$("#enableForceDiv").show();
		    	} else {
		    		$("#OOBBMC").hide();
		    		$("#OOBRemote").hide();
					$("#SepRemoteProtocolOpt").hide();
		    		$("#enableExternalRemoteDiv").hide();
		    		$("#enableExternalRemoteCheckbox").attr("checked", false);
					$("#inbandBMC").show();
					$('#oob_port_input').hide();
					$('#inband_cim_port_input').show();
					$('#inband_rest_port_input').show();
		    		if ($('#inbandInput').prop('checked')) {
		    			top.gl_Inband_Params.UserInput = true;
		    		} else {
		    			top.gl_Inband_Params.UserInput = false;
		    		}
		    		$("#certDefaultSection").hide();
		    		$("#enableForceDiv").show();
					if(top.isCFC(top.gl_current_mt)) {
						$('#CFCMustEnableExternalRemote').show();
						$("#OOBRemote").show();
						$("#SepRemoteProtocolOpt").show();
						$('#SepRemoteProtocolOpt option[value="SFTP"]').hide();
						$('#SepRemoteProtocolOpt option[value="HTTP"]').hide();
						if ($('#SepRemoteProtocolOpt').prop("value")=="SFTP" || $('#SepRemoteProtocolOpt').prop("value")=="HTTP") {
							$('#SepRemoteProtocolOpt option[value="HTTPS"]').prop("selected", true);
						}
						checkRemoteProtocolOpt();
					}
				}
				$("#enableBackupDiv").show();
			}
			$("#showNoAdaptersDiv").hide();
			top.gl_showNoAdapters = true;
		}

    	initOOBParams();
    	if (top.gl_OOB_Params.Enabled) {
    		Banner.set_active_status("", "");
    	}
    	// readOOBParams();
		// showTipsInfo("");
		// for bootable, unattended and autorun mode, skip this step
		if (top.gl_uxlite_bootable) {
			setTimeout(needForceCompare,1000);
		}

		printLog("DEBUG","function oob_init end.");
	}

	function needForceCompare(){
		top.initForceCompare();
		if (top.is_autorun() || top.is_unattend()) {
			gl_wizard.steps("next");
		}
	}

	function getMachineTypeByIMM(){
		deleteFile(top.getSupportFile("commonResult"));
		deleteFile(top.getSupportFile("scanResult"));
		
		$("#oobHostName,#oobUserName,#oobPassword,#remoteHostName,#remotePort,#remoteUserName,#remotePassword,#remoteLocation").prop("disabled",true);
		isGettingMachineType = true;
		// $("#showTipsInfo").html(statusImg + $.i18n.prop("OOBSetting.TipsInfo7"));
		top.showBmcWaitingMsg();

		var args = new Array();
        args.push(top.getSystemFile("oneCli"));
        args.push("update");
        args.push("scan");
		args.push("--imm");
		args.push(SplitFullConnInfo());

		args.push("--never-check-trust");
		args.push(...add_output_log5());
		printLog("INFO","run commend:" + getRunProgramCommend(args));
		runProgram(args, null, onGetMachineTypeFinished);
	}

	function onGetMachineTypeFinished(){
		if (userCanceled) {
			top.togglePrevious(true);
			top.toggleNext(true);
			return;
		}
		var isError = false;
		var errorInfo = "";
		try{
			var comm_ret_doc = top.readTextFile(top.getSupportFile("commonResult"));
			var comm_dom = ezJsLib.XmlDom.parse(comm_ret_doc);
			if("Yes" == ezJsLib.XmlDom.getValueByTagFromNode("ERROR", comm_dom.documentElement)){
				isError = true;
				errorInfo = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", comm_dom.documentElement);
			}

			// Bug 113848 - [UpdateXpress_all os]Select a blue machine for UpdateXpress remote update , the error message is not correct
			if (errorInfo.indexOf("You are running on an IBM system. But the current command is not supported") != -1) {
				errorInfo = "blue";
				top.gl_OOB_Params.MT = "blue";
			} else {
				var doc = top.readTextFile(top.getSupportFile("scanResult"));
				var dom = ezJsLib.XmlDom.parse(doc);
				var mt = ezJsLib.XmlDom.getValueByTagFromNode("MT", dom.documentElement);
				if (!mt || typeof(mt) == "undefined") {
					isError = true;
					errorInfo = $.i18n.prop("OOBSetting.TipsInfo8");
				} else {
					gl_OOB_Params.MT = mt;
				}
			}
		} catch(e) {
			isError = true;
			if (errorInfo == "") errorInfo = $.i18n.prop("OOBSetting.TipsInfo8");
		}
		
		top.togglePrevious(true);
		top.toggleNext(true);
		$("#oobHostName,#oobPort,#oobUserName,#oobPassword,#remoteHostName,#remotePort,#remoteUserName,#remotePassword,#remoteLocation").prop("disabled",false);
		top.hideBmcWaitingMsg();
		
		if (isError) {
			if (errorInfo == "blue") {
				isGettingMachineType = "runned";
			} else {
				showTipsInfo(errorInfo, "showBMCTips");
				isGettingMachineType = "runError";
			}
		} else {
			isGettingMachineType = "runned";
		}
		goNextStep();
	}

	function initOOBParams(){
		top.gl_OOB_Params.IMM_Address = "";
		top.gl_OOB_Params.IMM_UserName = "";
		top.gl_OOB_Params.IMM_Port = "";
		top.gl_OOB_Params.IMM_Password = "";
		top.gl_OOB_Params.Remote_Address = "";
		top.gl_OOB_Params.Remote_Port = "";
		top.gl_OOB_Params.Remote_UserName = "";
		top.gl_OOB_Params.Remote_Password = "";
		top.gl_OOB_Params.Remote_Location = "";
		top.gl_OOB_Params.MT = "";
	}

	function readOOBParams(){
		$("#oobHostName").val(top.gl_OOB_Params.IMM_Address);
		$("#oobUserName").val(top.gl_OOB_Params.IMM_UserName);
		$("#oobPort").val(top.gl_OOB_Params.IMM_Port);
		$("#oobPassword").val(top.gl_OOB_Params.IMM_Password);

		$("#remoteHostName").val(top.gl_OOB_Params.Remote_Address);
		$("#remotePort").val(top.gl_OOB_Params.Remote_Port);
		$("#remoteUserName").val(top.gl_OOB_Params.Remote_UserName);
		$("#remotePassword").val(top.gl_OOB_Params.Remote_Password);
		$("#remoteLocation").val(top.gl_OOB_Params.Remote_Location);
	}

	function writeOOBParams(){
		top.gl_OOB_Params.IMM_Address = $("#oobHostName").val();
		top.gl_OOB_Params.IMM_UserName = $("#oobUserName").val();
		top.gl_OOB_Params.IMM_Port = $("#oobPort").val();
		top.gl_OOB_Params.IMM_Password = $("#oobPassword").val();

		top.gl_OOB_Params.Remote_Address = $("#remoteHostName").val();
		top.gl_OOB_Params.Remote_Port = $("#remotePort").val();
		top.gl_OOB_Params.Remote_UserName = $("#remoteUserName").val();
		top.gl_OOB_Params.Remote_Password = $("#remotePassword").val();
		top.gl_OOB_Params.Remote_Location = $("#remoteLocation").val();
	}

	function writeInbandParams() {
		top.gl_Inband_Params.IMM_UserName = $("#inbandUserName").val();
		top.gl_Inband_Params.IMM_Port = $("#inbandCimPort").val();
		top.gl_Inband_Params.IMM_Password = $("#inbandPassword").val();
		top.gl_Inband_Params.REST_Port = $("#inbandRestPort").val();
	}

	function getIMMCert() {
		if (userCanceled) {
			top.togglePrevious(true);
			top.toggleNext(true);
			return;
		}
		var args = new Array();
    	args.push(top.getSystemFile("oneCli"));
    	args.push("misc");
    	args.push("gettrust");
    	args.push("--host");
    	args.push(top.gl_OOB_Params.IMM_Address);
		if (top.gl_OOB_Params.IMM_Port != null && top.gl_OOB_Params.IMM_Port != undefined && top.gl_OOB_Params.IMM_Port != "") {
			args.push("--port");
			args.push(top.gl_OOB_Params.IMM_Port);
		}
    	args.push("--type");
    	args.push("https");
    	args.push("--result");
    	// certIMMSaveFile is 
    	certIMMSaveFile = "IMM_" + top.gl_OOB_Params.IMM_Address + ".txt";
    	certIMMSaveFile = path.join(top.getSupportDir(), certIMMSaveFile);
    	top.deleteFile(certIMMTempFile);
		args.push(certIMMTempFile);
		args.push(...add_output_log5());
    	printLog("INFO","run commend:" + getRunProgramCommend(args));
    	runProgram(args, null, getIMMCertCB);
    	return "waiting";
	}

	function getIMMCertCB(success) {
		if (userCanceled) {
			top.togglePrevious(true);
			top.toggleNext(true);
			return "waiting";
		}
		if (!success || !top.fileExists(certIMMTempFile)) {
			scan_status = "bmc_fail";
			goNextStep();
		} else {
			scan_status = "bmc_success";
			goNextStep();
		}
	}

	function getRemoteCert() {
		if (userCanceled) {
			top.togglePrevious(true);
			top.toggleNext(true);
			return "waiting";
		}
		var args = new Array();
    	args.push(top.getSystemFile("oneCli"));
    	args.push("misc");
    	args.push("gettrust");
    	args.push("--host");
    	args.push(top.gl_OOB_Params.Remote_Address);
    	args.push("--port");
    	if (top.gl_OOB_Params.Remote_Port == "" || top.gl_OOB_Params.Remote_Port == undefined || top.gl_OOB_Params.Remote_Port == null) {
			if (top.gl_OOB_Params.Use_Sep_SFTP) {
				args.push("22");
			} else if (top.gl_OOB_Params.Use_Sep_HTTPS) {
				args.push("443");
			} else if (top.gl_OOB_Params.Use_Sep_FTP) {
				args.push("22");
			} else if (top.gl_OOB_Params.Use_Sep_HTTP) {
				args.push("80");
			}
    	} else {
    		args.push(top.gl_OOB_Params.Remote_Port);
    	}
    	args.push("--type");
    	if (top.gl_OOB_Params.Use_Sep_SFTP) {
			args.push("sftp");
		} else if (top.gl_OOB_Params.Use_Sep_HTTPS) {
			args.push("https");
		} else if (top.gl_OOB_Params.Use_Sep_FTP) {
			args.push("ftp");
		} else if (top.gl_OOB_Params.Use_Sep_HTTP) {
			args.push("http");
		}
    	args.push("--result");
    	certRemoteSaveFile = "Remote_" + top.gl_OOB_Params.Remote_Address + ".txt";
    	certRemoteSaveFile = path.join(top.getSupportDir(), certRemoteSaveFile);
    	top.deleteFile(certRemoteTempFile);
		args.push(certRemoteTempFile);
		args.push(...add_output_log5());
    	printLog("INFO","run commend:" + getRunProgramCommend(args));
    	runProgram(args, null, getRemoteCertCB);
    	return "waiting";
	}

	function getRemoteCertCB(success) {
		if (userCanceled) {
			top.togglePrevious(true);
			top.toggleNext(true);
			return "waiting";
		}
		if (!success || !top.fileExists(certRemoteTempFile)) {
			scan_status = "ssh_fail";
			goNextStep();
		} else {
			scan_status = "ssh_success";
			goNextStep();
		}
	}

	function checkInbandInput() {
		var cimPortValue = $("#inbandCimPort").val();
		var restPortValue = $("#inbandRestPort").val();
		var userValue = $("#inbandUserName").val();
		var passValue = $("#inbandPassword").val();
		if (cimPortValue && (isNaN(cimPortValue) || cimPortValue < 1 || cimPortValue > 65535)) {
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo4"), "showInbandBMCTips");
			return false;
		}
		if (restPortValue && (isNaN(restPortValue) || restPortValue < 1 || restPortValue > 65535)) {
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo4"), "showInbandBMCTips");
			return false;
		}
		if (!userValue && passValue || userValue && !passValue) {
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo10"), "showInbandBMCTips");
			return false;
		}
		return true;
	}

	function checkRemoteInputOnly() {
		var remoteHostName = $("#remoteHostName").val();
		var remotePort = $("#remotePort").val();
		var remoteUser = $("#remoteUserName").val();
		var remotePass = $("#remotePassword").val();
		var remoteLocation = $("#remoteLocation").val();
		if (!remoteHostName || !remoteLocation) {
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo3"), "showRemoteTips");
			return false;
		}
		// username/password is unnecessary for https/ftp/http
		if (top.gl_OOB_Params.Use_Sep_SFTP) {	
			if (!remoteUser || !remotePass) {
				showTipsInfo($.i18n.prop("OOBSetting.TipsInfo3"), "showRemoteTips");
				return false;
			} 
		}
		if(!checkHostName(remoteHostName)){
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo6"), "showRemoteTips");
			return false;
		} 
		if(remotePort && (isNaN(remotePort) || remotePort<1 || remotePort>65535) ){
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo4"), "showRemoteTips");
			return false;
		}
		return true;
	}

	function startGetCert() {
		printLog("INFO","Next was clicked.");
		if (top.gl_Inband_Params.Enabled) {
			// Inband input check
			if (top.gl_Inband_Params.UserInput) {
				if (!checkInbandInput()) {
					return false;
				}
				writeInbandParams();
				$("#showInbandBMCTips").hide();
			}
			// CFC remote server check
			if(top.isCFC(top.gl_current_mt)) {
				if (scan_status == "init") {
					showTipsInfo("");
					userCanceled = false;
					if (!checkRemoteInputOnly()) return false;
					writeOOBParams();
					top.showCertWaitMsg();
					if (!tagCheckDefault && !top.gl_OOB_Params.Use_Sep_FTP) {
						return getRemoteCert();
					}
					top.hideCertWaitMsg();
					return true;
				} else if (scan_status == "ssh_fail") {
					top.hideCertWaitMsg();
					scan_status = "init";
					if (!userCanceled) {
						showTipsInfo($.i18n.prop("OOBSetting.GetTrust.HTTPS.Failed"), "showRemoteTips");
						return false;
					} else {
						top.togglePrevious(true);
						top.toggleNext(true);
						return "waiting";
					}
				} else if (scan_status == "ssh_success") {
					top.hideCertWaitMsg();
					try {
						certRemoteTempContent = top.readTextFile(certRemoteTempFile);
					} catch (e) {
						showTipsInfo($.i18n.prop("OOBSetting.GetTrust.HTTPS.Failed"), "showRemoteTips");
						return false;
					}
					try {
						certRemoteSaveContent = top.readTextFile(certRemoteSaveFile);
					} catch (e) {
						certRemoteSaveContent = null;
					}

					certNewRemote = false;

					if (certRemoteTempContent == '') certNewRemote = false;
					if (certRemoteTempContent != '' && certRemoteTempContent != certRemoteSaveContent) certNewRemote = true;

					if (!certNewRemote) {
						top.hideCertWaitMsg();
						scan_status = "init";
						return true;
					} else {
						document.getElementById("certDialog").style.height = "295px";
					}
					if (certNewRemote) {
						$("#remoteCertSection").show();
						$("#remoteCertArea").html(certRemoteTempContent);
					}
			
					if (!userCanceled) {
						showCertContentMsg();
						return "waiting";
					} else {
						scan_status = "init";
						return "waiting";
					}
				} else if (scan_status == "cert_no_accept") {
					top.togglePrevious(true);
					top.toggleNext(true);
					scan_status = "init";
					return "waiting";
				} else if (scan_status == "start_get_mt") {
					if (certNewRemote) {
						if (top.fileExists(certRemoteSaveFile)) {
							top.deleteFile(certRemoteSaveFile);
						}
						top.writeTextFile(certRemoteSaveFile, certRemoteTempContent);
					}
					top.hideCertWaitMsg();
					scan_status = "init";
					return true;
				}
			}
			return true;
		// OOB Setting
		} else {
			if (!top.gl_OOB_Params.Use_Sep_Remote) {
				if (scan_status == "init") {
					showTipsInfo("");
					userCanceled = false;
					if (!checkOOBParams()) return false;
					writeOOBParams();
					if (!tagCheckDefault) {
						top.showCertWaitMsg();
						return getIMMCert();
					} else {
						scan_status = "start_get_mt";
						return beginGetMT();
					}
				} else if (scan_status == "bmc_fail") {
					top.hideCertWaitMsg();
					scan_status = "init";
					if (!userCanceled) {
						showTipsInfo($.i18n.prop("OOBSetting.GetTrust.BMC.Failed"), "showBMCTips");
						return false;
					} else {
						top.togglePrevious(true);
						top.toggleNext(true);
						return "waiting";
					}
				} else if (scan_status == "bmc_success") {
					top.hideCertWaitMsg();
					// var IMMCert = null;
					// var IMMSaveCert = null;
					certIMMSaveContent = null;
					certNewIMM = false;
	
					try {
						certIMMTempContent = top.readTextFile(certIMMTempFile);
					} catch (e) {
						showTipsInfo($.i18n.prop("OOBSetting.GetTrust.BMC.Failed"), "showBMCTips");
						return false;
					}
					try {
						certIMMSaveContent = top.readTextFile(certIMMSaveFile);
					} catch(e) {
						certIMMSaveContent = null;
					}
	
					if (certIMMTempContent == '') certNewIMM = false;
					if (certIMMTempContent == certIMMSaveContent) certNewIMM = false;
					if (certIMMTempContent != certIMMSaveContent && certIMMTempContent != '') certNewIMM = true;
	
					if (certNewIMM) {
						document.getElementById("certDialog").style.height = "295px";
						$("#bmcCertSection").show();
						$("#bmcCertArea").html(certIMMTempContent);
					} else {
						return beginGetMT();
					}
					/*
					if (certIMMSaveContent == null) {	// case: certificate has not been saved
						if (certIMMTempContent == "") {
							return beginGetMT();
						} else {
							document.getElementById("certDialog").style.height = "295px";
							$("#bmcCertSection").show();
							$("#bmcCertArea").html(certIMMTempContent);
						}
					} else {	// case: certificate has been saved before
						if (certIMMTempContent == certIMMSaveContent) {
							return beginGetMT();
						} else {
							document.getElementById("certDialog").style.height = "295px";
							$("#bmcCertSection").show();
							$("#bmcCertArea").html(certIMMTempContent);
						}
					}
					*/
					if (!userCanceled) {
						showCertContentMsg();
						return "waiting";
					} else {
						scan_status = "init";
						return "waiting";
					}
				} else if (scan_status == "cert_no_accept") {
					top.togglePrevious(true);
					top.toggleNext(true);
					scan_status = "init";
					return "waiting";
				} else if (scan_status == "start_get_mt") {
					if (certNewIMM) {
						if (top.fileExists(certIMMSaveFile)) {
							top.deleteFile(certIMMSaveFile);
						}
						top.writeTextFile(certIMMSaveFile, certIMMTempContent);
					}
					return beginGetMT();
				}	
			} else if (top.gl_OOB_Params.Use_Sep_SFTP || top.gl_OOB_Params.Use_Sep_HTTPS) {
				if (scan_status == "init") {
					showTipsInfo("");
					userCanceled = false;
					if (!checkOOBParams()) return false;
					writeOOBParams();
					top.showCertWaitMsg();
					if (!tagCheckDefault) {
						return getIMMCert();
					} else {
						return getRemoteCert();
					}
				} else if (scan_status == "bmc_fail") {
					top.hideCertWaitMsg();
					scan_status = "init";
					if (!userCanceled) {
						showTipsInfo($.i18n.prop("OOBSetting.GetTrust.BMC.Failed"), "showBMCTips");
						return false;
					} else {
						top.togglePrevious(true);
						top.toggleNext(true);
						return "waiting";
					}
				} else if (scan_status == "bmc_success") {
					return getRemoteCert();
				} else if (scan_status == "ssh_fail") {
					top.hideCertWaitMsg();
					scan_status = "init";
					if (!userCanceled) {
						if (!tagCheckDefault) {
							showTipsInfo($.i18n.prop("OOBSetting.GetTrust.Remote.Failed"), "showRemoteTips");
						} else {
							showTipsInfo($.i18n.prop("OOBSetting.RemoteConnect.Failed"), "showRemoteTips");
						}
						return false;
					} else {
						top.togglePrevious(true);
						top.toggleNext(true);
						return "waiting";
					}
				} else if (scan_status == "ssh_success") {
					top.hideCertWaitMsg();
					if (!tagCheckDefault) {
						try {
							certIMMTempContent = top.readTextFile(certIMMTempFile);
						} catch (e) {
							showTipsInfo($.i18n.prop("OOBSetting.GetTrust.BMC.Failed"), "showBMCTips");
							return false;
						}
						try {
							certRemoteTempContent = top.readTextFile(certRemoteTempFile);
						} catch (e) {
							showTipsInfo($.i18n.prop("OOBSetting.GetTrust.Remote.Failed"), "showRemoteTips");
							return false;
						}
						try {
							certIMMSaveContent = top.readTextFile(certIMMSaveFile);
						} catch (e) {
							certIMMSaveContent = null;
						}
						try {
							certRemoteSaveContent = top.readTextFile(certRemoteSaveFile);
						} catch (e) {
							certRemoteSaveContent = null;
						}
	
						certNewIMM = false;
						certNewRemote = false;
	
						if (certIMMTempContent == '') certNewIMM = false;
						if (certRemoteTempContent == '') certNewRemote = false;
						if (certIMMTempContent != '' && certIMMTempContent != certIMMSaveContent) certNewIMM = true;
						if (certRemoteTempContent != '' && certRemoteTempContent != certRemoteSaveContent) certNewRemote = true;
	
						if (certNewIMM == false && certNewRemote == false) return beginGetMT();
						if (certNewIMM != false && certNewRemote != false) {
							document.getElementById("certDialog").style.height = "515px";
						} else {
							document.getElementById("certDialog").style.height = "295px";
						}
						if (certNewIMM) {
							$("#bmcCertSection").show();
							$("#bmcCertArea").html(certIMMTempContent);
						}
						if (certNewRemote) {
							$("#remoteCertSection").show();
							$("#remoteCertArea").html(certRemoteTempContent);
						}
	
						/*
						if (IMMCert == "" && SFTPCert == "") return beginGetMT();
						if (IMMCert !== "" && SFTPCert != "") {
							document.getElementById("certDialog").style.height = "515px";
						} else {
							document.getElementById("certDialog").style.height = "295px";
						}
						if (IMMCert != "") {
							$("#bmcCertSection").show();
							$("#bmcCertArea").html(IMMCert);
						}
						if (SFTPCert != "") {
							$("#remoteCertSection").show();
							$("#remoteCertArea").html(SFTPCert);
						}
						*/
			 
						if (!userCanceled) {
							showCertContentMsg();
							return "waiting";
						} else {
							scan_status = "init";
							return "waiting";
						}
					} else {
						scan_status = "start_get_mt";
						return beginGetMT();
					}
					
				} else if (scan_status == "cert_no_accept") {
					top.togglePrevious(true);
					top.toggleNext(true);
					scan_status = "init";
					return "waiting";
				} else if (scan_status == "start_get_mt") {
					if (certNewIMM) {
						if (top.fileExists(certIMMSaveFile)) {
							top.deleteFile(certIMMSaveFile);//fix coverity issue 60436
						}
						top.writeTextFile(certIMMSaveFile, certIMMTempContent);
					}
					if (certNewRemote) {
						if (top.fileExists(certRemoteSaveFile)) {
							top.deleteFile(certRemoteSaveFile);
						}
						top.writeTextFile(certRemoteSaveFile, certRemoteTempContent);
					}
					return beginGetMT();
				}
			} else if (top.gl_OOB_Params.Use_Sep_FTP || top.gl_OOB_Params.Use_Sep_HTTP) {
				if (scan_status == "init") {
					showTipsInfo("");
					userCanceled = false;
					if (!checkOOBParams()) return false;
					writeOOBParams();
					top.showCertWaitMsg();
					if (!tagCheckDefault) {
						return getIMMCert();
					} else {
						top.hideCertWaitMsg();
						scan_status = "start_get_mt";
						return beginGetMT();
					}
				} else if (scan_status == "bmc_fail") {
					top.hideCertWaitMsg();
					scan_status = "init";
					if (!userCanceled) {
						showTipsInfo($.i18n.prop("OOBSetting.GetTrust.BMC.Failed"), "showBMCTips");
						return false;
					} else {
						top.togglePrevious(true);
						top.toggleNext(true);
						return "waiting";
					}
				} else if (scan_status == "bmc_success") {
					top.hideCertWaitMsg();
					if (!tagCheckDefault) {
						try {
							certIMMTempContent = top.readTextFile(certIMMTempFile);
						} catch (e) {
							showTipsInfo($.i18n.prop("OOBSetting.GetTrust.BMC.Failed"), "showBMCTips");
							return false;
						}
						try {
							certIMMSaveContent = top.readTextFile(certIMMSaveFile);
						} catch (e) {
							certIMMSaveContent = null;
						}
	
						certNewIMM = false;
	
						if (certIMMTempContent == '') certNewIMM = false;
						if (certIMMTempContent != '' && certIMMTempContent != certIMMSaveContent) certNewIMM = true;
	
						if (certNewIMM == false) {
							return beginGetMT();
						} else {
							document.getElementById("certDialog").style.height = "295px";
						}
						if (certNewIMM) {
							$("#bmcCertSection").show();
							$("#bmcCertArea").html(certIMMTempContent);
						}
			 
						if (!userCanceled) {
							showCertContentMsg();
							return "waiting";
						} else {
							scan_status = "init";
							return "waiting";
						}
					} else {
						scan_status = "start_get_mt";
						return beginGetMT();
					}
					
				} else if (scan_status == "cert_no_accept") {
					top.togglePrevious(true);
					top.toggleNext(true);
					scan_status = "init";
					return "waiting";
				} else if (scan_status == "start_get_mt") {
					if (certNewIMM) {
						if (top.fileExists(certIMMSaveFile)) {
							top.deleteFile(certIMMSaveFile);//fix coverity issue 60436
						}
						top.writeTextFile(certIMMSaveFile, certIMMTempContent);
					}
					return beginGetMT();
				}
			}
		}
	}

	function toggleInbandSection() {
		if ($("#inbandInput").prop("checked")) {
			printLog("INFO","check box 'Input BMC access information' checked.");
			$("#inbandInputSection").show();
			// AMD machine bmc port is default with 443
			if(top.isAmd(top.gl_current_mt)) {
				$("#inband_cim_port_input").hide();
				$("#inband_rest_port_input").hide();
			}
			top.gl_Inband_Params.UserInput = true;
		} else {
			printLog("INFO","check box 'Input BMC access information' unchecked.");
			$("#inbandInputSection").hide();
			top.gl_Inband_Params.UserInput = false;
		}
		$("#showInbandBMCTips").hide();//fix coverity issue 63435
	}

	function toggleEnableExternalRemote() {
		if ($("#enableExternalRemoteCheckbox").prop("checked")) {
			printLog("INFO","check box 'Use a seperate remote server instead of the BMC one' checked.");
			$("#OOBRemote").show();
			$("#SepRemoteProtocolOpt").show();
			top.gl_OOB_Params.Use_Sep_Remote = true;
			checkRemoteProtocolOpt();
		} else {
			printLog("INFO","check box 'Use a seperate remote server instead of the BMC one' unchecked.");
			$("#OOBRemote").hide();
			$("#SepRemoteProtocolOpt").hide();
			top.gl_OOB_Params.Use_Sep_Remote = false;
			// If disable remote server, we don't need to care the status of args or texts except "acceptCertLabel".
			$("#acceptCertLabel").html($.i18n.prop("OOBSetting.ConfirmTrust.Option"));
		}
		$("#showRemoteTips").hide();//fix coverity issue 63437
	}

	function toggleEnableBackup() {
		if ($("#enableBackupCheckbox").prop("checked")) {
			printLog("INFO","check box 'Only update the backup image of the BMC(and UEFI where applicable)' checked.");
			top.gl_optionBackup = true;
		} else {
			printLog("INFO","check box 'Only update the backup image of the BMC(and UEFI where applicable)' unchecked.");
			top.gl_optionBackup = false;
		}
	}

	function showNoAdapters() {
		if ($("#showNoAdaptersCheckbox").prop("checked")) {
			printLog("INFO","check box 'Show updates with no adapters detected' checked.");
			top.gl_showNoAdapters = true;
		} else {
			printLog("INFO","check box 'Show updates with no adapters detected' unchecked.");
			top.gl_showNoAdapters = false;
		}
	}

	function showCertContentMsg() {
		$("#certConfirmDiv").show();
	}

	function hideCertContentMsg() {
		$("#certConfirmDiv").hide();
	}

	function acceptCert() {
		hideCertContentMsg();
		cleanCertContent();
		// certAccepted = true;
		scan_status = "start_get_mt";
		goNextStep();
	}

	function noAcceptCert() {
		hideCertContentMsg();
		cleanCertContent();
		// certAccepted = false;
		scan_status = "cert_no_accept";
		goNextStep();
	}

	function cleanCertContent() {
		$("#bmcCertSection").hide();
		$("#bmcCertArea").html("");
		$("#remoteCertSection").hide();
		$("#remoteCertArea").html("");
	}

	function beginGetMT(){
		userCanceled = false;
		writeOOBParams();
		if(isGettingMachineType == "runned"){
			isGettingMachineType = false;
			// Check the current mt is in support list. Add by wengmh1 2017/3/3
			if(!top.checkSupportMachineType(gl_OOB_Params.MT))
			{
				alert($.i18n.prop("Common.SystemNotSupport"));
				scan_status = "init";
				return false;
			}
			// for oob case, remove update type page
			// if is purley, select UXSP
			// if is prepurley, select individual
			// add by chenhao: 20170425
			// rollback to previous design:
			// for oob case, display update type page
			// will let user to select whether use UXSP or individual
			if (top.gl_OOB_Params.Enabled) {
				// do not remove update type page
				// var update_type_index = gl_steps_current.indexOf(Update_Type);
		 		// if (update_type_index > 0) {
		 		//     gl_steps_current.splice(update_type_index, 1);
		 		// } 
		 		var update_selection_index = gl_steps_current.indexOf(Update_Selection);
		 		if (update_selection_index > 0){
		 			gl_steps_current.splice(update_selection_index, 1);
		 		}
		 		configSteps(gl_steps_current);

				/**
				 * About remote server, changed by liwx9 20210909
				 * Just for if-else below, not represent actual situation
				 * 			NoRemote	SFTP	FTP		HTTPS	HTTP
				 * CFC		   N		 N		 Y		  Y		 N
				 * Grantly	   N		 Y		 N		  N		 N
				 * Amd		   Y		 N		 N		  N		 N
				 * Others	   Y		 Y		 N		  Y		 Y
				 */
				if (top.isCFC()) {
					if (!top.gl_OOB_Params.Use_Sep_Remote || top.gl_OOB_Params.Use_Sep_SFTP || top.gl_OOB_Params.Use_Sep_HTTP) {
						top.hideBmcWaitingMsg();
		 				top.hideCertWaitMsg();
		 				alert($.i18n.prop('OOBSetting.CFC.Required', top.gl_OOB_Params.MT));
						return false;
					}
				} else if (top.isGrantly()) {
					if (!(top.gl_OOB_Params.Use_Sep_Remote && top.gl_OOB_Params.Use_Sep_SFTP)) {
						top.hideBmcWaitingMsg();
		 				top.hideCertWaitMsg();
		 				alert($.i18n.prop('OOBSetting.Grantly.Required', top.gl_OOB_Params.MT));
						return false;
					}
				} else if(top.isAmd()) {
					if(top.gl_OOB_Params.IMM_Port != "" && top.gl_OOB_Params.IMM_Port != "443") {
						top.hideBmcWaitingMsg();
						top.hideCertWaitMsg();
						alert($.i18n.prop('OOBSetting.Amd.Port', top.gl_OOB_Params.MT));
						return false;
					}
					if(top.gl_OOB_Params.Use_Sep_Remote) {
						top.hideBmcWaitingMsg();
						top.hideCertWaitMsg();
						alert($.i18n.prop('OOBSetting.Amd.Remote', top.gl_OOB_Params.MT));
						return false;
					}
				} else {
					if (top.gl_OOB_Params.Use_Sep_Remote && top.gl_OOB_Params.Use_Sep_FTP) {
						top.hideBmcWaitingMsg();
		 				top.hideCertWaitMsg();
		 				alert($.i18n.prop('OOBSetting.NotFTP.Required', top.gl_OOB_Params.MT));
						return false;
					}
				}
		 		// // no matter it is purley or grantley, will let user to select UXSP or individual
		 		// if (!top.isGrantly()) {
		 		// 	// top.gl_isUXSP = true;
		 		// } else {
		 		// 	// for oob mode, use UXSP for meta data
		 		// 	// top.gl_isUXSP = false;
		 		// 	// rollback to previous design
		 		// 	// for oob case, display update type page
				// 	// will let user to select whether use UXSP or individual
		 		// 	// top.gl_isUXSP = true;
		 		// 	// for oob case, no need to show update selection
		 		// 	// not sure what is the purpose of the following code, comment them first
		 		// 	/*
		 		// 	if (top.gl_isViaWeb) {
				//   		var acquire_update_index = gl_steps_current.indexOf(Acquire_Updates);
				//   		// if acquire page is not displayed, do not show update selection page
				//   		if (acquire_update_index > 0) {
				//   			gl_steps_current.splice(acquire_update_index, 0, Update_Selection);
				//   			configSteps(gl_steps_current);
				//   		}
				//   	}
				//   	*/

				// }
			} else if (top.gl_configRaid) {
				if (top.isCFC(top.gl_OOB_Params.MT)) {
					top.hideBmcWaitingMsg();
					top.hideCertWaitMsg();
					alert($.i18n.prop('OOBSetting.RaidConfig.CFC', top.gl_OOB_Params.MT));
					scan_status = "init";
					return false;
				}
			}
			Banner.set_active_status(gl_OOB_Params.MT, "");
			scan_status = "init";
			return true;
		}else if("runError" == isGettingMachineType){
			isGettingMachineType = false;
			scan_status = "init";
			return false;
		}else{
			showTipsInfo("");
			if(!checkOOBParams()){ 
				scan_status = "init";
				return false;
			}
			
			if(!isGettingMachineType)
				getMachineTypeByIMM();
			if(isGettingMachineType){
				top.togglePrevious(false);
				top.toggleNext(false);
				return "waiting";
			}
		}
	}

	function checkParamIsNull(){
		var ret = "";
		$(["oobHostName", "oobUserName", "oobPassword"]).each(function(i, n){
			var value=$("#" + n).val();
			if(!value || value == ""){
				ret = "showBMCTips";
				$("#"+n).focus();
				return false;
			}
		});
		if(ret == "" && top.gl_OOB_Params.Use_Sep_Remote){
			$(["remoteHostName", "remoteLocation"]).each(function(i, n){
				var value=$("#"+n).val();
				if(!value || value == ""){
					$("#" + n).focus();
					ret = "showRemoteTips";
					return false;
				}
			});
			// username/password is unnecessary for https/ftp/http
			if (top.gl_OOB_Params.Use_Sep_SFTP) {
				$(["remoteUserName", "remotePassword"]).each(function(i, n){
					var value=$("#"+n).val();
					if(!value || value == ""){
						$("#" + n).focus();
						ret = "showRemoteTips";
						return false;
					}
				});
			}
		}
		
		return ret;
	}

	function checkOOBParams(){
		var retid = checkParamIsNull();
		if(retid!=""){
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo3"), retid);
			return false;
		}

		var oobHostName = $("#oobHostName").val();
		if (!checkHostName(oobHostName)){
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo2"), "showBMCTips");
			return false;
		} 

		var oobPort = $("#oobPort").val();
		if(oobPort && (isNaN(oobPort) || oobPort<1 || oobPort>65535) ){
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo4"), "showBMCTips");
			return false;
		}

		if (top.gl_OOB_Params.Use_Sep_Remote) {
			var remoteHostName = $("#remoteHostName").val();
			if(!checkHostName(remoteHostName)){
				showTipsInfo($.i18n.prop("OOBSetting.TipsInfo6"), "showRemoteTips");
				return false;
			} 

			var remotePort = $("#remotePort").val();
			if(remotePort && (isNaN(remotePort) || remotePort<1 || remotePort>65535) ){
				showTipsInfo($.i18n.prop("OOBSetting.TipsInfo4"), "showRemoteTips");
				return false;
			}
		}
		return true;
	}

	/*
	function checkIPV4(ip){  
		var exp = /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/;  
		var flag = ip.match(exp);  
		if(flag != undefined && flag != "" && flag != null && flag != false){  
		   	return true;  
		} else {  
		  	return false;  
		}  
	}  

	function checkIPV6(ipvalue){  
	  	var isIpv6 = false;  
		if(ipvalue.match(/:/g).length <= 7 && /::/.test(ipvalue) ? /^([\da-f]{1,4}(:|::)){1,6}[\da-f]{1,4}$/i.test(ipvalue) : /^([\da-f]{1,4}:){7}[\da-f]{1,4}$/i.test(ipvalue)){  
		    isIpv6 = true;  
		}  
		if(isIpv6){  
		   	return true;  
		} else {  
		  	return false;  
		}  
		var matchColon = ipvalue.match(/:/g);
		if (matchColon == undefined || matchColon == null || matchColon == "") return false;
		if (matchColon.length > 7) return false;
		var flag = /::/.test(ipvalue) ? /^([\da-f]{1,4}(:|::)){1,6}[\da-f]{1,4}$/i.test(ipvalue) : /^([\da-f]{1,4}:){7}[\da-f]{1,4}$/i.test(ipvalue);
		if (flag != undefined && flag != "" && flag != false || flag != null) {
			return true;
		} else {
			return false;
		}
	} 
	*/

	function checkHostName(hostName) {
		var expHostName = /((^\s*((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))\s*$)|(^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$))|(^\s*((?=.{1,255}$)(?=.*[A-Za-z].*)[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?)*)\s*$)/;
		var flag = expHostName.test(hostName);
		if (flag) return true;
		else return false;
	}

	function showTipsInfo(str, id){
		if (str == ""){
			$("#showBMCTips").hide();
			$("#showRemoteTips").hide();
			$("#showInbandBMCTips").hide();
			return;
		}
		$("#"+id).show();
		$("#"+id+"Info").html(str);
	}

	function toggleEnableUpdateSelection() {
        if ($("#enableUpdate").prop("checked")) {
			printLog("INFO","check box 'Enable updating to a back-level firmware' checked.");
            top.gl_force = true;
        } else {
			printLog("INFO","check box 'Enable updating to a back-level firmware' unchecked.");
            top.gl_force = false;
        }
    }

	function setUserCancel(value) {
        userCanceled = value;
        isGettingMachineType = false;
        scan_status = "init";
        $("#oobHostName, #oobUserName, #oobPassword, #remoteHostName, #remotePort, #remoteUserName, #remotePassword, #remoteLocation").prop("disabled", false);
    }

    function userCancelGetCert(value) {
    	// certGot = false;
    	scan_status = "init";
    	userCanceled = true;
    	$("#oobHostName, #oobUserName, #oobPassword, #remoteHostName, #remotePort, #remoteUserName, #remotePassword, #remoteLocation").prop("disabled", false);
    } 

	function checkRemoteProtocolOpt() {
		if (top.gl_OOB_Params.Enabled) {
			if ($('#SepRemoteProtocolOpt').prop("value")=="SFTP") {
				// argumrnts
				top.gl_OOB_Params.Use_Sep_SFTP = true;
				top.gl_OOB_Params.Use_Sep_HTTPS = false;
				top.gl_OOB_Params.Use_Sep_FTP = false;
				top.gl_OOB_Params.Use_Sep_HTTP = false;
				// text
				$("#acceptCertLabel").html($.i18n.prop("OOBSetting.ConfirmTrust.Option.SFTP"));
				$("#RemoteTitle").html($.i18n.prop("OOBSetting.SFTP.Title"));
				$("#RemoteSubtitle").html($.i18n.prop("OOBSetting.SFTP.SubTitle"));
				$("#RemotePortHint").html($.i18n.prop("OOBSetting.SFTP.Port.Hint"));
				$("#RemotePayloadHint").html($.i18n.prop("OOBSetting.SFTP.Payload.Hint"));
				$("#RemoteIpInputTitle").html($.i18n.prop("OOBSetting.SFTP.Host"));
				$("#NecessaryFlagUser").show();
				$("#NecessaryFlagPassword").show();
			} else if ($('#SepRemoteProtocolOpt').prop("value")=="HTTPS") {
				top.gl_OOB_Params.Use_Sep_SFTP = false;
				top.gl_OOB_Params.Use_Sep_HTTPS = true;
				top.gl_OOB_Params.Use_Sep_FTP = false;
				top.gl_OOB_Params.Use_Sep_HTTP = false;
				$("#acceptCertLabel").html($.i18n.prop("OOBSetting.ConfirmTrust.Option.HTTPS"));
				$("#RemoteTitle").html($.i18n.prop("OOBSetting.HTTPS.Title"));
				$("#RemoteSubtitle").html($.i18n.prop("OOBSetting.HTTPS.SubTitle"));
				$("#RemotePortHint").html($.i18n.prop("OOBSetting.HTTPS.Port.Hint"));
				$("#RemotePayloadHint").html($.i18n.prop("OOBSetting.HTTPS.Payload.Hint"));
				$("#RemoteIpInputTitle").html($.i18n.prop("OOBSetting.SFTP.HostOnly"));
				$("#NecessaryFlagUser").hide();
				$("#NecessaryFlagPassword").hide();
			} else if ($('#SepRemoteProtocolOpt').prop("value")=="FTP") {
				top.gl_OOB_Params.Use_Sep_SFTP = false;
				top.gl_OOB_Params.Use_Sep_HTTPS = false;
				top.gl_OOB_Params.Use_Sep_FTP = true;
				top.gl_OOB_Params.Use_Sep_HTTP = false;
				$("#acceptCertLabel").html($.i18n.prop("OOBSetting.ConfirmTrust.Option"));
				$("#RemoteTitle").html($.i18n.prop("OOBSetting.FTP.Title"));
				$("#RemoteSubtitle").html($.i18n.prop("OOBSetting.FTP.SubTitle"));
				$("#RemotePortHint").html($.i18n.prop("OOBSetting.FTP.Port.Hint"));
				$("#RemotePayloadHint").html($.i18n.prop("OOBSetting.FTP.Payload.Hint"));
				$("#RemoteIpInputTitle").html($.i18n.prop("OOBSetting.SFTP.Host"));
				$("#NecessaryFlagUser").hide();
				$("#NecessaryFlagPassword").hide();
			} else if ($('#SepRemoteProtocolOpt').prop("value")=="HTTP") {
				top.gl_OOB_Params.Use_Sep_SFTP = false;
				top.gl_OOB_Params.Use_Sep_HTTPS = false;
				top.gl_OOB_Params.Use_Sep_FTP = false;
				top.gl_OOB_Params.Use_Sep_HTTP = true;
				$("#acceptCertLabel").html($.i18n.prop("OOBSetting.ConfirmTrust.Option"));
				$("#RemoteTitle").html($.i18n.prop("OOBSetting.HTTP.Title"));
				$("#RemoteSubtitle").html($.i18n.prop("OOBSetting.HTTP.SubTitle"));
				$("#RemotePortHint").html($.i18n.prop("OOBSetting.HTTP.Port.Hint"));
				$("#RemotePayloadHint").html($.i18n.prop("OOBSetting.HTTP.Payload.Hint"));
				$("#RemoteIpInputTitle").html($.i18n.prop("OOBSetting.SFTP.Host"));
				$("#NecessaryFlagUser").hide();
				$("#NecessaryFlagPassword").hide();
			}
		} else {
			if ($('#SepRemoteProtocolOpt').prop("value")=="HTTPS") {
				top.gl_OOB_Params.Use_Sep_SFTP = false;
				top.gl_OOB_Params.Use_Sep_HTTPS = true;
				top.gl_OOB_Params.Use_Sep_FTP = false;
				$("#certDefaultSection").show();
				$("#acceptCertLabel").html($.i18n.prop("OOBSetting.ConfirmTrust.Option.HTTPSOnly"));
				$("#RemoteTitle").html($.i18n.prop("OOBSetting.HTTPS.Title"));
				$("#RemoteSubtitle").html($.i18n.prop("OOBSetting.HTTPS.SubTitle"));
				$("#RemotePortHint").html($.i18n.prop("OOBSetting.HTTPS.Port.Hint"));
				$("#RemotePayloadHint").html($.i18n.prop("OOBSetting.HTTPS.Payload.Hint"));
				$("#RemoteIpInputTitle").html($.i18n.prop("OOBSetting.SFTP.HostOnly"));
			} else if ($('#SepRemoteProtocolOpt').prop("value")=="FTP") {
				top.gl_OOB_Params.Use_Sep_SFTP = false;
				top.gl_OOB_Params.Use_Sep_HTTPS = false;
				top.gl_OOB_Params.Use_Sep_FTP = true;
				$("#certDefaultSection").hide();
				$("#RemoteTitle").html($.i18n.prop("OOBSetting.FTP.Title"));
				$("#RemoteSubtitle").html($.i18n.prop("OOBSetting.FTP.SubTitle"));
				$("#RemotePortHint").html($.i18n.prop("OOBSetting.FTP.Port.Hint"));
				$("#RemotePayloadHint").html($.i18n.prop("OOBSetting.FTP.Payload.Hint"));
				$("#RemoteIpInputTitle").html($.i18n.prop("OOBSetting.SFTP.Host"));
			}
			$("#NecessaryFlagUser").hide();
			$("#NecessaryFlagPassword").hide();
		}
	}
	
	return {
		index: 0,
		name: "OOB_Setting",
        init: oob_init, 
        nextAction: startGetCert,
        previousAction: function(){
			printLog("INFO","Previous was clicked.");
        	showTipsInfo("");
        	return true;
        },
        toggleInbandSection: toggleInbandSection,
        toggleEnableUpdateSelection: toggleEnableUpdateSelection,
	toggleEnableExternalRemote: toggleEnableExternalRemote,
	checkRemoteProtocolOpt: checkRemoteProtocolOpt,
	toggleEnableBackup: toggleEnableBackup,
	showNoAdapters: showNoAdapters,
        setUserCancel: setUserCancel,
        userCancelGetCert: userCancelGetCert,
        acceptCert: acceptCert,
        noAcceptCert: noAcceptCert,
        checkDefault: checkDefault,
        needReInit: true,
		importId: '#import_oob_setting',
        selectorId: '.oob_setting',
        title: "Navi.OOBSetting"
	}
}();