// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Update_Selection = function() {

	var su_progress_timer;
	var startIndex = 2;
	var su_package_count = 0;
	var su_viewed_contents = null;
	var contentNo = 1;
	var su_incmpltStt = new Array();
	var selectedSize = 0; //the user-selected packs' total size, default integer
	var su_current_content_index = 0; //number of contents keeps increasing, unnecessary to check every contents in the xml file
	var isUXSPI = false;
	var noneOS = "none";
	var selectionContentDiv = "";
	var bmuFixIds = new Array();

	//buffer the html element frequently refered
	_doc = document;
	 //need the explorer to parse the js file after html file loaded
	header = [];
	var acquire_running = false;

	// the value will to set to true if there is error in ac_result.xml
	var mainContentMissing = false;

	function su_init() {
		printLog("INFO","Update Selection page init.");
		//remove two columns which are Size and Location at 2016.12.22
		header = ["", $.i18n.prop("UpdateSelection.Component"), $.i18n.prop("UpdateSelection.UpdateId"), $.i18n.prop("UpdateSelection.ReleaseDate")/**, $.i18n.prop("UpdateSelection.Size"), $.i18n.prop("UpdateSelection.Location")**/];
	
		beginAcq();

	}

	/*
	 * add operations that can perform asynchronously while reloading...
	 */
	function su_reload() {
		window.location.reload();
		toggleNext(false);
	}

	function su_collect() {
		printLog("INFO","Next was clicked.");
		if (top.gl_isUXSP) {
			top.gl_refresh_selection_page = false;
		} else {
			top.gl_su_list = new Array();
			for (var i = 0; i < su_package_count; i++) {
				if (_doc.getElementById("su_checkbox" + i).checked == true) {
					top.gl_su_list.push(getValue("ID", document.getElementById("su_checkbox" + i).value));
				}
			}
			$.unique(top.gl_su_list);
			if (top.gl_su_list.length < 1){
				alert($.i18n.prop("UpdateSelection.NoPackage"));
				return false;
			}
			else {
				//this global variable makes update_selection.html do nothing
				top.gl_refresh_selection_page = false;
				//append bmuFixIds
				top.gl_su_list = top.gl_su_list.concat(bmuFixIds);
				//nextDefinedByUX();
				//return true;
			}
		}
		return true;
	}

	function clearResultFiles() {
        deleteFile(top.getSupportFile("acquireResult"));
        var series = 2;
        // To avoid dead loop
        while(series<=100)
        {
            var tempFilename = top.getSupportFileBySeries("acquireResult", series)
            if(fileExists(tempFilename))
            {
                deleteFile(tempFilename);
                series++;
            }
            else
            {
                break;
            }
        }
        deleteFile(top.getSupportFile("commonResult"));
    }

	function beginAcq() {
		selectionContentDiv = $("#UpdateSelectionContentDiv").html();
		startIndex = 2;
		su_package_count = 0;
		su_viewed_contents = null;
		contentNo = 1;
		su_incmpltStt = new Array();
		selectedSize = 0; 
		su_current_content_index = 0; 
		acquire_running = false;
		mainContentMissing = false;

		togglePrevious(false);
    	toggleNext(false);
    	
		_details = _doc.getElementById("details_selection");
		_details.innerHTML = "";
		_details.style.display = "block";
		_doc.getElementById("acqMsg").style.display = "block";
		_doc.getElementById("beginBtn").style.display = "none";
		if (su_viewed_contents == null)
			su_viewed_contents = new Array();
		if (top.gl_os_list.length == 1 && top.gl_os_list[0] == "none") {
			contentNo = parseInt(top.gl_mt_list.length) * parseInt(top.gl_os_list.length) >= 1 ? parseInt(top.gl_mt_list.length) * parseInt(top.gl_os_list.length) : 1;
		} else {
			/*for defect XB048515*/
			if (top.gl_isUpdate && !top.gl_isUXSP) {
				var cnt = parseInt(top.gl_mt_list.length) * (parseInt(top.gl_os_list.length) + 1); /*1 means os "none" added for OS agnostic update */
				contentNo = cnt >= 1 ? cnt + 1 : 1;
			} else {
				/*1 added for UXSPI Binary and SEP download*/
				contentNo = parseInt(top.gl_mt_list.length) * parseInt(top.gl_os_list.length) >= 1 ? parseInt(top.gl_mt_list.length) * parseInt(top.gl_os_list.length) + 1 : 1;
			}
		}
		_doc.getElementById("acqMsg1").style.display = "block";
		//Preparation	
		clearResultFiles();

		var args = new Array();
		args.push(top.getSystemFile("oneCli"));
		args.push("update");
		args.push("acquire");
		args.push("--xml");
		if (!top.gl_isUXSP){
			args.push("--scope");
			args.push("latest");
		}
		// args.push("--report");
		args.push("--metaonly");

		//set mt
		args.push("--mt");
		if(top.gl_OOB_Params.Enabled){
	        args.push(top.gl_OOB_Params.MT);
	    }else {
	    	var mtString = "";
			if (!top.gl_isUpdate) {
				for (var i = 0; i < top.gl_mt_list.length; i++) {
					mtString += top.gl_mt_list[i] + ",";
				}
			}
	    	if (mtString == "") {
				mtString = top.gl_current_mt;
				args.push(mtString);
			}else{
				args.push(mtString.substring(0, mtString.length-1));
			}
	    } 

		//set os
		if(!top.gl_OOB_Params.Enabled){
			var osString = "";
			if (!top.gl_isUpdate) {
				for (var i = 0; i < top.gl_os_list.length; i++) {
					/*add "none" for agnostic in CLI */
					if (top.gl_os_list[i] != "none" || top.gl_isNoneSelected) {
						osString += top.gl_os_list[i] + ",";
					}
				}
			}
			args.push("--ostype");
			if (osString == "") {
				/*add "none" for agnostic in CLI */
				osString = top.gl_current_os; //add for OS agnostic update
				args.push(osString);
			}else{
				args.push(osString.substring(0, osString.length-1));
			}
		}
		else
		{
			args.push("--ostype");
			args.push("platform");
		}
		

		args.push("--dir");
        args.push(top.getSupportDir());

		//set proxy if there is
		args.push(...add_proxy_para());

		args.push(...add_output_log5());

        // top.setPreviewParams(args);

		// args.push("--preview");
		// args.push("--previewusername");
		// args.push("espftp");
		// args.push("--previewpassword");
		// args.push('2345.wert');
		top.use_preview_server(args);

		acquire_running = true;

		printLog("INFO","run commend:" + getRunProgramCommend(args));
		runProgram(args, null, onAcquireFinished);

		createAllContents();
		su_progress_timer = setInterval(showUpdateList, 1000);
	}

	function onAcquireFinished() {
		acquire_running = false;
	}

	function su_cancel() {
		$("#UpdateSelectionContentDiv").html(selectionContentDiv);
        clearInterval(su_progress_timer);
        top.killOneCli();
        _doc.getElementById("acqMsg").style.display = "none";
        _doc.getElementById("details_acquire").style.display = "none";
        _doc.getElementById("beginBtn").style.display = "block";
		//su_reload();
		togglePrevious(true);
	}

	function findBMUFixIds(doc){
		let _fixIdArr = new Array();
        let _doc = doc;
        let _dom = ezJsLib.XmlDom.parse(_doc);
        if(_dom == null)
            return _fixIdArr;
		let contents = _dom.documentElement.getElementsByTagName("CONTENT");
        for(var i=0;i<contents.length;i++){
            let _content = contents[i];
            if(_content == null)
                continue;
            let _total = ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", _content);
            for(var j=0;j<_total;j++){
                let _updateId = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("UPDATEID", _content, j);
                if(_updateId.indexOf("lnvgy_utl_boot")>-1)
					_fixIdArr.push(_updateId)
            }
        }
		return _fixIdArr;
    }

	function getNextAcquireResultData(ret, num){
		let _filePath = top.getSupportFile("acquireResult");
		let _fixIdArr = new Array();
		let _num = num;
		let _doc = null;
		if(_num > 1){
			_filePath = _filePath.substring(0, _filePath.length - 4) + _num + ".xml";
		}
		_doc = top.readTextFile(_filePath);
		if(_doc == null)
			return;
		else{
			_fixIdArr = findBMUFixIds(_doc);
			if(_fixIdArr.length<1){
				_num++;
				getNextAcquireResultData(ret, _num);
			}else{
				ret.filename = _filePath;
				ret.bmuFixIds = _fixIdArr;
				return;
			}
		}
	}

    function getBMUPackageInfo(){
		let ret = {
			filename: "none",
			bmuFixIds: []
		};
		getNextAcquireResultData(ret, 1);
		return JSON.parse(JSON.stringify(ret));
    }

    function showUpdateList() {
    	var _path = top.getSupportFile("acquireResult");
    	let fileObj = getBMUPackageInfo();
		bmuFixIds = fileObj.bmuFixIds;
		if(fileObj.bmuFixIds.length > 0 && fileObj.filename == _path) {
			return;
		}
		var doc = top.readTextFile(_path);
		if (!acquire_running) {
			clearInterval(su_progress_timer);
			var resultFile;
			resultFile = top.readTextFile(top.getSupportFile("commonResult"));
			if (resultFile) {
				var resultDom, resultMsg;
				resultDom = ezJsLib.XmlDom.parse(resultFile);
				resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
				if (resultDom.documentElement.getElementsByTagName("ERROR").length > 0 && ezJsLib.XmlDom.getValueByTagFromNode("ERROR", resultDom.documentElement) == "Yes") {
					if (mainContentMissing) {
						complete(0, resultMsg);
					} else {
						complete(2, resultMsg);
					}
				} else {
					complete(1, resultMsg);
				}
			} else {
				// unknown error
				complete(0, top.getComErrMsg());
			}
			displaySelectedSize();
		}
		if (doc == null) {
			if (acquire_running) {
				_doc.getElementById("acqMsg2").innerHTML = $.i18n.prop("UpdateSelection.Connecting");
			}
			return;
		} else {
			if (acquire_running) {
				_doc.getElementById("acqMsg2").innerHTML = $.i18n.prop("UpdateSelection.Acquiring") + '...';
			}
		}
		var dom = ezJsLib.XmlDom.parse(doc);
		//show the content number and the current one's index
		showStatus();
		//display new content(s)
		displayTable(dom, acquire_running);
  	}

	function showUpdateList_bak() {
		try {
			var _path = top.getSupportFile("acquireResult");
			 //do not display infomation about BMU
            let fileObj = getBMUPackageInfo();
			bmuFixIds = fileObj.bmuFixIds;
			if(fileObj.bmuFixIds.length>0 && fileObj.filename == _path)
				return;

			var doc = top.readTextFile(_path);
			if (
				/*(!acquire_running && su_incmpltStt.length == 0 && su_current_content_index == contentNo) || su_error_happened || (!acquire_running && su_current_content_index == 0 && doc == null)*/
				!acquire_running
			) {
				clearInterval(su_progress_timer);
				var resultFile;
				resultFile = top.readTextFile(top.getSupportFile("commonResult"));
				if (resultFile) { //end...  		
					var resultDom, resultMsg;
					resultDom = ezJsLib.XmlDom.parse(resultFile);
					resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
					if (resultDom.documentElement.getElementsByTagName("ERROR").length > 0 
						&& ezJsLib.XmlDom.getValueByTagFromNode("ERROR", resultDom.documentElement) == "Yes") {
						if (mainContentMissing) {
							complete(0, resultMsg);
						} else {
							complete(2, 'Some of the BMU or prerequisites packages are failed to download. ');
						}
					}	
					else
						complete(1, resultMsg);
				} else { //unkown error!
					complete(0, top.getComErrMsg());
				}
				displaySelectedSize();
			}
			if (doc == null) {
				if (acquire_running) {
					_doc.getElementById("acqMsg2").innerHTML = $.i18n.prop("UpdateSelection.Connecting");
				}
				return;
			} else {
				if (acquire_running) {
					_doc.getElementById("acqMsg2").innerHTML = $.i18n.prop("UpdateSelection.Acquiring") + '...';
				}
			}
			var dom = ezJsLib.XmlDom.parse(doc);
			//show the content number and the current one's index
			showStatus();
			//display new content(s)
			displayTable(dom, acquire_running);

		} catch (e) {
			//do nothing...
		}
	}

	/*
	 * update the incomplete statuses of packs in the table
	 */
	function updateIncmpltStt(dom) {
		var root = dom.documentElement;
		for (var i = 0; i < su_incmpltStt.length;) {
			var stt = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("STATUS", root, su_incmpltStt[i]);
			// if (stt.indexOf("available") > -1) {
			if (stt.indexOf("Already Downloaded") > -1) {
				//remove two columns which are Size and Location at 2016.12.22
				//_doc.getElementById("status" + su_incmpltStt[i]).innerHTML = stt;
				//_doc.getElementById("status" + su_incmpltStt[i]).innerHTML = $.i18n.prop("UpdateSelection.LocalHardDrive");
				su_incmpltStt.splice(i, 1); //remove this incomplete status from the list
			}else if(stt.indexOf("Done") > -1 || stt.indexOf("Error")>-1){
				//remove two columns which are Size and Location at 2016.12.22
				//_doc.getElementById("status" + su_incmpltStt[i]).innerHTML = $.i18n.prop("UpdateSelection.Internet");
				su_incmpltStt.splice(i, 1); //remove this incomplete status from the list
			} else
				i++;
		}
		return su_incmpltStt.length < 1;
	}

	/**
	 * check if this is a new content
	 */
	function isNewContent(index) {
		var isNew = true;
		for (var c = 0; c < su_viewed_contents.length; c++) {
			if (index == su_viewed_contents[c]) {
				isNew = false;
				break;
			}
		}
		return isNew;
	}
	/*
	 * display the whole table -- all contents and several incomplete acquistions (if any)
	 */
	function displayTable(dom, acquire_running) {
		var contents = dom.documentElement.getElementsByTagName("CONTENT");
		if (su_current_content_index >= contents.length) {
			/*
			 * If contents aren't shown completely when CLI is down, we could consider there is an error.
			 * In this case, what we need to do is to return immediately and handle error in next cycle.
			 * There won't be another content because this one is the last one.
			 */
			/*if (!acquire_running)
				su_error_happened = true;*/
			return;
		}
		for (var i = su_current_content_index; i < contents.length; i++) {
			var content = contents[i];
			var mt = ezJsLib.XmlDom.getValueByTagFromNode("MT", content);
			var os = ezJsLib.XmlDom.getValueByTagFromNode("OS", content);
			var total = ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content);

			if (mt == "undefined")
				mt = "";

			var thisContentComplete = true;
			var contentSizeKB = getContentSizeKB(content);
			var contentSize = formatNumberWithComma(formatData(parseFloat(contentSizeKB) / 1024));
			var windowsInsensitive = top.gl_isUpdate && !top.gl_OOB_Params.Enabled && top.gl_current_os=="windows";
			var index = (mt + getOSKey(os, windowsInsensitive)).toLowerCase();


			if (total < 1) { //content empty, unnecessary to create a table
				updateTitle(index, "None");
				updateTotal(index, total, contentSize);
				su_current_content_index++;
				continue;
			}

			if (!isNewContent(index)) //content listed, unnecessary to show ag...
			{
				thisContentComplete = updateIncmpltStt(dom);
				if (thisContentComplete) {
					var missingPack = false;
					for (var k = 0; k < total; k++) {
						var stt = ezJsLib.XmlDom.getValueByTagAndIndexFromNode('STATUS', content, k);
						if ( stt == 'Error' || stt == 'ERROR' ) {
							missingPack = true;
							$('#su_checkbox' + k).attr('disabled', true);
							$('#su_checkbox' + k).attr('checked', false);
						}
					}
					if (missingPack) {
						mainContentMissing = true;
						updateTitle(index, "Warning");
					} else {
						updateTitle(index, "Done");
					}
					su_current_content_index++;
					continue;
				} else //content not complete yet, all the following contents should wait
					return;
			}
			selectedSize += contentSizeKB;
			showPlusIcon(index);
			updateTitle(index, "Acquiring"); //content is coming...
			updateTotal(index, total, contentSize);
			su_viewed_contents.push(index);
			var cb = "<input type='checkbox' name='checkbox' value='" + index + "' id='content_checkbox" + index + "' onclick='Update_Selection.selectContent(this)' checked>";
			if (!top.gl_isUXSP) {
				header[0] = cb;
			}
			var table = createTable(index, false);
			for (var j = 0; j < total; j++) {
				var component = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("COMPONENT", content, j);
				var updateId = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("UPDATEID", content, j);
				var description = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("DESCRIPTION", content, j);
				var size = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("SIZE", content, j);
				var stt = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("STATUS", content, j);
				var datePlaceholder = "YYYY/MM/DD";
				//add a new row
				var newRow = table.insertRow(-1);
				var newCell0 = newRow.insertCell(-1);

				if (!top.gl_isUXSP) {
					// Users are not allowed to unselect sep package.
					if (updateId.indexOf("utl_tsep") > -1) {
						newCell0.innerHTML = "<input disabled=true type=\"checkbox\" name=\"checkbox\" value='ID=" + updateId + "SIZE=" + size + "' id=\"su_checkbox" + su_package_count + "\" onclick=\"Update_Selection.clickPack(" + su_package_count + ");\" checked>";
						newCell0.className = "EntityTableCell";
						newCell0.align = "center";
					} else if (updateId.indexOf("fw_esxi") > -1) {
						newCell0.innerHTML = "<input type=\"checkbox\" name=\"checkbox\" value='ID=" + updateId + "SIZE=" + size + "' id=\"su_checkbox" + su_package_count + "\" onclick=\"Update_Selection.clickPack(" + su_package_count + ");\" >";
						newCell0.className = "EntityTableCell";
						newCell0.align = "center";
						document.getElementById("content_checkbox" + index).checked = false;
					} else {
						newCell0.innerHTML = "<input type=\"checkbox\" name=\"checkbox\" value='ID=" + updateId + "SIZE=" + size + "' id=\"su_checkbox" + su_package_count + "\" onclick=\"Update_Selection.clickPack(" + su_package_count + ");\" checked>";
						newCell0.className = "EntityTableCell";
						newCell0.align = "center";
					}
				}

				var newCell1 = newRow.insertCell(-1);
				newCell1.innerHTML = component;
				newCell1.title = component;
				newCell1.className = "EntityTableCell";

				var newCell2 = newRow.insertCell(-1);
				newCell2.innerHTML = updateId;
				newCell2.title = description.replace(/ \(InstallXML\)/g, "");
				newCell2.className = "EntityTableCell";

				var newCell9 = newRow.insertCell(-1);
                newCell9.innerHTML = datePlaceholder;
                newCell9.title = datePlaceholder;
                newCell9.className = "EntityTableCell";

				if (stt.indexOf("Already Downloaded") < 0 && stt.indexOf("Done") < 0 && stt.indexOf("Error")<0) {
					// newCell4.id = "status" + su_package_count;
					// newRow.id = "pack" + su_package_count;
					su_incmpltStt.push(su_package_count);
					thisContentComplete = false;
				}

				//remove two columns which are Size and Location at 2016.12.22
				/*var newCell3 = newRow.insertCell(-1);
				newCell3.innerHTML = formatNumberWithComma(size);
				newCell3.title = formatNumberWithComma(size);
				newCell3.className = "EntityTableCell";
				newCell3.align = "right";

				var newCell4 = newRow.insertCell(-1);
				if (stt == "Locally available") {
					newCell4.innerHTML = $.i18n.prop("UpdateSelection.LocalHardDrive");
					newCell4.title = $.i18n.prop("UpdateSelection.LocalHardDrive");
				}else if("Already Downloaded"==stt){
					newCell4.innerHTML = $.i18n.prop("UpdateSelection.LocalHardDrive")
					newCell4.title = $.i18n.prop("UpdateSelection.LocalHardDrive");
				} else {
					newCell4.innerHTML = $.i18n.prop("UpdateSelection.Internet");
					newCell4.title = $.i18n.prop("UpdateSelection.Internet");
				}
				/*
				 * Two qualified strings are:
				 * const std::string UXLITE_ACQUIRE_CALLBACK_LOCALLY_AVAILABLE = " - Locally available";
				 * const std::string UXLITE_ACQUIRE_CALLBACK_REMOTELY_AVAILABLE = " - Remotely available";
				 * So we think it should be incompleted if there is an "available"
				 
				// if (stt.indexOf("available") < 0) { //incomplete...
				if (stt.indexOf("Already Downloaded") < 0 || stt.indexOf("Done") < 0 || stt.indexOf("Error")<0) {
					newCell4.id = "status" + su_package_count;
					newRow.id = "pack" + su_package_count;
					su_incmpltStt.push(su_package_count);
					thisContentComplete = false;
				}
				newCell4.className = "EntityTableCell";*/
				su_package_count++;
			}
			// if (thisContentComplete) {
			// 	su_current_content_index++;
			//	updateTitle(index, "Done");
			if (thisContentComplete) {
				var missingPack = false;
				for (var k = 0; k < total; k++) {
					var stt = ezJsLib.XmlDom.getValueByTagAndIndexFromNode('STATUS', content, k);
					if ( stt == 'Error' || stt == 'ERROR' ) {
						missingPack = true;
						$('#su_checkbox' + k).attr('disabled', true);
						$('#su_checkbox' + k).attr('checked', false);
					}
				}
				if (missingPack) {
					mainContentMissing = true;
					updateTitle(index, "Warning");
				} else {
					updateTitle(index, "Done");
				}
				su_current_content_index++;
				// continue;
			} else //this content not complete yet, all the following contents should wait
				return;
		}
	}

	/*
	 * progress of obtaining
	 */
	function showStatus() {
		var cur = su_viewed_contents.length + 1;
		var rest = contentNo - cur;
		var count = 0;
		if (top.gl_os_list.length == 1 && top.gl_os_list[0] == "none") {
			count = cur;
		} else {
			count = cur - 1;
		}
		switch (rest) {
			case -1:
				// _doc.getElementById("acqMsgImg").style.display = "none";
				_doc.getElementById("acqMsg1").innerHTML = $.i18n.prop("UpdateSelection.ObtainingDone");
				toggleNext(true);
				break;
			default:
				_doc.getElementById("acqMsg1").innerHTML = $.i18n.prop("UpdateSelection.ObtainingProcess",formatData(count / contentNo * 100));
		}
	}

	function selectContent(ref) {
		printLog("INFO", "check box 'select/deselect all' " + (ref.checked?" checked.":" unchecked."));
		var index = ref.id.substring("content_checkbox".length);
		var checkboxes = _doc.getElementById(TABLE_PRE + index).getElementsByTagName("input");
		var contentSize = 0;
		for (var i = 1; i < checkboxes.length; i++) {
			if (!checkboxes[i].disabled) {
				if (checkboxes[i].checked != ref.checked)
					contentSize += getValue("SIZE", checkboxes[i].value);
				checkboxes[i].checked = ref.checked;
			}
		}
		selectedSize = ref.checked ? (selectedSize + contentSize) : (selectedSize - contentSize);
		displaySelectedSize();
	}
	/*
	 * if a checkbox selected/deselected, re-calculate the selected packs' total size
	 */
	function clickPack(i) {
		printLog("INFO", "line " + i + (document.getElementById("su_checkbox"+i).checked?" checked.":" unchecked."));
		//remove two columns which are Size and Location at 2016.12.22
		/*if (_doc.getElementById("sizeMsg").style.display == "none")
			return;
		var temp = getValue("SIZE", _doc.getElementById("su_checkbox" + i).value);
		if (_doc.getElementById("su_checkbox" + i).checked)
			selectedSize += temp;
		else
			selectedSize -= temp;
		displaySelectedSize();*/
	}

	function updateTable() {
		var _path = top.getSupportFile("acquireResult");
		var doc = top.readTextFile(_path);
		var dom = ezJsLib.XmlDom.parse(doc);
		var contents = dom.documentElement.getElementsByTagName("CONTENT");
		for (var i = 0; i < contents.length; i++) {
			var content = contents[i];
			var mt = ezJsLib.XmlDom.getValueByTagFromNode("MT", content);
			var os = ezJsLib.XmlDom.getValueByTagFromNode("OS", content);
			var total = ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content);
			var windowsInsensitive = top.gl_isUpdate && !top.gl_OOB_Params.Enabled && top.gl_current_os=="windows";
			var index = (mt + getOSKey(os, windowsInsensitive)).toLowerCase();

			var table = _doc.getElementById("table" + index);
			for (var r = 0; r < total; ++r) {
				var releaseDate = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("RELEASEDATE", content, r);
				table.rows[1 + r].cells[3].innerHTML = releaseDate;
				table.rows[1 + r].cells[3].title = releaseDate;
			}
		}
	}
	
	/*
	 * if downloads finished, execute this
	 */
	function complete(c, msg) {
		updateTable(); // Add the releaseDate into table at the end
		_doc.getElementById("acqMsg").style.display = "none";
		var temp;
		temp = msg.split("\n");
		var msg2;
		msg2 = temp.join("<br>");

		switch (c) {
			case 0: //error
				_doc.getElementById("errorMsg").style.display = "block";
				_doc.getElementById("errorMsg2").innerHTML = $.i18n.prop("UpdateSelection.DownloadError",msg);
				break;
			case 1:
				_doc.getElementById("cplMsg").style.display = "block";
				_doc.getElementById("cplMsg2").innerHTML = msg2;
				//remove two columns which are Size and Location at 2016.12.22
				//_doc.getElementById("sizeMsg").style.display = "";
				break;
			case 2:
				$('#warnMsg').show();
				$('#warnMsg2').html(msg2);
				break;
		}
		//enable previous and next button whether the action is successful or not
		togglePrevious(true);
		toggleNext(true);
	}

	/*
	 * return a content total size in KB
	 * SIZE may have commas, so filter out
	 */
	function getContentSizeKB(content) {
		var csize = 0;
		for (var i = 0; i < content.getElementsByTagName("SIZE").length; i++) {
			var sz = $.trim(ezJsLib.XmlDom.getValueByTagAndIndexFromNode("SIZE", content, i));
			sz = sz.replace(/\,/g, "");
			csize += parseInt(sz);
		}
		return csize;
	}

	/*
	 * return a content total size in MB(eg. 1,234.56)
	 * SIZE may have commas, so filter out
	 */
	function getContentSizeWithFormat(content) {
		var csize = 0;
		for (var i = 0; i < content.getElementsByTagName("SIZE").length; i++) {
			var sz = $.trim(ezJsLib.XmlDom.getValueByTagAndIndexFromNode("SIZE", content, i));
			sz = sz.replace(/\,/g, "");
			csize += parseInt(sz);
		}
		return formatNumberWithComma(formatData(parseFloat(csize) / 1024));
	}

	/*
	 * "SIZE" for getting pack's size, "ID" for getting pack's updateId
	 */
	function getValue(size_id, v) {
		if (size_id == "SIZE") {
			return parseInt(v.substring(v.indexOf("SIZE=") + 5));
		} else if (size_id == "ID") {
			return v.substring(v.indexOf("ID=") + 3, v.indexOf("SIZE="));
		} else
			return null;
	}
	/*
	 * get user-selected packs' total size
	 */
	//function calculateSelectedSize(){
	//	selectedSize = 0;					//reset before re-calculating
	//	for(var i = 0; i < su_package_count; i++){
	//		if(_doc.getElementById("su_checkbox" + i).checked == true){
	//			selectedSize += parseInt(getValue("SIZE", _doc.getElementById("su_checkbox" + i).value));
	//		}
	//	}
	//	return selectedSize;
	//}

	function displaySelectedSize() {
		//remove two columns which are Size and Location at 2016.12.22
		/*if (selectedSize < 0)
			selectedSize = 0;
		_doc.getElementById("slctSize").innerHTML = formatNumberWithComma(formatData(parseFloat(selectedSize) / 1024)) + "MB";*/
	}

	/**
	 * update 'total' parameter in content title
	 */
	function updateTotal(index, total, totalSize) {
		var spans = _doc.getElementById(TITLE_PRE + index).getElementsByTagName("span");
		if (total == 0)
			spans[0].innerHTML = $.i18n.prop("UpdateSelection.NoUpdates");
		else
			spans[0].innerHTML = total + " " + $.i18n.prop("UpdateSelection.Updates");
		//  spans[0].innerHTML = total + " update(s) - " + totalSize + "MB";
	}

	/**
	 * before any download begins, show all the waiting contents first.
	 */
	function createAllContents() 
	{
		// Update Mode, only individual mode will lead to this page.
		if (top.gl_isUpdate) 
		{ 
			if(top.gl_OOB_Params.Enabled) 
			{
				// Under OOB mode, user only can update OS independent packages.
            	var index = (top.gl_OOB_Params.MT + noneOS).toLowerCase();
            	createContent("Machine", top.gl_OOB_Params.MT, getOSDisplayName(noneOS), index, createTitle);
        	}
        	else
        	{
        		// Under local mode, it maybe download current OS and OS independent packages.
        		// Now we use OneCli, it does not download OS independent packages when you specialize a MT.
        		var indexLocalOS = (top.gl_current_mt + top.gl_current_os).toLowerCase();
        		createContent("Machine", top.gl_current_mt, getOSDisplayName(top.gl_current_os), indexLocalOS, createTitle);
        		//var indexIndepentOS = (top.gl_current_mt + noneOS).toLowerCase();
				//createContent("Machine", top.gl_current_mt, getOSDisplayName(noneOS), indexIndepentOS, createTitle);
        	}
			return;
		}
		        
		// Acquire mode
		for (var i = 0; i < top.gl_xname_mt_list.length; i++) 
		{
			var a = top.gl_xname_mt_list[i];
			if (a[2] == "0") //unselected
				continue;
			var xname = a[0];
			var mt = a[1];
			for (var j = 0; j < top.gl_os_list.length; j++) 
			{
				var os = top.gl_os_list[j];
				var index = (mt + os).toLowerCase();
				createContent(xname, mt, getOSDisplayName(os), index, createTitle);
			}
		}
	}

	/**
	 * create a title bar for a content
	 */
	function createTitle(xname, mt, os, index, contentDiv) {
		var titleInnerHTML = new Array();
		titleInnerHTML.push("<div class='ContentTitleDiv' id='" + TITLE_PRE + index + "' onclick='toggleContent(this)'>");
		titleInnerHTML.push("<img style='margin-left:18px;' alt=\"Not Started\" src=\"images/statusStopped_obj16.gif\">&nbsp;");
		if (!isUXSPI) {
			if (xname == null)
				titleInnerHTML.push("<span></span>");
			else {
				if (os == "none") {
					titleInnerHTML.push(xname + " type " + mt + " - OS Independent - <span></span>");
				} else {
					titleInnerHTML.push(xname + " type " + mt + " - " + os + " - <span></span>");
				}
			}
		} else {
			titleInnerHTML.push($.i18n.prop("UpdateSelection.IndividualTitle")+"- <span></span>");
		}


		titleInnerHTML.push("</div>");
		contentDiv.innerHTML = titleInnerHTML.join("");
	}

	return {
		init: su_init,
		index: 0,
		name: "Update_Selection",
		su_cancel: su_cancel,
		beginAcq: beginAcq,
		selectContent: selectContent,
		clickPack: clickPack,
		nextAction: su_collect,
		previousAction: function(){
			printLog("INFO","Previous was clicked.");
            toggleNext(true);
            return true;
        },
		importId: '#import_update_selection',
        selectorId: '.update_selection',
        title: "Navi.UpdateSelection",
        needRefresh: true
	}

}();