var ezJsLib;

(function() {
    if (typeof ezJsLib != "undefined") 
    {
        return;
    } 
    else 
    {
        //$ ****** init ******
        ezJsLib = {};

        // ****** package for Xml Dom ******
        ezJsLib.XmlDom = {
            parse: function(_xml) {
                if ($) {
                    return $.parseXML(_xml);
                } else if (DOMParser) {
                    // Mozilla, Firefox, and related browsers
                    return (new DOMParser()).parseFromString(_xml, "text/xml");
                }
            },
            getValueByTag: function(_tag, _dom) {
                var nodevalue = null;
                var root = _dom.documentElement;
                return this.getValueByTagFromNode(_tag, root);
            },
            getValueByTagFromNode: function(_tag, _node) {
                var nodevalue = null;
                var nodes = _node.getElementsByTagName(_tag);
                if (nodes[0]) {
                    if ($) {
                        return $(nodes[0]).text();
                    }

                    if (nodes[0].firstChild) {
                        nodevalue = nodes[0].firstChild.nodeValue;
                    }
                    return nodevalue;
                }
                return nodevalue;
            },
            getValueByTagAndIndex: function(_tag, _dom, _index) {
                var nodevalue = null;
                var root = _dom.documentElement;
                return this.getValueByTagAndIndexFromNode(_tag, root, _index);
            },
            getValueByTagAndIndexFromNode: function(_tag, _node, _index) {
                var nodevalue = null;
                var nodes = _node.getElementsByTagName(_tag);
                if (nodes[_index]) {
                    if ($) {
                        return $(nodes[_index]).text();
                    }

                    if (nodes[_index].firstChild) {
                        nodevalue = nodes[_index].firstChild.nodeValue;
                    }
                }
                return nodevalue;
            },
            getNodeByTagAndIndex: function(_tag, _dom, _index) {
                var node = null;
                var root = _dom.documentElement;
                var nodes = root.getElementsByTagName(_tag);
                if (nodes[_index]) {
                    node = nodes[_index];
                }
                return node;
            },
            getChildNodeByTagAndIndexFromNode: function(_tag, _node, _index) {
                var node = null;
                var nodes = _node.getElementsByTagName(_tag);
                if (nodes[_index]) {
                    node = nodes[_index];
                }
                return node;
            },
            getChildNodeByTagFromNode: function(_tag, _node) {
                var nodes = _node.getElementsByTagName(_tag);
                if (nodes[0]) {
                    return nodes[0]
                }
                return null;
            },
            getStatus: function(statusValue) {
                var value = statusValue.toLowerCase();
                if (value.indexOf("ready") != -1) {
                    statusValue = "Not Started";
                } else if (value.indexOf("start package installation") != -1 || value.indexOf("start to unzip payload file") != -1 || value.indexOf("start calling iflash to update package") != -1) {
                    statusValue = "Running";
                } else if(value.indexOf("package installed successfully") != -1 || value.indexOf("Flash succeeded") != -1) {
                    statusValue = "Successfully Installed";
                } else if(value.indexOf("parse firmware package xml failed") != -1 || value.indexOf("skip installation successfully") != -1) {
                    statusValue = "Not Applicable";
                } else if (value.indexOf("failed to install package") != -1 || value.indexOf("package installation failed") != -1) {
                    statusValue = "Install did not succeed";
                }
                return statusValue;
            }

        };
    }
})();