// Copyright © 2017 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
const {app, BrowserWindow, dialog} = require('electron');
const path = require('path');
const url = require('url');
const ipcMain = require('electron').ipcMain;
const Menu = require('electron').Menu;
const os = require('os');

var win;
var close_flg = true;
var froce_close = false;

global.sharedObject = {
    showPrompt: true,
    messageConfirmExit: "",
    messageShowTitle: "",
    language: "en"
};

function init(){
    createWindow();
}

function createWindow (){
    Menu.setApplicationMenu(null);
    var icon_path = os.type().match(/windows/i)?'/images/l-favicon.ico':'/images/l-favicon.png';
    win = new BrowserWindow({
        width:1020, 
        height:780,
        resizable: true,
        frame: true,
        icon: __dirname + icon_path,
        show: false,
        webPreferences: {
            nodeIntegration: true,
            spellcheck: false,
            enableRemoteModule:true,
            contextIsolation: false
        }
    });
    require("@electron/remote/main").enable(win.webContents);
    require('@electron/remote/main').initialize();
    win.loadURL(url.format({
        pathname:path.join(__dirname, 'index.html'),
        protocol: 'file',
        slashes: true
    }));

    // win.webContents.openDevTools();
    // win.webContents.on('new-window', e => e.preventDefault());
    
    win.on('close', function(e) {
        if (global.sharedObject.showPrompt && !froce_close) {
            if(close_flg) {
                close_flg = false;
                var button = dialog.showMessageBoxSync(this, {
                    title:global.sharedObject.messageShowTitle,
                    message: global.sharedObject.messageConfirmExit,
                    buttons: ["Yes", "No"]
                });
                if(button != 0) {
                    e.preventDefault();
                }
                close_flg = true;
            } else {
                e.preventDefault();
            }    
        }  
    });
    win.on('closed', () => {
        win = null;
    });
    win.on('ready-to-show', () => {
        // win.loadURL(url.format({
        //     pathname:path.join(__dirname, 'index.html'),
        //     protocol: 'file',
        //     slashes: true
        // }));
        win.show();
    });
    if (process.versions.electron.indexOf("4.0.0") != -1) {
        const enforceInheritance = (topWebContents) => {
            const handle = (webContents) => {
                webContents.on('new-window', (event, url, frameName, disposition, options) => {
                    if (!options.webPreferences) {
                        options.webPreferences = {};
                    }
                    Object.assign(options.webPreferences, topWebContents.getLastWebPreferences());
                    if (options.webContents) {
                        handle(options.webContents);
                    }
                });
            }
            handle(topWebContents);
        }
        enforceInheritance(win.webContents);
    }
}
app.commandLine.appendSwitch('ignore-certificate-errors');
app.on('ready', init);
app.on('window-all-closed', () => {
    if(process.platform !== 'darwin'){
        app.quit();
    }
});
app.on('activate', () => {
    if(win === null){
        init();
    }
});

ipcMain.on('alertMsg', function(event, msg) {
    if(close_flg) {
        close_flg = false;
        event.returnValue = dialog.showMessageBoxSync(win, {
            title:global.sharedObject.messageShowTitle,
            message: msg,
            buttons: ["Ok"]
        });
        close_flg = true;
    }
});

ipcMain.on('confirmMsg', function(event, msg) {
    if(close_flg) {
        close_flg = false;
        event.returnValue = dialog.showMessageBoxSync(win, {
            title:global.sharedObject.messageShowTitle,
            message: msg,
            buttons: ["Yes", "No"]
        });
        close_flg = true;
    }
});

ipcMain.on('showOpenDialog', function(event, msg) {
    if(close_flg) {
        close_flg = false;
        event.returnValue = dialog.showOpenDialogSync(win, {
            properties: ['openDirectory']
        });
        close_flg = true;
    }
});

ipcMain.on('showOpenDialogFile', function(event, _defaultPath, _filterType) {
    if(close_flg) {
        close_flg = false;
        event.returnValue = dialog.showOpenDialogSync(win, {
            defaultPath: _defaultPath,
            properties: ['openFile'],
            filters: _filterType
        });
        close_flg = true;
    }
});

ipcMain.on('quitMsg', function(event, msg) {
    froce_close = true;
    app.quit();
});