#!/bin/bash
# Copyright © 2017 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
os_name()
{
    _name=`cat /etc/os-release | grep -E "^ID=" | cut -d "=" -f2`
    _name=${_name%%\"}
    _name=${_name##\"}
    echo $_name
}

os_version()
{
    _version=`cat /etc/os-release | grep "VERSION_ID=" | cut -d "=" -f2`
    _version=${_version%%\"}
    _version=${_version##\"}
    echo $_version
}

OS_NAME=`os_name`
OS_VERSION=`os_version`

if [[ "x$OS_NAME" != "xrhel" ]] && [[ "x$OS_NAME" != "xsles" ]] && [[ "x$OS_NAME" != "xcentos" ]]
then
    echo "The current OS does not support UpdateXpress or the file /etc/os-release missing."
    exit 1
fi

if [[ "x$OS_NAME" == "xrhel" ]] && [ $((${OS_VERSION%.*})) -lt 7 ]
then
    echo "UpdateXpress need supported by rhel7 and later version."
    exit 1
fi

if [[ "x$OS_NAME" == "xsles" ]] && [ $((${OS_VERSION%.*})) -lt 12 ]
then
    echo "UpdateXpress need supported by sles12 and later version."
    exit 1
fi

if [[ "x$OS_NAME" == "xcentos" ]] && [ -z $UXSPI_BOOTABLE ]
then
    echo "CentOS does not support UpdateXpress."
    exit 1
fi

DIR="$( cd "$( dirname "$0"  )" && pwd  )"

found=`gsettings list-keys org.gtk.Settings.FileChooser | grep startup-mode -c`
if [[ "$found" == "0" ]]
then
  cp -f ${DIR}/org.gtk.Settings.FileChooser.gschema.xml /usr/share/glib-2.0/schemas/org.gtk.Settings.FileChooser-onegui.gschema.xml >/dev/null 2>&1
  glib-compile-schemas /usr/share/glib-2.0/schemas >/dev/null 2>&1
fi
cd ${0%/*}/

export LD_LIBRARY_PATH="${DIR}"

chmod +x ${DIR}/lxce_ux.bin
${DIR}/lxce_ux.bin --disable-gpu --no-sandbox >/dev/null 2>&1
#${DIR}/lxce_ux.bin --disable-gpu

if [[ "$found" == "0" ]]
then
  rm /usr/share/glib-2.0/schemas/org.gtk.Settings.FileChooser-onegui.gschema.xml >/dev/null 2>&1
  glib-compile-schemas /usr/share/glib-2.0/schemas >/dev/null 2>&1
fi