rem Copyright © 2018 - present Lenovo.  All rights reserved.
rem Confidential and Proprietary.
@echo off

set partoperation=partoperation.po

set physicaldiskno=%1 
set diskSizeGb=%2
set physicaldisk=%3
set IS_DRIVE_FIXED="no"
set SYSLINUX=syslinux.exe

if %physicaldiskno% lss 0 (
	echo The physical disk sequence number is invalid, please make sure that you input the correct logical disk letter!
	exit 
)

::clear script.
if exist %partoperation% (
	del %partoperation%
)

::check the USB flash drive mode: DRIVE_FIXED/DRIVE_REMOVABLE
set PATH=%PATH%;C:\Windows\System32\wbem
set founddisk="no"
for /f "skip=1 tokens=1,2* delims=: " %%i in ('wmic logicaldisk get deviceid^,drivetype') do (
	if ["%%i:"] == ["%physicaldisk%"] (
	    if ["%%j"] == ["3"] (
			echo DRIVE_FIXED
			set IS_DRIVE_FIXED="yes"
			set founddisk="yes"
		)
		if ["%%j"] == ["2"] (
			echo DRIVE_REMOVABLE
			set IS_DRIVE_FIXED="no"
			set founddisk="yes"
		)
	)	
)

if %founddisk% equ "no" (
	echo "Not found the disk type, and format as removable usb drive"
)


::format usb drive........................................
echo select disk %physicaldiskno%				> "%partoperation%"
echo clean										>> "%partoperation%" 
echo convert mbr								>> "%partoperation%" 

if %diskSizeGb% GTR 32 (
	echo create partition primary size=32768	>> "%partoperation%"
) else (
	echo create partition primary				>> "%partoperation%"
)
echo format fs=fat32 label="BOMC" quick			>> "%partoperation%"

if %IS_DRIVE_FIXED% equ "yes" (
    echo assign									>> "%partoperation%"
)

echo active										>> "%partoperation%"
echo exit										>> "%partoperation%"

diskpart /s %partoperation% 

if %ERRORLEVEL% NEQ 0 (
	echo "diskpart failed, will do rescan and exit."
	echo rescan				> "%partoperation%"
	diskpart /s %partoperation% 
	if exist %partoperation% (
	del %partoperation%
	)

	exit 1 
)
::end format usb drive................................

if exist %partoperation% (
	del %partoperation%
)

if /i "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
	set SYSLINUX="syslinux64.exe"
) else (
	set SYSLINUX="syslinux.exe"
)

if %IS_DRIVE_FIXED% equ "yes" (
    %SYSLINUX% -f --install %physicaldisk%
) else (
	%SYSLINUX% --install %physicaldisk%
)

if %ERRORLEVEL% NEQ 0 (
	echo "Check usb key failed." 
)


echo "format usb successfully!"
exit 0
