// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
// Licensed Materials - Property of IBM
// 5648-F10 (C) Copyright International Business Machines Corp. 2005
// All Rights Reserved
// US Government Users Restricted Rights - Use, duplication or disclosure
// restricted by GSA ADP Schedule Contract with IBM Corp.

// return array of file name in the folder
function get_folder_content(folder) {
	return window.bomc.utils('get_folder_content', folder);
}

function createDirectory(directoryName) {
	return window.bomc.utils('createDirectory', directoryName);
}

// determine if the file or folder exists
// fileName: string - full native file name
// returns:  false if the file does not exist, true otherwise (or if shouldIndicateType is true, 1 if file exists, -1 directory exists, 0 file does not exist)
function fileExists(fileName) {
	return window.bomc.utils('fileExists', fileName);

}

function isDirectory(directoryName) {
	return window.bomc.utils('isDirectory', directoryName);

}

// determine if the file exists
// securityFcn: function = new Function('return window')
// fileName: string - full native file name
// returns: boolean
function secureFileExists(fileName) {
	return fileExists(fileName);
}

// determine if the directory exists
// securityFcn: function = new Function('return window')
// directory: string - full native directory name
// returns: boolean
function secureDirectoryExists(directory) {
	return secureFileExists(directory);
}


// gets the value of an environment variable
// securityFcn: function = new Function('return window')
// anyvar: string - name of variable
// returns: string - value of variable
//          undefined - variable is not defined
function secureGetEnv(anyvar) {
	top.printLog('anyvar : ', anyvar);
	return window.bomc.utils('secureGetEnv', anyvar);
}

// sets the value of an environment variable
// securityFcn: function = new Function('return window')
// anyvar: string - name of variable
// value: string - new value of variable
// returns: boolean - success status
function secureSetEnv(anyvar, value) {
	window.bomc.utils('secureSetEnv', anyvar, value);
}

// executes an arbitrary command
// securityFcn: function = new Function('return window')
// topDir: string - CD mount point
// args: [strings] - command and parameters
// waitBoolean: boolean - foreground or background
// isHidden: boolean - visible window or silent
// element: document element - element to disable while running
// returns integer - exit code if foreground or process status if background

// get a list of child directories
// securityFcn: function = new Function('return window')
// dir: string - parent directory
// returns: [directory name strings]
function secureGetDirectories(dir) {
	return window.bomc.utils('secureGetDirectories', dir);
}

// get a list of child files
// securityFcn: function = new Function('return window')
// dir: string - parent directory
// returns: [file name strings]
// new implementation by nodejs api
function secureGetFiles(dir) {
	return window.bomc.utils('secureGetFiles', dir);
}

function deleteFile(file) {
	return window.bomc.utils('deleteFile', file);
}

// read an external file
// fileName: string - full native file name or URL
// returns: string - contents of file if readable, null otherwise
function readTextFile(fileName) {
	return window.bomc.utils('readTextFile', fileName);
}

function pathJoin(...args) {
	return window.bomc.utils('join', ...args)
}

// read an external file
// securityFcn: function = new Function('return window')
// fileName: string - full native file name
// returns: [line strings]
function secureReadTextFile(fileName) {
	try {
		var fileContents = readTextFile(fileName);
		var fileLines = fileContents.split(/\r*\n/);
		if (fileLines.length > 0)
			//yeah this is smart, this is to remove the empty lines at the end of a file
			if (fileLines[fileLines.length - 1].length == 0)
				fileLines.pop();

		return fileLines;

	} catch (e) {
		//FSO failed, there's nothing we can do to read this files    
		top.logException(e, arguments);
	}
}

// write a text file
// fileName: string - full native file name
// text:  string - content of text file
// append: boolean - true = append text to end of file,  false = overwrite existing file
// returns: true if file was written successfully, false otherwise
function writeTextFile(fileName, fileContent, append) {
	return window.bomc.utils('writeTextFile', fileName, fileContent, append);
}

function winclose() {
	return win.close();
}

function statSync(filepath) {
	return window.bomc.utils('statSync', filepath);
}

function dirname(filepath) {
	return window.bomc.utils('dirname', filepath);
}

// securityFcn: function = new Function('return window')
// returns: void
function secureExit() {
	try {
		window.close();
	} catch (e) {
		top.logException(e, arguments);
	}
	winclose(); //Rarely called when debugging and refresh windows.
}
function loadMediaJson() {
	return window.bomc.utils('loadMediaJson');
}

function openExternal(link) {
	return window.bomc.utils('openExternal', link);
}

function showItemInFolder(configFile) {
	return window.bomc.utils('showItemInFolder', configFile);
}

function createReadStream(fileName) {
	return window.bomc.utils('createReadStream', fileName);
}

function getStream() {
	return window.bomc.utils('getStream');
}

function printLog(level, msg) {
	function getCallerFileNameAndLine() {
		function getException() {
			try {
				throw Error('');
			} catch (err) {
				return err;
			}
		}
		const err = getException();
		const stack = err.stack;
		const stackArr = stack.split('\n');
		let callerLogIndex = 0;
		for (let i = 0; i < stackArr.length; i++) {
			if (stackArr[i].indexOf("at printLog") > 0 && i + 1 < stackArr.length) {
				callerLogIndex = i + 1;
				break;
			}
		}
		if (callerLogIndex !== 0) {
			const callerStackLine = stackArr[callerLogIndex];
			return `[${callerStackLine.substring(callerStackLine.lastIndexOf("/") + 1, callerStackLine.lastIndexOf(':'))}]`;
		} else {
			return '[-]';
		}
	}
	return window.bomc.utils('printLog', level, getCallerFileNameAndLine(), msg)
}

function printInfoLog(msg) {
	console.log(msg);
	printLog("INFO", msg);
}

// Init log filter now that we have access to env vars
logInitFilter();

function loadContent(contentFile) {
	return window.bomc.utils('loadContent', contentFile);
}

function _loadAcResult(dom, index) {
	/* outputs 
	{
		MT:"7x01",
		OS:"platform",
		TOTAL: 34,
		CURRENTUPDATEID:"",
		FINISHED: false,
		ERROR:[],
		PACKAGES:[
			{
				UPDATEID:"brcm-lnvgy_fw_cna_oc.14-12.0.1317.7-9_linux_x86-64",
				DESCRIPTION:"Emulex OCe14xxx UCNA Firmware Update for Linux - 12.0.1317.7 - Release  (For Linux) (InstallXML)"
				COMPONENT:"Converged Network Adapter"
				SIZE:99
				DOWNLOADSIZE:99
				DOWNLOADSPEED:0
				STATUS:"Already downloaded"
				SELECTED:true
				RELEASEDATE:"2022/04/01"
			}
		]
	}
	*/
	try {
		let content = ezJsLib.XmlDom.getNodeByTagAndIndex("CONTENT", dom, index);
		if (content === null) {
			return null;
		}
		let result = {
			MT: ezJsLib.XmlDom.getValueByTagFromNode("MT", content),
			OS: ezJsLib.XmlDom.getValueByTagFromNode("OS", content),
			TOTAL: parseInt(ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content)),
			CURRENTUPDATEID: ezJsLib.XmlDom.getValueByTagFromNode("CURRENTUPDATEID", content),
			PACKAGES: [],
			FINISHED: false,
			SELECTED: true,
			ERROR: [],
		}
		let packages = ezJsLib.XmlDom.getNodeByTagAndIndex("CONTENT", dom, index);
		let doneCount = 0;
		for (let i = 0; i < result.TOTAL; i++) {
			let pkg = {
				UPDATEID: ezJsLib.XmlDom.getValueByTagAndIndexFromNode("UPDATEID", packages, i),
				DESCRIPTION: ezJsLib.XmlDom.getValueByTagAndIndexFromNode("DESCRIPTION", packages, i),
				COMPONENT: ezJsLib.XmlDom.getValueByTagAndIndexFromNode("COMPONENT", packages, i),
				SIZE: parseInt(ezJsLib.XmlDom.getValueByTagAndIndexFromNode("SIZE", packages, i)),
				DOWNLOADSIZE: parseInt(ezJsLib.XmlDom.getValueByTagAndIndexFromNode("DOWNLOADSIZE", packages, i)),
				DOWNLOADSPEED: parseInt(ezJsLib.XmlDom.getValueByTagAndIndexFromNode("DOWNLOADSPEED", packages, i)),
				STATUS: ezJsLib.XmlDom.getValueByTagAndIndexFromNode("STATUS", packages, i),
				SELECTED: true,
				RELEASEDATE: ezJsLib.XmlDom.getValueByTagAndIndexFromNode("RELEASEDATE", packages, i)
			}
			result.PACKAGES.push(pkg)
			let statusValue = pkg.STATUS;

			if (statusValue.toLowerCase().indexOf('already download') != -1 || statusValue.toLowerCase().indexOf('done') != -1) {
				doneCount++;
			} else if (statusValue.toLowerCase().indexOf('error') != -1) {
				doneCount++;
				result.ERROR.push(pkg.UPDATEID);
			}
			index++;
			content = ezJsLib.XmlDom.getNodeByTagAndIndex("CONTENT", dom, index);
		}
		result.FINISHED = (doneCount == result.TOTAL);
		return result;
	} catch (error) {
		console.log(error);
	}
	return null;
}

function loadAcResult(acResultFile, index) {
	/* outputs 
	{
		MT:"7x01",
		OS:"platform",
		TOTAL: 34,
		CURRENTUPDATEID:"",
		FINISHED: false,
		ERROR:[],
		PACKAGES:[
			{
				UPDATEID:"brcm-lnvgy_fw_cna_oc.14-12.0.1317.7-9_linux_x86-64",
				DESCRIPTION:"Emulex OCe14xxx UCNA Firmware Update for Linux - 12.0.1317.7 - Release  (For Linux) (InstallXML)"
				COMPONENT:"Converged Network Adapter"
				SIZE:99
				DOWNLOADSIZE:99
				DOWNLOADSPEED:0
				STATUS:"Already downloaded"
				SELECTED:0
				RELEASEDATE:"2022/04/01"
			}
		]
	}
	*/
	const dom = ezJsLib.XmlDom.parse(top.readTextFile(acResultFile));
	return _loadAcResult(dom, index);
}

function loadAcResults(acResultFile) {
	/* outputs 
	[{
		MT:"7x01",
		OS:"platform",
		TOTAL: 34,
		CURRENTUPDATEID:"",
		FINISHED: false,
		ERROR:[],
		PACKAGES:[
			{
				UPDATEID:"brcm-lnvgy_fw_cna_oc.14-12.0.1317.7-9_linux_x86-64",
				DESCRIPTION:"Emulex OCe14xxx UCNA Firmware Update for Linux - 12.0.1317.7 - Release  (For Linux) (InstallXML)"
				COMPONENT:"Converged Network Adapter"
				SIZE:99
				DOWNLOADSIZE:99
				DOWNLOADSPEED:0
				STATUS:"Already downloaded"
				SELECTED:true
				RELEASEDATE:"2022/04/01"
			}
		]
	}]
	*/
	const dom = ezJsLib.XmlDom.parse(top.readTextFile(acResultFile));
	let results = [];
	let index = 0;
	let ret = _loadAcResult(dom, index);
	while(ret !== null)
	{
		results.push(ret);
		index++;
		ret = _loadAcResult(dom, index);
	}
	return results;
}