// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
// This check can be passed as an argument to an secure functions
// in the API that you call or any secure functions you define in
// secureUserExtensions.js
// var userSecurityCheck = new Function('return window');
/*******************************************************************************
 * global variables definition
 ******************************************************************************/
Date.prototype.Format = function (fmt) {
    var o = {
        "M+": this.getMonth() + 1, 
        "d+": this.getDate(), 
        "h+": this.getHours(), 
        "m+": this.getMinutes(), 
        "s+": this.getSeconds(), 
        "q+": Math.floor((this.getMonth() + 3) / 3), 
        "S": this.getMilliseconds() 
    };
    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
    return fmt;
}

var basicInfo;
var guiHelper;
var cliErrorMsg;
var guiHelperFlag = 0;

var propertiesInfo = new Array();
// system drive letter
var gl_systemDrive;
// log file folder: C:\Lenovo_Support for windows or /var/log/Lenovo_Support for linux
var gl_ibm_support;
// system seperator
var gl_systemSeperator;

// pattern for server address
var ipv4_pattern = /^((25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(25[0-5]|2[0-4]\d|[01]?\d\d?)$/;
var ipv6_pattern = /^([\da-fA-F]{1,4}:){6}((25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(25[0-5]|2[0-4]\d|[01]?\d\d?)|::([\da−fA−F]1,4:)0,4((25[0−5]|2[0−4]\d|[01]?\d\d?)\.)3(25[0−5]|2[0−4]\d|[01]?\d\d?)|::([\da−fA−F]1,4:)0,4((25[0−5]|2[0−4]\d|[01]?\d\d?)\.)3(25[0−5]|2[0−4]\d|[01]?\d\d?)|^([\da-fA-F]{1,4}:):([\da-fA-F]{1,4}:){0,3}((25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(25[0-5]|2[0-4]\d|[01]?\d\d?)|([\da−fA−F]1,4:)2:([\da−fA−F]1,4:)0,2((25[0−5]|2[0−4]\d|[01]?\d\d?)\.)3(25[0−5]|2[0−4]\d|[01]?\d\d?)|([\da−fA−F]1,4:)2:([\da−fA−F]1,4:)0,2((25[0−5]|2[0−4]\d|[01]?\d\d?)\.)3(25[0−5]|2[0−4]\d|[01]?\d\d?)|^([\da-fA-F]{1,4}:){3}:([\da-fA-F]{1,4}:){0,1}((25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(25[0-5]|2[0-4]\d|[01]?\d\d?)|([\da−fA−F]1,4:)4:((25[0−5]|2[0−4]\d|[01]?\d\d?)\.)3(25[0−5]|2[0−4]\d|[01]?\d\d?)|([\da−fA−F]1,4:)4:((25[0−5]|2[0−4]\d|[01]?\d\d?)\.)3(25[0−5]|2[0−4]\d|[01]?\d\d?)|^([\da-fA-F]{1,4}:){7}[\da-fA-F]{1,4}|:((:[\da−fA−F]1,4)1,6|:)|:((:[\da−fA−F]1,4)1,6|:)|^[\da-fA-F]{1,4}:((:[\da-fA-F]{1,4}){1,5}|:)|([\da−fA−F]1,4:)2((:[\da−fA−F]1,4)1,4|:)|([\da−fA−F]1,4:)2((:[\da−fA−F]1,4)1,4|:)|^([\da-fA-F]{1,4}:){3}((:[\da-fA-F]{1,4}){1,3}|:)|([\da−fA−F]1,4:)4((:[\da−fA−F]1,4)1,2|:)|([\da−fA−F]1,4:)4((:[\da−fA−F]1,4)1,2|:)|^([\da-fA-F]{1,4}:){5}:([\da-fA-F]{1,4})?|([\da−fA−F]1,4:)6:/;

var gblElName = "";
var reqFileOperations = new Array();

// This check can be passed as an argument to an secure functions
// in the API that you call or any secure functions you define in
// secureUserExtensions.js
var userSecurityCheck = new Function('return window');

var bLoadConfig = false;
var bMediaFormat = false;
var bCheckForLatest = false;
var localMode = false;
var configTag = new Array();

var mtArray = new Array();
// var toolArea;
// var enableProxy=false;

/*****************************/
/* var for http proxy setting*/
/*****************************/
var proxyPwd = "";
var proxyUid;
var proxyPort;
var proxyAdd;
var useProxy = false; // boolean:  true - use auth info; false: otherwise
var useProxyAuth = false;
var useURLCustomCaCertFile = false;
var useProxyCaCertFile = false;
var proxy_custom = false;
var proxy_specify_cert = false;
var proxy_insecure = false;
var url_custom = false;
var url_specify_cert = false;
var url_insecure = false;
var default_lenovo_url = "https://support.lenovo.com";
var default_ibm_url = "https://www-03.ibm.com";
var urlCustomCaCertFile = "";
var proxyType = "http";
var proxyCaCertFile = "";
var proxyCheckResult = "";
var proxyStatusImg = "";
var defaultUrl = true;
var userInputUrl = "";

var acquireMode;
var usbReFlash = false;
var toolzip="";
var program;
// var bootEnv;
var writeName;
var workingdir;      // the directory of bomc100.exe/bomc100.sles10 extracted
var isForce=false;
// binaries
var workingdirProgram; // the directory for downloading and image creating
var portabledir;	// the directory of bomc100.exe package
var mainAppName;
var bomcCommandArray = new Array();    // show this BoMC command to customers
var pxeFile="";      // for configuration file's IBM_SYSTEM_PXE_FILE
var pxeTFTPAddress="";      // for configuration file's IBM_SYSTEM_PXE_TFTP_ADDRESS
var isoFile="";      // for configuration file's IBM_SYSTEM_ISO_FILE
var usbKeyVolume=""; // for configuration file's IBM_SYSTEM_USB_KEY
var cdVolume="";     // for configuration file's IBM_SYSTEM_CD
var cd;              // for guihelp.dat's IBM_SYSTEM_CD
var usbKey;          // for guihelp.dat's IBM_SYSTEM_USBDISK
var autorun;		 // specify the autorun program when booting OS.
var acquireToolOnly = false;
// var uxliteSelected=false;
var tui=false;			// enable tui mode
var latest=false;       // download the latest packages
var currentMT ="";   // machine type of which bomc is running on
var mtStr = "";
// var vmwareUpdate = ""; //acquire updates for VMWare ESXi embedded hypervisor
// var noFirmware = false;
var arch="x64"; //the default is for x64
var supportVMWare = "";//which versions of VMWare update will be supported
var availableVMWare; //vmware update supported in xml file

var iGuiFlashPos = 0;
var bomc_gui="bomc_gui.dat";
var bomc_tmp="bomc_tmp.dat";
var checkproxy_result = "";

var version="1.00.00";
var mediaLabel;
// var mediaLabel="Bootable Media - " + Date();
/** **** Added by kelvin ****** */
var gl_ac_result;
var gl_query_selection_result;
var guilogInfo;
var isDSADisabled = false;

var mediaFormat = 0;//0 means CD, 1 is DVD, 2 is USB, 3 PXE
// onload" will be called twice
// some functions need to be called only after the whole body finished loading
// "enterAction" defined in properties file won't help
// we use this var to make a record
var isFirstInit = true;
var STATUS = {"SUCCESS":0, "PROGRESS":1, "FAIL":2, "WARNING":3};
var SYSTEM_SUPPORT_LIST;
// original location of sys_support_list.xml
var originLocationSSL;

var SALIE_SUPPORT_LIST;
var originSalieLocationSSL;
var gl_salie_machine_list = new Array();

var X_SUPPORT_LIST;
var originXLocationSSL;

var CONFIRM_CONTINUE_FILE;
// add for unattended mode support

var strUnattdCfgFullStr = "";
var strUnattdCfgFullStr_tmp = "";
var isRebootBmc = true;
var strUnattdUseUserName = false;
var strUnattdCfgPassword = "";

var strConfigVersion = "13.3.0";

var boot_need_acq = false;

// var jbod_enabled = false;

/*
"systemx": include lenovo systemx machiens
"purley": include lenovo purley machines
"ibm": includ ibm machines
"storage": include storage machines
*/
var selectedOSMachineType = new Array();

// init tag for Proxy page
var proxyInit = false;

var use_Intel_RSTe_RAID_Configuration = false;
var dir_Intel_RSTe_RAID_Configuration = "";
var originRAIDSW;
var configFiles = [];

var FILE_SEPARATOR = "/";
if (top.OSTYPE.toLowerCase().indexOf("windows") >= 0) {
    FILE_SEPARATOR = "\\";
}

function convertFilePathValue(value){
    if(!value)
        return "No";
    if(value.indexOf(".iso")>-1){
        return (value.substr(0,value.length-4)+"_2.iso");
    }else{
        return (value + "_2");
    }
}

function getMtStr(mt){
    if(!mt)
        return "NO";
    var mtStr = "";
    for (var i=0; i<mt.length-1; i++)
    {
        mtStr += mt[i] + ",";
    }
    if (mt[i]) 
        mtStr += mt[i];
    return mtStr;
}


/** *************************** */

/*******************************************************************************
 * Configuration save and load interfaces
 ******************************************************************************/
/**
    * A valid machine type should be a 4-digit text
    */
function isMTValid(mt) {
    var valid = true;
    var regExp2 = /^[a-zA-Z\d]{4}$/gi;

    if (mt != null && mt.length == 4) {
        // for (var i = 0; i < 4; i++) {
        //     var c = mt.substr(i, 1);
        //     if (c < '0' || c > '9') {
        //         valid = false;
        //         break;
        //     }
        // }
        if(!mt.match(regExp2)){
            valid = false;
        }
    } else {
        valid = false;
    }
    return valid;
}

function validVer(ver) {
    // ver is like 13.3.0
    if (ver == null || ver == undefined || ver == "") {
        return false;
    }
    var valid = true;
    for (var i = 0; i < ver.length; i++) {
        if (ver[i] == ".") {
            continue;
        }
        if (isNaN(ver[i])) {
            valid = false;
            break;
        }
    }
    return valid;
}

function loadConfig(file) {
    var propertiesInfo = new Array();
    var invalidMT = false;
    if (!engineTop.secureFileExists(file)) {
        alert("Can't get config file: " + file);
        return;
    }
    engineTop.secureRead1PropertyFile(file, propertiesInfo, false);

    var isPreviousVersion = false;
    var versionInFile;
    if (typeof(propertiesInfo["IBM_SYSTEM_VERSION"]) == "undefined") {
        isPreviousVersion = true;
        versionInFile = "1.x";
    } else {
        versionInFile = propertiesInfo["IBM_SYSTEM_VERSION"];
        if (!top.validVer(versionInFile)) {
            alert("Invalid configuration of tool version. It will be set to " + strConfigVersion);
        } else if (versionInFile != strConfigVersion) {
            isPreviousVersion = true;
        }
        configTag["IBM_SYSTEM_VERSION"] = "1";
    }
    if (isPreviousVersion == true) {
        var vMsg = "The config file to be loaded is generated by BoMC " + versionInFile + "\n";
        vMsg += "It may cause some functions of this tool to work improperly.\n";
        alert(vMsg);
        return false;
    }

    if (propertiesInfo["IBM_SYSTEM_MACHINETYPE"] != "") {
        mtStr = propertiesInfo["IBM_SYSTEM_MACHINETYPE"];
        //mtStr = (mtStr == "NULL")? "": mtStr;
        // Added by Vincent for '-m all' support
        if (mtArray.length) {
            // clear the mtArray
            mtArray.length = 0;
        }
        if (mtStr.indexOf("all") != -1 ||  mtStr.indexOf("ALL") != -1) {
            mtArray.push("all");
            configTag["IBM_SYSTEM_MACHINETYPE"] = "1";
        } else if (mtStr.indexOf("NULL") != -1) {
            mtArray.length = 0;
            configTag["IBM_SYSTEM_MACHINETYPE"] = "1";
        } else {
            var beginPos = 0;
            var lastPos = mtStr.indexOf(",");

            while (lastPos > 0) {
                if (!isMTValid(mtStr.substr(0, lastPos))) {
                    mtArray.length = 0;
                    alert("Invalid IBM_SYSTEM_MACHINETYPE configuration. The list will be set to NULL.");
                    invalidMT = true;
                    break;
                }
                mtArray.push(mtStr.substr(0, lastPos));
                beginPos = lastPos + 1;
                mtStr = mtStr.slice(beginPos);
                lastPos = mtStr.indexOf(",");
            }
            if (!invalidMT) {
                if (!isMTValid(mtStr)) {
                    mtArray.length = 0;
                    alert("Invalid IBM_SYSTEM_MACHINETYPE configuration. The list will be set to NULL.");
                } else {
                    mtArray.push(mtStr);
                    configTag["IBM_SYSTEM_MACHINETYPE"] = "1";
                }
            }
        }
    }

    if (propertiesInfo["IBM_SYSTEM_ACQUIRE"] != "") {
        acquireMode = propertiesInfo["IBM_SYSTEM_ACQUIRE"];
        if (acquireMode == "YES")
        {
            acquireMode = true;
			if(gl_steps_current.indexOf(UpdateSelection)<0)
				gl_steps_current.splice(gl_steps_current.indexOf(Progress),0,UpdateSelection);
        }
        else if (acquireMode == "NO")
        {
            acquireMode = false;
			if(gl_steps_current.indexOf(UpdateSelection)>0)
				gl_steps_current.splice(gl_steps_current.indexOf(UpdateSelection),1);
        }
        else {
            acquireMode = true;
			if(gl_steps_current.indexOf(UpdateSelection)<0)
				gl_steps_current.splice(gl_steps_current.indexOf(Progress),0,UpdateSelection);
            alert("Invalid value for IBM_SYSTEM_ACQUIRE configuration. The value will be set to YES.");
        }
        configTag["IBM_SYSTEM_ACQUIRE"] = "1";
    }
    // if (propertiesInfo["IBM_SYSTEM_TUI"] != "") {
    //     if (propertiesInfo["IBM_SYSTEM_TUI"] == "YES")
    //         tui = true;
    //     else if (propertiesInfo["IBM_SYSTEM_TUI"] == "NO")
    //         tui = false;
    //     else {
    //         tui = false;
    //         alert("Invalid value for IBM_SYSTEM_TUI configuration. The value will be set to NO.");
    //     }
    //     configTag["IBM_SYSTEM_TUI"] = "1";
    // }
    if (propertiesInfo["IBM_SYSTEM_LATEST"] != "") {
        if (propertiesInfo["IBM_SYSTEM_LATEST"] == "YES") {
            latest = true;
        } else if (propertiesInfo["IBM_SYSTEM_LATEST"] == "NO")
            latest = false;
        else {
            latest = false;
            alert("Invalid value for IBM_SYSTEM_LATEST configuration. The value will be set to NO.");
        }
        configTag["IBM_SYSTEM_LATEST"] = "1";
    }
    if ((propertiesInfo["IBM_SYSTEM_PROXY_USER"]) &&
            (propertiesInfo["IBM_SYSTEM_PROXY_USER"]) != "NULL") {
        proxyUid = propertiesInfo["IBM_SYSTEM_PROXY_USER"];
	useProxyAuth = true;
        configTag["IBM_SYSTEM_PROXY_USER"] = "1";
    } else {
        proxyUid = "";
        configTag["IBM_SYSTEM_PROXY_USER"] = "1";
    }

    if ((propertiesInfo["IBM_SYSTEM_PROXY_PORT"]) &&
            (propertiesInfo["IBM_SYSTEM_PROXY_PORT"]) != "NULL") {
        proxyPort = propertiesInfo["IBM_SYSTEM_PROXY_PORT"];
        configTag["IBM_SYSTEM_PROXY_PORT"] = "1";
    } else {
        proxyPort = "";
        configTag["IBM_SYSTEM_PROXY_PORT"] = "1";
    }

    if ((propertiesInfo["IBM_SYSTEM_PROXY_ADDRESS"]) &&
            (propertiesInfo["IBM_SYSTEM_PROXY_ADDRESS"]) != "NULL") {
        proxyAdd = propertiesInfo["IBM_SYSTEM_PROXY_ADDRESS"];
	useProxy = true;
        configTag["IBM_SYSTEM_PROXY_ADDRESS"] = "1";
    } else {
        proxyAdd = "";
        configTag["IBM_SYSTEM_PROXY_ADDRESS"] = "1";
    }

    if ((propertiesInfo["IBM_SYSTEM_ADDITIONAL_CA_CERT_FILE"]) &&
            (propertiesInfo["IBM_SYSTEM_ADDITIONAL_CA_CERT_FILE"]) != "NULL") {
        additionalCaCertFile = propertiesInfo["IBM_SYSTEM_ADDITIONAL_CA_CERT_FILE"];
	useAdditionalCaCertFile = true;
        configTag["IBM_SYSTEM_ADDITIONAL_CA_CERT_FILE"] = "1";
    } else {
        additionalCaCertFile = "";
        configTag["IBM_SYSTEM_ADDITIONAL_CA_CERT_FILE"] = "1";
    }

    if ((propertiesInfo["IBM_SYSTEM_PROXY_CA_CERT_FILE"]) &&
            (propertiesInfo["IBM_SYSTEM_PROXY_CA_CERT_FILE"]) != "NULL") {
        proxyCaCertFile = propertiesInfo["IBM_SYSTEM_PROXY_CA_CERT_FILE"];
	useProxyCaCertFile = true;
        configTag["IBM_SYSTEM_PROXY_CA_CERT_FILE"] = "1";
    } else {
        proxyCaCertFile = "";
        configTag["IBM_SYSTEM_PROXY_CA_CERT_FILE"] = "1";
    }
    // ///////////////////////////////////////////////////////

    if ((propertiesInfo["IBM_SYSTEM_FUNCTION"]) &&
            (propertiesInfo["IBM_SYSTEM_FUNCTION"] != "NULL")) {
        program = propertiesInfo["IBM_SYSTEM_FUNCTION"];
        configTag["IBM_SYSTEM_FUNCTION"] = "1";
    }

    // ////////////////////////////////////////////////////////////
    if ((propertiesInfo["IBM_SYSTEM_ISO_FILE"]) &&
            (propertiesInfo["IBM_SYSTEM_ISO_FILE"] != "NULL")) {
        isoFile = propertiesInfo["IBM_SYSTEM_ISO_FILE"];
        usbKeyVolume = "";
        cdVolume = "";
        pxeFile = "";
        // writeName = "IBM_SYSTEM_ISO_FILE";
        configTag["IBM_SYSTEM_ISO_FILE"] = "1";
    }
    if ((propertiesInfo["IBM_SYSTEM_PXE_FILE"]) &&
            (propertiesInfo["IBM_SYSTEM_PXE_FILE"] != "NULL")) {
        pxeFile = propertiesInfo["IBM_SYSTEM_PXE_FILE"];
        usbKeyVolume = "";
        cdVolume = "";
        isoFile = "";
        // writeName = "IBM_SYSTEM_PXE_FILE";
        configTag["IBM_SYSTEM_PXE_FILE"] = "1";
        if ((propertiesInfo["IBM_SYSTEM_PXE_TFTP_ADDRESS"]) &&
                (propertiesInfo["IBM_SYSTEM_PXE_TFTP_ADDRESS"] != "NULL")) {
            pxeTFTPAddress = propertiesInfo["IBM_SYSTEM_PXE_TFTP_ADDRESS"];
            configTag["IBM_SYSTEM_PXE_TFTP_ADDRESS"] = "1";
        }
    }
    if ((propertiesInfo["IBM_SYSTEM_USB_KEY"]) &&
            (propertiesInfo["IBM_SYSTEM_USB_KEY"] != "NULL")) {
        usbKeyVolume = propertiesInfo["IBM_SYSTEM_USB_KEY"];
        isoFile = "";
        cdVolume = "";
        pxeFile = "";
        // writeName = "IBM_SYSTEM_USB_KEY";
        configTag["IBM_SYSTEM_USB_KEY"] = "1";
    }
    if ((propertiesInfo["IBM_SYSTEM_CD"]) &&
            (propertiesInfo["IBM_SYSTEM_CD"] != "NULL")) {
        cdVolume = propertiesInfo["IBM_SYSTEM_CD"];
        isoFile = "";
        usbKeyVolume = "";
        pxeFile = "";
        // writeName = "IBM_SYSTEM_CD";
        configTag["IBM_SYSTEM_CD"] = "1";
    }
    // ////////////////////////////////////////////////////////////////
    if((propertiesInfo["IBM_SYSTEM_REBOOT_BMC"]) &&
    (propertiesInfo["IBM_SYSTEM_REBOOT_BMC"]) == "YES")
    {
        top.isRebootBmc = true;
    }
    else
    {
        top.isRebootBmc = false;
    }

    if ((propertiesInfo["IBM_SYSTEM_UNATTENDED"]) &&
            (propertiesInfo["IBM_SYSTEM_UNATTENDED"]) != "NULL") {
        strUnattdCfgFullStr = propertiesInfo["IBM_SYSTEM_UNATTENDED"];
        strUnattdCfgFullStr_tmp = strUnattdCfgFullStr;
        configTag["IBM_SYSTEM_UNATTENDED"] = "1";
        
        if((propertiesInfo["IBM_SYSTEM_UNATTENDED_AUTH"]) &&
        (propertiesInfo["IBM_SYSTEM_UNATTENDED_AUTH"]) == "YES")
        {
            top.strUnattdUseUserName = true;
        }
    }

    if (propertiesInfo["IBM_SYSTEM_WORKINGDIR"] &&
            (propertiesInfo["IBM_SYSTEM_WORKINGDIR"] != "NULL")) {
	    if(top.OSTYPE == "windows" && 
	              (propertiesInfo["IBM_SYSTEM_WORKINGDIR"].indexOf("/") != -1
	              ||(propertiesInfo["IBM_SYSTEM_ISO_FILE"] &&
            (propertiesInfo["IBM_SYSTEM_ISO_FILE"] != "NULL")&&propertiesInfo["IBM_SYSTEM_ISO_FILE"].indexOf("/") != -1)
	              ||(propertiesInfo["IBM_SYSTEM_PXE_FILE"] &&
            (propertiesInfo["IBM_SYSTEM_PXE_FILE"] != "NULL")&&propertiesInfo["IBM_SYSTEM_PXE_FILE"].indexOf("/") != -1)
	              ||(propertiesInfo["IBM_SYSTEM_USB_KEY"] &&
            (propertiesInfo["IBM_SYSTEM_USB_KEY"] != "NULL")&&propertiesInfo["IBM_SYSTEM_USB_KEY"].indexOf("/") != -1)
	              ||(propertiesInfo["IBM_SYSTEM_CD"] &&
            (propertiesInfo["IBM_SYSTEM_CD"] != "NULL")&&propertiesInfo["IBM_SYSTEM_CD"].indexOf("/") != -1)
            )){
	 	    var vMsg = "The config file to be loaded is generated by linux\n";
	        vMsg += "It may cause some functions of this tool to work improperly.\n";
	        vMsg += "Do you want to continue?";
	        if (confirm(vMsg) == false) {
	            return false;
        	}
        }else if(top.OSTYPE == "unix" &&
            (propertiesInfo["IBM_SYSTEM_WORKINGDIR"].indexOf("\\") != -1
	              ||(propertiesInfo["IBM_SYSTEM_ISO_FILE"] &&
            (propertiesInfo["IBM_SYSTEM_ISO_FILE"] != "NULL")&&propertiesInfo["IBM_SYSTEM_ISO_FILE"].indexOf("\\") != -1)
	              ||(propertiesInfo["IBM_SYSTEM_PXE_FILE"] &&
            (propertiesInfo["IBM_SYSTEM_PXE_FILE"] != "NULL")&&propertiesInfo["IBM_SYSTEM_PXE_FILE"].indexOf("\\") != -1)
	              ||(propertiesInfo["IBM_SYSTEM_USB_KEY"] &&
            (propertiesInfo["IBM_SYSTEM_USB_KEY"] != "NULL")&&propertiesInfo["IBM_SYSTEM_USB_KEY"].indexOf("\\") != -1)
	              ||(propertiesInfo["IBM_SYSTEM_CD"] &&
            (propertiesInfo["IBM_SYSTEM_CD"] != "NULL")&&propertiesInfo["IBM_SYSTEM_CD"].indexOf("\\") != -1)
            )){	
	        var vMsg = "The config file to be loaded is generated by windows\n";
	        vMsg += "It may cause some functions of this tool to work improperly.\n";
	        alert(vMsg);
	        return false;
	    }
	    workingdirProgram =propertiesInfo["IBM_SYSTEM_WORKINGDIR"];
	    configTag["IBM_SYSTEM_WORKINGDIR"] = "1";

    }
    if (propertiesInfo["IBM_SYSTEM_AUTORUN"] &&
            (propertiesInfo["IBM_SYSTEM_AUTORUN"] != "NULL")) {
        autorun =propertiesInfo["IBM_SYSTEM_AUTORUN"];
        configTag["IBM_SYSTEM_AUTORUN"] = "1";
    }
    /*
     * if(propertiesInfo["IBM_SYSTEM_TOOL_FILE"] &&
     * (propertiesInfo["IBM_SYSTEM_TOOL_FILE"] != "NULL")) { toolzip
     * =propertiesInfo["IBM_SYSTEM_TOOL_FILE"]; configTag["IBM_SYSTEM_TOOL_FILE"] =
     * "1"; }
     */
    if (propertiesInfo["IBM_SYSTEM_FORCE_OVERWRITE"] &&
            (propertiesInfo["IBM_SYSTEM_FORCE_OVERWRITE"] != "NULL")) {
        if (propertiesInfo["IBM_SYSTEM_FORCE_OVERWRITE"] == "YES") {
            isForce = true;
        } else if (propertiesInfo["IBM_SYSTEM_FORCE_OVERWRITE"] == "NO") {
            isForce = false;
        } else {
            isForce = false;
            alert("Invalid value for IBM_SYSTEM_FORCE_OVERWRITE configuration. The value will be set to NO.");
        }
        configTag["IBM_SYSTEM_FORCE_OVERWRITE"] = "1";
    }

    // if (propertiesInfo["IBM_SYSTEM_VMWARE_ESXI_UPDATE"] &&
    //         (propertiesInfo["IBM_SYSTEM_VMWARE_ESXI_UPDATE"] != "NULL")
    //         && (propertiesInfo["IBM_SYSTEM_VMWARE_ESXI_UPDATE"] != "NO")) {
    //     var vmwareUpdate = propertiesInfo["IBM_SYSTEM_VMWARE_ESXI_UPDATE"];
    //     if (vmwareUpdate == "YES") {
    //         setVmwareUpdateValue("3.5");
    //     }  else {
    //         setVmwareUpdateValue(vmwareUpdate);
    //     }
    //     configTag["IBM_SYSTEM_VMWARE_ESXI_UPDATE"] = "1";
    // } else if (propertiesInfo["IBM_SYSTEM_VMWARE_ESXI_UPDATE"] == "NULL"
    //            || propertiesInfo["IBM_SYSTEM_VMWARE_ESXI_UPDATE"] == "NO") {
    //     setVmwareUpdateValue("");
    //     configTag["IBM_SYSTEM_VMWARE_ESXI_UPDATE"] = "1";
    // }

    // if (top.OSTYPE == "windows") {
    //     if (propertiesInfo["IBM_SYSTEM_NO_FIRMWARE_UPDATE"] &&
    //             (propertiesInfo["IBM_SYSTEM_NO_FIRMWARE_UPDATE"] != "NULL")) {
    //         if (propertiesInfo["IBM_SYSTEM_NO_FIRMWARE_UPDATE"] == "YES") {
    //             setNoFirmwareValue(true);
    //         } else if (propertiesInfo["IBM_SYSTEM_NO_FIRMWARE_UPDATE"] == "NO") {
    //             setNoFirmwareValue(false);
    //         } else {
    //             setNoFirmwareValue(false);
    //             alert("Invalid value for IBM_SYSTEM_NO_FIRMWARE_UPDATE configuration. The value will be set to NO.");
    //         }
    //         configTag["IBM_SYSTEM_NO_FIRMWARE_UPDATE"] = "1";
    //     }

    //     if (propertiesInfo["IBM_SYSTEM_DEPLOY_ARCHITECTURE"] &&
    //             (propertiesInfo["IBM_SYSTEM_DEPLOY_ARCHITECTURE"] != "NULL")) {
    //         setArchValue(propertiesInfo["IBM_SYSTEM_DEPLOY_ARCHITECTURE"]);
    //         configTag["IBM_SYSTEM_DEPLOY_ARCHITECTURE"] = "1";
    //     }
    // }

    if (propertiesInfo["IBM_SYSTEM_MEDIALABEL"] &&
            (propertiesInfo["IBM_SYSTEM_MEDIALABEL"] != "NULL")) {
        mediaLabel =propertiesInfo["IBM_SYSTEM_MEDIALABEL"];
        configTag["IBM_SYSTEM_MEDIALABEL"] = "1";
    }
    return;

}
function clearConfig() {
    initGlbVars();
}

function getSecureSaveName(propertystr) {
    // replace "\" with "\\" in order to make it suitable for saving into config
    // file
    var tmpstr = propertystr.replace(/\\/g, "\\\\");
    return tmpstr;
}
function getSecureLoadName(propertystr) {
    // replace "\\" with "\" in order to make it suitable for accessing(read and
    // write)
    var tmpstr = propertystr.replace(/\\\\/g, "\\");
    return tmpstr;
}

function initSupportList(targetFile, sourceFile)
{
    if (!top.fileExists(targetFile))
    {
        if (!top.fileExists(top.dirname(targetFile)))
        {
            top.createDirectory(top.dirname(targetFile));
        }
        top.writeTextFile(targetFile, top.readTextFile(sourceFile));
    }
}

function callbackForGuiHelper(result, error)
{
    guiHelperFlag = 1;
}

function callbackAfterRunGuiHelper(result, error)
{
    console.log("callbackAfterRunGuiHelper");
    if (!engineTop.secureFileExists(basicInfo)) 
    {
        alert("BoMC must be run in a super-user mode !");
        Exit(true);
    }

    engineTop.secureRead1PropertyFile(basicInfo, propertiesInfo, false);
    workingdir = propertiesInfo["IBM_SYSTEM_DIR"];
    // If BoMC is embedded into UXSPI
    if ( getEnv('IBM_PORTABLE_EXEC_DIR_UXSPI') != top.UNDEFINED && getEnv('IBM_PORTABLE_EXEC_DIR_UXSPI') != "") {
        workingdirProgram = getEnv('IBM_PORTABLE_EXEC_DIR_UXSPI');
        // alert("IBM_PORTABLE_EXEC_DIR_UXSPI=" + workingdirProgram);
    } else {
        if (top.OSTYPE == "windows") {
            var lastFolderStr = "workingdir";
            if ( getEnv('IBM_PORTABLE_EXEC_DIR') != top.UNDEFINED && getEnv('IBM_PORTABLE_EXEC_DIR') != "" ) {
                portabledir = getEnv('IBM_PORTABLE_EXEC_DIR');
                if (portabledir.lastIndexOf(":") != (portabledir.length - 2)) {
                    lastFolderStr = "\\" +lastFolderStr;
                }
                workingdirProgram = portabledir + lastFolderStr;
            } else {
                
                if(workingdir == top.UNDEFINED || workingdir == "")
                    workingdir = top.getStartingTopDir();
                console.log("workingdir = ", workingdir);
                console.log("workingdir.length = ", workingdir.length);
                if (workingdir.lastIndexOf(":") != (workingdir.length - 2)) {
                    lastFolderStr = "\\" + lastFolderStr;
                }
                workingdirProgram = workingdir + lastFolderStr;
            }
        } else {
            if ( getEnv('IBM_PORTABLE_EXEC_DIR') != top.UNDEFINED && getEnv('IBM_PORTABLE_EXEC_DIR') != "" ) {
                portabledir = getEnv('IBM_PORTABLE_EXEC_DIR');
                workingdirProgram = portabledir + "/workingdir";
            } else {
                workingdirProgram = workingdir + "/workingdir";
            }
        }
    }

    usbKey = propertiesInfo["IBM_SYSTEM_USBDISK"];
    cd = propertiesInfo["IBM_SYSTEM_CD"];
    var os = propertiesInfo["IBM_SYSTEM_OS"];
    //if (os == "101" || os == "102" || os == "103" || os == "104" || os == "105" || os == "106" || os == "107" || os == "108" || os == "109") {
    if(os.length==3 && os[0]=="1") {
        // mainAppName = "bomc100_cli.exe";
        mainAppName = "bomc.exe";
    } else {
        mainAppName = "bomc.bin"
    }
    currentMT = propertiesInfo["IBM_SYSTEM_MT"];
    

    initGlbVars();
    if (getEnv('BOMC_DSA_DISABLE')!=undefined && getEnv('BOMC_DSA_DISABLE') != "") {
        isDSADisabled = true;
    }

    getVersion();
    console.log("end to callbackAfterRunGuiHelper");
}

function tcInit() {
    console.log("tcInit");
    if (top.OSTYPE == "windows") 
    {
        gl_systemDrive = top.getEnv("SystemDrive");
        gl_ibm_support = gl_systemDrive + "\\Lenovo_Support\\";
        console.log("gl_ibm_support = ", gl_ibm_support);
        gl_systemSeperator = '\\';
    } 
    else 
    {
        gl_ibm_support = "/var/log/Lenovo_Support/";
        gl_systemSeperator = '/';
    }
    mediaLabel="BootableMedia_" + new Date().Format("yyyyMMdd-hhmmss");

    // copy sys_support_list.xml if it is not copied when bomc is extracted
    SYSTEM_SUPPORT_LIST = gl_ibm_support + getOSCommand("sys_support_list");
    CONFIRM_CONTINUE_FILE = gl_ibm_support + getOSCommand("CONFIRM_CONTINUE_FILE");
    originLocationSSL = getStartingTopDir() + getOSCommand('originLocationSSL');

    SALIE_SUPPORT_LIST = gl_ibm_support + getOSCommand("salie_support_list");
    originSalieLocationSSL = getStartingTopDir() + getOSCommand("originSalieLocationSSL");

    X_SUPPORT_LIST = top.gl_ibm_support + getOSCommand("x_support_list");
    originXLocationSSL = getStartingTopDir() + getOSCommand("originXLocationSSL");

    guiHelper = getOSCommand('guiHelper');
    basicInfo = top.gl_ibm_support + getOSCommand('basicInfo');
    console.log("get basicInfo : ", basicInfo);
    cliErrorMsg = top.gl_ibm_support + getOSCommand('cliErrorMsg');
    gl_ac_result = top.gl_ibm_support + getOSCommand('gl_ac_result');
    gl_query_selection_result = top.gl_ibm_support + getOSCommand('gl_query_selection_result');
    guilogInfo = top.gl_ibm_support + getOSCommand('guilogInfo');
    checkproxy_result = top.gl_ibm_support + getOSCommand("tmpFile");
    console.log("get info");
    originRAIDSW = getStartingTopDir() + getOSCommand("originRAIDSW");

    var args = new Array();
    args.push(getStartingTopDir() + getNativeFileSeparator() + guiHelper);
    args.push("--file");
    args.push(top.bomc_gui);
    console.log("args : ", args);
    printLog("INFO", args);
    var rc = secureRunProgram(null, args, BACKGROUND, HIDDEN, null, callbackAfterRunGuiHelper);
}

function initAllList() {
    if (!top.fileExists(originLocationSSL)) {
        alert("Failed to init whole systems list! ");
    } else {
        var allListContent = "";
        var allListContentArr = "";
        try {
            allListContent = top.readTextFile(originLocationSSL);
        } catch(e) {
            alert("Failed to init whole systems list! ");
        }
        allListContentArr = allListContent.split("\n");
        for (var i = 0; i < allListContentArr.length; i++) {
            var temp = allListContentArr[i];
            if (temp.indexOf("machineType") != -1) {
                var mtStart = temp.indexOf("<machineType>");
                temp = temp.substr(mtStart, temp.length);
                var mtEnd = temp.indexOf("</machineType>");
                temp = temp.substr(0, mtEnd);
                temp = temp.replace("<machineType>", "");
                if (top.allList.indexOf(temp) == -1) {
                    top.allList.push(temp);
                }  
            }
        }
    }
}

function initStorageList() {
    top.storageList = ["4587", "6413", "7DAH"];
}

function initLenovoSystemxList() {
    if (!top.fileExists(originXLocationSSL)) {
        alert("Failed to init Lenovo Systemx list! ");
    } else {
        var xListContent = top.readTextFile(originXLocationSSL);
        var xListContentArr = xListContent.split("\n");
        var tempArr = new Array();
        for (var i = 0; i < xListContentArr.length; i++) {
            var temp = xListContentArr[i];
            temp = temp.trim();
            if (temp != "" && temp != null && temp != undefined) {
                if (tempArr.indexOf(temp) == -1) {
                    tempArr.push(temp);
                }
            }
        }
        for (var i = 0; i < tempArr.length; i++) {
            if (top.lenovoSystemxList.indexOf(tempArr[i]) == -1) {
                top.lenovoSystemxList.push(tempArr[i]);
            }
        }
    }
}

function initPurleyList() {
    var tempArr = top.lenovoSystemxList.concat();
    top.purleyList = [];
    for (var i = 0; i < top.allList.length; i++) {
        if (tempArr.indexOf(top.allList[i]) == -1 && top.purleyList.indexOf(top.allList[i])) {
            top.purleyList.push(top.allList[i]);
        }
    }
}

function updateAllListFile() {

}

function updateSalieListFile() {

}

function updateXListFile() {

}

function initSalieListFile() {
    if (top.fileExists(originLocationSSL)) {
        if (top.fileExists(originSalieLocationSSL)) {
            top.deleteFile(originSalieLocationSSL);
        }
        var allListContent = top.readTextFile(originLocationSSL);
        var allListContentArr = allListContent.split("\n");
        var allListArr = new Array();
        for (var i = 0; i < allListContentArr.length; i++) {
            if (allListContentArr[i].indexOf("machineType") != -1) {
                var temp = allListContentArr[i];
                var mtStart = temp.indexOf("<machineType>");
                temp = temp.substr(mtStart, temp.length);
                var mtEnd = temp.indexOf("</machineType>");
                temp = temp.substr(0, mtEnd);
                temp = temp.replace("<machineType>", "");
                if (allListArr.indexOf(temp) == -1) {
                    allListArr.push(temp);
                }
            }
        }
        var salieListArr = new Array();
        for (var i = 0; i < allListArr.length; i++) {
            if (salieListArr.indexOf(allListArr[i]) == -1) {
                salieListArr.push(allListArr[i]);
            }
        }
        var fileStr = "[\n";
        for (var i = 0; i < salieListArr.length; i++) {
            if (i == salieListArr.length - 1) {
                fileStr += '\t"' + salieListArr[i] + '"\n';
            } else {
                fileStr += '\t"' + salieListArr[i] + '",\n';
            }
        }
        fileStr += "]";
        top.writeTextFile(originSalieLocationSSL, fileStr);
    }
}

function initGlbVars() {
    // Not a formal initialize,just for prototype here
    // All these info will need to load from an initial configuration file
    // machineType = "8843,1883,7995";

    // clear the mtArray
    mtArray.length = 0;
    // mtArray.push("8843");
    // mtArray.push("7995");
    // toolArea = "Updates";
    acquireMode = true;
    if(gl_steps_current.indexOf(UpdateSelection)<0)
        gl_steps_current.splice(gl_steps_current.indexOf(Progress),0,UpdateSelection);
    // enableProxy = false;
    proxyPwd = "";
    proxyUid = "";
    proxyPort = "";
    proxyAdd = "";
    program = "UPDATE"; //the default value for function is "UPDATE"
    autorun = "NULL";
    // bootEnv = "linux";
    writeName = "IBM_SYSTEM_ISO_FILE";
    if (top.OSTYPE == "windows") {
        if (workingdirProgram.lastIndexOf("\\") == workingdirProgram.length-1)
            isoFile = workingdir + "bootable.iso";
        else
            isoFile = workingdir + "\\bootable.iso";
    } else {
        if (workingdirProgram.lastIndexOf("/") == workingdirProgram.length-1)
            isoFile = workingdir + "bootable.iso";
        else
            isoFile = workingdir + "/bootable.iso";
    }
    // workingdir = "C:\\bomc\\app\\workingdir";

    availableVMWare = new Array();
    //getVMWareSupportList();

    // initSalieListFile();
    initSupportList(SYSTEM_SUPPORT_LIST, originLocationSSL);
    // initSupportList(SALIE_SUPPORT_LIST, originSalieLocationSSL);
    initSupportList(X_SUPPORT_LIST, originXLocationSSL);

    // refresh salie_support_list
    // initAllList();
    // initLenovoSystemxList();
    // initPurleyList();
    // initStorageList();
}

function getVersion() {
    var versionStr = new Array();
    var versionInfo = "";
    if (top.OSTYPE == "windows") { 
        versionInfo = top.workingdir + "\\" + "version.inc";

    } else { // linux ...
        versionInfo = top.workingdir + "/" + "version.inc";
    }

    if (!engineTop.secureFileExists(versionInfo)) {
        alert("Can't get version file: " + versionInfo);
        return;
    }
    engineTop.secureRead1PropertyFile(versionInfo, versionStr, false);


    if (versionStr["FDR_VER_STRING"] != "") {
        top.version = versionStr["FDR_VER_STRING"];
    }
}

// ***********************************************************************************
// Update Navigation items
// ***********************************************************************************
function initialNavigation() {
    // "hide" the load configuration navigation menu
    top.updateNavigation("loadconfig", false);
    top.updateNavigation("proxysetting1", false);
    top.updateNavigation("checklatestversion", false);
    top.updateNavigation('unattendedconfig',false);
}

function updateNavigation(menuid, show) {
    top.showNavigation(menuid, show);
    top.activateNavigation(menuid, show);
}

/*
 * We override the default next() function by adding a declare named nextAction.
 * So we need to implement a customized navigation function which will makes
 * current page jump to next page.
 */
function nextDefinedByTC() {
    var navOrder = top.getWizardNavOrder();
    var found = false;
    for (var i = 0; i < navOrder.length; i++) {
        if (navOrder[i] == top.navigationCurrent) {
            found = true;
            if (i < navOrder.length - 1) {
                top.navigateTo(navOrder[i+1]);
                break;
            } else {
                top.Exit();
            }
        }
    }
    if (!found) {
        // If we get here, we're currently sitting on a deactivated nav item.
        // Fallback to complete nav order to navigate to the next item.
        var allNavOrder = getNavOrder();
        var found = false;
        for (var i = 0; i < allNavOrder.length; i++) {
            if (allNavOrder[i] == top.navigationCurrent) {
                if (i < allNavOrder.length - 1) {
                    top.navigateTo(allNavOrder[i+1]);
                    break;
                } else {
                    top.Exit();
                }
            }
        }
    }
}

function prevDefinedByTC() {
    var navOrder = top.getWizardNavOrder();
    var found = false;
    for (var i = 0; i < navOrder.length; i++) {
        if (navOrder[i] == top.navigationCurrent) {
            found = true;
            if (i > 0) {
                var curNav = top.navigationCurrent;
                top.navigateTo(navOrder[i - 1]);
                top.setNavigationState(curNav, 'unvisited');
            }
            break;
        }
    }
    if (!found) {
        // If we get here, we're currently sitting on a deactivated nav item.
        // Fallback to complete nav order to navigate to the next item.
        var allNavOrder = getNavOrder();
        var found = false;
        for (var i = 0; i < allNavOrder.length; i++) {
            if (allNavOrder[i] == top.navigationCurrent) {
                if (i > 0) {
                    var curNav = top.navigationCurrent;
                    top.navigateTo(navOrder[i - 1]);
                    top.setNavigationState(curNav, 'unvisited');
                }
                break;
            }
        }
    }
}

// ***********************************************************************************
// File Operations
// ***********************************************************************************


function updateElement(id, elName, url) {
    var p = new Object();
    p.fileName = url;
    p.prefix = id;
    p.onLoadComplete = assignElText;
    gblElName = elName;
    loadFileData(p);
}

function assignElText(text) {
    document.getElementById(gblElName).innerHTML = text;
}

function getSimpleSetting(xmlDoc, section, setting) {

    var allSections = xmlDoc.getElementsByTagName("root").item(0);
    var i = 0;
    var sectionNode;
    var resultStr = "";

    for (i = 0; i < allSections.childNodes.length; i++) {
        if (allSections.childNodes[i].attributes) {
            if (allSections.childNodes[i].attributes.getNamedItem("name").nodeValue == section) {
                sectionNode = allSections.childNodes[i];
                break;
            }
        } else {

            // could not find any node attributes
        }
    }

    for (i = 0; i < sectionNode.childNodes.length; i++) {
        if (sectionNode.childNodes[i].attributes.getNamedItem("name").nodeValue == setting) {
            resultStr = sectionNode.childNodes[i].attributes.getNamedItem("value").nodeValue;
            break;
        }
    }

    return resultStr;


}



function getXML(url, loadCompleteFn, uniqueID) {
    idVal = "id";
    if (uniqueID) idVal = uniqueID;

    var p = new Object();
    p.fileName = url;
    p.prefix = idVal;
    p.onLoadComplete = loadCompleteFn;
    p.returnAsXML = true;
    loadFileData(p);

}

// ***************************************************************************************
function loadFileData(params) {
    var i = 0;

    // branch for native XMLHttpRequest object
    if (window.XMLHttpRequest) {
        try {
            // netscape.security.PrivilegeManager.enablePrivilege('UniversalBrowserRead');
            // netscape.security.PrivilegeManager.enablePrivilege('UniversalBrowserWrite');

            if (!(reqFileOperations[params.prefix]))
                reqFileOperations[params.prefix] = new XMLHttpRequest();
        } catch (e) {
            alert("error creating XMLHttpRequest object for writeExpandableList: " + e);
            reqFileOperations[params.prefix] = null;
        }
        // branch for IE/Windows ActiveX version
    } else if (window.ActiveXObject) {
        try {

            if (!(reqFileOperations[params.prefix]))
                reqFileOperations[params.prefix] = new ActiveXObject("Microsoft.XMLHTTP");

        } catch (e) {
            reqFileOperations[params.prefix] = false;
        }

    }


    if (reqFileOperations[params.prefix]) {

        

        params.fileData = null;

        // we need to use the secureReadTextFile
        // function to actually get the text
        // because the XMLHTTPRequest object
        // may not be able to access local xml files due to
        // security settings, esp. IE7 security settings
        var fileText = "";

        fileText = top.secureReadTextFile(params.fileName);

        fileText = fileText.toString();

        // need to figure out if this is a comma delimited string instead of an
        // array
        // may hav to handle differently

        // if there are any carriage returns in the string, remove them
        i = fileText.indexOf("\r");
        while (i > -1) {
            fileText = fileText.replace(/\r/,"");
            i = fileText.indexOf("\r");
        }

        // if there are any line feeds in the string, remove them
        i = fileText.indexOf("\n");
        while (i > -1) {
            fileText = fileText.replace(/\n/,"");
            i = fileText.indexOf("\n");
        }

        // if there are any commas in the string, remove them
        // i think that the secureReadTextFile function might insert commas,
        // and return a csv string, maybe with commas where the /n/r characters
        // were
        i = fileText.indexOf(",");
        while (i > -1) {
            fileText = fileText.replace(/,/,"");
            i = fileText.indexOf(",");
        }


        if (document.implementation.createDocument) {
            // Mozilla, create a new DOMParser
            var parser = new DOMParser();
            params.fileData = parser.parseFromString(fileText, "text/xml");
        } else if (window.ActiveXObject) {
            // IE, create a new XML document using ActiveX and use loadXML as a
            // DOM parser.
            params.fileData = new ActiveXObject("Microsoft.XMLDOM");
            params.fileData.async = "false";
            params.fileData.loadXML(fileText);
        }

        if (params.onLoadComplete) {
            params.onLoadComplete(params.fileData);
            // params.onLoadComplete(fileText);

        }

    }

}




// ***************************************************************************************
function processXMLRequestChangeFileOperations(params) {

    var readyStateDescrips = new Array(5);
    readyStateDescrips[0] = "uninitialized";
    readyStateDescrips[1] = "loading";
    readyStateDescrips[2] = "loaded";
    readyStateDescrips[3] = "interactive";
    readyStateDescrips[4] = "complete";

    params.fileData = null;

    if (reqFileOperations[params.prefix]) {

        // only if req shows "complete"
        if (reqFileOperations[params.prefix].readyState == 4) {
            // only if "OK"
            if ((reqFileOperations[params.prefix].status == 200) || (reqFileOperations[params.prefix].status == 0)) {
                if (params.returnAsXML) {
                    // Do I really need to do it this way in order to allow the
                    // xml
                    // to be parsed from a local file not on a server?
                    // it would be easier to just use the responseXML object,
                    // but
                    // it doesn't seem to work in IE locally.
                    if (document.implementation.createDocument) {
                        // Mozilla, create a new DOMParser
                        var parser = new DOMParser();
                        params.fileData = parser.parseFromString(reqFileOperations[params.prefix].responseText, "text/xml");
                    } else if (window.ActiveXObject) {
                        // IE, create a new XML document using ActiveX and use
                        // loadXML
                        // as a DOM parser.
                        params.fileData = new ActiveXObject("Microsoft.XMLDOM");
                        params.fileData.async = "false";
                        params.fileData.loadXML(reqFileOperations[params.prefix].responseText);
                    }

// params.fileData = reqFileOperations[params.prefix].responseXML;
                } else
                    params.fileData = reqFileOperations[params.prefix].responseText;
                /*
                 * i = params.fileData.indexOf("\r");
                 *
                 * //if there are any carriage returns in the string, remove
                 * them while (i > -1) { params.fileData =
                 * params.fileData.replace(/\r/,""); i =
                 * params.fileData.indexOf("\r"); }
                 *
                 * tmp = params.fileData.split("\n"); params.fileLineCount =
                 * tmp.length;
                 */
                if (params.onLoadComplete) {
                    params.onLoadComplete(params.fileData);
                }

            } else {
                alert("There was a problem retrieving the data for loading file:\n" + reqFileOperations[params.prefix].statusText);
            }
        }

    }

}

/*******************************************************************************
 * For debug
 ******************************************************************************/
function showmtArray() {
    var mtStr = "mtArray:\n";
    for (var i=0; i<top.mtArray.length-1; i++) {
        mtStr += top.mtArray[i] + "\n"
             }
             mtStr += top.mtArray[i];
    alert(mtStr);
}
function showtoolArray() {
    var str = "toolArray:\n";
    // str += toolArea;
    alert(str);
}
function showOtherinfo() {
    var str = "proxyPwd: " + proxyPwd;
    str += "\n proxyUid: " + proxyUid;
    str += "\n proxyPort: " + proxyPort;
    str += "\n proxyAdd: " + proxyAdd;
    str += "\n program: " + program;
    // str += "\n bootEnv: " + bootEnv;
    str += "\n isoFile: " + isoFile;
    str += "\n workingdir: " + workingdir;
    alert(str);
}

/**
  * Present license agreement panel if NOT accepted before
  * Otherwise, step forward
  */
function checkLicense() {
    if (LicenseAgreement.isAccepted() == false) {
        LicenseAgreement.presentAgreement();
    }
}

/*need transfer to display Chinese */
function ansi2utf8(srcFileName, dstFileName) {
    var FSO = new ActiveXObject("Scripting.FileSystemObject");
    var nForReading=1;
    var oFileObj = FSO.OpenTextFile(srcFileName, nForReading, false);
    var sFileContents=oFileObj.ReadAll();
    oFileObj.Close();
    if (dstFileName == "") {
        writeTextFile(srcFileName, sFileContents, false);
    } else {
        writeTextFile(dstFileName, sFileContents, false);
    }
}
function setVmwareUpdateValue(value) {
    vmwareUpdate = value;
}

function getVmwareUpdateValue() {
    return vmwareUpdate;
}

// Function performed when "Cancel" requested on global status panel
var cancelAction;
function cancelRequest() {
    if (typeof(cancelAction) == "function") {
        cancelAction();
    }
    hideGlobalStatus();
}
function initGlobalStatusPanel() {
    var panelStr = new String();
    panelStr += "<div style='float:clear;'></div><div id='gStatusDiv'>"
                +   "<img id='gStatusImg' src='./images/progress_anim2.gif' alt='Progressing'/>"
                + "<div id='gStatusInfo' ></div></input></div>";
    var panelDiv = document.getElementById("langSelectWrapper");
    panelDiv.innerHTML = panelStr;

    panelDiv.style.backgroundImage = "url(./images/bkg_message_info.gif)";
    // panelDiv.style.backgroundRepeat = "repeat-x";
    // panelDiv.style.paddingLeft = "0px";
    // panelDiv.style.paddingRight = "0px";
    // panelDiv.style.paddingTop = "0px";
    // panelDiv.style.paddingBottom = "10px";
    var offsetHeight = document.body.offsetHeight;
    panelDiv.style.height = offsetHeight;

}

/**
  * @param
  *       msg - string to be displayed
  *       callback - action performed when "Cancel" requested
  *       status(STATUS) - enum indicating current status
  */
function showGlobalStatus(msg, callback, status) {
    if (typeof(callback) == "function") {
        cancelAction = callback;
    } else {
        cancelAction = null;
    }

    var statusInfo = top.document.getElementById("gStatusInfo");
    statusInfo.innerHTML = (msg == null) ? "In progress now, please wait..." : msg;
    var statusImg = document.getElementById("gStatusImg");
    switch (status) {
    case STATUS.SUCCESS: {
        statusImg.src = "./images/statusSuccess.gif";
        break;
    }
    case STATUS.FAIL: {
        statusImg.src = "./images/statusCritical.gif";
        break;
    }
    case STATUS.PROGESS: {
        statusImg.src = "./images/progress_anim2.gif";
        break;
    }
    case STATUS.WARNING: {
        statusImg.src = "./images/statusWarning.png";
        break;
    }
    default:
        statusImg.src = "./images/progress_anim2.gif";
        break;
    }
    // var overlay = document.getElementById("overlay");
    // overlay.style.display = "block";
    var gStatusPanel = top.window.document.getElementById("langSelectWrapper");
    // if (top.BROWSER == "IExplore") {
    //     gStatusPanel.style.display = "inline-block";
    // } else {
    //     gStatusPanel.style.display = "table";
    // }

    //test
    // var offsetHeight = document.body.offsetHeight;
    // gStatusPanel.style.height = offsetHeight;
    gStatusPanel.style.display = "inline-block";
    //test

    /*// Horizontally aligned to center
    var topWidth = top.document.body.clientWidth;
    var panelWidth = gStatusPanel.clientWidth;
    if (panelWidth == 0) {
        gStatusPanel.style.width = panelWidth;
    }
    if (panelWidth < topWidth) {
        gStatusPanel.style.left = (topWidth - panelWidth) / 2;
    }
    // Vertically aligned to middle
    var topHeight = top.document.body.clientHeight;
    var panelHeight = gStatusPanel.clientHeight;
    if (panelHeight == 0) {
        gStatusPanel.style.height = panelHeight;
    }
    if (panelHeight < topHeight) {
        gStatusPanel.style.top = (topHeight -panelHeight) / 2;
    }*/

}
function hideGlobalStatus() {
    var gStatusPanel = document.getElementById("langSelectWrapper");
    gStatusPanel.style.display = "none";
    /*var overlay = document.getElementById("overlay");
    overlay.style.display = "none";*/
}

/**
 * Check if content in array
 * @param
 *    array   - target probing container
 *    content - element to probe
 * @return
 *    true  - at least 1 is found
 *    false - otherwise
 */
function existInArray(array, content) {
    var exist = false;
    for (var i = 0; i < array.length; ++i) {
        if (array[i] == content) {
            exist = true;
            break;
        }
    }
    return exist;
}

// function setNoFirmwareValue(value) {
//     noFirmware = value;
// }

// function getNoFirmwareValue() {
//     return noFirmware;
// }

// function setArchValue(value) {
//     arch = value;
// }

// function getArchValue() {
//     return arch;
// }

/**
 * Example: change "uxspi,dsa" to "Updates, Diagnostics"
 */
// function getProgramDisplayName(programs) {
//     if (top.selectedOSMachineType.indexOf("storage") != -1) {
//         return 'storage';
//     }
//     var displayName = "";
//     var programArray = programs.split(",");
//     for (var i = 0; i < programArray.length; ++i) {
//         if ("uxspi" == programArray[i]) {
//             displayName += ",Updates";
//         } else if ("dsa" == programArray[i]) {
//             displayName += ",Diagnostics";
//         } else if ("serverguide" == programArray[i]) {
//             displayName += ",Deployment";
//         }
//     }
//     return displayName.substring(1);
// }

/*
var deleteFile;
if (top.BROWSER == "IExplore") {
    deleteFile = function(fileName) {
        try {
            var fso = new ActiveXObject("Scripting.FileSystemObject");
            if (fso.FileExists(fileName)) {
                file = fso.GetFile(fileName);
                file.Delete();
            }
        } catch (e) {
            top.logException(e);
            return false;
        }
        return true;
    };
} else {
    deleteFile = function(fileName) {
        try {
            netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
            var file = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
            file.initWithPath(fileName);
            if (file.exists()) {
                file.remove(false);
            }
        }	catch (e) {
            top.logException(e);
            return false;
        }
        return true;
    };
}
*/
function getVMWareSupportList(){
    initSupportList(SYSTEM_SUPPORT_LIST, originLocationSSL);
    initSupportList(SALIE_SUPPORT_LIST, originSalieLocationSSL);
    try {
        gl_salie_machine_list = JSON.parse(top.readTextFile(SALIE_SUPPORT_LIST));
        if(gl_salie_machine_list == null) throw new Error();
        // var supportListlFile = findFile(null, SYSTEM_SUPPORT_LIST);
        var supportListlFile = SYSTEM_SUPPORT_LIST;
        getXML(supportListlFile, readVMWareList, "getSupportVmwareVers");
    } catch (error) {
        if(!window.confirm("The format of '"+ SALIE_SUPPORT_LIST 
        + "' is error, do you continue to load this file from libs directory." ))
        return;

        if(top.OSTYPE == "windows"){
            var salie_support_list_temp = top.workingdir + "\\SALIE_SYSTEM_SUPPORT_LIST_13.3.0.json";
            gl_salie_machine_list = JSON.parse(readTextFile(salie_support_list_temp));

            var supportListFile_temp = top.workingdir + "\\SYSTEM_SUPPORT_LIST_13.3.0.xml";
            getXML(supportListFile_temp, readVMWareList, "getSupportVmwareVers");
        }else{
            var salie_support_list_temp = top.workingdir + "/SALIE_SYSTEM_SUPPORT_LIST_13.3.0.json";
            gl_salie_machine_list = JSON.parse(readTextFile(salie_support_list_temp));

            var supportListFile_temp = top.workingdir + "/SYSTEM_SUPPORT_LIST_13.3.0.xml";
            getXML(supportListFile_temp, readVMWareList, "getSupportVmwareVers");
        }
    }
    
    
}

function readVMWareList(xmlDoc){
    if (availableVMWare.length){
		availableVMWare.length = 0;
    }
    
    var root = xmlDoc.documentElement;
    var firstSystem = root.getElementsByTagName("system").item(0);
    var count = firstSystem.childNodes.length;
    for (var i = 0; i < count; i ++) {
            var curNodeName = firstSystem.childNodes[i].nodeName;
            if (curNodeName.indexOf("vmwareupdate") != -1) {
                	var vmwareVer;
			var startPos = curNodeName.indexOf("vmwareupdate") + 12;
			vmwareVer = curNodeName.substring(startPos);
			
			availableVMWare.push(vmwareVer);
            }
    }
}

function setPreviewParams(args) {
    var previewFile = gl_ibm_support + "preview.json";
    if(top.fileExists(previewFile))
    {
        var content = top.readTextFile(previewFile);
        if (content[0] === 0xEF && content[1] === 0xBB && content[2] === 0xBF) {
            content = content.slice(3);
        }
        var previewParams = JSON.parse(content.toString('utf-8'));
        args.push("--preview-enable");
        args.push("--preview-username");
        args.push(previewParams.username);
        args.push("--preview-password");
        args.push(previewParams.password);
    }
}

function mkdirsSync(dirname) {
    if (top.fileExists(dirname)) {
		return true;
    } else {
        top.createDirectory(dirname);
        return true;
	}
}

function createSampleFile(fileDir) {
    if (!fileExists(fileDir))
    {
        if (!fileExists(top.dirname(fileDir)))
        {
            mkdirsSync(top.dirname(fileDir));
        }
        top.writeTextFile(fileDir, top.readTextFile(originRAIDSW));
        return true;
    }
    else
    {
        return false;
    }
}

function getIniFiles(filesPath){
    var files = [];
    var allGet = top.get_folder_content(filesPath);
    for(var i = 0; i<allGet.length; ++i)
    {
        var fPath = filesPath + FILE_SEPARATOR + allGet[i];
        if (top.fileExists(fPath) && allGet[i].lastIndexOf(".ini") == allGet[i].length-4) { 
            files.push(allGet[i]);
        }
    }
    return files;
}

function loadConFiles(sourceFiles,sourceFilesDir)
{
    configFiles = [];
    for(var i = 0; i<sourceFiles.length; ++i)
    {
        configFiles[i] = [sourceFiles[i],top.readTextFile(sourceFilesDir+FILE_SEPARATOR+sourceFiles[i])];
    }
}

function writeConFiles(targetDir)
{
    if (!fileExists(targetDir))
    {
        mkdirsSync(targetDir);
    }
    for(var i = 0; i<configFiles.length; ++i)
    {
        top.writeTextFile(targetDir + FILE_SEPARATOR + configFiles[i][0], configFiles[i][1]);
    }
}

function isCorrectDirectory(directoryName) {
	try {
		return top.isDirectory(directoryName);
	} catch (e) {
		top.logException(e, arguments);
		return false;
	}
}

function openSampleFile() {
    var mywidth = 800;
    var myheight = 600;
    var myleft = (screen.width - mywidth) / 2;
    var mytop = (screen.height - myheight) / 2;
    var sampleFileOpts = 'width=' + mywidth + ', height=' + myheight;
    sampleFileOpts += ', top=' + mytop + ', left=' + myleft;
    sampleFileOpts += ', directories=no';
    sampleFileOpts += ', location=no';
    sampleFileOpts += ', menubar=yes';
    sampleFileOpts += ', resizable=yes';
    sampleFileOpts += ', scrollbars=yes';
    sampleFileOpts += ', status=no';
    sampleFileOpts += ', toolbar=no';
    sampleFileOpts += ', close=yes';
    sampleFileOpts += ', show=true';

    var iniSampleFileWindow = window.open(originRAIDSW, "RAID_SAMPLE.ini", sampleFileOpts);
    if (window.focus) iniSampleFileWindow.focus();
}