// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
var CreateMedia=function(){
	var timer1_ux;
	var overwriteChecked = false;
	//var isoFileSelectedByUser = "";
	//var pxeDirSelectedByUser = "";
	var pxeIPValid = true;
	var fileNameValid = true;
	var userAllowOverwrite = true;

	function createMedia_init()
	{
		if (top.selectedOSMachineType.indexOf("storage") != -1) {
			$('#deviceType').attr('disabled', true);
			$('#device').attr('disabled', false);
			$('#device_desc').hide();
			$('#device_select').hide();
			$('#device_section').hide();
		} else {
			$('#deviceType').removeAttr('disabled');
			$('#device').attr('disabled', true);
			$('#device_desc').show();
			$('#device_select').show();
			$('#device_section').show();
		}
		if (top.selectedOSMachineType.indexOf("storage") != -1 || top.selectedOSMachineType.indexOf("ibm") != -1 
		|| document.getElementById("deviceType").value == "PXE"|| document.getElementById("deviceType").value == "USB")
		{
			if(top.copy_ram_disk) $("#copyRamDisk").click();
			$("#RamDisk").hide();
		}
		else
		{
			$("#RamDisk").show();
		}
		// $('#fileName').attr('value', top.isoFile);
		document.getElementById("fileName").value = top.isoFile;
		isoFileSelectedByUser = top.isoFile;
		top.bMediaFormat = true;
		top.isForce = false;
		updateMediaProperty();
 	}

 	function refreshMediaProperty() {
 		
 	}

	function checkSelection(updateGlobal)
	{
		var x=document.getElementById("device");
		var y=document.getElementById("fileName");
	    var b=document.getElementById("Browse");
		if (x.checked)
		{
	    	showUSBKey(true);
			y.disabled = true;
			b.disabled = true;
			b.style.color = "gray";
	        createISOFile = false;
	        createPXEFile = false;
		}
		else
		{
	    	showUSBKey(false);
			y.disabled = false;
			b.disabled = false;
			b.style.color = "black";
	        var sel = document.getElementById("deviceType");
	        if (sel.options[sel.selectedIndex].text == "CD/DVD" || sel.options[sel.selectedIndex].text == "DVD")
	        {
	            createISOFile = true;
	            createPXEFile = false;
	        }
	        else
	        {
	            createISOFile = false;
	            createPXEFile = true;
	        }
		}

		// Bug 90983 - [BoMC10.4_sles12]select not iso file,the path change to \;select write directly to device fail,then select write to image file,the path can not modify and the Browse can not stick.
		if (document.getElementById("image").checked)
		{
			document.getElementById("fileName").disabled = false;
			document.getElementById("Browse").disabled = false;
			document.getElementById("Browse").style.color = "black";
		}
	     
		if (updateGlobal)
		    setWriteName();
	}


	function selectUSBKey(theOption)
	{
		if (theOption == "undefined") {
	        alert('No device found');
	        return;
	    }
	    var theValue = theOption.text;
	    var x=document.getElementById("deviceType");
	    if (x.options[x.selectedIndex].text == "CD/DVD" || x.options[x.selectedIndex].text == "DVD")
	    {
	    	top.cdVolume = theValue;
	    	top.usbKeyVolume = "";
	    	top.pxeFile="";      
	        top.isoFile=""; 
	    }
	    if (x.options[x.selectedIndex].text == "USB")
	    {
	    	top.usbKeyVolume = theValue;
	    	top.cdVolume = "";
	    	top.pxeFile="";      
	        top.isoFile=""; 
	    }
		
		setWriteName();
	}
	function changeIso(theValue) {
	    if (engineTop.secureFileExists(theValue)) {
	        overwriteChecked = true;
	        top.isForce = true;
	    } else {
	        overwriteChecked = false;
	        top.isForce = false;                	    
	    }

	    if(createISOFile == true) {
	        top.isoFile = theValue;
	        document.getElementById("fileName").value = theValue;
	        // isoFileSelectedByUser = theValue;
	    } else {
	        top.pxeFile = theValue;
	        document.getElementById("fileName").value =  theValue;
	        // pxeDirSelectedByUser = theValue;
	    }
	}

	function selectDevice(theValue)
	{
		var x=document.getElementById("device");
		var z=document.getElementById("image");
		var y=document.getElementById("fileName");
		var b=document.getElementById("Browse");

	  var pxeExtra = document.getElementById("pxeExtra");
	  pxeExtra.style.display = "none";
	  
	  // When device changed, need to reset the force value. Add by wengmh1 2017/3/16
		top.isForce = false;

	  if (theValue == "CD") {
		if (top.selectedOSMachineType.indexOf("storage") == -1 && top.selectedOSMachineType.indexOf("ibm") == -1) $("#RamDisk").show();
	    //document.listForm.fileName.value = "bootable.iso";
	    x.disabled = true;
	    z.disabled = false;
		x.checked = false;
		z.checked = true;
		showUSBKey(false);
	    if(x.checked == true)
	    {
	        y.disabled = true;
			b.disabled = true;
			b.style.color = "gray";
	        showUSBKey(false);
	    }
	    else if(z.checked == true)
	    {
	        y.disabled = false;
			b.disabled = false;
			b.style.color = "black";
	        if (top.OSTYPE == "windows")
	        {
	        	if (top.isoFile != null && top.isoFile != '')
	        	{
	        		y.value = top.isoFile;
	        	}
	        	//else if (isoFileSelectedByUser != null && isoFileSelectedByUser != '')
	        	//{
	        	//	y.value = isoFileSelectedByUser;
	        	//}
	            else if (top.workingdirProgram.lastIndexOf("\\") == top.workingdirProgram.length-1)
	            {
		            y.value = top.workingdirProgram + "bootable.iso";
	            }
	            else
	            {
        			y.value = top.workingdirProgram + "\\bootable.iso";
	            }
		        //document.listForm.fileName.value = top.workingdirProgram + "\\bootable.iso";
	        }
	        else
	        {
	        	if (top.isoFile != null && top.isoFile != '')
	        	{
	        		y.value = top.isoFile;
	        	}
	        	//else if (isoFileSelectedByUser != null && isoFileSelectedByUser != '')
	        	//{
	        	//	y.value = isoFileSelectedByUser;
	        	//}
	            else if( top.workingdirProgram.lastIndexOf("/") == top.workingdirProgram.length-1)
	            {
		            y.value = top.workingdirProgram + "bootable.iso";
	            }
	            else
	            {
	                   y.value = top.workingdirProgram + "/bootable.iso";
	            }
	            //document.listForm.fileName.value = top.workingdirProgram + "/bootable.iso";
	        }
	    }
	  }
	  else if (theValue == "USB"){
		if(top.copy_ram_disk) $("#copyRamDisk").click();
		$("#RamDisk").hide();
	    y.value = "";
	    x.disabled = false;
	    x.checked = "checked";
	    y.disabled = true;
		b.disabled = true;
		b.style.color = "gray";
	    z.disabled = true;
	    showUSBKey(true);
	  }
	  else if (theValue == "PXE"){
		if(top.copy_ram_disk) $("#copyRamDisk").click();
		$("#RamDisk").hide();
	    pxeExtra.style.display = "";

	    var address = document.getElementById("pxeTFTPAddress");
	    if (top.pxeTFTPAddress == "") {
	        address.value = "9.123.196.61";
	    } else {
	        address.value = top.pxeTFTPAddress;
	    }
	    
	    if (top.OSTYPE == "windows")
	    {
    		if (top.pxeFile != null && top.pxeFile != '')
        	{
        		y.value = top.pxeFile;
        	}
        	//else if (pxeDirSelectedByUser != null && pxeDirSelectedByUser != '')
        	//{
        	//	y.value = pxeDirSelectedByUser;
        	//}
            else if (top.workingdirProgram.lastIndexOf("\\") == top.workingdirProgram.length-1)
            {
	            y.value = top.workingdirProgram + "pxedir";
            }
            else
            {
                y.value = top.workingdirProgram + "\\pxedir";
            }
	    }
	    else
	    {
			if (top.pxeFile != null && top.pxeFile != '')
			{
				y.value = top.pxeFile;
			}
			//else if (pxeDirSelectedByUser != null && pxeDirSelectedByUser != '')
        	//{
        	//	y.value = pxeDirSelectedByUser;
        	//}
            else if (top.workingdirProgram.lastIndexOf("/") == top.workingdirProgram.length-1)
            {
	            y.value = top.workingdirProgram + "pxedir";
            }
            else
            {
                y.value = top.workingdirProgram + "/pxedir";
            }
	    }
	    showUSBKey(false);
	    z.disabled = false;
	    z.checked = "checked";
	    x.disabled = true;
	    y.disabled = false;
		b.disabled = false;
		b.style.color = "black";
	  }
	  else {
	    y.value = "";
	  }
	  updateDesc(theValue);
	  setWriteName();
	}

	function updateDesc(theValue) {
	  if (theValue == "PXE") {
	    var imageLocationDiv = document.getElementById("imageLocationDiv");
	    imageLocationDiv.style.display = "none";
	    var pxeFileTitle = document.getElementById("pxeFileTitle");
	    pxeFileTitle.style.display = "";
	    var pxeExtra = document.getElementById("pxeExtra");
	    pxeExtra.style.display = "";    
	  } else {
	    var imageLocationDiv = document.getElementById("imageLocationDiv");
	    imageLocationDiv.style.display = "";
	    
	    var pxeFileTitle = document.getElementById("pxeFileTitle");
	    pxeFileTitle.style.display = "none";

	    var pxeExtra = document.getElementById("pxeExtra");
	    pxeExtra.style.display = "none";
	  }
	}

	var NoUSB = 0;
	var timerID;
	
	function count() {
	     document.getElementById("device").checked = false;
		 document.getElementById("image").checked = true;
		 checkSelection(false);
		 var deviceType = document.getElementById("deviceType");
		 deviceType.selectedIndex = 0;
		 document.getElementById("fileName").value = top.isoFile;
	     selectDevice("CD");
	     // clearInterval(timerID);
	     NoUSB = 0;
	}

	/**
	  * Disable/Enable user to input tftp address
	  * @param
	  *       cb - object of checkbox indicating whether or not user is allowed to input tftp address
	  */
	function enableTFTP(cb) {
	    var addressInput = document.getElementById("pxeTFTPAddress");
	    if (cb.checked == true) {
	        addressInput.disabled = false;
	    } else {
	        addressInput.disabled = true;
	    }
	}

	function showUSBKey(status)
	{
	    if (status == true) {
	    document.getElementById("pxeExtra").style.display = "none";
		document.getElementById("usbKeyTitle").style.display ="";
		document.getElementById("usbKeyContent").style.display = "";
	    } else {
		document.getElementById("usbKeyTitle").style.display = "none" ;
		document.getElementById("usbKeyContent").style.display = "none" ;
	    }
		
		var mtStr;
		var x=document.getElementById("deviceType");
		//alert(x.options[x.selectedIndex].text);
	    if (x.options[x.selectedIndex].value == "CD")
	    {
	    	mtStr = top.cd;
	    }
	    if (x.options[x.selectedIndex].value == "USB")
	    {
	    	mtStr = top.usbKey;
	    }
	    
		if (mtStr) 
		{
			var usbKeyVolume = document.getElementById("usbKeyVolume");
			var ooption = new Array();
			var beginPos = 0;
			var lastPos = mtStr.indexOf(";");
			
			while(lastPos > 0)
			{
				ooption.push(mtStr.substr(0, lastPos));
				beginPos = lastPos + 1;
				mtStr = mtStr.slice(beginPos);
				lastPos = mtStr.indexOf(";");
			}	
			//ooption.push(mtStr);  // ex: usbKey=A:;I:; last item=""  

	    		usbKeyVolume.options.length = 0;
			var i;
			for(i=0; i<ooption.length; ++i)
			{
				usbKeyVolume.options[i] = new Option(ooption[i], ooption[i]);
			}
			if (i > 0) {
				// default selected item
				usbKeyVolume.selectedIndex = --i;
			}
			else {
			  if ( x.options[x.selectedIndex].value == "CD" && !document.getElementById("device").checked)
			  {
			  	//nothing to do, for defect 493830
			  }
			  else if ( NoUSB == 0 )
			  {
			  	NoUSB = 1;
				alert("No USB Key found.");
				// timerID = setInterval("count()",1000);
				count();
			  }
			}
			
		}
	}
	function setWriteName()
	{
		var sel = document.getElementById("deviceType");

		if (document.getElementById("device").checked)
		{
	        createISOFile = false;
	        createPXEFile = false;
			if (sel.options[sel.selectedIndex].text == "USB" )
			{
				sel = document.getElementById("usbKeyVolume");
				  if ( sel.options.length != 0 )
				  {
			    top.usbKeyVolume = sel.options[sel.selectedIndex].value;
			    }
			    top.cdVolume = "";
			    top.isoFile = "";
			    top.pxeFile = "";
			}
			else if (sel.options[sel.selectedIndex].value == "CD")
			{
				top.writeName = "IBM_SYSTEM_CD";
	            var deviceSelected = sel.options[sel.selectedIndex].text;
				sel = document.getElementById("usbKeyVolume");
				if (sel.options.length == 0) {
				    var errMsg = "No device \"" + deviceSelected + "\" found in your system";
				    count();
				    //alert(errMsg);
				    return;
				}
			    top.cdVolume = sel.options[sel.selectedIndex].value;
			    top.usbKeyVolume = "";
			    top.isoFile = "";
			    top.pxeFile = "";
			}
			else // pxe
			{
				// not possible	
			}
		}

		else
		{
			var filename = document.getElementById("fileName").value;
			if (sel.options[sel.selectedIndex].text == "PXE" )
			{
	            createISOFile = false;
	            createPXEFile = true;
				top.pxeFile=filename;      
	            top.isoFile="";      
	            top.usbKeyVolume=""; 
	            top.cdVolume="";  
			}
			else 
			{
	            createISOFile = true;
	            createPXEFile = false;
				      top.pxeFile=""; 
	            if(filename == "")
	            {   
	              if (top.OSTYPE == "windows")
	                  {
	                      if(top.workingdirProgram.lastIndexOf("\\") == top.workingdirProgram.length-1)
	                      {
	          	                document.getElementById("fileName").value = top.workingdirProgram + "bootable.iso";
	          	                
	                      }
	                      else
	                      {
	                            document.getElementById("fileName").value = top.workingdirProgram + "\\bootable.iso";
	                      }                  
	                  }
	                  else
	                  {
	                      if(top.workingdirProgram.lastIndexOf("/") == top.workingdirProgram.length-1)
	                      {
	          	               document.getElementById("fileName").value = top.workingdirProgram + "bootable.iso";
	          	          }
	                      else
	                      {
	                           document.getElementById("fileName").value = top.workingdirProgram + "/bootable.iso";
	                      }
	                  } 
	            } 
	            top.isoFile = document.getElementById("fileName").value;
	            top.usbKeyVolume=""; 
	            top.cdVolume="";  
			}
		}
	}

	/**
	  * @return - bool
	  *             - whether there is physical device in this system for the media type selected
	  */
	function isDeviceExist() {
	    var exist = true;
	    var isWriteToDevice = document.getElementById("device").checked;
	    if (isWriteToDevice == true) {
	        var currentDeviceType = document.getElementById("deviceType");
	        var currentDeviceTypeName = currentDeviceType.options[currentDeviceType.selectedIndex].text;
	        var deviceNameList = document.getElementById("usbKeyVolume");
	        if (deviceNameList.options.length == 0) {
	            exist = false;
	            var errMsg = "No device \"" + currentDeviceTypeName + "\" found in your system";
	            alert(errMsg);
	        }
	    }
	    return exist;
	}

	function createDeviceAfterValidation() {
		pxeIPValid = true;
		fileNameValid = true;
		userAllowOverwrite = true;

	    if (isDeviceExist() == true) {
	        checkOverwrite();
	    }
	   	var sel = document.getElementById("deviceType");
		top.mediaFormat = sel.selectedIndex;
		if (!pxeIPValid || !fileNameValid || !userAllowOverwrite) {
			return false;
		} else {
			return true;
		}
	}

	/*
		check whether iso file name is empty or has the .iso suffix
		@return:
		true means image file name is OK.
		false means image file name is empty or not iso file.
	*/
	function checkIsoFile()
	{
		var ret = true;
		var fileName = document.getElementById("fileName").value;
		if(fileName == "")
		{
			alert("Please assign the file name for iso creation");
			fileNameValid = false;
			ret = false;
		}
		else
		{
			var index;
			index = fileName.lastIndexOf(".");
			if (index != -1)
			{
				var suffix = fileName.substr(index);
				if (suffix != ".iso")
				{
					alert("The image file must be .iso file");
					//alert(fileName + "  " + suffix);
					fileNameValid = false;
					ret = false;
				}
				else
				{
					//file name is OK and set top.isoFile
					top.isoFile = fileName;
					fileNameValid = true;
				}
			}
			else
			{
				alert("The image file must be .iso file");
				fileNameValid = false;
				ret = false;
			}
		}

		return ret;
	}
	function checkOverwrite()
	{
		if(top.isForce == true)
		{
			overwriteChecked = true;
			top.configTag["IBM_SYSTEM_FORCE_OVERWRITE"] == "";  
		}
	    // need to do nothing now, because we change to use dialog box to choose the directory or file
		if(createISOFile == true)
		{
			if(engineTop.secureFileExists(top.isoFile))
			{
				// ISO file already exists in working directory
				if(confirm("Are you sure you want to overwrite " + top.isoFile + "?"))
				{
					top.isForce = true;
					userAllowOverwrite = true;
					return true;
				}
				else
				{
					alert("Please assign another name for the ISO file");
					userAllowOverwrite = false;
					return false;
				}
			}
			else if(checkIsoFile() == true)
			{
				//ISO file not exists
				return true;
			}
		}
		else if(createPXEFile == true)
		{
			var pxeKeyFile = "";
			if (top.OSTYPE == "windows")
			{
				if(top.pxeFile.lastIndexOf("\\") == top.pxeFile.length-1)
				{
					pxeKeyFile = top.pxeFile + "pxelinux.0";
				}
				else
				{
					pxeKeyFile = top.pxeFile + "\\pxelinux.0";
				}                  
			}
			else
			{
				if(top.pxeFile.lastIndexOf("/") == top.pxeFile.length-1)
				{
					pxeKeyFile = top.pxeFile + "pxelinux.0";
				}
				else
				{
					pxeKeyFile = top.pxeFile + "/pxelinux.0";
				}
			}

			var errMsg = "";
			var pxeExisted = engineTop.secureFileExists(pxeKeyFile);
			if (pxeExisted)
			{
				if (confirm("Are you sure you want to overwrite " + top.pxeFile + "?"))
				{
					top.isForce = true;
					userAllowOverwrite = true;
				}
				else
				{
					errMsg = "Please assign another direcotry for pxe creation";
				}
			}
			else if (top.pxeFile == "")
			{
				errMsg = "Please assign the directory for pxe creation";
			}

			if(errMsg != "")
			{
				alert(errMsg);
				fileNameValid = false;
			}            
			else
			{
				var addressText = document.getElementById("pxeTFTPAddress");
				if (top.trim(addressText.value) == "") {
					alert("Please specify the TFTP Address");
					pxeIPValid = false;
					return false;
				} else {
					top.pxeTFTPAddress = addressText.value.replace(/^\s+/, '').replace(/\s+$/, '');
					if (top.pxeTFTPAddress.search(/\s+/g) != -1) {
						alert("No space(s) allowed in the middle of tftp server address");
						pxeIPValid = false;
						return false;
					} else if (top.pxeTFTPAddress.match(ipv4_pattern) == null && top.pxeTFTPAddress.match(ipv6_pattern) == null) {
						alert("Please input valid IPv4 or IPv6 address.");
						pxeIPValid = false;
						return false;
					} else {
						pxeIPValid = true;
						return true;
					}
				}
			}
		}
		else
		{
			//create usb or burn to device
			return true;
		}
	}

	/**
	  * 
	  */ 
	function initStatusIndicator() {
	    if (top.isForce == true) {
	        overwriteChecked = true;
	    } else {
	        overwriteChecked = false;
	    }
	    if (top.configTag["IBM_SYSTEM_ISO_FILE"] == "1") {
	        createISOFile = true;
	        createPXEFile = false;
	    } else if (top.configTag["IBM_SYSTEM_PXE_FILE"] == "1") {
	        createPXEFile = true;
	        createISOFile = false;
	    } else {
	        // dummy for now
	    }
	}

			

    function updateMediaProperty()
    {
		initStatusIndicator();
		var args = new Array();
		args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
		args.push("--file");
		args.push(top.bomc_gui);
		if(!secureRunProgram(null, args, BACKGROUND, HIDDEN, null, updateCreateMedia))
		{
			updateCreateMedia();
		}
    }

	function updateCreateMedia()
	{
		var propertiesInfo = new Array();
		if (!engineTop.secureFileExists(top.basicInfo)) {
			alert("Can't get basic info!");
			return false;
		}
		engineTop.secureRead1PropertyFile(top.basicInfo, propertiesInfo, false);
		top.usbKey = propertiesInfo["IBM_SYSTEM_USBDISK"];
		
		var deviceType = document.getElementById("deviceType");
		var usbKeyVolume = document.getElementById("usbKeyVolume");
		var option;
		if (top.OSTYPE == "windows") {
			if (top.program.indexOf("serverguide") != -1) //no serverguide
			{
				if (deviceType.options.length != 1) {
					for (var i = 0; i < deviceType.options.length; i++) {
						if (deviceType.options[i].value == "USB" || deviceType.options[i].value == "PXE") {
							deviceType.options.remove(i);
							i = 0;
						}
					}
				}
				//selectDevice("CD"); //only cd/dvd option
			} else {
				if (deviceType.options.length == 1) {
					deviceType.options[1] = new Option("USB", "USB");
					deviceType.options[2] = new Option("PXE", "PXE");
				}
			}
		} else {
			if (deviceType.options.length == 1) {
				deviceType.options[1] = new Option("USB", "USB");
				deviceType.options[2] = new Option("PXE", "PXE");
				//alert(deviceType.option.length);
			}
		}

		if (top.configTag["IBM_SYSTEM_ISO_FILE"] == "1") {
			updateDesc("CD");
			document.getElementById("deviceType").selectedIndex = 0;
			document.getElementById("device").checked = false;
			document.getElementById("image").checked = true;
			document.getElementById("device").disabled = true;
			checkSelection(false);
			deviceType.selectedIndex = 0;
			document.getElementById("fileName").value = top.isoFile;
			top.pxeFile = "";
			top.usbKeyVolume = "";
			top.configTag["IBM_SYSTEM_ISO_FILE"] = "0";
		} else if (top.configTag["IBM_SYSTEM_PXE_FILE"] == "1") {
			updateDesc("PXE");
			document.getElementById("deviceType").selectedIndex = 2;
			document.getElementById("device").disabled = true;
			document.getElementById("image").checked = true;
			//checkSelection(false);
			deviceType.selectedIndex = 2;
			document.getElementById("fileName").value = top.pxeFile;
			top.isoFile = "";
			top.usbKeyVolume = "";
			top.configTag["IBM_SYSTEM_PXE_FILE"] = "0";

			document.getElementById("pxeExtra").style.display = "";

			if (top.configTag["IBM_SYSTEM_PXE_TFTP_ADDRESS"] == "1") {
				document.getElementById("pxeTFTPAddress").value = top.pxeTFTPAddress;
				top.configTag["IBM_SYSTEM_PXE_TFTP_ADDRESS"] = "0";
			} else {
				document.getElementById("pxeTFTPAddress").value = "9.123.196.61";
			}
			checkSelection(false);
		} else if (top.configTag["IBM_SYSTEM_USB_KEY"] == "1") {
			updateDesc("USB");
			document.getElementById("deviceType").selectedIndex = 1;
			document.getElementById("device").checked = true;
			document.getElementById("image").checked = false;
			checkSelection(false);

			deviceType.selectedIndex = 1;
			selectDevice("USB");
			for (var i = 0; i < usbKeyVolume.options.length; ++i) {
				if (usbKeyVolume.options[i].text == top.usbKeyVolume) {
					usbKeyVolume.selectedIndex = i;
					break;
				}
			}
			top.isoFile = "";
			top.pxeFile = "";
			//if ( usbKeyVolume.selectedIndex != i)
			//alert("can't find Volume %s", top.usbKeyVolume);

			top.configTag["IBM_SYSTEM_USB_KEY"] = "0";
		} else if (top.configTag["IBM_SYSTEM_CD"] == "1") {
			updateDesc("CD");
			document.getElementById("deviceType").selectedIndex = 0;
			document.getElementById("device").checked = false;
			document.getElementById("image").checked = true;
			document.getElementById("device").disabled = true;
			checkSelection(false);

			deviceType.selectedIndex = 0;
			for (var i = 0; i < usbKeyVolume.options.length; ++i) {
				if (usbKeyVolume.options[i].text == top.cdVolume) {
					usbKeyVolume.selectedIndex = i;
					break;
				}
			}
			top.isoFile = "";
			top.pxeFile = "";
			//if ( usbKeyVolume.selectedIndex != i)
			//alert("can't find Volume %s", top.cdVolume);

			top.configTag["IBM_SYSTEM_CD"] = "0";
		} else {
			if (deviceType.options.length == 1) {
				top.pxeFile = "";
				top.usbKeyVolume = "";

				if (top.isoFile == "") {
					if (top.OSTYPE == "windows") {
						if (top.workingdirProgram.lastIndexOf("\\") == top.workingdirProgram.length - 1)
							top.isoFile = top.workingdirProgram + "bootable.iso";
						else
							top.isoFile = top.workingdirProgram + "\\bootable.iso";
					} else {
						if (top.workingdirProgram.lastIndexOf("/") == top.workingdirProgram.length - 1)
							top.isoFile = top.workingdirProgram + "bootable.iso";
						else
							top.isoFile = top.workingdirProgram + "/bootable.iso";
					}
				}
				updateDesc("CD");
				document.getElementById("deviceType").selectedIndex = 0;
				document.getElementById("fileName").value = top.isoFile;

				document.getElementById("device").disabled = true;
				document.getElementById("image").disabled = false;
				setWriteName();
			}

			if (top.pxeFile != "") {
				document.getElementById("fileName").value = top.pxeFile;
			} else if (top.usbKeyVolume != "") {
				document.getElementById("fileName").value = "";
			} else {
				document.getElementById("fileName").value = top.isoFile;
			}
			if (top.usbKeyVolume != "")
			{
				showUSBKey(true);
				var i;
				for (i = 0; i < usbKeyVolume.options.length; ++i) {
					if (usbKeyVolume.options[i].text == top.usbKeyVolume) {
						usbKeyVolume.selectedIndex = i;
						break;
					}
				}
				if(i == usbKeyVolume.options.length)
				{
					setWriteName();
				}
			}
		}
	}
	
	function saveFileButtonChange(dir)
	{
		if(dir != null && dir != '')
		{
			document.getElementById("fileName").value = dir;
			top.isoFile = dir;
			//isoFileSelectedByUser = dir;
		}
		if (engineTop.secureFileExists(top.isoFile))
		{
	        overwriteChecked = true;
	        top.isForce = true;
	    } else {
	        overwriteChecked = false;
	        top.isForce = false;                	    
	    }
	}

	function openFolderButtonChange(dir) {
		if ( dir != null && dir != '' ) {
			document.getElementById( "fileName" ).value = dir;
			top.pxeFile = dir;
			
			//pxeDirSelectedByUser = dir;
		}
	}

	function changeFileLocation()
	{
		// if user want to create ISO file, will open save file dialog
		if (createISOFile == true)
		{
			saveFileDirectory("fileName", saveFileButtonChange);
		}
		// if user want to create PXE file, will open folder dialog
		else 
		{
			setWorkingDirectroy("fileName", false, openFolderButtonChange);
		}
	}

	function pxeIPchange() {
		top.pxeTFTPAddress = document.getElementById("pxeTFTPAddress");
	}

	function copyRamDisk() {
		top.copy_ram_disk = $("#copyRamDisk").prop("checked");
	}

	return{
		name: "CreateMedia",
        init: createMedia_init,
        updateMediaProperty: updateMediaProperty,
        selectDevice: selectDevice,
        selectUSBKey: selectUSBKey,
        checkSelection: checkSelection,
        changeFileLocation: changeFileLocation,
        saveFileButtonChange: saveFileButtonChange,
        openFolderButtonChange: openFolderButtonChange,
        pxeIPchange: pxeIPchange,
        changeIso: changeIso,
		copyRamDisk: copyRamDisk,
        nextAction: createDeviceAfterValidation,
        title: "Media Format",
        content: loadContent("menu_CreateMedia.html"),
	}
}();
