// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
const ProgressSteps = {
	step_acquire_payload: 1,
	step_acquire_tools: 2,
	step_create_media: 3,
};

var tool_ac_result = {
	code: 0,
	msg: ""
}

var updates_ac_result = {
	code: 0,
	msg: ""
}


const LENOVO_REQUISITE_PACKAGE = "Lenovo Requisite Package";
var Progress = function () {
	/*
	 * in this file, use a combination of mt & os as talbe/div's 'index' or 'contentIndex'
	 */
	var running_step = ProgressSteps.step_create_media;
	var ac_content_index = 0;
	var ac_isNew_content = true;
	var ac_current_content_count = 0;
	var ac_content_count = 0;
	var ac_pkg_count = 0;
	var ac_tool_count = 0;
	var ac_canceled = false;
	var ac_additional_index_array = new Array();
	//record each content's height for sliding
	var ac_beginCount = 0;

	var strDate;
	var last_usbKeyVolume = "";
	var answer = "";

	var errCode = 0;
	var userSelected = false;
	var overallSteps = 0; // overall steps for media creation

	//record the error occured in one package
	var wrong = 0;
	var isContinue = false;

	var ibmMtArr = new Array();
	var lenovoMtArr = new Array();

	//buffer the html element frequently refered
	header = ["Component", "Update ID", "Size (KB)", "Status"];

	// if any system has been selected
	// var sysSelected = false;

	var in_process_index = "";
	var in_process_rows_index = [];

	Array.prototype.indexOf = function (e) {
		for (var i = 0; i < this.length; i++) {
			if (this[i] == e)
				return i;
		}
		return -1;
	};

	Array.prototype.add = function (val) {
		var index = this.indexOf(val);
		if (index == -1) {
			this.push(val);
		}
	};

	Array.prototype.remove = function (val) {
		var index = this.indexOf(val);
		if (index > -1) {
			this.splice(index, 1);
		}
	};

	function gui_log(text) {
		top.writeTextFile(top.guilogInfo, "\n\t" + text + "\n\t", true);
	}

	// Bug 122980 - Some machines packages can not download when use the latest BoMC download all machines packages
	function mtArrSort() {
		ibmMtArr = [];
		lenovoMtArr = [];
		for (var i = 0; i < top.mtArray.length; i++) {
			lenovoMtArr.push(top.mtArray[i]);
		}
		top.mtArray = ibmMtArr;
		top.mtArray = top.mtArray.concat(lenovoMtArr);
	}

	function checkOverwrite() {
		if (top.isForce == true) {
			top.configTag["IBM_SYSTEM_FORCE_OVERWRITE"] == "";
		}

		if (createISOFile == true) {
			if (engineTop.secureFileExists(top.isoFile)) {
				// ISO file already exists in working directory
				if (confirm("Are you sure you want to overwrite " + top.isoFile + "?")) {
					top.isForce = true;
					return true;
				}
				else {
					alert("Please go back to \"Media Format\" and assign another name for the ISO file");
					return false;
				}
			}
			else {
				return true;
			}
		}
		else if (createPXEFile == true) {
			var pxeKeyFile = "";
			if (top.OSTYPE == "windows") {
				if (top.pxeFile.lastIndexOf("\\") == top.pxeFile.length - 1) {
					pxeKeyFile = top.pxeFile + "pxelinux.0";
				}
				else {
					pxeKeyFile = top.pxeFile + "\\pxelinux.0";
				}
			}
			else {
				if (top.pxeFile.lastIndexOf("/") == top.pxeFile.length - 1) {
					pxeKeyFile = top.pxeFile + "pxelinux.0";
				}
				else {
					pxeKeyFile = top.pxeFile + "/pxelinux.0";
				}
			}

			var pxeExisted = engineTop.secureFileExists(pxeKeyFile);
			if (pxeExisted) {
				if (confirm("Are you sure you want to overwrite " + top.pxeFile + "?")) {
					top.isForce = true;
					return true;
				}
				else {
					alert("Please go back to \"Media Format\" and assign another direcotry for pxe creation");
					return false;
				}
			}
			else {
				return true;
			}
		}
		else {
			//create usb or burn to device
			return true;
		}
	}

	function progressInit() {
		if (!top.isForce) {
			if (!checkOverwrite()) {
				top.togglePrevious(true);
				return;
			}
		}


		if (top.use_Intel_RSTe_RAID_Configuration) {
			top.writeConFiles(
				top.workingdirProgram
				+ (top.workingdirProgram.lastIndexOf(FILE_SEPARATOR) == top.workingdirProgram.length - 1 ? "" : FILE_SEPARATOR)
				+ "configfiles");
		}

		in_process_index = "";
		in_process_rows_index.splice(0, in_process_rows_index.length);

		mtArrSort();

		$("#details").empty().hide();
		$("#acqMsg").hide();
		$("#cplMsg").hide();
		$("#noMsg").hide();
		$("#cancelMsg").hide();
		$("#beginBtn").hide();
		$("#multiflash").hide();
		$("#retryBtn").hide();
		header = ["Component", "Update ID", "Size (KB)", "Status"];
		top.toggleNext(false);

		if (top.acquireMode) {
			ac_init();
		}
		else {
			top.isBomcRunning(killBomcConfirm);
		}
	}

	function killBomcConfirm(success) {
		if (success) {
			var confirmKill = top.confirm("Another running bomc is detected. If you want to continue this program, the running one need to be killed. Are you sure to kill it and continue now? ");
			console.log("check confirmKill result is ", confirmKill);
			if (confirmKill) {
				top.killAsync(top.mainAppName, killBomcCB);
			} else {
				$("#beginBtn").show();
				return false;
			}
		} else {
			ac_init();
		}
	}

	function killBomcCB(success) {
		if (success) {
			ac_init();
		} else {
			$("#beginBtn").show();
			return false;
		}
	}

	function ac_init() {
		ac_reload();
		begin(document.getElementById("beginBtn"));
	}

	//refresh Aquire_Updates.html
	function ac_reload() {
		// window.location.reload();
		$("#details").empty().hide();
		$("#acqMsg").hide();
		$("#acqMsg1").html("Progressing. . .");
		$("#acqMsg2").html("...").hide();
		$("#beginBtn").show();
		$("#retryBtn").hide();
		$("#progressbarBundle2").hide();
		$("#noMsg").hide();
		running_step = ProgressSteps.step_create_media;
		ac_content_index = 0;
		ac_isNew_content = true;
		ac_current_content_count = 0;
		ac_content_count = 0;
		ac_pkg_count = 0;
		ac_tool_count = 0;
		ac_additional_index_array = new Array();
		strDate;
		ac_beginCount = 0;

		errCode = 0;
		userSelected = false;
		overallSteps = 0;

		wrong = 0;
		isContinue = false;

		document = document;
		header = ["Component", "Update ID", "Size (KB)", "Status"];

		if (!top.acquireMode || top.usbReFlash) {
			setProgressMainAppStopped();
		}

		// sysSelected = false;

		top.toggleNext(false);
	}

	function initToolArr() {
		ac_additional_index_array = new Array();
		var tempArr = new Array();

		if (top.selectedOSMachineType.indexOf("x") != -1 || top.selectedOSMachineType.indexOf("purley") != -1) {
			if (tempArr.indexOf("UPDATE") == -1) {
				tempArr.push("UPDATE");
			}
		}
		if (top.selectedOSMachineType.indexOf("ibm") != -1) {
			if (tempArr.indexOf("UXSPI") == -1) {
				tempArr.push("UXSPI");
			}
		}

		for (var i = 0; i < top.selectedOSMachineType.length; i++) {
			if (top.program == "UPDATE") {
				if (top.selectedOSMachineType[i] == "x") {
					if (tempArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") == -1) {
						tempArr.push("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)");
					}
				}
				if (top.selectedOSMachineType[i] == "ibm") {
					if (tempArr.indexOf("Maintenance Mode OS(for IBM system X)") == -1) {
						tempArr.push("Maintenance Mode OS(for IBM system X)");
					}
				}
				if (top.selectedOSMachineType[i] == "purley") {
					if (tempArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") == -1) {
						tempArr.push("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)");
					}
				}
			} else if (top.program == "FULL") {
				if (top.selectedOSMachineType[i] == "x") {
					if (tempArr.indexOf("DSA") == -1) {
						tempArr.push("DSA");
					}
					if (tempArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") == -1) {
						tempArr.push("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)");
					}
				}
				if (top.selectedOSMachineType[i] == "ibm") {
					if (tempArr.indexOf("Maintenance Mode OS(for IBM system X)") == -1) {
						tempArr.push("Maintenance Mode OS(for IBM system X)");
					}
					if (tempArr.indexOf("ASU") == -1) {
						tempArr.push("ASU");
					}
					if (tempArr.indexOf("DSA") == -1) {
						tempArr.push("DSA");
					}
				}
				if (top.selectedOSMachineType[i] == "purley") {
					if (tempArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") == -1) {
						tempArr.push("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)");
					}
				}
			}
		}

		var sortArr = new Array();
		if (tempArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") != -1) {
			if (sortArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") == -1) {
				sortArr.push("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)");
			}
		}
		if (tempArr.indexOf("Maintenance Mode OS(for IBM system X)") != -1) {
			if (sortArr.indexOf("Maintenance Mode OS(for IBM system X)") == -1) {
				sortArr.push("Maintenance Mode OS(for IBM system X)");
			}
		}
		if (tempArr.indexOf("ASU") != -1) {
			if (sortArr.indexOf("ASU") == -1) {
				sortArr.push("ASU");
			}
		}
		if (tempArr.indexOf("UPDATE") != -1) {
			if (sortArr.indexOf("UPDATE") == -1) {
				sortArr.push("UPDATE");
			}
		}
		if (tempArr.indexOf("UXSPI") != -1) {
			if (sortArr.indexOf("UXSPI") == -1) {
				sortArr.push("UXSPI");
			}
		}
		if (tempArr.indexOf("DSA") != -1) {
			if (sortArr.indexOf("DSA") == -1) {
				sortArr.push("DSA");
			}
		}
		ac_additional_index_array = sortArr;
	}

	function store_bomc_command(args) {
		top.bomcCommandArray.length = 0;
		top.bomcCommandArray = args.slice();
		let argsShouldHideForCli = ['--xml'];
		if (top.acquireMode) {
			argsShouldHideForCli.push('--no-acquire');
		}
		for (let i = 0; i < argsShouldHideForCli.length; i++) {
			let iPos = top.bomcCommandArray.indexOf(argsShouldHideForCli[i]);
			if (iPos !== -1) {
				top.bomcCommandArray.splice(iPos, 1);
			}
		}

		var patt1 = new RegExp("--password=");
		var patt2 = new RegExp("--proxy-password=");
		var patt3 = new RegExp("bomc.exe|bomc.bin");

		// hidden passowrd.
		// hidden absolute path of BoMC
		for (var i = 0; i < args.length; i++) {
			if (patt1.test(args[i])) {
				top.bomcCommandArray[i] = "--password=***";
			} else if (patt2.test(args[i])) {
				top.bomcCommandArray[i] = "--proxy-password=***";
			} else if (patt3.test(args[i])) {
				top.bomcCommandArray[i] = "<LXCE BoMC>";
			}
		}
		// remove proxy script
		top.bomcCommandArray.shift()
	}

	function setProgressMainAppStopped() {
		console.log("setProgressMainAppStopped");
		progressMainAppIsRunning = false;
	}

	function deleteProcessInteractionFiles() {
		deleteFile(top.gl_ac_result);
		deleteFile(top.cliErrorMsg);
	}

	function begin(ref) {
		document.getElementById("cancelMsg").style.display = "none";
		document.getElementById("contentMeter1").setAttribute("value", 0);
		top.togglePrevious(false);
		document.getElementById("acqMsg").style.display = "block";
		document.getElementById("details").style.display = "block";
		ref.style.display = "none";
		ac_canceled = false;
		if (!top.acquireMode || top.usbReFlash) {
			deleteFile(top.guilogInfo);
		}
		//deleteProcessInteractionFiles();
		initToolArr();
		if (top.selectedOSMachineType.indexOf("storage") != -1) {
			if (top.acquireToolOnly && !top.usbReFlash) {
				createJbodContent();
				acquire_media_tools()
				setTimeout(showStatus_ac, 1000);
			} else {
				complete(1, '');
			}
		} else {
			if ((top.acquireMode || top.acquireToolOnly) && !top.usbReFlash) {
				if (top.acquireToolOnly || top.gl_selected_list.size == 0) {
					acquire_media_tools();
				}
				else {
					acquire_payloads()
				}
				createAllContents();
				setTimeout(showStatus_ac, 1000);
			} else {
				complete(1, "");
			}
		}
	}

	function ac_cancel() {
		//clearInterval(ac_progress_timer);
		killApp_bomc(top.mainAppName);
		setProgressMainAppStopped();
		ac_reload();
		ac_canceled = true;
		document.getElementById("cancelMsg").style.display = "block";
		document.getElementById("contentMeter1").setAttribute("value", 0);
		top.togglePrevious(true);
	}

	function confirmContinue(warningMsg) {
		if (isContinue == false) {
			var msg = warningMsg + "\nAre you sure you want to continue?";
			answer = "STOP";
			if (confirm(msg)) {
				isContinue = true;
				answer = "CONTINUE";
			}
			top.writeTextFile(top.CONFIRM_CONTINUE_FILE, answer, false);
		}
		gui_log("confirm continue");
		return isContinue;
	}

	function showStatus_ac() {
		strDate = Date();
		gui_log(strDate + " showStatus_ac in");
		console.log("running step:" + running_step);
		if (ac_canceled == true) {
			return;
		}
		if (running_step != ProgressSteps.step_acquire_payload && running_step != ProgressSteps.step_acquire_tools) {
			complete(0);
			return;
		}
		else {
			if (running_step == ProgressSteps.step_acquire_payload) {
				errCode = updates_ac_result.code;
				errMsg = updates_ac_result.msg;
				ac_content_count = ac_pkg_count;
			}
			else {
				errCode = tool_ac_result.code;
				errMsg = tool_ac_result.msg;
				ac_content_count = ac_tool_count;
			}
		}

		if (errCode >= 100) {
			complete(0, errMsg);
			return;
		}

		if (!top.fileExists(top.gl_ac_result) && progressMainAppIsRunning) {
			document.getElementById("acqMsg1").innerHTML = "Connecting...";
			document.getElementById("acqMsg1").setAttribute("aria-label", "Connecting...");
			document.getElementById("contentMeter1").setAttribute("value", 0);
			document.getElementById("contentMeter1").setAttribute("max", 100);
			setTimeout(showStatus_ac, 1000);
			return;
		}

		if (!top.fileExists(top.gl_ac_result) && !progressMainAppIsRunning) {
			if (errCode >= 100 && errCode < 256) {
				//cli return error
				//clearInterval(ac_progress_timer);
				complete(0, errMsg);
				return;
			} else {
				errCode = 0;
				errMsg = "bomc process error";
				complete(errCode, errMsg);
				return;
			}
		}

		var doc = top.readTextFile(top.gl_ac_result);

		var dom = ezJsLib.XmlDom.parse(doc);
		//doc is not null but dom is null
		if (dom == null) {
			setTimeout(showStatus_ac, 1000);
			return;
		}
		var content = ezJsLib.XmlDom.getNodeByTagAndIndex("CONTENT", dom, ac_content_index);
		if (content == null) {
			//refresh the progress bar
			_updateProgress(content);
			if (!progressMainAppIsRunning) {
				//clearInterval(ac_progress_timer); 
				//stop the timer
				complete(0, errMsg);
				return;
			}
			setTimeout(showStatus_ac, 1000);
			return;
		}

		var mt = ezJsLib.XmlDom.getValueByTagFromNode("MT", content);
		// defect-159191: [bomc01c]If the second MT download failure, bomc would not pop out warning message then the GUI will hang at downloading
		var needErrorConfirm = false;
		if (mt.toLowerCase() != "tool") {
			needErrorConfirm = true;
		}
		var os = ezJsLib.XmlDom.getValueByTagFromNode("OS", content);
		var total = parseInt(ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content));
		var index = "";
		if (os == "platform") {
			index = mt.toLowerCase();
		} else {
			index = (mt + unifyOS(os)).toLowerCase();
		}
		in_process_index = index;
		//update content coming...

		if (mt == "all" || (mt == "undefined" && os == "NONE")) { //get fixIds list or invalid mt and os
			setTimeout(showStatus_ac, 1000);
			return;
		}

		document.getElementById("acqMsg1").style.display = "block";
		document.getElementById("acqMsg2").style.display = "block";
		document.getElementById("progressbarBundle1").style.display = "inline";
		document.getElementById("progressbarBundle2").style.display = "inline";
		document.getElementById('cancelBtn').style.marginLeft = (top.BROWSER == "IExplore") ? "44" : "36" + "px";


		if (ac_isNew_content) {
			wrong = 0;
			updateTotal(index, total);
			ac_beginCount = 0;
			ac_current_content_count = total;

			if (total > 0) {
				showPlusIcon(index);
				updateTitle(index, "Acquiring");
				var table = null;
				if (ac_beginCount == 0) {
					table = createTable(index, true);
				} else {
					table = document.getElementById("table" + index);
				}

				for (var i = 0; i < total; i++) {
					//default consider that its a full xml file, including all nodes
					var component = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("COMPONENT", content, i);
					var updateId = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("UPDATEID", content, i);
					var description = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("DESCRIPTION", content, i);
					var size = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("SIZE", content, i);
					var statusValue = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("STATUS", content, i);

					//add a new row
					var newRow = table.insertRow(-1);

					var newCell1 = newRow.insertCell(-1);
					//The following codes are used to test the match between the content and the title
					//var machineType = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("MT", content, 0);
					//var os = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("OS", content, 0);
					//newCell1.innerHTML = component + machineType + os;
					if (component == "Undefined" || component == "null")
						component = "UXSP";
					newCell1.innerHTML = component;
					newCell1.title = component;
					newCell1.className = "EntityTableCell";

					var newCell4 = newRow.insertCell(-1);
					newCell4.innerHTML = updateId;
					newCell4.title = description.replace(/ \(InstallXML\)/g, "");
					newCell4.className = "EntityTableCell";

					var newCell6 = newRow.insertCell(-1);
					newCell6.innerHTML = formatNumberWithComma(size);
					newCell6.title = formatNumberWithComma(size);
					newCell6.className = "EntityTableCell";
					newCell6.align = "right";

					var newCell7 = newRow.insertCell(-1);
					newCell7.title = "Not Started";
					newCell7.innerHTML = "<img src='images/statusStopped_obj16.gif' alt='Not Started'>" + "Not Started";
					newCell7.className = "EntityTableCell";
					ac_isNew_content = false;
				}
			} else {
				updateTitle(index, "None");
				ac_isNew_content = true;
				//start parsing new content
				ac_content_index++;
			}
		} else {
			var package_finished_count = ac_beginCount;
			//record the number of wrong status of the contents
			table = document.getElementById("table" + index);
			for (var i = 0; i < total; i++) {
				var statusValue = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("STATUS", content, i);
				if (statusValue.toLowerCase().indexOf('already download') != -1) {
					table.rows[1 + ac_beginCount + i].cells[3].title = statusValue;
					table.rows[1 + ac_beginCount + i].cells[3].innerHTML = "<img src='images/statusNormal_obj16.gif' alt='Already Downloaded'>" + statusValue;
					package_finished_count++;
					in_process_rows_index.remove(1 + ac_beginCount + i);
				} else if (statusValue.toLowerCase().indexOf('acquiring') != -1) {
					// calculate completing percent for current package
					var downloadedSize = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("DOWNLOADSIZE", content, i);
					var totalSize = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("SIZE", content, i);
					var completePercent;
					if (totalSize == 0) {
						completePercent = 100;
					} else {
						completePercent = (parseFloat(downloadedSize) / parseFloat(totalSize) * 100).toFixed(0);
					}
					if (completePercent > 100) {
						completePercent = 100;
					} else if (completePercent < 0) {
						completePercent = 0;
					}
					table.rows[1 + ac_beginCount + i].cells[3].title = statusValue + "(" + completePercent + "%)";
					table.rows[1 + ac_beginCount + i].cells[3].innerHTML = "<img src='images/progress_anim2_small.gif' alt='Acquiring'>" + statusValue + "(" + completePercent + "%)";
					in_process_rows_index.add(1 + ac_beginCount + i);
					/*
					* If the cli exits abnormally when downloading, the status of the UXSP will be always "acquiring",
					* and the status on the xml won't be changed.
					* In this case, what we need to do is to just traverse the xml file.
					*/
					if (!progressMainAppIsRunning) {
						wrong++;
						table.rows[1 + ac_beginCount + i].cells[3].title = statusValue;
						table.rows[1 + ac_beginCount + i].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif' alt='Critical Error'>" + statusValue;
						package_finished_count++;
						in_process_rows_index.remove(1 + ac_beginCount + i);
					}
				} else if (statusValue.toLowerCase().indexOf('done') != -1) {
					table.rows[1 + ac_beginCount + i].cells[3].title = statusValue;
					table.rows[1 + ac_beginCount + i].cells[3].innerHTML = "<img src='images/statusSuccess_obj16.gif' alt='Success'>" + statusValue;
					package_finished_count++;
					in_process_rows_index.remove(1 + ac_beginCount + i);
				} else if (statusValue.toLowerCase().indexOf('error') != -1) {
					wrong++;
					table.rows[1 + ac_beginCount + i].cells[3].title = statusValue;
					table.rows[1 + ac_beginCount + i].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif' alt='Critical Error'>" + statusValue;
					package_finished_count++;
					in_process_rows_index.remove(1 + ac_beginCount + i);
					//if updates contents is partly download, should pop up confirm dialog box
					if (needErrorConfirm && wrong > 0) {
						if (confirmContinue("some update files are missed  ")) {
						} else {
							ac_cancel();
						}
					}
				} else {
					if (!progressMainAppIsRunning) {
						package_finished_count++;
					}
				}
			}

			console.log("PACKAGE_FINISHED_COUNT=" + package_finished_count);
			//finished downloading one package
			if (package_finished_count == ac_current_content_count) {
				if (wrong == ac_current_content_count) {
					updateTitle(index, "Error");
					if (top.program.indexOf("UPDATE") != -1 && ac_content_index == 1) {
						complete(0, errMsg);
					}
				}
				else if (wrong == 0) {
					updateTitle(index, "Done");
					in_process_index = "";
				}
				else {
					updateTitle(index, "Warning");
					in_process_index = "";
				}
				ac_isNew_content = true;
				//start parsing new content
				ac_content_index++;
			}
		}
		_updateProgress(content);

		//all statuses in ac_result.xml are "Done" or "Already Downloaded
		if (ac_content_index == ac_content_count) {
			//It's a little hard to handle all kinds of errors here.
			if ((errCode >= 100 && errCode < 256)) {
				complete(0, errMsg);
				return;
			} else {
				complete(1, "");
				return;
			}
		}
		setTimeout(showStatus_ac, 1000);
	}

	function _updateProgress(content) {
		if (content == null) {
			//if content is null, restore the package downloading progress bar to zero
			document.getElementById("contentMeter1").setAttribute("value", 0);
			document.getElementById("contentMeter1").setAttribute("max", 100);
			document.getElementById("acqMsg1").innerHTML = "Acquiring now, please wait...";
			document.getElementById("cancelBtn").style.marginLeft = "36px";
			return;
		}

		var packages = content.getElementsByTagName("PACKAGE");
		var machineType = ezJsLib.XmlDom.getValueByTagFromNode("MT", content);
		var total = ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content);
		var currentUpdateId = ezJsLib.XmlDom.getValueByTagFromNode("CURRENTUPDATEID", content);
		var currentUpdateIdIndex = -1;
		for (var i = 0; i < total; i++) {
			var updateId = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("UPDATEID", content, i);
			if (updateId == currentUpdateId)
				currentUpdateIdIndex = i;
		}
		if (currentUpdateIdIndex == -1)
			return;

		document.getElementById("cancelBtn").style.marginLeft = "36px";
		document.getElementById("acqMsg2").style.marginLeft = "36px";
		document.getElementById("contentMeter2").style.marginLeft = "36px";

		if (packages.length == 0) {
			document.getElementById("acqMsg1").innerHTML = "Acquiring now, please wait...";
			document.getElementById("acqMsg2").innerHTML = "Acquiring " + ac_content_index + " of " + ac_content_count + " package bundle(s)";

			document.getElementById("contentMeter2").setAttribute("max", ac_content_count);
			document.getElementById("contentMeter2").setAttribute("value", ac_content_index + 1);
			if (machineType == "Tool" || machineType == "VMWARE ESXi Updates" || machineType == "Requisite Package") {
				document.getElementById("acqMsg2").innerHTML = "Acquiring " + (ac_content_index + 1) + " of " + ac_content_count + " package bundle(s)";
				document.getElementById("acqMsg2").style.marginLeft = "36px";
				document.getElementById("contentMeter2").style.marginLeft = "36px";
				document.getElementById("contentMeter2").setAttribute("max", ac_content_count);
				document.getElementById("contentMeter2").setAttribute("value", ac_content_index + 1);
			} else {
				if (confirmContinue("No applicable updates available") == false) {
					ac_cancel();
				} else {
					document.getElementById("acqMsg2").innerHTML = "Acquiring " + (ac_content_index + 1) + " of " + ac_content_count + " package bundle(s)";
					document.getElementById("acqMsg2").style.marginLeft = "36px";
					document.getElementById("contentMeter2").style.marginLeft = "36px";
					document.getElementById("contentMeter2").setAttribute("max", ac_content_count);
					document.getElementById("contentMeter2").setAttribute("value", ac_content_index + 1);
				}
			}
			return;
		}

		var downloaded = packages[currentUpdateIdIndex].getElementsByTagName("DOWNLOADSIZE")[0].childNodes[0].nodeValue;//kb
		var downloadedValue = parseFloat(downloaded);
		var strDownloaded = formatNumberWithComma(downloaded);

		var size = packages[currentUpdateIdIndex].getElementsByTagName("SIZE")[0].childNodes[0].nodeValue;
		var strSize = formatNumberWithComma(size);
		var sizeValue = parseFloat(size);

		var speed = packages[currentUpdateIdIndex].getElementsByTagName("DOWNLOADSPEED")[0].childNodes[0].nodeValue;		//KB/Sec
		if (parseFloat(speed) > downloadedValue) {
			speed = downloadedValue;
		}
		var strSpeed = formatNumberWithComma(speed);

		var acquire_msg_prefix;
		var acquire_msg_postfix;;
		if (running_step == ProgressSteps.step_acquire_payload) {
			acquire_msg_prefix = "Acquiring updates";
			acquire_msg_postfix = " package bundle(s)";
		}
		else {
			acquire_msg_prefix = "Acquiring media tools";
			acquire_msg_postfix = " media tool(s)";
		}
		//progress of contents...
		if (ac_content_index < ac_content_count) {
			document.getElementById("acqMsg2").innerHTML = acquire_msg_prefix + " " + (ac_content_index + 1) + " of " + ac_content_count + acquire_msg_postfix;
			document.getElementById("contentMeter2").setAttribute("max", ac_content_count);
			document.getElementById("contentMeter2").setAttribute("value", ac_content_index + 1);
		}
		//progress of packages
		if (packages.length != 0) {
			var data;
			if (sizeValue == 0) {
				data = 100;
			} else {
				data = (1 - downloadedValue / sizeValue) * 100;
			}
			if (data < 0) {
				data = 0;
			} else if (data > 100) {
				data = 100;
			}
			document.getElementById("contentMeter1").setAttribute("value", (downloadedValue / sizeValue) * 100);
			document.getElementById("contentMeter1").setAttribute("max", 100);
			var text = acquire_msg_prefix + ": " + currentUpdateId
				+ "<br/>" + strDownloaded + " of " + strSize + "KB" + " (" + strSpeed + "KB/Sec)";
			document.getElementById("acqMsg1").innerHTML = text;
			document.getElementById("acqMsg1").setAttribute("aria-label", text);
		} else {
			document.getElementById("contentMeter1").setAttribute("value", 0);
			document.getElementById("contentMeter1").setAttribute("max", 100);
			var text = "Acquiring updates (0 of 0) - 100% complete.";
			document.getElementById("acqMsg1").innerHTML = text;
			document.getElementById("acqMsg1").setAttribute("aria-label", text);
		}
	}

	function formatData(input) {
		var per = input.toString();
		if (parseFloat(input) < 0) {
			per = 0;
		} else if (per.indexOf(".") > 0) {
			per = per.substring(0, per.indexOf(".") + 3);
		}
		return per;
	}

	function waitingForMainAppExit(callback) {
		if (progressMainAppIsRunning) {
			console.log("Previous bomc process is running, waiting for it.");
			setTimeout(() => {
				console.log("try to check main app exit again");
				waitingForMainAppExit(callback)
			}, 1000);
			return;
		}
		if (callback) {
			callback();
		}
	}

	//if downloads finished, execute this
	function complete(c, msg) {
		console.log("complete: " + c);
		if (ac_canceled) {
			return;
		}
		switch (c) {
			case 0:			//error when acquiring
				document.getElementById("acqMsg").style.display = "none";
				document.getElementById("noMsg").style.display = "block";
				document.getElementById("noMsg2").innerHTML = "Error(s) occurs while downloading! <br>Error message: " + msg;
				if (in_process_index != "") {
					updateTitle(in_process_index, "Error");
					var table = document.getElementById("table" + in_process_index);
					for (var j = 0, len = in_process_rows_index.length; j < len; ++j) {
						table.rows[in_process_rows_index[j]].cells[3].title = "Error";
						table.rows[in_process_rows_index[j]].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif' alt='Critical Error'>Error";
					}
				}
				top.togglePrevious(true);
				$("#retryBtn").show();
				break;
			case 2:		   //error when creating bootable media
				document.getElementById("createMsg").style.display = "none";
				document.getElementById("noMsg").style.display = "block";
				document.getElementById("noMsg2").innerHTML = "Error(s) occurs while creating the bootable media! <br>Error message: " + msg;
				//stop the cli process if it's still running
				if (progressMainAppIsRunning) {
					killApp_bomc(top.mainAppName);
				}
				$("#retryBtn").show();
				top.togglePrevious(true);
				break;
			case 1:
				//finish acquisition
				document.getElementById("createValue").setAttribute("value", 0);
				document.getElementById("createValue").setAttribute("max", 100);
				//ac_progress_timer2 = setInterval(showStatus_cr,1000);
				if (wrong > 0) {
					if (confirmContinue("Some update files are missed  ")) {
						gui_log("some update files are missed, and user still choose to continue.");
					} else {
						$("#retryBtn").show();
						return;
					}
				}
				if (running_step == ProgressSteps.step_acquire_payload) {
					document.getElementById("acqMsg").style.display = "Acquiring media tools...";
					waitingForMainAppExit(() => {
						acquire_media_tools();
						setTimeout(showStatus_ac, 1000);
					});
				}
				else {
					//finish acquisition
					document.getElementById("acqMsg").style.display = "none";
					document.getElementById("createMsg").style.display = "block";
					waitingForMainAppExit(() => {
						create_media();
						setTimeout(showStatus_cr, 1000);
					});
				}
				break;
			case 9:
				//finish creation
				document.getElementById("createMsg").style.display = "none";
				document.getElementById("cplMsg").style.display = "block";
				//reporting the success message
				if (top.usbKeyVolume != "") {
					msg += "Please eject disk " + top.usbKeyVolume;
				}
				if (top.isoFile != "") {
					msg += "The image file path is:" + top.isoFile;
				}
				if (top.pxeFile != "") {
					msg += "The image file path is:" + top.pxeFile;
				}
				//document.getElementById("cplMsg2").innerHTML = ("The bootable media has been created successfully!<br>" + msg);

				var length = 60;
				var obj = document.getElementById("cplMsg2");
				var strContent = msg;
				var strTemp = "";

				while (strContent.length > length) {
					strTemp += strContent.substr(0, length) + "<br />";
					strContent = strContent.substr(length, strContent.length);
				}
				strTemp += strContent;

				document.getElementById("cplMsg2").innerHTML = ("The bootable media has been created successfully!<br>" + strTemp);
				top.toggleNext(true);		//enable "next" button
				top.togglePrevious(true);
				if (top.usbKeyVolume != "") {
					updateMediaProperty();
					last_usbKeyVolume = top.usbKeyVolume;
					document.getElementById("multiflashLable").innerHTML = "If you want to create another bootable media with the same content, you must first eject the current media from drive {" + last_usbKeyVolume + "}, insert another one then click the button <b>Create Again</b>. If the new media is assigned a different drive letter by Windows, you can choose another drive letter accordingly.";
					$("#multiflash").show();
				}
				// boot_need_acq = false;
				break;
		}
	}

	function getCLIErrorCode() {
		var cliErrorMsgFile;
		var errDom;
		if (!top.fileExists(top.cliErrorMsg)) {
			return;
		}

		cliErrorMsgFile = top.readTextFile(top.cliErrorMsg);

		if (cliErrorMsgFile) {
			errCode = 0;
			errDom = ezJsLib.XmlDom.parse(cliErrorMsgFile);
			errMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", errDom.documentElement);
			errCode = ezJsLib.XmlDom.getValueByTagFromNode("CODE", errDom.documentElement);
			stepSN = ezJsLib.XmlDom.getValueByTagFromNode("STEPSERIAL", errDom.documentElement);
		}
	}

	function showStatus_cr() {
		getCLIErrorCode();
		strDate = Date();
		gui_log(strDate + " showStatus_cr in");
		gui_log("error code is ", errCode);
		if (errCode >= 100 && errCode < 256) {
			//cli errors occurred
			//clearInterval(ac_progress_timer2);		//stop the timer
			complete(2, errMsg);
			return;
		} else if (errCode >= 10 && errCode < 100) {
			//cli generated warning message
			//currently we only handle the BOMCWARNING_FORMAT_USBKEY (value is 10) and BOMCWARNING_PROGRESS_INFO (value is 20) warning message
			if (errCode == 10) {
				if (userSelected == false) {
					if (confirm("USB key needs formatting. This will erase all existing data on the key.  Are you sure you want to continue?")) {
						//user select to format the usb key
						userSelected = true;
						tmpFile = top.gl_ibm_support + getOSCommand("tmpFile");
						if (!engineTop.secureFileExists(tmpFile)) {
							alert("Can't get temp file!");
						}
						var args = new Array();
						if (top.OSTYPE == "windows") {
							args.push(getStartingTopDir() + getNativeFileSeparator() + "..\\guiInput.bat");
						} else { //linux ...
							args.push(getStartingTopDir() + getNativeFileSeparator() + "../guiInput.sh");
						}
						args.push("yes");
						secureRunProgram(null, args, BACKGROUND, HIDDEN);
					} else {
						userSelected = true;
						var args = new Array();
						if (top.OSTYPE == "windows") {
							args.push(getStartingTopDir() + getNativeFileSeparator() + "..\\guiInput.bat");
						} else { //linux ...
							args.push(getStartingTopDir() + getNativeFileSeparator() + "../guiInput.sh");
						}
						args.push("no");
						secureRunProgram(null, args, BACKGROUND, HIDDEN);
						//clearInterval(ac_progress_timer2);		//stop the timer
						complete(2, "Failed to format the USB Key.");
						return;
					}
				} else {
					//ignore.
				}
			} else if (errCode == 20) {
				//update the creation progress info
				if (stepSN > overallSteps) {
					stepSN = overallSteps;
				}
				document.getElementById("createValue").setAttribute("value", (stepSN / overallSteps) * 100);
				document.getElementById("createValue").setAttribute("max", 100);
				document.getElementById("createMsg3").innerHTML = errMsg + " - " + formatData((stepSN / overallSteps) * 100) + "% complete...";
			}
		} else {

			getCLIErrorCode();
			if ((errCode == 0) && !progressMainAppIsRunning) {
				//cli finished successfully
				//clearInterval(ac_progress_timer2);		//stop the timer
				complete(9, "");
				return;
			}
		}
		setTimeout(showStatus_cr, 1000);
	}

	function open_no_uxsp_url() {
		var sWidth = 500;
		var sHeight = 200;
		var l = (screen.availWidth - sWidth) / 2;
		var t = (screen.availHeight - sHeight) / 2;
		var style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
		var loc = ',left=' + l + ',top=' + t + ',width=' + sWidth + ',height=' + sHeight;
		// window.open(findFile(null, 'noUpdates.html'),  '', style+loc);
		window.open("../bomc/content/no_uxsp_updates.html", '', style + loc);
	}

	function open_no_indiv_url() {
		var sWidth = 500;
		var sHeight = 200;
		var l = (screen.availWidth - sWidth) / 2;
		var t = (screen.availHeight - sHeight) / 2;
		var style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
		var loc = ',left=' + l + ',top=' + t + ',width=' + sWidth + ',height=' + sHeight;
		// window.open(findFile(null, 'noUpdates.html'),  '', style+loc);
		window.open("../bomc/content/no_indiv_updates.html", '', style + loc);
	}

	function openNoRequisiteURL() {
		var sWidth = 500;
		var sHeight = 200;
		var l = (screen.availWidth - sWidth) / 2;
		var t = (screen.availHeight - sHeight) / 2;
		var style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
		var loc = ',left=' + l + ',top=' + t + ',width=' + sWidth + ',height=' + sHeight;
		// window.open(findFile(null, 'noRequisite.html'),  '', style+loc);
		window.open("../bomc/content/noRequisite.html", '', style + loc);
	}

	function openNoSEPsURL() {
		var sWidth = 500;
		var sHeight = 200;
		var l = (screen.availWidth - sWidth) / 2;
		var t = (screen.availHeight - sHeight) / 2;
		var style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
		var loc = ',left=' + l + ',top=' + t + ',width=' + sWidth + ',height=' + sHeight;
		// window.open(findFile(null, 'noSEPpkgAvailable.html'),  '', style+loc);
		window.open("../bomc/content/noSEPpkgAvailable.html", '', style + loc);
	}

	function openDownloadErrorURL() {
		var sWidth = 500;
		var sHeight = 200;
		var l = (screen.availWidth - sWidth) / 2;
		var t = (screen.availHeight - sHeight) / 2;
		var style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
		var loc = ',left=' + l + ',top=' + t + ',width=' + sWidth + ',height=' + sHeight;
		// window.open(findFile(null, 'DownloadError.html'),  '', style+loc);
		window.open("../bomc/content/DownloadError.html", '', style + loc);
	}

	/**
	 * update 'total' parameter in content title
	 */
	/*Style: 'resizable,toolbar,status,menubar,personalbar,location,directories,titlebar,close,scrollbars'*/
	function updateTotal(index, total) {
		var spans = document.getElementById(TITLE_PRE + index).getElementsByTagName("span");

		if (total == 0) {
			if ((index.indexOf("vmware esxi updates") != -1)) {
				spans[0].innerHTML = "(No packages available)";
			} else if (index.indexOf("tool") != -1) {
				spans[0].innerHTML = "(No update packages required. <a href=\"javascript:void 0\" onclick=Progress.openNoSEPsURL()> Details...</a>)"
			} else if (index.indexOf("requisite package") != -1) {
				spans[0].innerHTML = "(No additional requisite required <a href=\"javascript:void 0\" onclick=Progress.openNoRequisiteURL()> Details...</a>)"
			} else {
				if (top.latest) {
					spans[0].innerHTML = "(No applicable Individual Updates for this system! <a href=\"javascript:void 0\" onclick=Progress.open_no_indiv_url()> Details...</a>)";
				} else {
					spans[0].innerHTML = "(No applicable UXSP for this system! <a href=\"javascript:void 0\" onclick=Progress.open_no_uxsp_url()> Details...</a>)";
				}
			}
		} else
			spans[0].innerHTML = total + " update(s)";
	}

	function createJbodContent() {
		var mt = "Tool";
		var os = "Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)";
		var index = (mt + os).toLowerCase();
		++ac_tool_count;
		createContent('', mt, os, index);
	}

	/**
	 * before any download begins, show all the waiting contents first.
	 */
	function createAllContents() {
		if (!top.acquireMode && top.acquireToolOnly) {
			// No add MT updates downloading or prereq downloading. Add by Wengmh1 2017/3/11
		} else {
			let needPrereqContent = false;
			top.gl_selected_list.forEach(function (value, key) {
				if (key.indexOf("lenovo") == -1) {
					var type = "Updates";
					createContent("", key, type, key);
					++ac_pkg_count;
					if (!needPrereqContent) {
						needPrereqContent = value.length > 0;
					}
				}
			})
			// Only for latest needs to append download prereqs.
			if (needPrereqContent && !top.noPrereq && top.latest) {
				var mt = LENOVO_REQUISITE_PACKAGE;
				var os = LENOVO_REQUISITE_PACKAGE;
				var type = "Updates";
				var index = (mt + unifyOS(os)).toLowerCase();
				createContent("", mt, type, index);
				++ac_pkg_count;
			}
		}

		for (var i = 0; i < ac_additional_index_array.length; i++) {
			var mt = "Tool";
			var os = ac_additional_index_array[i];
			var index = (mt + os).toLowerCase();
			createContent("", mt, os, index);
			++ac_tool_count;
		}
	}

	/*
	 * 1234.56 -> 1,234.56
	 */
	function formatNumberWithComma(input) {
		var str = "", value = input.toString();
		var dotPos = value.indexOf(".");
		var integer = dotPos > -1 ? value.substring(0, dotPos) : value;
		var dicemal = dotPos > -1 ? value.substring(dotPos) : "";
		var chars = top.trim(integer).split("");
		for (var i = chars.length - 1; i > -1; i--) {
			str = chars[i] + str;
			if ((chars.length - i) % 3 == 0 && i != 0) {
				str = "," + str;
			}
		}
		return str + dicemal;
	}

	/*
	 * extract from wizard.js-->previous, default case
	 */
	function commonPre() {
		var navOrder = top.getWizardNavOrder();
		var found = false;
		for (var i = 0; i < navOrder.length; i++) {
			if (navOrder[i] == top.navigationCurrent && i > 0) {
				found = true;
				top.navigateTo(navOrder[i - 1]);
				break;
			}
		}
		if (!found) {
			var allNavOrder = getNavOrder();
			var found = false;
			for (var i = 0; i < allNavOrder.length; i++) {
				if (allNavOrder[i] == top.navigationCurrent && i > 0) {
					top.navigateTo(allNavOrder[i - 1]);
					break;
				}
			}
		}
	}

	function progressPreviousAction() {
		if (!top.acquireMode) {
			top.toggleNext(true);
		}
	}

	function showUSBKey() {
		var mtStr = top.usbKey;
		if (mtStr) {
			var usbKeyVolume = document.getElementById("progress_usbKeyVolume");
			var ooption = new Array();
			var beginPos = 0;
			var lastPos = mtStr.indexOf(";");

			while (lastPos > 0) {
				ooption.push(mtStr.substr(0, lastPos));
				beginPos = lastPos + 1;
				mtStr = mtStr.slice(beginPos);
				lastPos = mtStr.indexOf(";");
			}

			usbKeyVolume.options.length = 0;
			var i;
			for (i = 0; i < ooption.length; ++i) {
				usbKeyVolume.options[i] = new Option(ooption[i], ooption[i]);
			}
			if (i > 0) {
				// default selected item
				usbKeyVolume.selectedIndex = --i;
			}
		}
	}

	function setWriteName() {
		var sel = document.getElementById("progress_usbKeyVolume");
		if (sel.options.length != 0) {
			top.usbKeyVolume = sel.options[sel.selectedIndex].value;
		}
	}

	function updateMediaProperty() {
		var args = new Array();
		args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
		args.push("--file");
		args.push(top.bomc_gui);
		if (!secureRunProgram(null, args, BACKGROUND, HIDDEN, null, updateCreateMedia)) {
			updateCreateMedia();
		}
	}

	function updateCreateMedia() {
		var propertiesInfo = new Array();
		if (!engineTop.secureFileExists(top.basicInfo)) {
			alert("Can't get basic info!");
			return false;
		}
		engineTop.secureRead1PropertyFile(top.basicInfo, propertiesInfo, false);
		top.usbKey = propertiesInfo["IBM_SYSTEM_USBDISK"];
		var usbKeyVolume = document.getElementById("progress_usbKeyVolume");

		if (top.usbKeyVolume != "") {
			showUSBKey();
			for (i = 0; i < usbKeyVolume.options.length; ++i) {
				if (usbKeyVolume.options[i].text == top.usbKeyVolume) {
					usbKeyVolume.selectedIndex = i;
					break;
				}
			}
			if (i == usbKeyVolume.options.length) {
				setWriteName();
			}
		}
	}

	function selectUSBKey(theOption) {
		if (theOption == "undefined") {
			alert('No device found');
			return;
		}
		var theValue = theOption.text;
		top.usbKeyVolume = theValue;
		setWriteName();
	}

	function reFlash() {
		var args = new Array();
		args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
		args.push("--file");
		args.push(top.bomc_gui);
		secureRunProgram(null, args, BACKGROUND, HIDDEN, null, checkCreateMedia);
	}

	function checkCreateMedia() {
		var propertiesInfo = new Array();
		if (!engineTop.secureFileExists(top.basicInfo)) {
			alert("Can't get basic info!");
			return false;
		}
		engineTop.secureRead1PropertyFile(top.basicInfo, propertiesInfo, false);
		top.usbKey = propertiesInfo["IBM_SYSTEM_USBDISK"];

		var findDisk = false;
		var mtStr = top.usbKey;
		if (mtStr) {
			var beginPos = 0;
			var lastPos = mtStr.indexOf(";");

			while (lastPos > 0) {
				if (top.usbKeyVolume == mtStr.substr(0, lastPos)) {
					findDisk = true;
					break;
				}
				beginPos = lastPos + 1;
				mtStr = mtStr.slice(beginPos);
				lastPos = mtStr.indexOf(";");
			}
		}
		if (findDisk) {
			if (last_usbKeyVolume == top.usbKeyVolume
				|| confirm("Are you sure to create the bootable media in another drive?")) {
				top.usbReFlash = true;
				progressInit();
				top.usbReFlash = false;
			}
		}
		else {
			alert("No media found in drive {" + top.usbKeyVolume + "}, insert a media to continue.");
		}
	}

	function retry() {
		gui_log("Press the Retry button...");
		top.writeTextFile(top.CONFIRM_CONTINUE_FILE, "RETRY", false);
		ac_init();
	}

	function append_common_args(args) {
		if (top.OSTYPE == "windows") {
			args.push(top.pathJoin(top.workingdir, "proxy.bat"));
		} else {
			args.push(top.pathJoin(top.workingdir, "proxy.sh"));
		}
		args.push(top.pathJoin(top.workingdir, top.mainAppName));

		top.program = top.program.replace("uxspi", "UPDATE");

		if (top.selectedOSMachineType.indexOf("storage") != -1) {
			args.push('--function=jbod');
		} else {
			args.push('--function=' + top.program.toLowerCase());
		}

		var mt = top.mtArray.join(",");
		if (mt != "" && mt != undefined && mt != null) {
			args.push("--machine-type=" + mt);
		}

		if (top.url_custom) {
			if (top.url_insecure) {
				args.push("--insecure");
			} else if (top.url_specify_cert) {
				if (top.urlCustomCaCertFile != "" && top.urlCustomCaCertFile != null) {
					args.push("--cacert");
					args.push(top.urlCustomCaCertFile);
				}
			}
		}

		if (top.useProxy) {
			if (top.proxyAdd != "" && top.proxyAdd != null && top.proxyAdd != undefined && top.proxyPort != "" && top.proxyPort != null && top.proxyPort != undefined) {
				if (top.proxyType == "https" ||
					top.proxyType == "socks4" ||
					top.proxyType == "socks4a" ||
					top.proxyType == "socks5" ||
					top.proxyType == "socks5h") {
					args.push("--proxy-address=" + top.proxyType + "://" + top.proxyAdd);
				} else {
					args.push("--proxy-address=" + top.proxyAdd);
				}
				args.push("--proxy-port=" + top.proxyPort);
			}
			if (top.useProxyAuth) {
				if (top.proxyUid != "" && top.proxyUid != null && top.proxyUid != undefined) {
					args.push("--proxy-user=" + top.proxyUid);
				}
				if (top.proxyPwd != "" && top.proxyPwd != null && top.proxyPwd != undefined) {
					args.push("--proxy-password=" + top.proxyPwd);
				}
			}

			if (top.proxy_insecure) {
				args.push("--proxy-insecure");
			} else {
				if (top.proxy_specify_cert) {
					if (top.proxyCaCertFile != "" && top.proxyCaCertFile != null) {
						args.push("--proxy-cacert");
						args.push(top.proxyCaCertFile);
					}
				}
			}
		}


		args.push("-l");
		args.push(top.workingdirProgram);

		if (top.latest) {
			args.push("--latest");
		}

		if (top.OSTYPE == "windows") {
			if (top.mediaLabel == "") {
				args.push("--description=" + "\"" + " " + "\"");
			} else {
				args.push("--description");
				args.push(top.mediaLabel);
			}
		} else {
			if (top.mediaLabel == "") {
				args.push("--description=" + " ");
			} else {
				args.push("--description=" + top.mediaLabel);
			}
		}
		if (top.noPrereq == true) {
			args.push("--noprereq");
		}
	}

	function acquire_payloads() {
		console.log("Start to acquire payloads");
		deleteProcessInteractionFiles();
		ac_content_index = 0;
		running_step = ProgressSteps.step_acquire_payload;
		var args = new Array();
		append_common_args(args)
		args.push("--acquire-type=package");
		args.push("--xml");
		args.push("--selected-file=" + top.gl_query_selection_result);

		progressMainAppIsRunning = true;
		top.runProgram(args, function () {
			getCLIErrorCode();
			updates_ac_result.code = errCode;
			updates_ac_result.msg = errMsg;
			//add prereqs to update selection if there is prereqs downloaded.
			let acResults = loadAcResults(top.gl_ac_result);
			for (let i = 0; i < acResults.length; ++i) {
				if (LENOVO_REQUISITE_PACKAGE !== acResults[i].MT) {
					continue
				}
				let prereqIDs = []
				for (let j = 0; j < acResults[i].PACKAGES.length; ++j) {
					prereqIDs.push(acResults[i].PACKAGES[j].UPDATEID)
				}
				if (prereqIDs.length > 0) {
					let updateSelection = JSON.parse(top.readTextFile(UpdateSelection.selectionFile));
					updateSelection.push({
						rules: {
							includeIDs: prereqIDs
						}
					})
					top.writeTextFile(UpdateSelection.selectionFile, JSON.stringify(updateSelection));
				}
			}
			setProgressMainAppStopped();
		});
	}

	function acquire_media_tools(callback = undefined) {
		console.log("Start to acquire media tools");
		deleteProcessInteractionFiles();
		ac_content_index = 0;
		running_step = ProgressSteps.step_acquire_tools;
		var args = new Array();
		append_common_args(args)
		args.push("--acquire-type=tools");
		args.push("--xml");

		progressMainAppIsRunning = true;
		top.runProgram(args, function () {
			getCLIErrorCode();
			tool_ac_result.code = errCode;
			tool_ac_result.msg = errMsg;
			setProgressMainAppStopped();
		});
	}

	function create_media() {
		console.log("Start to create media");
		deleteProcessInteractionFiles();
		running_step = ProgressSteps.step_create_media;
		var dir;
		var args = new Array();
		append_common_args(args);

		if (top.selectedOSMachineType.indexOf("storage") == -1) {
			if (!top.isRebootBmc) {
				args.push('--noreboot');
			}
			if (top.strUnattdCfgFullStr != "" && top.strUnattdCfgFullStr != "NULL" && top.strUnattdCfgFullStr != undefined) {
				args.push("--unattended=" + top.strUnattdCfgFullStr);
				if (top.after_updating_firmware == "Noaction") {
					args.push("--noshutdown");
				}
				else if (top.after_updating_firmware == "Reboot") {
					args.push("--rebootos");
				}
				if (top.strUnattdUseUserName) {
					if (top.OSTYPE == "windows") {
						args.push("--password=" + "\"\"" + top.strUnattdCfgPassword + "\"\"");
					} else {
						args.push("--password=" + "\"" + top.strUnattdCfgPassword + "\"");
					}
				}
			}
		}

		var mt = "";
		for (var i = 0; i < top.mtArray.length; ++i) {
			if (i == 0) {
				mt = top.mtArray[i];
			} else {
				mt = mt + "," + top.mtArray[i];
			}
		}

		if (top.selectedOSMachineType.indexOf("storage") == -1) {
			if (top.autorun != "NULL") {
				args.push("--autorun");
			}
		}

		if (top.mediaFormat == 1) {
			if (top.usbKeyVolume != "") {
				overallSteps = 6;
				args.push("--usbkey=" + top.usbKeyVolume);
			}
		} else if (top.mediaFormat == 2) {
			if (top.pxeFile != "") {
				overallSteps = 6;
				if (top.OSTYPE == "windows") {
					var lastChar = top.pxeFile.charAt(top.pxeFile.length - 1);
					if (lastChar == "\\") {
						top.pxeFile = top.pxeFile.substring(0, top.pxeFile.length - 1);
					}
					args.push("--pxe");
					args.push(top.pxeFile);
				} else {
					args.push("--pxe=" + top.pxeFile);
				}
				if (top.pxeTFTPAddress != "") {
					args.push("--tftp-pxe-address=" + top.pxeTFTPAddress);
				}
			}
		} else {
			if (top.isoFile != "") {
				overallSteps = 6;
				if (top.OSTYPE == "windows") {

					args.push("--iso");
					args.push(top.isoFile);
				} else {
					args.push("--iso=" + top.isoFile);
				}
			}
		}

		if (top.copy_ram_disk) {
			args.push("--copytoramdisk");
		}

		if (top.isForce) {
			args.push("--force");
		}
		args.push("--update-selection");
		args.push(UpdateSelection.selectionFile);
		args.push('--no-acquire');
		args.push("--xml");

		// Add for preview 
		setPreviewParams(args);
		store_bomc_command(args);
		progressMainAppIsRunning = true;
		runProgram(args, setProgressMainAppStopped);
	}

	return {
		name: "Progress",
		header: header,
		openNoRequisiteURL: openNoRequisiteURL,
		ac_cancel: ac_cancel,
		openNoSEPsURL: openNoSEPsURL,
		// openNoUpdatesURL: openNoUpdatesURL,
		open_no_uxsp_url: open_no_uxsp_url,
		open_no_indiv_url: open_no_indiv_url,
		begin: begin,
		init: progressInit,
		selectUSBKey: selectUSBKey,
		updateMediaProperty: updateMediaProperty,
		reFlash: reFlash,
		retry: retry,
		nextAction: function () { return true; },
		previousAction: progressPreviousAction,
		title: "Progress",
		content: loadContent("menu_Progress.html"),
	}
}();
