// preload with contextIsolation enabled
const { contextBridge, ipcRenderer } = require('electron')

contextBridge.exposeInMainWorld('bomc', {
    alertMsg: (msg) => ipcRenderer.sendSync('alertMsg', msg),
    showOpenDialog: (msg) => ipcRenderer.sendSync('showOpenDialog', msg),
    showOpenDialogFile: (_defaultPath, _filterType) => ipcRenderer.sendSync('showOpenDialogFile', _defaultPath, _filterType),
    showSaveDialogFile: (_defaultPath, _filterType) => ipcRenderer.sendSync('showSaveDialogFile', _defaultPath, _filterType),
    confirmMsg: (msg) => ipcRenderer.sendSync('confirmMsg', msg),
    quitMsg: (msg) => ipcRenderer.sendSync('quitMsg', msg),
    setMessageBoxTitle: (title) => ipcRenderer.send('setMessageBoxTitle', title),
    setExitConfirmFlag: (flag) => ipcRenderer.send('setExitConfirmFlag', flag),
    setExitConfirmMessage: (msg) => ipcRenderer.send('setExitConfirmMessage', msg),
    runProgram: (args, callback) => {
        const callbackName = "runProgram" + Date.now().toString();
        ipcRenderer.once(
            callbackName,
            (_, ...args) => {
                if(callback){
                    callback(...args)
                }
            }
        )
        console.log(args.join(" "));
        console.log(JSON.stringify(args));
        ipcRenderer.send('runProgram', args, callbackName)
    },
    secureRunProgram: (topDir, args, foreGroundValue, isHidden, workingDirectory, callback) => {
        console.log("Enter preload.js secureRunProgram");
        const callbackName = "secureRunProgram" + Date.now().toString();
        ipcRenderer.once(
            callbackName,
            (_, ...args) => {
                if(callback){
                    callback(...args)
                }
            }
        )
        console.log(args.join(" "));
        console.log(JSON.stringify(args));
        ipcRenderer.send('secureRunProgram', topDir, args, foreGroundValue, isHidden, workingDirectory, callbackName)
    },
    utils: (funcName, ...args) => { return ipcRenderer.sendSync(funcName, ...args) },
    reload: () => ipcRenderer.send('reload')
})
