#!/bin/sh
# Copyright © 2018 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
export DATA_DIR_NAME="ASC"
AS_DIR="${LOCAL_STORAGE_DIR}/$DATA_DIR_NAME"
AS_LOG_DIR="${BOMC_LOG_DIR}/$DATA_DIR_NAME"

export MD_LOG_DIR=$AS_LOG_DIR

function makesure()
{
	while [ true ]
	do
		read -p "$1" ans  
		if [ "x$ans" == "xy" ] || [ "x$ans" == "xY" ];then	
			return 0
		elif [ "x$ans" == "xn" ] || [ "x$ans" == "xN" ];then
			return 1
		else
			echo "Invalid input."
		fi
	done
}

function ShowSaveSystemSettings()
{
	time=`date +%Y%m%d%H%M%S`
	filepath="$AS_DIR/${CUR_MACHINE_TYPE}_${CUR_SN}_${time}_system_settings.txt"
	read -p "Enter the REST port (empty for no change): " rest_port
	${Run} "$SET_CMD" "blank" "$filepath" "$rest_port"
	if [ $? == 0 ];then	
		more $filepath
		#filepath1=`echo "$filepath"|sed 's/\/toolscenter/<USB>/'`
		#echo "System settings has been saved in $filepath1." 
		while [ true ]
		do
			read -p "* Do you want to save it? [Y/N]"  ans
			[ -z "$ans" ]&&continue
			if [ "x$ans" == "xY" ] || [ "x$ans" == "xy" ];then
				$EXSTORAGE "save" $filepath
				break
			elif [ "x$ans" == "xN" ] || [ "x$ans" == "xn" ];then
				break
			else
				echo "Invalid input."
			fi
		done
	fi
}


function ViewSavedSystemSettings()
{
	$EXSTORAGE "view" 
	[ $? != 0 ]&& return
	file=`cat $CHOOSE_FILE`
	more $file
}


function RestoreSystemSettingswithVPD()
{
	# chooseSystemSettings "doStoreWithVPD"
	$EXSTORAGE "restore" 
	[ $? != 0 ]&& return
	file=`cat $CHOOSE_FILE`
	read -p "Enter the REST port (empty for no change): " rest_port
	${Run} "$SET_CMD" "-" "$file" "$rest_port"
}	


function RestoreSystemSettingswithoutVPD()
{
	# chooseSystemSettings "doStoreWithoutVPD"
	$EXSTORAGE "restore" 
	[ $? != 0 ]&& return
	file=`cat $CHOOSE_FILE`
	read -p "Enter the REST port (empty for no change): " rest_port
	${Run} "$SET_CMD" "-" "$file" "$rest_port"
	
}

function ChangeAssetTagNumber()
{
	echo "Get current Asset Tag."
	read -p "Enter the REST port (empty for no change): " rest_port
#	${Run} "$GET_CMD" "cat $ONECLI_CONSOLE_FILE |grep -v 'Log('| grep '=' | grep -v ')='|grep -v 'Translated ASU Command'"
	${Run} "$GET_CMD" "cat $ONECLI_CONSOLE_FILE |grep '^SYSTEM_PROD_DATA.SysEncloseAssetTag'" "$rest_port"
	#${Run} "$ONECLI_BIN config show SYSTEM_PROD_DATA.SysEncloseAssetTag $ONECLI_ADD_OPTION --output $AS_LOG_DIR" 
	[ $? != 0 ] && return
#SysEncloseAssetTag
#SysEncloseAssetTag_Label
	echo ""
	read -p "* Enter the setting value for Asset Tag (empty for no change):" tag
	[ -z "${tag}" ] && return
	${Run} "$SET_CMD" "-" "$tag" "$rest_port"
	#${Run} "$ONECLI_BIN config set SYSTEM_PROD_DATA.SysEncloseAssetTag "
}
		
function ChangeUUIDNumber()
{
	echo "Get current UUID."
	read -p "Enter the REST port (empty for no change): " rest_port
	#${Run} "$GET_CMD" "cat $ONECLI_CONSOLE_FILE |grep -v 'Log('| grep '=' | grep -v ')='|grep -v 'Translated ASU Command'"
	${Run} "$GET_CMD" "cat $ONECLI_CONSOLE_FILE |grep '^SYSTEM_PROD_DATA.SysInfoUUID'" "$rest_port"
	#${Run} "$ONECLI_BIN config show SYSTEM_PROD_DATA.SysInfoUUID $ONECLI_ADD_OPTION --output $AS_LOG_DIR" "cat $ONECLI_CONSOLE_FILE | grep '=' | grep -v ')='|grep -v 'Translated ASU Command'"
	[ $? != 0 ] && return

	echo ""
	read -p "* Enter the setting value for UUID (empty for no change):" uuid
	[ -z "${uuid}" ] && return
	${Run} "$SET_CMD" "-" "$uuid" "$rest_port"
	#${Run} "$ONECLI_BIN config set SYSTEM_PROD_DATA.SysInfoUUID  ${uuid} $ONECLI_ADD_OPTION --output $AS_LOG_DIR"
}

function GenerateNewRandomUUIDNumber()
{
	read -p "Enter the REST port (empty for no change): " rest_port
#	SYSTEM_PROD_DATA.SysInfoUUID=80c6a9afb99cb70114995cf3fc370aa8
	if [ "x$BOOT_OS_ENV_TYPE" == x"MCP" ];then
		${Run} "$SET_CMD" "-" "$rest_port"
		#${Run} "$ONECLI_BIN config createuuid  SYSTEM_PROD_DATA.SysInfoUUID $ONECLI_ADD_OPTION --output $AS_LOG_DIR" "blank"
		[ $? != 0 ] && return
		uuid=`cat $ONECLI_CONSOLE_FILE |grep -v 'Log('|grep 'SYSTEM_PROD_DATA.SysInfoUUID='| sed s/'SYSTEM_PROD_DATA.SysInfoUUID='//g 2>/dev/null`
		[ -n "${uuid}" ] && echo -e "The UUID:\n${uuid}"

	else
		${Run} "$SET_CMD" "-" "$rest_port"
		#${Run} "$ONECLI_BIN config createuuid  SYSTEM_PROD_DATA.SysInfoUUID $ONECLI_ADD_OPTION --output $AS_LOG_DIR" "blank"
		[ $? != 0 ] && return
		uuid=`cat $ONECLI_CONSOLE_FILE |grep 'SYSTEM_PROD_DATA.SysInfoUUID'| sed s/'The uuid for SYSTEM_PROD_DATA.SysInfoUUID value is '//g | sed s/'The UUID for SYSTEM_PROD_DATA.SysInfoUUID value is '//g 2>/dev/null`
		[ -n "${uuid}" ] && echo -e "The UUID is:\n${uuid}"

	fi
	
}

function LoadUEFIToDefault()
{
	
	makesure "* Are you sure you want to load UEFI to default? [Y/N]:"
	if [ $? == 0 ];then
		read -p "Enter the REST port (empty for no change): " rest_port
		$Run "$SET_CMD" "-" "$rest_port"
	fi
}

function LoadBMCToDefault()
{
	echo "* Loading the BMC to the default will reset the IP address and you may lost the current connection!"
	makesure "* Are you sure you want to load BMC to default? [Y/N]:"
	if [ $? == 0 ];then
		read -p "Enter the REST port (empty for no change): " rest_port
		$Run "$SET_CMD" "-" "$rest_port"
	fi
}

function ChangeBMCHostname()
{
	echo "Get current BMC hostname."
	read -p "Enter the REST port (empty for no change): " rest_port
	#${Run} "$GET_CMD" "cat $ONECLI_CONSOLE_FILE |grep -v 'Log('| grep '=' | grep -v ')='|grep -v 'Translated ASU Command'" 
	${Run} "$GET_CMD" "cat $ONECLI_CONSOLE_FILE |grep '^IMM.HostName1'" "$rest_port"
	#${Run} "$ONECLI_BIN config show IMM.HostName1 $ONECLI_ADD_OPTION --output $AS_LOG_DIR" "cat $ONECLI_CONSOLE_FILE | grep '=' | grep -v ')='|grep -v 'Translated ASU Command'" 
	[ $? != 0 ] && return

	echo ""
	read -p "* Enter the setting value for HostName (empty for no change):" hostname
	[ -z "${hostname}" ] && return
	${Run} "$SET_CMD" "-" "${hostname}" "$rest_port"
	#${Run} "$ONECLI_BIN config set IMM.HostName1  ${hostname} $ONECLI_ADD_OPTION --output $AS_LOG_DIR"
}

function EnableDisableBMCDHCPSetting()
{
	while [ true ]
	do
		read -p "Enter your choice ('e' to enable | 'd' to disable | 'q' to quit):" ans
		if [ -z "$ans" ];then
			continue
		elif [ "x$ans" = "xq" ] || [ "x$ans" = "xQ" ];then
			break
		elif [ "x$ans" = "xe" ] || [ "x$ans" = "xE" ];then
			read -p "Enter the REST port (empty for no change): " rest_port
			${Run} "$SET_CMD" "-" "Enabled" "$rest_port"
			#${Run} "$ONECLI_BIN config set IMM.DHCP1 Enabled $ONECLI_ADD_OPTION --output $AS_LOG_DIR"
			break
		elif [ "x$ans" = "xd" ] || [ "x$ans" = "xD" ];then
			read -p "Enter the REST port (empty for no change): " rest_port
			${Run} "$SET_CMD" "-" "Disabled" "$rest_port"
		 	#${Run} "$ONECLI_BIN config set IMM.DHCP1 Disabled $ONECLI_ADD_OPTION --output $AS_LOG_DIR"
			break
		else
			echo "Invalid input."
		fi
	done
}

Ipv4_ip=""
function InputIP()
{
	Ipv4_ip=""
	while [ true ]
	do
		read -p "$1" Ipv4_ip
		if [ -z "$Ipv4_ip" ];then
			break
		elif [[ ! $(echo "$Ipv4_ip" | grep -P  '^([01]?\d\d?|2[0-4]\d|25[0-5])\.([01]?\d\d?|2[0-4]\d|25[0-5])\.([01]?\d\d?|2[0-4]\d|25[0-5])\.([01]?\d\d?|2[0-4]\d|25[0-5])$') ]] >/dev/null;then
			echo "$2"
		else
			break
		fi
	done
	return 0
}

function SetStaticIPv4NetworkingConfigurationforBMC()
{
	echo "Get current static IPv4 information."
	
	configtmp="/tmp/bomcipv4"
	echo "show IMM.HostIPAddress1 " >${configtmp}
	echo "show IMM.HostIPSubnet1" >>${configtmp}
	echo "show IMM.GatewayIPAddress1" >>${configtmp}
	read -p "Enter the REST port (empty for no change): " rest_port
	"${Run}" "${GET_CMD}" "cat $ONECLI_CONSOLE_FILE |grep -v 'Log('|grep -E 'IMM.HostIPAddress1=|IMM.HostIPSubnet1=|IMM.GatewayIPAddress1='" "${configtmp}" "$rest_port"
	#${Run} "${ONECLI_BIN} config show batch --file ${configtmp} $ONECLI_ADD_OPTION --output $AS_LOG_DIR" "cat $ONECLI_CONSOLE_FILE |grep -E 'IMM.HostIPAddress1=|IMM.HostIPSubnet1=|IMM.GatewayIPAddress1='"
	[ $? != 0 ] && return
	
	echo ""
	while [ true ]
	do
		read -p "* Are you sure you want to change these values? [Y/N]:" ans
		if [ "x$ans" == "xy" ] || [ "x$ans" == "xY" ];then	
			InputIP "* Enter the setting value for IP (empty for no change):" "Invalid IP address."
			[ $? != 0 ] && return 
			ip=$Ipv4_ip
			InputIP "* Enter the setting value for mask (empty for no change):" "Invalid mask."
			[ $? != 0 ] && return 
			mask=$Ipv4_ip
			InputIP "* Enter the setting value for gateway (empty for no change):" "Invalid gateway."
			[ $? != 0 ] && return 
			getway=$Ipv4_ip
			
			[ -z "${ip}" ]&& [ -z "${mask}" ]&&[ -z "${getway}" ]&& return

			#rm -f ${configtmp} 1>/dev/null 2>&1
			if [ "x$BOOT_OS_ENV_TYPE" == "xMCP" ]; then
				echo set IMM.DHCP1=Disabled >${configtmp}
				[ -n "${ip}" ] && echo set IMM.HostIPAddress1="${ip}" >>${configtmp}
				[ -n "${mask}" ] && echo set IMM.HostIPSubnet1="${mask}" >>${configtmp}
				[ -n "${getway}" ] && echo set IMM.GatewayIPAddress1="${getway}" >>${configtmp}
			else

				echo set IMM.DHCP1 Disabled >${configtmp}
				[ -n "${ip}" ] && echo set IMM.HostIPAddress1 "${ip}" >>${configtmp}
				[ -n "${mask}" ] && echo set IMM.HostIPSubnet1 "${mask}" >>${configtmp}
				[ -n "${getway}" ] && echo set IMM.GatewayIPAddress1 "${getway}" >>${configtmp}
			fi
			${Run} "${SET_CMD}" "-" "${configtmp}" "$rest_port"
			#${Run} "${ONECLI_BIN} config batch --file ${configtmp} $ONECLI_ADD_OPTION --output $AS_LOG_DIR"
			rm -f ${configtmp} >/dev/null 2>&1
			break
			
		elif [ "x$ans" == "xn" ] || [ "x$ans" == "xN" ];then
			return
		fi
	done
	#config set IMM.DHCP1=Disabled IMM.HostIPAddress1=10.240.194.207 IMM.HostIPSubnet1=255.255.254.0 IMM.GatewayIPAddress1=10.240.194.1 

}

WatchDogTime=0
function queryWatchdogTime()
{
	times=(2.5 3 3.5 4 10)
	count=0
	echo ""
	echo "Watchdog time could be as below:"
	echo -e "No.\tOS Watchdog Time"
	for t in ${times[@]}
	do 
		let count=count+1
		printf "%d\t%-4.1f minutes\n" $count ${t}
		#echo -e "$count\t${t} minutes"
	done

	while [ true ]
	do
		read -p "* Enter your choice ('q' to quit):" ans
		if [ -z "$ans" ];then
			continue
		elif [ "x$ans" = "xq" ] || [ "x$ans" = "xQ" ];then
			return 1
		elif [ $ans -gt 0 ] 2>/dev/null && [ $ans -le $count ];then
			let ans=ans-1
			WatchDogTime=${times[$ans]}
			break
		else
			echo "Invalid input."
		fi
	done
	return 0
}

function EnableDisableBMCOSWatchdogSetting()
{
	
	while [ true ]
	do
		read -p "Enter your choice ('e' to enable | 'd' to disable | 'q' to quit):" ans
		if [ -z "$ans" ];then
			continue
		elif [ "x$ans" = "xq" ] || [ "x$ans" = "xQ" ];then
			break
		elif [ "x$ans" = "xe" ] || [ "x$ans" = "xE" ];then
			queryWatchdogTime
			[ $? != 0 ] && break
			read -p "Enter the REST port (empty for no change): " rest_port
			#echo "time=$WatchDogTime"
			${Run} "$SET_CMD" "-" "$WatchDogTime" "$rest_port"
			#${Run} "$ONECLI_BIN config set IMM.OSWatchdog $WatchDogTime $ONECLI_ADD_OPTION --output $AS_LOG_DIR"
			
			break
		elif [ "x$ans" = "xd" ] || [ "x$ans" = "xD" ];then
			read -p "Enter the REST port (empty for no change): " rest_port
			${Run} "$SET_CMD" "-" "Disabled" "$rest_port"
		 	#${Run} "$ONECLI_BIN config set IMM.OSWatchdog Disabled $ONECLI_ADD_OPTION --output $AS_LOG_DIR"
			break
		else
			echo "Invalid input."
		fi
	done
}



function SSHtoBMC()
{
	# read -p "* In order to ssh to BMC, We need enable LanOverUsb and SSH_Enable, Are you sure you want to continue [Y/N]:" ans  
	# if [ "x$ans" == "xy" ] || [ "x$ans" == "xY" ];then	
	# 	configtmp="/tmp/configtmp"
	# 	echo "set IMM.LanOverUsb=Enabled " >${configtmp}
	# 	echo "set IMM.SSH_Enable=Enabled" >>${configtmp}
	# 	${Run} "${ONECLI_BIN} config set batch --file ${configtmp} $ONECLI_ADD_OPTION --output $AS_LOG_DIR"
	# 	ret=$?	
	# 	rm -f ${configtmp} >/dev/null 2>&1
	# 	[ $ret != 0 ] && return
	# elif [ "x$ans" == "xn" ] || [ "x$ans" == "xN" ];then
	# 	return
	# else
	# 	echo "Invalid input."
	# 	return
	# fi
	echo "Please make sure enable LanOverUsb and SSH_Enable."
	read -p "* Enter username:" username  
	echo -n "* Enter password:"
	#stty -echo
	read -s password
	#stty echo
	
    ssh ${username}:${password}@169.254.95.118
	
}

function RebootBMC()
{
	while [ true ]
	do
		read -p "* Are you sure you want to reboot BMC? [Y/N]:" ans  
		if [ "x$ans" == "xy" ] || [ "x$ans" == "xY" ];then
			read -p "Enter the REST port (empty for no change): " rest_port
			read -p "Enter the CIM port (empty for no change): " cim_port
			${Run} "$SET_CMD" "-" "$cim_port" "$rest_port"
			#${Run} "$ONECLI_BIN rebootbmc $ONECLI_ADD_OPTION --output $AS_LOG_DIR"	
			return
		elif [ "x$ans" == "xn" ] || [ "x$ans" == "xN" ];then
			return
		# else
		# 	echo "Invalid input."
		# 	return
		fi
	done

	
}

function CommandLineforAdvancedUsers()
{
	echo -e "\"exit\" can quit the command line."
	/bin/sh
}

#this place should add loop
function SetHardwareSystemPlanarClockDateTime()
{
	echo "Current time is `date '+%Y-%m-%d %H:%M:%S'`."
	
	timezone="(`date +"%Z %z"`)"
	while [ true ]
	do
		read -p "Enter time$timezone with format 'YYYY-MM-DD HH:MM:SS' (empty for no change):" stime
		if [ -z "$stime" ];then
			break
		fi
		if [[ ! $(echo "$stime" | grep -P  '^\d{4}.\d{2}.\d{2} \d{2}:\d{2}:\d{2}') ]] >/dev/null;then
			echo "Invalid format"
			continue
		fi

		date -s "$stime"
		if [ $? == 0 ];then
			hwclock -w 1>/dev/null 2>&1
			if [ $? == 0 ]; then
				echo "[Success]"
			else
				echo "[Failure]"
			fi
			break
		#else
		#	echo "[Failure]"
		fi
		
	done
	
	
	#echo "Sorry, this function has not been accomplished."
	# command=
	# $ONECLI_BIN ${command}
}

function ClearAllBMCEventLogs()
{
	
	while [ true ]
	do
		read -p "* Are you sure you want to clear all BMC event logs? [Y/N]:" ans  
		if [ "x$ans" == "xy" ] || [ "x$ans" == "xY" ];then
			read -p "Enter the REST port (empty for no change): " rest_port
			read -p "Enter the CIM port (empty for no change): " cim_port
			"${Run}" "$SET_CMD" "-" "$cim_port" "$rest_port"
			#${Run} "$ONECLI_BIN rebootbmc $ONECLI_ADD_OPTION --output $AS_LOG_DIR"	
			return
		elif [ "x$ans" == "xn" ] || [ "x$ans" == "xN" ];then
			return
		# else
		# 	echo "Invalid input."
		# 	return
		fi
	done
	#${Run} "$ONECLI_BIN logmgr clearall $ONECLI_ADD_OPTION --output $AS_LOG_DIR"
}	


mkdir -p $AS_DIR 1>/dev/null 2>/dev/null
mkdir -p $AS_LOG_DIR 1>/dev/null 2>/dev/null
$1
