// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.

function buildCfg() {
  return window.xpress.utils('buildCfg')
}

function languagesCfg() {
  return window.xpress.utils('languagesCfg')
}

function updateLanguagesCfg(cfg) {
  return window.xpress.utils('updateLanguagesCfg', cfg)
}

async function runProgram(args, workingDirectory, callback, msgs) {
  return new Promise(function (resolve) {
    window.xpress.runProgram(args, workingDirectory, function (success, error, stdout, stderr, procId, errorCode, extInfo) {
      if (callback) {
        callback(success, error, stdout, stderr, errorCode, extInfo);
      }
      resolve({
        success: success,
        error: error,
        stdout: stdout,
        stderr: stderr,
        processId: procId,
        errorCode: errorCode,
        extInfo: extInfo
      });
    }, msgs);
  });
}

function runProgramSync(args, workingDirectory) {
  console.log(JSON.stringify(args));
  return window.xpress.utils('runProgramSync', args, workingDirectory);
}

function setCleanCommand(args) {
  console.log("Set clean command:", args);
  return window.xpress.utils('setCleanCommand', args);
}

function openExternal(link) {
  return window.xpress.utils('openExternal', link);
}

function enableUsbLan() {
  console.log("performing command: enable_usblan");
  window.xpress.enable_usblan();
}

function refine_onecli_command(args) {
  // remove "--comparexml" parameter and value
  var index = args.indexOf("--comparexml");
  if (index > -1) {
    args.splice(index, 2);
  }

  // OneCLI command replacement with "<LXCE OneCLI>"
  args[0] = "<LXCE OneCLI>";

  // Hidden the password like "--bmc username:xxxx@1.1.1.1"
  hidden_oob_passwd(args, "--bmc");
  hidden_oob_passwd(args, "--imm");
  hidden_oob_passwd(args, "--sftp");
  hidden_oob_passwd(args, "--https");
  hidden_oob_passwd(args, "--ftp");
  hidden_oob_passwd(args, "--http");
  hidden_oob_passwd(args, "--proxy");

  // Hidden the password like "--bmc-passphrase xxxx"
  hidden_parameter_passwd(args, "--bmc-password");
  hidden_parameter_passwd(args, "--passphrase");
  hidden_parameter_passwd(args, "--ts-password");
}

function hidden_oob_passwd(args, type_str) {
  var index = args.indexOf(type_str);
  if (index > -1) {
    args[index + 1] = args[index + 1].replace(/(?<=:).*(?=@)/, "***");
  }
}

function hidden_parameter_passwd(args, pattern) {
  var index = args.indexOf(pattern);
  if (index > -1) {
    args[index + 1] = "***";
  }
}

function store_onecli_command(args) {
  let command_type_index = 2;
  let command_type = args[command_type_index];
  let commandArray = args.slice();
  refine_onecli_command(commandArray);

  if (command_type == "acquire") {
    top.gl_acquireCommandArray = commandArray.slice();

  } else if (command_type == "flash") {
    top.gl_flashCommandArray = commandArray.slice();

  } else if (command_type == "raid") {
    top.gl_raidCommandArray = commandArray.slice();

  } else if (command_type == "claim") {
    top.gl_security_claimCommandArray = commandArray.slice();

  } else if (command_type == "enablesecuritypack") {
    top.gl_security_enableCommandArray = commandArray.slice();

  } else if (command_type == "gettoken") {
    top.gl_security_gettokenCommandArray = commandArray.slice();

  } else if (command_type == "unlock") {
    top.gl_security_unlockCommandArray = commandArray.slice();

  } else if (command_type == "activate") {
    top.gl_security_activateCommandArray = commandArray.slice();

  } else if (command_type == "callhome") {
    top.gl_security_callhomeCommandArray = commandArray.slice();

  } else if (command_type == "lock") {
    top.gl_security_lockCommandArray = commandArray.slice();

  } else if (command_type == "setstatustoactive") {
    top.gl_security_setActiveCommandArray = commandArray.slice();

  } else if (command_type == "checktask") {
    top.gl_check_task = commandArray.slice();

  } else if (command_type == "canceltask") {
    top.gl_cancel_task = commandArray.slice();

  } else if (command_type == "startstaged") {
    top.gl_start_staged_task = commandArray.slice();

  } else if (command_type == "restore") {
    top.gl_sed_restoreCommandArray = commandArray.slice();

  } else if (command_type == "backup") {
    top.gl_sed_backupCommandArray = commandArray.slice();

  } else if (args[command_type_index] == "checktask") {
    top.gl_check_task = commandArray.slice();

  } else if (args[command_type_index] == "canceltask") {
    top.gl_cancel_task = commandArray.slice();

  } else if (args[command_type_index] == "startstaged") {
    top.gl_start_staged_task = commandArray.slice();

  } else if (args[command_type_index] == "restore") {
    top.gl_sed_restoreCommandArray = commandArray.slice();

  } else if (args[command_type_index] == "backup") {
    top.gl_sed_backupCommandArray = commandArray.slice();

  } else if (args[command_type_index] == "generate") {
    top.gl_sed_generateCommandArray = commandArray.slice();

  } else if (args[command_type_index] == "ospower") {
    top.gl_ospower_osCommandArray = commandArray.slice();

  } else if (args[command_type_index] == "enableportalactivation") {
    top.gl_portal_activation_CommandArray = commandArray.slice();

  } else if (args[command_type_index] == "configmotiondetection") {
    top.gl_config_motion_detection_CommandArray = commandArray.slice();

  } else if (args[command_type_index] == "configintrusiondetection") {
    top.gl_config_chassis_intrusion_CommandArray = commandArray.slice();

  }
}

function reboot_decode(value) {
  switch (value) {
    case '0':
      return 'No reboot required';
    case '1':
      return 'Reboot Forced by Update';
    case '2':
      return 'Reboot Required Immediately after update';
    case '3':
      return 'Reboot Required to take effect';
    case '4':
      return 'Logoff Required to take effect';
    default:
      return value;
  }
}

function get_bomc_config_content() {
  if (!top.fileExists('/tmp/bomc.config')) return;
  try {
    var bomc_config_content = top.readTextFile('/tmp/bomc.config');
  } catch (e) {
    return;
  }
  var bomc_config_array = bomc_config_content.split('\n');
  for (var i = 0; i < bomc_config_array.length; i++) {
    if (bomc_config_array[i].indexOf('IBM_SYSTEM_MEDIALABEL=') != -1) {
      top.gl_descriptive_name = bomc_config_array[i].replace('IBM_SYSTEM_MEDIALABEL=', '');
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_UNATTENDED=') != -1) {
      top.gl_is_unattend = ('NULL' != bomc_config_array[i].replace('IBM_SYSTEM_UNATTENDED=', ''));
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_REBOOT_BMC=') != -1) {
      top.gl_reboot_bmc = ('YES' == bomc_config_array[i].replace('IBM_SYSTEM_REBOOT_BMC=', ''));
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_AUTORUN=') != -1) {
      top.gl_autorun = ('NULL' != bomc_config_array[i].replace('IBM_SYSTEM_AUTORUN=', ''));
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_USB_KEY=') != -1) {
      top.gl_usb_key = bomc_config_array[i].replace('IBM_SYSTEM_USB_KEY=', '');
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_PXE_FILE=') != -1) {
      top.gl_pxe_file = bomc_config_array[i].replace('IBM_SYSTEM_PXE_FILE=', '');
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_MACHINETYPE=') != -1) {
      top.gl_mt_array = bomc_config_array[i].replace('IBM_SYSTEM_MACHINETYPE=', '').split(',');
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_FORCE_ID=') != -1
      && bomc_config_array[i].replace('IBM_SYSTEM_FORCE_ID=', '') != 'NULL') {
      top.gl_bomc_force_list = bomc_config_array[i].replace('IBM_SYSTEM_FORCE_ID=', '').split(',');
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_COPY_TO_RAMDISK=') != -1) {
      top.gl_copy_ramdisk = ('YES' == bomc_config_array[i].replace('IBM_SYSTEM_COPY_TO_RAMDISK=', ''));
    }
    else if (bomc_config_array[i].indexOf('IBM_SYSTEM_ISO_PATH=') != -1) {
      top.gl_ISO_path = bomc_config_array[i].replace('IBM_SYSTEM_ISO_PATH=', '');
    }
  }
}

function get_descriptive_name() {
  return top.gl_descriptive_name;
}

function is_unattend() {
  return top.gl_is_unattend;
}

function is_reboot_bmc() {
  return top.gl_reboot_bmc;
}

function is_autorun() {
  return top.gl_autorun;
}

function in_ramdisk() {
  return top.gl_copy_ramdisk;
}

// return true if it requires bootable updatexpress to copy payloads
// return false if it need not copy payloads
function need_copy() {
  return (top.gl_usb_key == 'NULL' && top.gl_pxe_file == 'NULL');
}

function getMTFromImage() {
  return top.gl_mt_array;
}

function getBomcForceList() {
  return top.gl_bomc_force_list;
}

function isAmd(mt) {
  if (!mt) {
    mt = top.gl_mt_list[0];
  }
  for (var i = 0; i < top.gl_amd_mt_list.length; i++) {
    if (mt == top.gl_amd_mt_list[i]) {
      return true;
    }
  }
  return false;
}

function isCFC(mt) {
  if (!mt) {
    mt = top.gl_mt_list[0];
  }
  for (var i = 0; i < top.gl_cfc_mt_list.length; i++) {
    if (mt == top.gl_cfc_mt_list[i]) {
      return true;
    }
  }
  return false;
}

function isGrantly(mt) {
  if (!mt) {
    mt = top.gl_mt_list[0];
  }
  for (var i = 0; i < top.gl_grantly_mt_list.length; i++) {
    if (mt == top.gl_grantly_mt_list[i]) {
      return true;
    }
  }
  return false;
}

function saveMetaToLocal() {
  var acRltPath = top.getSupportFile('acquireResult');
  if (top.fileExists(acRltPath)) {
    var ac_Content = top.readTextFile(acRltPath);
    var acRltMetaPath = top.getSupportFile('acResultMeta');
    if (top.fileExists(acRltMetaPath)) {
      top.deleteFile(acRltMetaPath);
    }
    top.writeTextFile(acRltMetaPath, ac_Content);
  }
  var acRlt2Path = top.getSupportFile('acquireResult2');
  if (top.fileExists(acRlt2Path)) {
    var ac2_Content = top.readTextFile(acRlt2Path);
    var acRlt2MetaPath = top.getSupportFile('acResult2Meta');
    if (top.fileExists(acRlt2MetaPath)) {
      top.deleteFile(acRlt2MetaPath);
    }
    top.writeTextFile(acRlt2MetaPath, ac2_Content);
  }
}

function getPackageType(updateId) {
  var compareCheck = getSupportFile("compareResult", "oneCli");
  var compareContent;
  if (top.fileExists(compareCheck)) {
    compareContent = top.readTextFile(compareCheck);
  }
  if (!compareContent) return "bmu";
  else {
    var domCheck = ezJsLib.XmlDom.parse(compareContent);
    var tagPackageArray = domCheck.getElementsByTagName("PACKAGE");
    for (var i = 0; i < tagPackageArray.length; i++) {
      if (ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", tagPackageArray[i]) == updateId) {
        var childupdates;
        try {
          childupdates = tagPackageArray[i].getElementsByTagName("CHILDUPDATES");
          childupdates = childupdates[0].getElementsByTagName("CHILDUPDATE");
        } catch (e) {
          childupdates = new Array();
        }
        if (childupdates.length == 0) {
          var agentlessValue;
          try {
            agentlessValue = ezJsLib.XmlDom.getValueByTagFromNode("AGENTLESSSUPPORT", tagPackageArray[i]);
          } catch (e) {
            agentlessValue = 0;
          }
          if (agentlessValue == 0) {
            return "bmu";
          } else {
            return "OOB";
          }
        } else {
          var isBmu = false;
          for (var i = 0; i < childupdates.length; i++) {
            var category;
            try {
              category = ezJsLib.XmlDom.getValueByTagFromNode("CCATEGORY", childupdates[i]);
            } catch (e) {
              category = "Legacy Option";
            }
            if (category.toLowerCase().indexOf("legacy option") != -1) {
              var isBmu = true;
              break;
            }
          }
          if (isBmu) {
            return "bmu";
          } else {
            return "OOB";
          }
        }
      }
    }
  }
}

function getSystemFile(fileId) {
  var commands = top.loadSetting("system_files.json");
  if (commands[fileId].win == undefined && commands[fileId].linux == undefined) {
    return top.pathJoin(top.gl_base_path, commands[fileId].toString());
  }
  if (top.OSTYPE == "windows") {
    return top.pathJoin(top.gl_base_path, commands[fileId].win.toString());
  } else {
    return top.pathJoin(top.gl_base_path, commands[fileId].linux.toString());
  }
}

function getGenericOSType() {
  return window.xpress.utils('getGenericOSType')
}

function getOS() {
  return window.xpress.utils('getOS')
}

function getSupportDir() {
  return window.xpress.utils('getSupportDir')
}

function getSupportFile(fileId, type, middlePath = "") {
  let files = top.loadSetting("support_files.json");
  let baseDir = getSupportDir();
  if (middlePath == null) middlePath = "";
  if (middlePath !== "") {
    if (isAbsolutePath(middlePath)) {
      baseDir = middlePath;
    } else {
      baseDir = top.pathJoin(getTempPath4ThisTask(), middlePath)
    }
  }
  if (type) {
    return top.pathJoin(baseDir, files[fileId][type].toString());
  } else {
    return top.pathJoin(baseDir, files[fileId].toString());
  }
}

function getSupportFileBySeries(fileId, seriesId, type) {
  var file = getSupportFile(fileId, type);
  return file.replace(".xml", seriesId + ".xml");
}

// gets the value of an environment variable
// name: string - name of variable
// returns: string - value of variable
//          undefined - variable is not defined
function getEnv(name) {
  let val = window.xpress.utils('getEnv', name);
  return val ? val : "";
}

function copyToClipBoard(data) {
  return window.xpress.utils('copyToClipBoard', data);
}
// showPrompt: boolean - Determines if an "Are you sure you want to exit" dialog will be shown
// returns void
function Exit(showPrompt) {
  window.xpress.setExitConfirmFlag(showPrompt);
  window.xpress.close();
}

function parsePropertiesFile(filename) {
  return window.xpress.utils('parsePropertiesFile', filename)
}

/**
 * write user's selections (MT & OS) to hard disk
 */
function writeConfigFile() {
  if (!top.gl_store_os && !top.gl_store_mt)
    return;
  var root = "<?xml version=\"1.0\"?>";
  root += "<root>\n";
  root += "<timestamp>";
  root += top.gl_configlist_time_stamp;
  root += "</timestamp>\n";
  for (var i = 0; i < top.gl_config_list.length; i++) {
    var a = top.gl_config_list[i];
    root += "\t<system>";
    root += "<xname>" + a[0] + "</xname>";
    root += "<machineType>" + a[1] + "</machineType>";
    root += "<selected>" + a[2] + "</selected>";
    root += "<noUXSP>" + a[3] + "</noUXSP>";
    root += "</system>\n";
  }
  for (i = 0; i < top.gl_os_list.length; i++) {
    root += "<OS>" + top.gl_os_list[i] + "</OS>\n";
  }

  root += "</root>";
  top.writeTextFile(top.getSupportFile("configList"), root);
}

// Build proxy uri: userid:password@ip:port
function buildProxyUri(userid, password, ip, port) {
  var uri = top.gl_proxyType + "://";
  if (gl_proxy_account) uri += (userid + ":" + password + "@");
  uri += ((ip[0] != "[" && ip.indexOf(":") != -1) ? ("[" + ip + "]") : (ip));
  if (port != "") uri += (":" + port);
  return uri;
}

function add_proxy_para() {
  var args = new Array();
  if (top.gl_url_custom) {
    if (top.gl_url_insecure) {
      args.push("--insecure");
    }
    else if (top.gl_url_specify_cert) {
      args.push("--cacert");
      args.push(top.gl_url_cert);
    }
  }
  if (top.gl_isProxy) {
    var proxyUri = buildProxyUri(top.gl_proxy_username, top.gl_proxy_password, top.gl_proxy_address, top.gl_proxy_port);
    args.push("--proxy");
    args.push(proxyUri);
    if (top.gl_proxy_custom) {
      if (top.gl_proxy_insecure) {
        args.push("--proxy-insecure");
      }
      else if (top.gl_proxy_specify_cert) {
        args.push("--proxy-cacert");
        args.push(top.gl_proxy_cert);
      }
    }
  }
  return args;
}

function add_output_log5(middlePath = "") {
  var args = new Array();
  args.push("--output");
  if (middlePath) {
    args.push(top.pathJoin(getTempPath4ThisTask(), middlePath));
  } else {
    args.push(top.getSupportDir());
  }
  args.push("--log");
  args.push("5");
  return args;
}

//for unattend mode
function uxlite_alert(text) {
  if (top.getEnv("BOMC_UNATTENDED_MODE")) {
    top.Exit(false);
  } else {
    alert(text);
  }

}

function getComErrMsg() {
  if (top.OSTYPE == "windows")
    return $.i18n.prop("Common.UnknownFailWin");
  else
    return $.i18n.prop("Common.UnknownFailLinux");
}

function setWorkingDir(eleId, iFlag) {
  var path = window.xpress.showOpenDialog('');
  if (path && path[0]) {
    var dir = path[0];
    document.getElementById(eleId).value = dir;
    if (iFlag)
      top.gl_workingDir = dir;
    console.log(dir);
  }
}

function setFileParentdir(eleId, filename) {
  var path = window.xpress.showOpenDialog('');
  if (path && path[0]) {
    var dir = path[0];
    if (filename)
      dir = top.pathJoin(dir, filename);
    document.getElementById(eleId).value = dir;
    console.log(dir);
  }
}

function getFileParentdir(filename) {
  var path = window.xpress.showOpenDialog('');
  if (path && path[0]) {
    var dir = path[0];
    if (filename)
      dir = top.pathJoin(dir, filename);
    console.log(dir);
    return dir;
  }
}

function openFileDirectory(eleId, callback, filterType) {
  var _defaultPath = "";
  if (eleId)
    _defaultPath = document.getElementById(eleId).value;
  var _filterType = [];
  if (filterType)
    _filterType = filterType;
  else
    _filterType = [{ name: 'All Files', extensions: ['*'] }];
  var path = window.xpress.showOpenDialogFile(_defaultPath, _filterType);
  if (path && path[0]) {
    var dir = path[0];
    document.getElementById(eleId).value = dir;
    if (callback)
      callback(dir);
    console.log(dir);
  }
}

function checkSupportMachineType(mt) {
  var supportMTList = getSupportMachineTypeList();
  var found = false;
  for (var i = 0; i < supportMTList.length; i++) {
    if (supportMTList[i].toLowerCase() == mt.toLowerCase()) {
      found = true;
      break;
    }
  }
  return found;
}

function hasPurleyOrOther(mt) {
  var purley = false;
  var prepurley = false;
  if (mt) {
    for (var i = 0; i < mt.length; i++) {
      if (isNaN(mt[i])) {
        purley = true;
      } else {
        prepurley = true;
      }
    }
  }
  if (purley && !prepurley) {
    return "purley";
  } else if (!purley && prepurley) {
    return "prepurley";
  } else {
    return "muti";
  }
}

function getSupportMachineTypeList() {
  var machineTypeList = new Array();
  var supportListFile = null;
  try {
    supportListFile = top.readTextFile(top.getSupportFile("configList", false));
    if (supportListFile == null) {
      throw $.i18n.prop("MachineType.NoFile");
    }
  }
  catch (e)             //load config sys file failed, load default one
  {
    printLog("INFO", "excepton happened:" + e);
    supportListFile = top.readTextFile(top.getSystemFile("mtList"));
  }

  if (supportListFile != null) {
    var dom = ezJsLib.XmlDom.parse(supportListFile);
    var allSystems = dom.documentElement.getElementsByTagName("system");
    for (var i = 0; i < allSystems.length; i++) {
      var mt = allSystems.item(i).childNodes[1].firstChild.nodeValue;
      machineTypeList.push(mt);
    }
  }
  return machineTypeList;
}

function alert(msg) {
  window.xpress.alertMsg(msg);
}

function confirm(msg) {
  return 0 == window.xpress.confirmMsg(msg);
}

function confirmWithCheckBox(msg, checkboxMsg) {
  let res = window.xpress.confirmMsgWithCheckBox(msg, checkboxMsg);
  let isYes = res.response == 0;
  return { isYes: isYes, isChecked: res.checkboxChecked };
}

function quit(msg) {
  window.xpress.quitMsg(msg);
}

// Remove password as the cred file is using
// If no params, use the first server info as OOB non-multiserver case
function SplitFullConnInfo(serverInfo) {
  let _serverInfo = { userName: "", ip: "", port: "" };
  if (serverInfo) {
    _serverInfo = serverInfo;
  } else if (Server_Pool.selectedServerList[0]) {
    _serverInfo = Server_Pool.selectedServerList[0];
  }
  let userid = _serverInfo.userName;
  let addr = _serverInfo.ip;
  let port = _serverInfo.port;
  if (addr.indexOf(":") != -1) {
    if (port != undefined && port != null && port != "") {
      return (userid + "@[" + addr + "]:" + port);
    } else {
      return (userid + "@[" + addr + "]");
    }
  } else {
    if (port != undefined && port != null && port != "") {
      return (userid + "@" + addr + ":" + port);
    } else {
      return (userid + "@" + addr);
    }
  }
}

function SplitXCCInfo() {
  let conn = [];
  conn.push("--mt");
  conn.push(top.gl_mt_list[0]);
  conn.push("--sn");
  conn.push(top.gl_Edge_Machine_Params.SN);
  return conn.concat();
}

function setExternalExplorer(aTag) {
  if (aTag instanceof Element) {
    aTag.addEventListener('click', e => {
      e.preventDefault();
      top.openExternal(aTag.getAttribute('href'));
    });
  } else {
    const link = document.getElementById(aTag);
    link.addEventListener('click', e => {
      e.preventDefault();
      top.openExternal(link.getAttribute('href'));
    });
  }
}

function write_config_batch_file_sync(config_items, cmd, prefix, config_batch_file) {
    return window.xpress.write_config_batch_file_sync(config_items, cmd, prefix, config_batch_file);
}

function read_config_batch_file_sync(cmd, prefix, config_batch_file) {
    return window.xpress.read_config_batch_file_sync(cmd, prefix, config_batch_file);
}

function generate_multi_server_task_file_sync(server_list, multi_task_file) {
    return window.xpress.generate_multi_server_task_file_sync(server_list, multi_task_file);
}

function rewrite_compare_result(selected_list, forceid_list, callback) {
  let compare_rewrite_xml = top.getSupportFile('compareResult', 'rewrite');
  let compare_xml = top.getSupportFile('compareResult', 'oneCli');
  top.deleteFile(compare_rewrite_xml);
  let tag_sel = 0;
  let tag_force = 0;
  let rested_selected_list = selected_list.concat();
  let infile = top.readTextFile(compare_xml);
  let outfile = "";
  if (infile != null) {
      let content = (new DOMParser()).parseFromString(infile, "text/xml");
      for (let pkg of content.getElementsByTagName("PACKAGE")) {
          let updateId = pkg.getElementsByTagName("UPDATEID")[0].innerHTML;
          tag_sel = 0;
          tag_force = 0;
          if (rested_selected_list) {
              for (let i = 0; i < rested_selected_list.length; ++i) {
                  if (updateId.indexOf(rested_selected_list[i]) != -1) {
                      rested_selected_list.splice(i, 1);
                      tag_sel = 1;
                      break;
                  }
                  tag_sel = 0;
              }
          }
          if (forceid_list) {
              for (let i = 0; i < forceid_list.length; ++i) {
                  if (updateId.indexOf(forceid_list[i]) != -1) {
                      tag_force = 1;
                      break;
                  }
                  tag_force = 0;
              }
          }
          pkg.getElementsByTagName("SELECTED")[0].innerHTML = tag_sel;
          pkg.getElementsByTagName("FORCEID")[0].innerHTML = tag_force;
          for (let childSel of pkg.getElementsByTagName("CSELECTED")) {
              childSel.innerHTML = tag_sel;
          }
      }
      outfile = (new XMLSerializer()).serializeToString(content);
  }
  top.writeTextFile(compare_rewrite_xml, outfile, false);

  if (callback) {
      callback();
  }
}

function merge_compare_result(selected_list, callback, compare_rewrite_xml, compare_xml) {
  return window.xpress.merge_compare_result(selected_list, callback, compare_rewrite_xml, compare_xml)
}

function write_acquire_xml(includeid_list, callback, acquire_xml) {
  return window.xpress.write_acquire_xml(includeid_list, callback, acquire_xml)
}

function getTaskName() {
  return top.gl_task[top.gl_curTaskIndex];
}

/**
 * @param  path
 * It can be a log file or a directory contains several subfolders named with ip
 */
function setLogFile(path) {
  top.logFiles[top.gl_curTaskIndex] = path;
}

function getLogFile(taskId) {
  if (taskId == undefined) {
    taskId = top.gl_curTaskIndex;
  }
  return top.logFiles[taskId];
}

function setOneCliCommandString(cmdString) {
  top.onecliCommandStrings[top.gl_curTaskIndex] = cmdString;
}

function getOneCliCommandString(taskId) {
  if (taskId == undefined) {
    taskId = top.gl_curTaskIndex;
  }
  return top.onecliCommandStrings[taskId];
}

function getTempPath4ThisTask() {
  let taskName = top.gl_task.length > 0? top.gl_tasksName[top.gl_task[top.gl_curTaskIndex]].replace(/[^A-Za-z_]/g, ""): "Common";
  let tempPath = top.pathJoin(top.getSupportDir(), "UX-" + taskName);
  if (directoryExists(tempPath)) {
    return tempPath;
  }
  createDirectory(tempPath);
  return tempPath;
}

function clone(any) {
  function checkType(any) {
    return Object.prototype.toString.call(any).slice(8, -1)
  }
  if (checkType(any) === 'Object') { // copy object
    let o = {};
    for (let key in any) {
      o[key] = clone(any[key])
    }
    return o;
  } else if (checkType(any) === 'Array') { // copy arr
    var arr = []
    for (let i = 0, leng = any.length; i < leng; i++) {
      arr[i] = clone(any[i])
    }
    return arr;
    // CID 190100: Unsafe evaluation function (SIGMA.unsafe_eval)
    // } else if (checkType(any) === 'Function') { // copy function
    //     return new Function('return ' + any.toString()).call(this)
  } else if (checkType(any) === 'Date') { // copy date
    return new Date(any.valueOf())
  } else if (checkType(any) === 'RegExp') { // copy regex
    return new RegExp(any)
  } else if (checkType(any) === 'Map') { // copy map
    let m = new Map()
    any.forEach((v, k) => {
      m.set(k, clone(v))
    })
    return m
  } else if (checkType(any) === 'Set') { // copy set
    let s = new Set()
    for (let val of any.values()) {
      s.add(clone(val))
    }
    return s
  }
  return any;
}

function isIPV4(ip) {
  var reg = /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/
  return reg.test(ip)
}

function isIPV6(ip) {
  return /:/.test(ip)
    && ip.match(/:/g).length < 8
    && /::/.test(ip)
    ? (ip.match(/::/g).length == 1
      && /^::$|^(::)?([\da-f]{1,4}(:|::))*[\da-f]{1,4}(:|::)?$/i.test(ip))
    : /^([\da-f]{1,4}:){7}[\da-f]{1,4}$/i.test(ip);
}

function ipValidate(ip) {
  return isIPV4(ip) || isIPV6(ip);
}

function tr(msg) {
  if (top.gl_translate_dict == undefined || top.gl_translate_dict == null) {
    loadLocaleTr();
  }
  var args = [].slice.call(arguments);
  if (msg in top.gl_translate_dict) {
    trmsg = top.gl_translate_dict[msg];
  } else {
    trmsg = msg;
    printLog("ERROR", "The key '{0}' does not exist in the translate file.".format(msg));
    console.log("The key '{0}' does not exist in the translate file.".format(msg));
  }
  if (args.length > 1) {
    args.splice(0, 1);
    trmsg = trmsg.format(...args);
  }
  return trmsg;
}

function checkHostName(hostName) {
  var expHostName = /((^\s*((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))\s*$)|(^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$))|(^\s*((?=.{1,255}$)(?=.*[A-Za-z].*)[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?)*)\s*$)/;
  var flag = expHostName.test(hostName);
  if (flag) return true;
  else return false;
}

function loadLocaleTr() {
  try {
    let trFileName = top.pathJoin(top.gl_app_base_path, "locale/lang_en.json");
    top.gl_translate_dict = JSON.parse(top.readTextFile(trFileName));
  } catch (e) {
    console.log(e);
  }
  try {
    let trFileName = top.pathJoin(top.gl_app_base_path, "locale/lang_" + top.BUILD_LANGUAGE + ".json");
    let tempDict = JSON.parse(top.readTextFile(trFileName));
    for (let key in tempDict) {
      top.gl_translate_dict[key] = tempDict[key];
    }
  } catch (e) {
    console.log(e);
  }
  if (top.gl_translate_dict == null) {
    top.gl_translate_dict = {}
  }
}

$.i18n.prop = tr;

const TaskTool = function (is_operational_after_done = true, max_retry_count = 2) {

  const { ref } = Vue

  let stage = ref("undone");

  let timeHandler = null;

  const getCommonResult = function (ip) {
    let resultFile = "";
    if (ip != undefined && ip != null && ip != "") {
        resultFile = top.readTextFile(top.getSupportFile("commonResult", null, ip));
    } else {
        resultFile = top.readTextFile(top.getSupportFile("commonResult"));
    }
    var resultDom, resultMsg, errCode;
    if (resultFile != null) {
      resultDom = ezJsLib.XmlDom.parse(resultFile);
      resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
      errCode = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", resultDom.documentElement);
      setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
      return { msg: resultMsg, code: errCode };
    } else {
      return { msg: /* top.getComErrMsg() */'Unknown error occurred during process.', code: null };
    }
  }

  // poor implmentation
  const moveFilesToTargetDir = function (task_infos) {
    let cache = new Map();
    let dir = getMultiCmdOutputDir();
    let logfile = basename(dir)+'.log';

    const move = function(ti) {
        let ip = (ti.isonly == undefined || ti.isonly == false) ? ti.server.ip : null;
        const createCommonRes = function() {
            let error = !ti.taskStatus.result ? "Yes" : "No";
            let errorcode = !ti.taskStatus.result ? 1 : 0;
            let msg = !ti.taskStatus.result ? "Failure" : "Success";
            return `<?xml version="1.0" encoding="utf-8"?>
<COMMONRESULT>
    <ERROR>${error}</ERROR>
    <ERRORCODE>${errorcode}</ERRORCODE>
    <MESSAGE>${msg}</MESSAGE>
    <ONECLI>Yes</ONECLI>
    <LOGFILE>${logfile}</LOGFILE>
</COMMONRESULT>`;
        }

        top.deleteFile(top.getSupportFile("commonResult", null, ip));
        top.writeTextFile(top.getSupportFile("commonResult", null, ip), createCommonRes());
        if (!cache.get(logfile)) {
            cache.set(logfile, top.readTextFile(top.pathJoin(dir, logfile)));
        }
        let fullPath = ip == null ? (top.pathJoin(top.getSupportDir(), logfile)) : (top.pathJoin(getTempPath4ThisTask(), ip, logfile));
        top.writeTextFile(fullPath, cache.get(logfile));
    }

    if(task_infos.length == 1) {
        task_infos[0].isonly = true;
    }

    for(let ti of task_infos) {
        move(ti);
    }

  }

  const TaskStatus = function (proMsg, sucMsg) {
    this.isRunning = false;
    this.isFailed = false;
    this.isFinished = true;
    this.isCanceled = false;
    this.img = "images/progress_anim2_small.gif";
    this.errmsg = '';
    this.recomm = '';
    this.taskProcessingMsg = proMsg;
    this.taskSucceedMsg = sucMsg;
  }

  let id = 0;
  const TaskInfo = function (name, args, callback, taskStatus, server) {
    this.id = id++;
    this.server = server;
    this.name = name;
    this.args = args;
    this.callback = callback;
    this.taskStatus = taskStatus;
  }

  class AsyncPool {
    executing = [];
    constructor(poolLimit, callback) {
      this.poolLimit = poolLimit == 1 ? 5 : poolLimit; // pool size can not be 1, or callback will be invoked after every single task
      this.callback = callback;
      this.count = 0;
    }
    add(promiseCreator) {
      if (this.executing.length < this.poolLimit) {
        const p = Promise.resolve().then(() => promiseCreator());
        const e = p.then((res) => {
          this.executing.splice(this.executing.indexOf(e), 1);
          this.count -= 1;
          if (this.count == 0 && this.callback != undefined && this.callback != null) {
            this.callback();
          }
          return res;
        });
        this.count += 1;
        this.executing.push(e);
        return e;
      } else {
        const race = Promise.race(this.executing);
        return race.then(() => this.add(promiseCreator));
      }
    }
  }


  let taskStarted = function (ti) {
    ts = ti.taskStatus;
    ts.isFinished = false;
    ts.isRunning = true;
    ts.isCanceled = false;
    ts.img = "images/progress_anim2_small.gif";
  }

  let allTaskStarted = function (task_infos, update_process, interval) {
    for(let ti of task_infos){
        taskStarted(ti);
    }
    if (update_process) {
        timeHandler = {
            id:setInterval(() => {
                update_process(task_infos);
            }, interval),
            func: update_process
        }
    }
  }

  const taskFailed = function (ti) {
    ts = ti.taskStatus;
    let errcode2recommendation = function (errcode) {
      if (errcode != null && errcode != undefined && top.gl_errorcodeToRecommendedAction[Number(errcode)] != undefined) {
        return top.gl_errorcodeToRecommendedAction[Number(errcode)];
      }
    }
    ts.isFailed = true;
    ts.isFinished = true;
    ts.img = "images/statusCritical_obj16.gif";
    let res = null;
    if ((ti.isonly != undefined && ti.isonly == true) || ti.server == undefined) {
        res = getCommonResult(null);
    } else {
        res = getCommonResult(ti.server.ip);
    }
    ts.errmsg = res.msg;
    ts.recomm = errcode2recommendation(res.code);
  }

  const taskSucceed = function (ti) {
    ts = ti.taskStatus;
    ts.isFailed = false;
    ts.isFinished = true;
    ts.img = "images/statusSuccess_obj16.gif";
    if ((ti.isonly != undefined && ti.isonly == true) || ti.server == undefined) {
        getCommonResult(null);
    } else {
        getCommonResult(ti.server.ip);
    }
  }

  const taskCanceled = function (ti) {
    ti.taskStatus.isCanceled = true;
    // ts.img = "images/statusSuccess_obj16.gif";
  }

  const taskFinished = function (res, ti) {
    if(res == "killed") {
      taskCanceled(ti);
    } else {
        if (res) {
            taskSucceed(ti);
        } else {
            taskFailed(ti);
        }
    }
  }

  const allTaskFinished = function (task_infos) {
    if(timeHandler){
        clearInterval(timeHandler.id);
        timeHandler.func(task_infos);
        timeHandler = null;
    }
    for(let ti of task_infos){
        taskFinished(ti.taskStatus.result, ti);
    }
  }

  const clickable = ref('');
  const startProcess = function () {
    clickable.value = 'notclick';
    toggleNext(false);
    togglePrevious(false);
  }

  const processStopped = function (res, can_not_next_with_failure=true) {
    if (res) {
      toggleNext(true);
      togglePrevious(true);
      stage.value = "done";
      if (is_operational_after_done == true) {
        clickable.value = '';
      }
    } else if (res == false || res == "killed") {
      toggleNext(!can_not_next_with_failure);
      togglePrevious(true);
      stage.value = can_not_next_with_failure ? "undone" : "done";
      clickable.value = '';
    }
  }

  const runTask = async function (args) {
    printLog("INFO", "run command:" + getRunProgramCommend(args));
    deleteFile(top.getSupportFile("commonResult"));
    top.store_onecli_command(args);
    return await runProgram(args.slice(), null);
  }

  const runOrderedTasksSync = async function (taskInfos, options) {
    if(options == undefined) {
        options = {}
    }
    startProcess();
    let all_res = true;
    for (let i = 0; i < taskInfos.length; i++) {
      let res = false, err = null;
      let count = 0;
      const max = max_retry_count;
      taskStarted(taskInfos[i]);
      while ((res !== 'killed' && !res && count < max)) {
        let obj = await runTask(taskInfos[i].args);
        res = obj.success == true ? true : (obj.extInfo.killed == true ? "killed" : false);
        count++;
      }
      taskInfos[i].taskStatus.result = res;
      taskFinished(res, taskInfos[i]);
      if (taskInfos[i].callback) {
        taskInfos[i].callback(res);
      }
      if (!res || res === 'killed') {
        all_res = res;
        break;
      }
    }
    processStopped(all_res, options.can_not_next_with_failure == undefined ? true : options.can_not_next_with_failure);
    return true;
  }

  // TODO: supervise task status
  const runMultiTasks = async function (task_infos, options) {
    if(options == undefined) {
        options = {}
    }
    startProcess();
    let res = true;
    let args = task_infos[0].args;
    allTaskStarted(task_infos, options.update_process, options.interval);
    let obj = await runTask(args);
    // ****** should monitor every single task's status ******
    res = obj.success == true ? true : (obj.extInfo.killed == true ? "killed" : false);
    for(let ti of task_infos){
        if(obj.extInfo.killed == true) {
            ti.taskStatus.result = "killed";
        } else {
            ti.taskStatus.result = res;
        }
    }
    moveFilesToTargetDir(task_infos)
    allTaskFinished(task_infos); 
    // ************************
    processStopped(res, options.can_not_next_with_failure);
    return res;
  }
  
  const runMultiSingleTasksAsync = async function(taskInfos, options) {
    if (taskInfos.length == 0) {
        console.log("no tasks need to be run")
        return true;
    }
    if(options == undefined) {
        options = {}
    }
    return new Promise((resolve)=>{
        startProcess();
        // *****************
        if (taskInfos.length == 1) {
            taskInfos[0].isonly = true;
        }
        // *****************
        let res = true;
        const pool = new AsyncPool(options.concurrent_num, ()=>{
            //   allTaskFinished(taskInfos);
            if(timeHandler){
                clearInterval(timeHandler.id);
                timeHandler.func(taskInfos);
                timeHandler = null;
            }
            processStopped(res, options.can_not_next_with_failure == undefined ? true : options.can_not_next_with_failure);
            resolve(res);
            console.log("All task finished.");
        });
        for (let ti of taskInfos) {
          top.store_onecli_command(ti.args);
          deleteFile(top.getSupportFile("commonResult", null, taskInfos.length == 1 ? null : ti.server.ip));
          let promiseCreator = function(){
                return runProgram(ti.args, null, (success, error, stdout, stderr, errorCode, extInfo)=>{
                    console.log(`task ${ti.server.ip} finished. ${success}`)
                    res = res && success;
                    if (extInfo.killed == true) {
                        res = "killed";
                    }
                    ti.taskStatus.result = success == true ? true : (extInfo.killed == true ? "killed" : false);
                    taskFinished(ti.taskStatus.result, ti);
                    if(ti.callback){
                        ti.callback(ti.taskStatus.result, ti);
                    }
                })
            }
        pool.add(promiseCreator);
        }
        allTaskStarted(taskInfos, options.update_process == undefined ? null : options.update_process, options.interval == undefined ? 1000 : options.interval);
    })
  }

  return {
    runOrderedTasksSync: runOrderedTasksSync,
    runMultiTasks: runMultiTasks,
    runMultiSingleTasksAsync: runMultiSingleTasksAsync,
    TaskStatus: TaskStatus,
    TaskInfo: TaskInfo,
    AsyncPool: AsyncPool,
    clickable: clickable,
    stage: stage,
  }
}

// assume that the array in multi_command_history.json is ordered
function getMultiCmdOutputDir() {
    try {
        let obj = JSON.parse(top.readTextFile(top.getSupportFile('multi_command_history')));
        let latest_item = obj.History[obj.History.length-1];
        return latest_item['Saved Folder'];
    } catch (e) {
        printLog("ERROR", "Failed to get dir");
    }
}