// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
function appendHtml(filename, containerId) {
    var htmlContent = top.readTextFile(top.pathJoin(top.gl_app_base_path, filename), "utf-8");
    document.getElementById(containerId).innerHTML += htmlContent;
}

// importHtml to a specific location, function enhanced to support templates.
// options: object - two types of options, 1. contains importId, selectorId and hookId, this is to 
//  insert the html content under hookId. 2. contains importId, selectorId, index and title, this is 
//  to dynamically instert a jQuery step.
// returns: no returns
function importHtml(options) {
    if (typeof (options) == "undefined" || options == null) {
        console.log("importHtml doesn't define options");
        return doc;
    }
    var doc = document.querySelector(options.selectorId);
    if (doc == null) {
        appendHtml(options.pageFilename, options.containerId);
        doc = document.querySelector(options.selectorId);
    }
    if (options.title) {
        gl_wizard.steps("insert", options.index, {
            title: options.title,
            content: doc.innerHTML
        });
    } else {
        if (!doc || !doc.innerHTML) {
            console.log("import html error: ", options);
            console.log("doc: ", doc);
        }
        document.querySelector(options.hookId).innerHTML = doc.innerHTML;
    }
}

function goNextStep() {
    $("#navigationbar-vertical").steps("next");
}

// top.gl_task must be set before call configSteps()
function configSteps(newSteps) {
    if (gl_wizard_steps == null) {
        // The order of this array must be same with document id="navigationbar-vertical" in index.html
        gl_wizard_steps = [Welcome, Obtain_Latest_Version, Target_Server, Update_Task
            , Update_Location, Update_Type, Proxy_Setting, Update_Selection
            , Acquire_Updates, Update_Comparison, Update_Execution
            , Finish, Machine_Types, Target_Operating_Systems
            , Target_Directory, OOB_Setting, Raid_Config
            , TShield_Setting, Security_Pack, Task_Complete, Staged_Task
            , Security_Task, Sed_Management, Server_Pool
            , Portal_Activation, Sensor_Configuration, Local_Activation, Direct_Connection_Setting
            , Bios_Mode_Select,Bios_Configure, Bios_Change_View, Bios_Writer, Bios_Export, Bios_Execute
            , Collect_Log, Collect_Log_Setting];
    }

    for (var i=0; i<newSteps.length; i++) {
        if (!newSteps[i]) {
            alert($.i18n.prop("Common.StepNull",i));
            return;
        }
        newSteps[i].index = i;
        var stepFound = false;
        for (var j=i; j< gl_wizard_steps.length; j++){
            if (gl_wizard_steps[j].name == newSteps[i].name) {
                stepFound = true;
                if (j > i) {
                    for (var x = i; x < j; x++) {
                        if(gl_wizard_steps[x].uninit){
                            gl_wizard_steps[x].uninit();
                        }
                        gl_wizard.steps('remove', i);
                    }
                    gl_wizard_steps.splice(i,(j-i));
                }
                break;
            }
        }
        if (!stepFound) {
            importHtml({
                importId: newSteps[i].importId,
                selectorId: newSteps[i].selectorId,
                index: i,
                title: newSteps[i].localizedTitle
            });
            gl_wizard_steps.splice(i, 0, newSteps[i]);
        }
    }
    if (gl_wizard_steps.length > newSteps.length){
        for (i=newSteps.length; i<gl_wizard_steps.length; i++) {
            if(gl_wizard_steps[i].uninit){
                gl_wizard_steps[i].uninit();
            }
            gl_wizard.steps('remove', newSteps.length);
        }
    }
    gl_wizard_steps = newSteps.concat();
    gl_steps_current = gl_wizard_steps.concat();
    initLocale();
    removeDoneStepClass();
    if (top.gl_uxlite_bootable != "1") {
        // anyos does not custom steps
        customConfigStepsUI();
    }
}

function removeDoneStepClass(cIndex){
    if(!cIndex){
        var cIndex = -1;
        $("#navigationbar-vertical").find("li").each(function(i, n){
            var $this = $(this);
            if($this.hasClass("current")){
                cIndex = i;
                return true;
            }
            if(cIndex>-1 && i>cIndex && $this.hasClass("done"))
                $this.removeClass("done").addClass("disabled");
        });
    }else{
        $("#navigationbar-vertical").find("li").each(function(i, n){
            var $this = $(this);
            if(i>cIndex && $this.hasClass("done"))
                $this.removeClass("done").addClass("disabled");
        });
    }
    
}

gl_next_state_changed = null;
gl_previous_state_changed = null;

function togglePrevious(enable) { 
    toggleActionButton("previous", enable); 
    gl_previous_state_changed = enable;
}

function toggleNext(enable) { 
    toggleActionButton("next", enable);
    gl_next_state_changed = enable;
}

function toggleActionButton(buttonId, enable) {
    if (enable) {
        // Enable disabled button
        var button = $("#navigationbar-vertical").find('a[href="#' + buttonId + '-disabled"]');
        button.attr("href", '#' + buttonId);
        button.parent().removeClass();
    }
    else {
        // Disable enabled button
        var button = $("#navigationbar-vertical").find('a[href="#' + buttonId + '"]');
        button.attr("href", '#' + buttonId + '-disabled');
        button.parent().addClass("disabled");
    }
}

function disableAllTab() {
    $("[role='tab']").addClass("disabled");
}

// Return number of steps before executing actual tasks.
// e.g. [Welcome, Target_Server, Create_Repository, Finish] return 2, because user confirms tasks at Target_Server.
// [Welcome, Target_Server, Update_Task, Raid_Config, Finish] return 3, because user confirms tasks at Update_Task.
function countPretasksSteps() {
    let lastIndex = top.gl_steps_current.indexOf(Update_Task);
    if (lastIndex == -1) {
        lastIndex = top.gl_steps_current.indexOf(Target_Server);
    }
    return lastIndex + 1;
}

/**
 * div navigationbar-vertical
 * - index (display -> none)
 * - customIndex (0 -> newly added)
 * - content
 * - actions
 * div end
 */
// Hide origin navigationbar of jquery.step, show our own navigationbar
function customConfigStepsUI() {
    let navDiv = document.getElementById("navigationbar-vertical");
    let customStepDiv;

    let customStepDivId = "customStepsDiv";
    if (document.getElementById(customStepDivId) == null || document.getElementById(customStepDivId) == undefined) {
        navDiv.childNodes[0].style = "display:none;";
        let newDiv = document.createElement("div");
        newDiv.className = "steps";
        newDiv.id = customStepDivId;
        navDiv.insertBefore(newDiv, navDiv.childNodes[1]);
    }
    customStepDiv = document.getElementById(customStepDivId);

    let customSteps = [];
    let counts = countPretasksSteps();
    // As non-task steps, they will be displayed in a normal style.
    for (let i = 0; i < counts; ++i) {
        customSteps.push(top.gl_steps_current[i].localizedTitle);
    }
    // Tasks' steps will be displayed as a whole
    for (let i = 0; i < top.gl_task.length; ++i) {
        customSteps.push(top.gl_tasksName[top.gl_task[i]]);
    }
    customSteps.push(Finish.localizedTitle);

    /**
     * 	<div class="steps">
        <ul>
          <li class="done" id="customStep0">
            <a><span class="number">1.</span> Welcome</a>
          </li>
          <li class="current" id="customStep1">
            <a><span class="number">2.</span> Task</a>
          </li>
          <li class="disabled" id="customStep2">
            <a><span class="number">3.</span> Update<span id="customStepInfo2"></span></a>
          </li>
          <li class="disabled" id="customStep3">
            <a><span class="number">4.</span> Finish</a>
          </li>
        </ul>
      </div>
     */
    let htmlContent = "<ul>";
    for (let i = 0; i < customSteps.length; ++i) {
        htmlContent += "<li class=\"disabled\" id=\"customStep" + i + "\">";
        htmlContent += "<a class=\"clearfix\"><span class=\"number\">" + (i + 1) + ".</span> " + customSteps[i] + "<span style=\"float:right;margin-top:4px;\" id=\"customStepInfo" + i + "\"></span>" + "</a></li>";
    }
    htmlContent += "</ul>";
    customStepDiv.innerHTML = htmlContent;
    highlightStepsUI();
}

function highlightStepsUI() {
    let highlightIndex = 0;
    let currentStep = gl_wizard.data("state").currentIndex;
    if (currentStep < countPretasksSteps()) {
        highlightIndex = currentStep;
    } else {
        highlightIndex = countPretasksSteps() + top.gl_curTaskIndex;
    }
    let totalStepNumber = document.getElementById("customStepsDiv").getElementsByTagName("li").length;
    for (let i = 0; i < highlightIndex; ++i) {
        document.getElementById("customStep" + i).className = "done";
    }
    document.getElementById("customStep" + highlightIndex).className = "current";
    for (let i = highlightIndex + 1; i < totalStepNumber; ++i) {
        document.getElementById("customStep" + i).className = "disabled";
    }
    updateStepsProgress();
}

function updateStepsProgress() {
    if (top.gl_task.length > 0) {
        // e.g. (5/8), now calculate 8
        let stepsNumberOfTask = [];
        let completeIndex = [];
        let tmpArr = top.gl_steps_current.concat();
        let tmpCompleteIndex = -1;
        for (let i = countPretasksSteps(); (tmpCompleteIndex = tmpArr.indexOf(Task_Complete, tmpCompleteIndex + 1)) != -1; i = tmpCompleteIndex + 1) {
            stepsNumberOfTask.push(tmpCompleteIndex - i);
            completeIndex.push(tmpCompleteIndex);
        }
        // e.g. (5/8), now calculate 5
        let currentStep = gl_wizard.data("state").currentIndex;
        let stepIndexOfCurTask = stepsNumberOfTask[top.gl_curTaskIndex] - (completeIndex[top.gl_curTaskIndex] - currentStep - 1)
        // display
        let beg = countPretasksSteps();
        for (let i = 0; i < top.gl_task.length; ++i) {
            if (i >= stepsNumberOfTask.length) {
                break;
            }
            // Add: if a task only contain one step such as (1/1), remove it
            if (stepsNumberOfTask[i] == 1) {
                document.getElementById("customStepInfo" + (beg + i)).innerText = "";
                continue;
            }
            if (i < top.gl_curTaskIndex) {
                document.getElementById("customStepInfo" + (beg + i)).innerText = "(" + stepsNumberOfTask[i] + "/" + stepsNumberOfTask[i] + ")";
            } else if (i > top.gl_curTaskIndex) {
                document.getElementById("customStepInfo" + (beg + i)).innerText = "(0/" + stepsNumberOfTask[i] + ")";
            } else {
                // current case, remove improper value
                if (stepIndexOfCurTask < 0) stepIndexOfCurTask = 0;
                if (stepIndexOfCurTask > stepsNumberOfTask[i]) stepIndexOfCurTask = stepsNumberOfTask[i];
                document.getElementById("customStepInfo" + (beg + i)).innerText = "(" + stepIndexOfCurTask + "/" + stepsNumberOfTask[i] + ")";
            }
        }
    }
}