// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Bios_Execute = function () {

    const { reactive, ref, watch, computed } = Vue

    const taskTool = TaskTool(true, 1);

    let biosExecuteApp = undefined;

    let items_to_be_set = new Array();

    let headers = [
        {
            index: 1,
            title: "",
            width: 15,
        },
        {
            index: 2,
            title: "Setting name",
            width: 30,
        },
        {
            index: 3,
            title: "Set value",
            width: 30,
        },
        {
            index: 4,
            title: "Result",
            width: 25,
        }
    ];

    const generateSettingFile = function (setting_data) {
        return write_config_batch_file_sync(setting_data, "set", "BIOS.", top.getSystemFile("configBatchFile"));
    }

    const generateMultiTaskFile = function (servers) {
        return generate_multi_server_task_file_sync(servers, top.getSystemFile("multiTaskConfig"));
    }

    const readConfigError = function (ip) {
        let obj = {}
        let filepath = top.getSupportFile("config_error", null, ip);
        if (top.fileExists(filepath)) {
            try {
                obj = JSON.parse(top.readTextFile(filepath));
            } catch (e) {
                printLog("ERROR", "Failed to read edgeserverStatus json.");
                return {};
            }
        }
        return obj;
    }

    const deleteConfigError = function (ip) {
        let filepath = top.getSupportFile("config_error", null, ip);
        if (top.fileExists(filepath)) {
            top.deleteFile(filepath);
        }
    }

    const status = ["progress", "stopped", "info", "success", "critical", "warning"];

    const updateErrorInfoInRows = function (table, ti, error_data) {
        let count = table.data.length
        let is_write_error = JSON.stringify(error_data) === '{}';
        const updateRow = function (row, msg) {
            row[0].status = status[4];
            row[0].content = status[4];
            row[3].title = "Error";
            row[3].content = msg;
            row[3].style = {
                "text-decoration": "underline",
                "color": "rgb(45, 108, 191)"
            };
            row[3].classes = "Hoverable";
        }
        for (let row of table.data) {
            if (!is_write_error && error_data["set BIOS." + row[1].attributeName] != undefined) {
                updateRow(row, error_data["set BIOS." + row[1].attributeName]);
                count -= 1;
            } else if(is_write_error) {
                updateRow(row, ti.taskStatus.errmsg);
                count -= 1;
            }
        }
        table.desc = !is_write_error ? "{0} items setting succeed out of {1}".format(count, table.data.length) : ti.taskStatus.errmsg;
    }


    let vue_obj = {
        setup () {
            const button_label = ref("Start");
            let flag = true;
            const start = function () {
                flag = false;
                button_label.value = "Cancel";
            }

            const stop = function () {
                flag = true;
                button_label.value = "Start";
            }
            const effective_method = ref("manually");
            const need_export = ref(false);
            const percentage = ref(0);
            const progress_status = ref('')
            const show_progress = ref(false);
            const desc = reactive({
                proMsg: ''
            })
            const rebooting_status = reactive([]);
            const width = ref(300);

            let taskInfos_for_config = new Array();
            let taskInfos_for_reboot = new Array();
            let tables = reactive(new Array());
            let rows = new Array();

            const startProcess = async function () {
                start();
                show_progress.value = false;
                rows.length = 0;
                width.value = 300;
                setLogFile("");

                for (let item of items_to_be_set) {
                    let index = 1;
                    let row = [
                        {
                            index: index++,
                            status: status[3],
                            content: status[3],
                        },
                        {
                            index: index++,
                            title: item.AttributeName,
                            attributeName: item.AttributeName,
                            content: item.HelpText,
                        },
                        {
                            index: index++,
                            title: item.Value,
                            content: item.Value,
                        },
                        {
                            index: index++,
                            title: "Success",
                            content: "Success",
                        },
                    ];
                    rows.push(row);
                }

                tables.length = 0;
                taskInfos_for_config.length = 0;

                generateSettingFile(items_to_be_set);
                generateMultiTaskFile(Server_Pool.selectedServerList);

                const ip_2_rows = {}
                const ip_2_table = {}
                desc.proMsg = `Writing BIOS configuration... ( 0 / ${Server_Pool.selectedServerList.length} )`
                for (let server of Server_Pool.selectedServerList) {
                    let args_for_config = [
                        top.getSystemFile("oneCli"),
                        "config",
                        "batch",
                        "--bmc",
                        SplitFullConnInfo(server),
                        "--file",
                        top.getSystemFile("configBatchFile"),
                        "--json",
                        "--never-check-trust",
                        ...add_output_log5(Server_Pool.selectedServerList.length == 1 ? undefined : server.ip)
                    ];
                    ip_2_rows[server.ip] = clone(rows);

                    task_info = new taskTool.TaskInfo("BIOSConfigure", args_for_config, (res, ti)=>{
                        if (false === res) {
                            updateErrorInfoInRows(ip_2_table[ti.server.ip], ti, readConfigError(ti.isonly ? null : ti.server.ip));
                        }
                    }, reactive(new taskTool.TaskStatus(tr("Configure BIOS settings."), tr("Configure BIOS settings."))), server);

                    taskInfos_for_config.push(task_info);

                    let _table = {
                        headers: headers,
                        title: server.ip,
                        desc: "{0} items setting succeed out of {1}".format(items_to_be_set.length, items_to_be_set.length),
                        ts: task_info,
                        data: ip_2_rows[server.ip],
                    }

                    ip_2_table[server.ip] = _table;

                    tables.push(_table);

                    deleteConfigError(Server_Pool.selectedServerList.length == 1 ? null : server.ip);
                }

                const options = {
                    concurrent_num: 10,
                    can_not_next_with_failure: false,
                    update_process: (task_infos) => {
                        let count = 0;
                        for (let ti of task_infos) {
                            if (ti.taskStatus.result != undefined) {
                                count++;
                            }
                        }
                        desc.proMsg = `Writing BIOS configuration... ( ${count} / ${Server_Pool.selectedServerList.length} )`;
                    },
                    interval: 1000
                }

                let res = await taskTool.runMultiSingleTasksAsync(taskInfos_for_config, options);

                if (res == "killed") {
                    return;
                } else {
                    stop();
                }

                const update_progress = function (task_infos) {
                    let count = 0;
                    for (let ti of task_infos) {
                        if (ti.taskStatus.isFinished && !ti.taskStatus.isFailed) {
                            count++;
                        }
                    }
                    percentage.value = Math.max(percentage.value, Math.floor((100 / task_infos.length) * count));
                    percentage.value = Math.min(percentage.value + 1, Math.floor(100 / task_infos.length * (count + 1) - 1));
                    if (count == task_infos.length) {
                        percentage.value = 100;
                        progress_status.value = "success";
                    }
                }

                if (effective_method.value == "immediately") {
                    disabled.value = true;
                    start();
                    rebooting_status.length = 0;
                    taskInfos_for_reboot.length = 0;
                    for (let ti of taskInfos_for_config) {
                        let args_for_reboot = [
                            top.getSystemFile("oneCli"),
                            "ospower",
                            "reboot",
                            "--bmc",
                            SplitFullConnInfo(ti.server),
                            "--never-check-trust",
                            ...add_output_log5(taskInfos_for_config.length == 1 ? undefined : ti.server.ip)
                        ]
                        let _ti = new taskTool.TaskInfo("RebootSystem", args_for_reboot, null, reactive(new taskTool.TaskStatus(tr("Rebooting system..."), tr("Reboot system."))), ti.server)
                        if (ti.taskStatus.result == true) {
                            taskInfos_for_reboot.push(_ti);
                            rebooting_status.push(
                                {
                                    ip: _ti.server.ip,
                                    ts: _ti.taskStatus,
                                    desc: ''
                                }
                            )
                        } else {
                            width.value = 500;
                            rebooting_status.push(
                                {
                                    ip: ti.server.ip,
                                    ts: ti.taskStatus,
                                    desc: tr('Failed to write BIOS configuration')
                                }
                            )
                        }
                    }
                    show_progress.value = taskInfos_for_reboot.length > 0;
                    percentage.value = 0;
                    progress_status.value = '';

                    const options = {
                        concurrent_num: 10,
                        can_not_next_with_failure: false,
                        update_process: update_progress,
                        interval: taskInfos_for_reboot.length * 800
                    }

                    res = await taskTool.runMultiSingleTasksAsync(taskInfos_for_reboot, options);
                    if (res == "killed") {
                        return;
                    } else {
                        if (!res){
                            progress_status.value = "warning";
                        }
                        stop();
                        disabled.value = false;
                    }
                }
            }

            const disabled = ref(false);

            const cancelProcess = function () {
                top.killOneCli();
                disabled.value = true;
                desc.proMsg = "Canceling...";
                let handler = setInterval(() => {
                    for (let ti of taskInfos_for_config) {
                        if (ti.taskStatus.isCanceled) {
                            disabled.value = false;
                            stop();
                            clearInterval(handler);
                            return;
                        }
                    }
                }, 500);
            }

            const button_function = function () {
                if (flag) {
                    startProcess();
                } else {
                    cancelProcess();
                }
            }

            return {
                clickable: taskTool.clickable,
                effective_method,
                need_export,
                tables,
                button_label,
                disabled,
                button_function,
                rebooting_status,
                desc,
                show_progress,
                percentage,
                progress_status,
                width,
                tr,
            }
        }
    }

    let init_vue = async function () {
        if (biosExecuteApp == undefined) {
            biosExecuteApp = Vue.createApp(vue_obj);
            const { uxTable } = await import('../Common_Components/UX_Table/UX_Table.js');
            const { taskStatus } = await import('../Common_Components/Task_Status/Task_Status.js');
            biosExecuteApp.component("uxtable", uxTable).component("taskstatus", taskStatus);
            biosExecuteApp.use(ElementPlus);
            biosExecuteApp.mount('#bios_execute_vue');
        }
        items_to_be_set.length = 0;
        let temp = { ...Bios_Configure.BiosChangeData };
        Object.values(temp).forEach(e => {
            items_to_be_set.push({ ...e });
        })
    }

    let uninit = function () {
        if (biosExecuteApp != null || biosExecuteApp != undefined) {
            biosExecuteApp.unmount();
            biosExecuteApp = undefined;
        }
    }

    let init = function () {
        printLog("DEBUG", "Init bios execute app.");
        /* if (taskTool.stage.value == "done") {
            top.toggleNext(true);
            top.togglePrevious(true);
        } else {
            top.toggleNext(false);
            top.togglePrevious(true);
        } */
        top.toggleNext(false);
        top.togglePrevious(true);
        init_vue();
    }

    return {
        index: 0,
        name: "Bios_Execute",
        init: init,
        uninit: uninit,
        nextAction: function () {
            if (top.gl_multi_server_management) top.setLogFile(top.getTempPath4ThisTask());
            return true;
        },
        previousAction: function () {
            return true;
        },
        importId: '#import_bios_execute',
        selectorId: '.bios_execute',
        title: "Navi.BIOSExecute",
        localizedTitle: tr("Navi.BIOSExecute"),
        needReInit: true
    }
}();