// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.

Bios_Change_View = (function () {
    let log = console.log;

    let vue_app = undefined;

    function init() {
        log("init bios change view");
        init_vue();
    }

    let thisPage = Vue.reactive({
        allReady: false,
    });

    async function verify() {
        return true;
    }

    function next() {
        if (thisPage.allReady) {
            return true;
        }
        verify()
            .then((ok) => {
                if (ok) {
                    thisPage.allReady = true;
                    gl_wizard.steps("next");
                }
            })
            .catch((msg) => {
            });
        return false;
    }

    function previous() {
        top.toggleNext(true);
        return true;
    }

    function init_vue() {
        if (vue_app != undefined) {
            return;
        }
        vue_app = Vue.createApp(vue_class);
        vue_app.use(ElementPlus);
        vue_app.mount("#bios_change_view_vue");
    }

    function uninit() {
        if (vue_app != undefined) {
            vue_app.unmount();
            vue_app = undefined;
        }
    }

    function removeItem(item) {
        let index = Bios_Configure.BiosChangeData.indexOf(item);
        if (index >= 0) {
            Bios_Configure.BiosChangeData.splice(index, 1);
        }
        top.toggleNext(Bios_Configure.BiosChangeData.length > 0);
    }

    let vue_class = {
        data() {
            return {
                bios: Bios_Configure.BiosChangeData
            };
        },
        methods: {
            tr: top.tr,
            removeItem: removeItem
        },
        mounted() { },
        watch: {
        },
        computed: {
        },
        directives: {
            focus: {
                mounted(el) {
                    el.focus();
                },
            },
        },
    };

    return {
        index: 0,
        name: "Bios_Change_view",
        init: init,
        nextAction: next,
        previousAction: previous,
        importId: "#import_bios_change_view",
        selectorId: ".bios_change_view_class",
        title: "BIOS Change View",
        localizedTitle: tr("BIOS Change View"),
        uninit: uninit,
    };
})();
