// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.

Bios_Writer = (function () {
    let log = console.log;

    let vue_app = undefined;

    function init() {
        log("init bios write");
        init_vue();
    }

    let thisPage = Vue.reactive({
        allReady: true,
    });

    async function verify() {
        thisPage.allReady = true;
        return true;
    }

    function next() {
        if (thisPage.allReady) {
            return true;
        }
        verify()
            .then((ok) => {
                if (ok) {
                    thisPage.allReady = true;
                    gl_wizard.steps("next");
                }
            })
            .catch((msg) => {
            });
        return false;
    }

    function previous() {
        top.toggleNext(true);
        return true;
    }

    function init_vue() {
        checkNextEnable();
        if (vue_app != undefined) {
            return;
        }
        vue_app = Vue.createApp(vue_class);
        vue_app.use(ElementPlus);
        vue_app.mount("#bios_writer_vue");
    }

    function uninit() {
        if (vue_app != undefined) {
            vue_app.unmount();
            vue_app = undefined;
        }
    }

    async function onBegin() {
        log("Begin clicked ...");
        verify();
        log(effective.Type);
    }

    function checkNextEnable() {
        top.toggleNext(thisPage.allReady);
    }

    let effective = Vue.reactive({
        Type: "immediately"
    });

    let exportType = Vue.reactive({
        Enable: false,
    })

    

    let selectInfo = Vue.reactive({
        fileName: "bios_configure.json",
        onBrowseFile: function () {
            printLog("INFO", "button 'Browse...' was clicked.");
            let _filterType = [{ name: 'Json Files', extensions: ['json'] }];
            let path = window.xpress.showOpenDialogFile(this.fileName, _filterType);
            if (path && path[0]) {
                this.fileName = path[0];
            }
        }
    })

    let vue_class = {
        data() {
            return {
                thisPage: thisPage,
                effective: effective,
                selectInfo: selectInfo,
                exportType: exportType
            };
        },
        methods: {
            tr: top.tr,
            onBegin: onBegin
        },
        mounted() { },
        watch: {
            "thisPage.allReady": checkNextEnable
        },
        computed: {
        },
        directives: {
            focus: {
                mounted(el) {
                    el.focus();
                },
            },
        },
    };

    return {
        index: 0,
        name: "Bios_Writer",
        init: init,
        nextAction: next,
        previousAction: previous,
        importId: "#import_bios_writer",
        selectorId: ".bios_writer_class",
        title: "BIOS Write",
        localizedTitle: tr("BIOS Write"),
        uninit: uninit,
    };
})();
