// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Collect_Log_Setting = function () {

    let vue_class = {
        data() {
            return {
                currentPage: currentPage,
                logCollect: logCollect,
                logDir: logDir
            };
        },
        methods: {
            tr: top.tr
        },
        watch: {
            logCollect: {
                immediate: true,
                deep: true,
                handler (newVal) {
                    top.toggleNext(newVal.bmcLog || newVal.ffdcLog);
                }
            }
        },
        directives: {
            focus: {
                mounted(el) {
                    el.focus();
                }
            }
        }
    };

    let log = console.log;

    let currentPage = Vue.reactive({
        vue_app: undefined,
        init: function () {
            logDir.path = top.pathJoin(top.gl_base_path, "Logs");
        }
    });

    let logDir = Vue.reactive({
        path: "",
        chooseDir: function () {
            var dir = window.xpress.showOpenDialog(this.path);
            if (dir && dir[0]) {
                this.path = dir[0];
                console.log(dir);
            }
        }
    })

    let logCollect = Vue.reactive({
        bmcLog: false,
        ffdcLog: false
    })

    function init() {
        printLog("INFO", "Collect Log Setting page init.");
        init_vue();
    };

    async function init_vue() {
        if (currentPage.vue_app) {
            return;
        }
        currentPage.init();
        currentPage.vue_app = Vue.createApp(vue_class);
        currentPage.vue_app.mount('#collect_log_setting_vue');
    }

    function uninit() {
        if (!currentPage.vue_app) {
            return;
        }
        currentPage.vue_app.unmount();
        currentPage.vue_app = undefined;
    }

    function next() {
        log("next click in update task page.");
        let ret = validatePath(logDir.path);
        if(ret != "success") {
			if(ret == $.i18n.prop("Common.UnavailablePath")) {
				if(confirm($.i18n.prop("TargetDirectory.DirectoryNotExist"))) {
					createDirectory(logDir.path);
					if(!directoryExists(logDir.path)) {
						alert($.i18n.prop("Common.CreatePathFailure"));
						return false;
					}
				} else {
					return false;
				}
			} else {
				alert(ret);
				return false;
			}
		}
        if (!top.isFloderEmpty(logDir.path)) {
            if(!confirm(tr("Current files may be overwritten because the target folder is not empty. Do you want to continue?"))) {
                return false;
            }
        }
        Collect_Log_Setting.collectSetting = {
            isCollectBMCLog: logCollect.bmcLog,
            isCollectFFDC: logCollect.ffdcLog,
            outputDir: logDir.path
        }
        return true;
    }

    function previous() {
        top.toggleNext(true);
        return true;
    }

    return {
        index: 0,
        name: "Collect_Log_Setting",
        init: init,
        nextAction: next,
        previousAction: previous,
        importId: '#import_collect_log_setting',
        selectorId: '.collect_log_setting',
        title: "Collect Log Setting",
        localizedTitle: tr("Collect Log Setting"),
        collectSetting: {},
        uninit: uninit
    }
}();