// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
export let switchButton = function () {

    const { ref, reactive, watch } = Vue
    /* 
    settings: {
        name: "xxx",
        label: ['Enable', 'Disable'],
        default: false,
        hasTip: true,
        tip: "xxx",
    }
     */
    return {
        props: ['settings'],
        emits: ['option'],
        setup (props, ctx) {
            const tipsStyle = reactive({
                'position': 'fixed'
            });

            const on = ref(false);
            on.value = props.settings.value;
            watch(on, (n) => {
                ctx.emit('option', n);
            })

            watch(() => props.settings.value, (n) => {
                on.value = n;
            })

            const show = ref(false);

            const showFloatingIntro = function (e) {
                let elemRect = e.currentTarget.getBoundingClientRect();
                tipsStyle.top = (elemRect.top + 20) + "px";
                tipsStyle.left = (elemRect.left + 20) + "px";
                tipsStyle.width = (document.body.clientWidth - elemRect.left - 40) + "px";
                show.value = true;
            }

            const hideFloatingIntro = function () {
                show.value = false;
            }

            props.settings.id = Math.random();

            return {
                settings: props.settings,
                on,
                tipsStyle,
                showFloatingIntro,
                hideFloatingIntro,
                show,
                tr
            }
        },
        template: readTextFile(appBasePath() + '/js/ext/Common_Components/Switch_Button/Switch_Button.html')
    }
}();