// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.

Direct_Connection_Setting = (function () {
  let log = console.log;

  let vue_app = undefined;

  let local_network_file = top.pathJoin(top.getEnv("TMP"), "onecli_discover_network_info.json");
  let crypt_temp_file = top.pathJoin(top.basePath(), "multi_server.json");
  let PASSWORD_NEED_RESET = 54;

  function init() {
    log("init direct connection setting");
    init_vue();
  }

  function getConnectionData(){
    Server_Pool.selectedServerList = [{
      ip: bmcInfo.ip,
      port: bmcInfo.port,
      userName: bmcInfo.userName,
      mt: bmcInfo.mt,
      sn: bmcInfo.sn
    }];
    top.gl_multi_server_management = false;
  }

  function next() {
    if (bmcInfo.verifyOk) {
      getConnectionData();
      return true;
    }
    oneCli.isRunning = true;
    verifyConnect()
      .then((ok) => {
        oneCli.isRunning = false;
        if (ok) {
          oneCli.verifyOk = true;
          oneCli.runInfo = "";
          gl_wizard.steps("next");
        }
      })
      .catch((msg) => {
        oneCli.isRunning = false;
        oneCli.runInfo = "";
        errorInfo.info = msg;
      });
    return false;
  }

  function previous() {
    top.toggleNext(true);
    return true;
  }

  function init_vue() {
    checkNextButton();
    if (vue_app != undefined) {
      return;
    }
    vue_app = Vue.createApp(vue_class);
    vue_app.use(ElementPlus);
    vue_app.mount("#direct_connection_setting_vue");
    oneCli.isRunning = true;
    getAdapterInfo()
      .then(() => { oneCli.isRunning = false; })
      .catch(() => { oneCli.isRunning = false; });
  }

  function uninit() {
    if (vue_app != undefined) {
      vue_app.unmount();
      vue_app = undefined;
    }
  }

  function showOnecliFailInfo(msg = tr("Execute onecli command fail."), stderr = "") {
    let commonResult = top.getSupportFile("commonResult");
    let xmlContent = top.readTextFile(commonResult);
    errorInfo.info = msg;
    if (!xmlContent) {
      errorInfo.info = msg;
      errorInfo.detail = stderr;
      return;
    }
    let comm_dom = ezJsLib.XmlDom.parse(xmlContent);
    if ("Yes" == ezJsLib.XmlDom.getValueByTagFromNode("ERROR", comm_dom.documentElement)) {
      errorInfo.detail = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", comm_dom.documentElement);
      errorInfo.code = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", comm_dom.documentElement);
    }
  }

  let getConnectionInfo = function (ip, port, userName) {
    if (ip.includes(":")) {
      if (port && port != "") {
        return (userName + "@[" + ip + "]:" + port);
      } else {
        return (userName + "@[" + ip + "]");
      }
    } else {
      if (port && port != "") {
        return (userName + "@" + ip + ":" + port);
      } else {
        return (userName + "@" + ip);
      }
    }
  }

  function onChangePassword(ip, port, userName, newPassword) {
    oneCli.isRunning = true;
    ChangePassword(ip, port, userName, newPassword)
      .then(() => { oneCli.isRunning = false; })
      .catch(() => { oneCli.isRunning = false; });
  }

  async function ChangePassword(ip, port, userName, newPassword) {
    let args = [
      top.getSystemFile("oneCli"),
      "misc",
      "bmcpassword",
      "--bmc",
      getConnectionInfo(ip, port, userName),
      "--never-check-trust",
      "--newpwd",
      newPassword,
      "--quiet",
      ...add_output_log5(),
    ];
    oneCli.isRunning = true;
    oneCli.runInfo = "Change password...";
    let result = await oneCli.start(args);
    oneCli.isRunning = false;
    oneCli.runInfo = "";
    if (result.success) {
      bmcInfo.mustChangePassword = false;
      bmcInfo.password = newPassword;
    }
  }

  async function encrypt(ip, port, userName, password) {
    if (!userName || !password || !ip) {
      return false;
    }
    let multiData = {
      connection_credentials: {
        "default_alias": userName + ":" + password
      },
      target_systems: [
        ip + (port ? ":" + port : "")
      ]
    }
    try {
      top.writeTextFile(crypt_temp_file, JSON.stringify(multiData, null, 2));
      let args = [];
      args.push(top.getSystemFile("oneCli"));
      args.push("encrypt");
      args.push("--configfile");
      args.push(crypt_temp_file);
      args.push("--unattended");
      args.push("-q");
      args.push(...add_output_log5(ip));
      top.store_onecli_command(args);
      printLog("INFO", "run command:" + getRunProgramCommend(args));
      top.deleteFile(top.getSupportFile("commonResult"));
      result = await runProgram(args, null);
      if (!result.success) {//if file format error occurred, try to restore it.
        top.deleteFile(top.getSupportFile("commonResult"));
        return false;
      }
      bmcInfo.encryptOk = true;
      return true;
    } catch (e) {
      log(e);
    }
    return false;
  }

  async function discoverBMC() {
    let args = [
      top.getSystemFile("oneCli"),
      "discover",
      "--ip",
      bmcInfo.ip,
      "--noslp",
      "--noslpdiscover",
      "--nossdp",
      "--timeout",
      5,
      ...add_output_log5(),
    ];
    let discoverFileName = top.getSupportFile("discoverResult");
    top.deleteFile(discoverFileName);
    let result = await oneCli.start(args);
    if (!result.success) {
      return false;
    }
    let rootObj = JSON.parse(top.readTextFile(discoverFileName));
    top.deleteFile(discoverFileName);
    if (rootObj.List.length == 1) {
      bmcInfo.mt = rootObj.List[0].MT;
      bmcInfo.sn = rootObj.List[0].SN;
    }
    Banner.set_active_status(bmcInfo.mt, top.gl_current_os_d);
    return rootObj.Find == 1;
  }

  async function checkBmcAccount() {
    let args = [
      top.getSystemFile("oneCli"),
      "ux",
      "check-bmc-account",
      "--bmc",
      getConnectionInfo(bmcInfo.ip, null, bmcInfo.userName),
      "--never-check-trust",
      "--noping",
      ...add_output_log5(),
    ];
    let result = await oneCli.start(args);
    if (result.success) {
      return true;
    }
    if (result.errorCode == PASSWORD_NEED_RESET) {
      bmcInfo.mustChangePassword = true;
    } else {
      showOnecliFailInfo(tr("Connect to BMC fail."), result.stderr);
    }
    return false;
  }

  async function doScan() {
    let args = [];
    args.push(top.getSystemFile("oneCli"));
    args.push("update");
    args.push("scan");
    args.push("--bmc");
    args.push(getConnectionInfo(bmcInfo.ip, null, bmcInfo.userName));
    args.push("--never-check-trust");
    args.push(...add_output_log5());
    args.push("--skipfw");
    top.store_onecli_command(args);
    return oneCli.start(args);
  }

  async function getAdapterInfo() {
    let args = [
      top.getSystemFile("oneCli"),
      "ux",
      "network",
      ...add_output_log5(),
    ];
    let result = await oneCli.start(args);
    if (!result.success) {
      return false;
    }
    try {
      let data = top.readTextFile(local_network_file);
      let rootObj = JSON.parse(data);
      adapterInfo.list = [];
      for (let item of rootObj) {
        let adapterItem = {
          Id: item.ID,
          MAC: item.MAC,
          IP: [],
          Name: item.Name,
          Description: item.Description,
          LinkState: item.LinkState
        };
        for (let v of item.IP) {
          adapterItem.IP.push(v[0]);
        }
        adapterInfo.list.push(adapterItem);
        if (adapterItem.IP.length > 0 && (adapterItem.IP[0].startsWith("169") || adapterItem.IP[0].startsWith("192.168.70.1"))) {
          adapterInfo.currentId = adapterItem.Id;
        }
        if (adapterItem.currentId == -1 && adapterItem.LinkState === "Up") {
          adapterInfo.currentId = adapterItem.Id;
        }
      }
      if (adapterInfo.currentId == -1 && adapterInfo.list.length > 0) {
        for (let item of adapterInfo.list) {
          if (item.LinkState === "Up") {
            adapterInfo.currentId = item.Id;
            break;
          }
        }
      }
      if (rootObj.length == 0) {
        return false;
      }
    } catch (exp) {
      printLog("ERROR", exp);
      return false;
    }
    return true;
  }

  async function addIPToAdapter() {
    errorInfo.reset();
    let items = bmcInfo.ip.split(".");
    if (items.length != 4) {
      errorInfo.info = "IP address format error.";
      return false;
    }
    if (items[3] == "1") {
      items[3] = "2";
    } else {
      items[3] = "1";
    }
    let ip = items.join(".");
    let args = [
      top.getSystemFile("oneCli"),
      "ux",
      "addip",
      "--network-id",
      adapterInfo.currentId,
      "--ip",
      ip,
      ...add_output_log5()
    ]
    top.store_onecli_command(args);
    printLog("INFO", "run command:" + getRunProgramCommend(args));
    let result = await top.runProgram(args);
    if (!result.success) {
      showOnecliFailInfo("Add IP to adapter fail", result.stderr);
    }
    args = [
      top.getSystemFile("oneCli"),
      "ux",
      "restore",
      ...add_output_log5()
    ];
    top.setCleanCommand(args);
    return result.success;
  }

  async function restoreAdapter() {
    errorInfo.reset();
    let args = [
      top.getSystemFile("oneCli"),
      "ux",
      "restore",
      ...add_output_log5()
    ]
    top.store_onecli_command(args);
    printLog("INFO", "run command:" + getRunProgramCommend(args));
    let result = await top.runProgram(args);
    if (!result.success) {
      showOnecliFailInfo("Restore adapter fail", result.stderr);
    }
    return result.success;
  }

  async function verifyConnect() {
    log("verify connect clicked");
    errorInfo.reset();
    let result = false;
    if (!bmcInfo.encryptOk) {
      oneCli.runInfo = "Encrypt password...";
      result = await encrypt(bmcInfo.ip, null, bmcInfo.userName, bmcInfo.password);
      if (!result) return false;
    }
    oneCli.runInfo = "";
    oneCli.runInfo = tr("Try to connect BMC...");
    result = await discoverBMC();
    if (result) {
      oneCli.runInfo = "";
      oneCli.runInfo = tr("Check username and password by BMC...");
      result = await checkBmcAccount();
      if (result) {
        bmcInfo.verifyOk = true;
        return true;
      }
      return false;
    }
    await restoreAdapter();
    if (adapterInfo.list.length == 0) {
      errorInfo.info = tr("No valid ethernet adapters found.");
      return false;
    }
    if (adapterInfo.currentId == -1 && adapterInfo.list.length > 1) {
      errorInfo.info = tr("Please select a valid adapter first.");
      return false;
    }
    oneCli.runInfo = "";
    oneCli.runInfo = tr("Add IP address to adapter...");
    result = await addIPToAdapter();
    if (!result) return false;
    oneCli.runInfo = "";
    oneCli.runInfo = tr("Get adapter info...");
    result = await getAdapterInfo();
    if (!result) return false;
    oneCli.runInfo = "";
    oneCli.runInfo = tr("Try to connect BMC...");
    result = await discoverBMC();
    if (result) {
      oneCli.runInfo = "";
      oneCli.runInfo = tr("Check username and password by BMC...");
      result = await checkBmcAccount();
      if (!result) {
        return false;
      }
    }
    if (!result) {
      errorInfo.info = tr("Connect to BMC fail.");
      errorInfo.detail = tr("Please check the network is connect to BMC correctly, and make sure the machine is powered on.");
      return false;
    }
    bmcInfo.verifyOk = true;
    return true;
  }

  function onVerifyConnect() {
    oneCli.isRunning = true;
    verifyConnect()
      .then((ok) => {
        oneCli.isRunning = false; oneCli.verifyOk = ok;
        oneCli.runInfo = "";
      })
      .catch((msg) => {
        oneCli.isRunning = false;
        errorInfo.info = msg;
        oneCli.runInfo = "";
      })
  }

  function checkNextButton() {
    bmcInfo.encryptOk = false;
    bmcInfo.verifyOk = false;
    if (!bmcInfo.userName || !bmcInfo.password) {
      top.toggleNext(false);
      return false;
    }
    if (bmcInfo.mustChangePassword) {
      top.toggleNext(false);
      return false;
    }
    top.toggleNext(true);
    return true;
  }

  function canChangedPassword() {
    if (bmcInfo.newPassword1 == '' || bmcInfo.newPassword1 != bmcInfo.newPassword2) {
      return false;
    }
    return true;
  }

  let bmcInfo = Vue.reactive({
    ip: "192.168.70.125",
    userName: "",
    password: "",
    mustChangePassword: false,
    verifyOk: false,
    newPassword1: "",
    newPassword2: "",
    encryptOk: false,
    showPasswordTips: false,
    mt:"",
    sn:"",
    verifyIp: function () {
      return top.isIPV4(this.ip);
    },
    validPassword: function () {
      regex = /^(?!.*(.)\1\1)(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\W_]+$)(?![a-z0-9]+$)(?![a-z\W_]+$)(?![0-9\W_]+$)(?![a-zA-Z\W_]+$)[a-zA-Z0-9\W_]{10,32}$/;
      return regex.test(this.newPassword1);
    }
  });

  let oneCli = Vue.reactive({
    isRunning: false,
    args: [],
    runInfo: "",
    Kill: function () {
      top.killOneCli();
    },
    start: async function (args) {
      deleteFile(top.getSupportFile("commonResult"));
      this.args = args;
      printLog("INFO", "run command:" + getRunProgramCommend(args));
      return top.runProgram(args);
    },
  });

  let errorInfo = Vue.reactive({
    info: "",
    code: 0,
    detail: "",
    reset: function () {
      (this.info = ""), (this.code = 0);
      this.detail = "";
    },
  });

  let adapterInfo = Vue.reactive({
    currentId: -1,
    list: [],
    setCurrentId: function (item) {
      if (item.ConnectState != "Up") return;
      this.currentId = item.Id;
    }
  });

  function userNameOrPasswordChanged(){
    bmcInfo.mustChangePassword = false;
    checkNextButton();
  }

  let vue_class = {
    data() {
      return {
        bmcInfo: bmcInfo,
        errorInfo: errorInfo,
        oneCli: oneCli,
        adapterInfo: adapterInfo
      };
    },
    methods: {
      tr: top.tr,
      onVerifyConnect: onVerifyConnect,
      onChangePassword: onChangePassword,
      onGetAdapterInfo: function () {
        oneCli.isRunning = true;
        getAdapterInfo()
          .then(() => { oneCli.isRunning = false; })
          .catch(() => { oneCli.isRunning = false; })
      }
    },
    mounted() { },
    watch: {
      "bmcInfo.userName": userNameOrPasswordChanged,
      "bmcInfo.password": userNameOrPasswordChanged,
      "bmcInfo.mustChangePassword": checkNextButton
    },
    computed: {
      canChangedPassword: canChangedPassword,
      allInputValid: checkNextButton
    },
    directives: {
      focus: {
        mounted(el) {
          el.focus();
        },
      },
    },
  };

  return {
    index: 0,
    name: "Direct_Connection_Setting",
    init: init,
    nextAction: next,
    previousAction: previous,
    importId: "#import_direct_connection_setting",
    selectorId: ".direct_connection_setting",
    title: "Direct Connection",
    localizedTitle: tr("Direct Connection"),
    uninit: uninit,
  };
})();
