// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Finish = function() {

	var logFileName = "";
	var logFileFullName = "";
	var chosedUsb = "";
	var usbPartition = 1;
	var mountPoint = "/var/usb";
	var sftpAddr = "";
	var sftpPort = 22;
	var sftpUser = "";
	var sftpPass = "";
	var validErrMsg = "";
	var upLogSuccess = false;
	var saveLogSuccess = false;
	var needSaveLog = false;
	var needUpLog = false;
	var tagLogSFTPCheckDefault = false;
	var certLogSFTPSaveFile = '';
	var certLogSFTPSaveContent;
	var certLogSFTPTempFile = '';
	var certLogSFTPTempContent;
	var certLogNewSFTP = false;

	let selectedTaskId = 0;

	function finish_init() {
		printLog("INFO","Finish page init.");
		logFileFullName = "";
		chosedUsb = "";
		certLogNewSFTP = false;
		certLogSFTPTempFile = top.pathJoin(top.getSupportDir(), "LogSFTP_Cert.txt");

		// Common content
		document.getElementById("completeMsg").innerHTML = "<img src='images/statusInformation_obj16.gif'> ";
		if (top.gl_task.indexOf(top.gl_isUpdate) != -1 && top.gl_needPrereqWarn) {
			document.getElementById("completeMsg").innerHTML += $.i18n.prop("Finish.PrereqWarn");
		} else {
			document.getElementById("completeMsg").innerHTML += $.i18n.prop("Finish.UpdateComplete");
		}
		if (top.gl_task.indexOf(top.gl_isUpdate) != -1 && true == top.gl_isValidUefiUpdate) {
			document.getElementById("completeMsg").innerHTML += "<BR><BR><img src='images/statusInformation_obj16.gif'> ";
			document.getElementById("completeMsg").innerHTML += $.i18n.prop("Finish.UEFIUpdate");
		}
		document.getElementById("externalButton").innerHTML = "<BR><button href='javascript:void 0' onclick='Finish.dumpLog()'>"+$.i18n.prop("Finish.ViewLog")+"<\/button>";

		document.getElementById("externalButton").innerHTML += "<button href='javascript:void 0' id='logbutton' onclick='Finish.showSaveUpLogModal()'>Save Log<\/button>";
		top.gl_curTaskIndex = 0;

		if (top.getEnv("BOMC_UNATTENDED_MODE")) top.Exit(false);
	}

	function dumpLog() {
		printLog("INFO","button 'View Log' was clicked.");
		// remove the alert since nw.js does not support CTRL + W to close the window
		// 20160921 by chenhao9
		// alert("The log will be brought up in a separate browser window.\nPress \"Ctrl + w\" to return.");
		let mywidth = 600;
		let myheight = 400;
		let myleft = (screen.width - mywidth) / 2;
		let mytop = (screen.height - myheight) / 2;
		let logOpts = 'width=' + mywidth + ', height=' + myheight;
		logOpts += ', top=' + mytop + ', left=' + myleft;
		logOpts += ', directories=no';
		logOpts += ', location=no';
		logOpts += ', menubar=yes';
		logOpts += ', resizable=yes';
		logOpts += ', scrollbars=yes';
		logOpts += ', status=no';
		logOpts += ', toolbar=no';
		logOpts += ', close=yes';
		logOpts += ', show=true';
		logOpts += ', title=Lenovo XClarity Essentials UpdateXpress';
		let logContent = "";
		if (getLogFile(selectedTaskId) == null || getLogFile(selectedTaskId) == undefined || getLogFile(selectedTaskId) == "") {
			logContent = "<HTML><BODY><PRE>" + $.i18n.prop("Finish.NoLogFound") + "<\/PRE><\/BODY><\/HTML>";
			top.writeTextFile(top.getSupportFile("logHtml"), logContent);
		} else {
			logContent = top.readTextFile(top.pathJoin(top.getSupportDir(), getLogFile(selectedTaskId)), "null");
			// It may cause error-codes
			// logContent = "<HTML><BODY><PRE>" + logContent + "<\/PRE><\/BODY><\/HTML>";
			top.writeTextFile(top.getSupportFile("logHtml"), "<HTML><BODY><PRE>");
			top.writeTextFile(top.getSupportFile("logHtml"), logContent, 'a');
			top.writeTextFile(top.getSupportFile("logHtml"), "<\/PRE><\/BODY><\/HTML>", 'a');
		}
		let logWindow = window.open("file://" + top.getSupportFile("logHtml"), "", logOpts);
		if (window.focus) logWindow.focus();
	}

	/**
	 * Below functions are for ELIE(upload logs, etc)
	 */
	function toggleSftpDiv() {
		if ($("#upLogCheck").prop("checked")) {
			$("#upLogDiv").show();
			needUpLog = true;
		} else {
			$("#upLogDiv").hide();
			needUpLog = false;
		}
	}

	function toggleUsbDiv() {
		if ($("#saveToUsbCheck").prop("checked")) {
			getUsbInfo();
		} else {
			$("#saveToUsbDiv").hide();
			needSaveLog = false;
		}
	}

	function showSaveUpLogModal() {
		$("#saveUpLogModal").modal("show");
		$("#contentDiv").show();
	}

	function hideSaveUpLogModal() {
		$("#saveUpLogModal").modal("hide");
	}

	function getUsbInfo() {
		querySystemInfo(getUsbInfoCb);
	}

	function checkTotalInput() {
		if (!needSaveLog && !needUpLog) {
			alert("Please select an option. ");
			return;
		}
		// check input of sftp server
		if (needUpLog) {
			if (!checkSftpInfo()) {
				return false;
			}
		}
		$("#validErr").html("");
		$("#progressDiv").show();
		$("#progressPic").show();
		$("#contentDiv").hide();
		saveLogSuccess = false;
		upLogSuccess = false;
		copySysLog();
	}

	function startSaveUpLog(success) {
		if (!success) {
			alert("Failed to create log file. Please try again. ");
			completeSaveUp();
			return;
		}
		if (needSaveLog) {
			usbPartition = 1;
			copyLogFileToUsb();
		}
		else if (needUpLog) {
			tagLogSFTPCheckDefault?upLogToSftpSvr():getLogSFTPCert();
		}
	}

	function checkSftpInfo() {
		// init
		validErrMsg = "";
		// collect input
		sftpAddr = $("#sftpAddr").val().trim();
		sftpPort = $("#sftpPort").val().trim();
		if (sftpPort == "" || sftpPort == null || sftpPort == undefined) {
			sftpPort = 22;
		}
		sftpUser = $("#sftpUser").val().trim();
		sftpPass = $("#sftpPass").val().trim();
		sftpPath = $("#sftpPath").val().trim();
		// validate input
		if (!validSftpAddr()) {
			$("#validErr").html(validErrMsg);
			return false;
		}
		if (!validSftpPort()) {
			$("#validErr").html(validErrMsg);
			return false;
		}
		if (!validSftpUser()) {
			$("#validErr").html(validErrMsg);
			return false;
		}
		if (!validSftpPass()) {
			$("#validErr").html(validErrMsg);
			return false;
		}
		if (!validRemotePath()) {
			$("#validErr").html(validErrMsg);
			return false;
		}
		return true;
	}

	function getUsbInfoCb(success) {
		if (!success) {
			alert($.i18n.prop("Finish.FailedToGetUSBInfo"));
			needSaveLog = false;
			$("#saveToUsbDiv").hide();
			$("#saveToUsbCheck").attr("checked", false);
			return;
		} else {
			// top.gl_properties_info = top.parsePropertiesFile(top.gl_basic_info_file);
			var usbInfo = top.gl_properties_info["IBM_SYSTEM_USBDISK"];
			if (usbInfo == "NULL" || usbInfo == "") {
				alert($.i18n.prop("Finish.NoUSBFound"));
				needSaveLog = false;
				$("#saveToUsbDiv").hide();
				$("#saveToUsbCheck").attr("checked", false);
				return;
			} else {
				if (usbInfo[usbInfo.length - 1] == ";") {
					// remove the ";" at the end of this string
					usbInfo = usbInfo.slice(0, usbInfo.length - 1);
				}
				top.gl_usbInfoArray = usbInfo.split(";");
				createDeviceList();
				needSaveLog = true;
				$("#saveToUsbDiv").show();
			}
		}
	}

  	function createDeviceList() {
	    var deviceContainer = document.getElementById("deviceOptions");
	    // empty the select element
	    deviceContainer.length = 0;

	    // for (var i = 0; i < top.usbListLength; i++) {
	    for (var i = 0; i < top.gl_usbInfoArray.length; i++) {
			var perUSB = new Option();
			// var value_d = top.usbDeviceList[i].childNodes[0].nodeValue;
			// var value_disk = top.usbDiskList[i].childNodes[0].nodeValue;
			var valueDisk = top.gl_usbInfoArray[i];
			perUSB.value = valueDisk;
			perUSB.text = valueDisk;
			perUSB.innerHTML = perUSB.text;
			deviceContainer.appendChild(perUSB);
	    }
  	}

	function validSftpAddr() {
		// valid not null
		if (sftpAddr == "" || sftpAddr == null || sftpAddr == undefined) {
			validErrMsg = $.i18n.prop("Common.RquiredField");
			return false;
		}
		// valid correction
		var expHostName = /((^\s*((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))\s*$)|(^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$))|(^\s*((?=.{1,255}$)(?=.*[A-Za-z].*)[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?)*)\s*$)/;
		var flag = expHostName.test(sftpAddr);
		if (!flag) {
			validErrMsg = $.i18n.prop("Common.IllegalServerAddress");
			return false;
		}
		return true;
	}

	function validSftpPort() {
		sftpPort = parseInt(sftpPort);
		if (isNaN(sftpPort) || sftpPort < 1 || sftpPort > 65535) {
			validErrMsg = $.i18n.prop("Common.Port.Warning");
			return false;
		}
		return true;
	}

	function validSftpUser() {
		if (sftpUser == "" || sftpUser == null || sftpUser == undefined) {
			validErrMsg = $.i18n.prop("Common.RquiredField");
			return false;
		}
		return true;
	}

	function validSftpPass() {
		if (sftpPass == "" || sftpPass == null || sftpPass == undefined) {
			validErrMsg = $.i18n.prop("Common.RquiredField");
			return false;
		}
		return true;
	}

	function validRemotePath() {
		if (sftpPath == "" || sftpPath == null || sftpPath == undefined) {
			validErrMsg = $.i18n.prop("Common.RquiredField");
			return false;
		}
		return true;
	}

	function copySysLog() {
		var args = new Array();
		args.push(top.getSystemFile("copySysLog"));
		var dstFolder = top.getSupportDir();
		args.push(dstFolder);
		runProgram(args, null, createLogFile);
	}

	function createLogFile(success) {
		if (!success) {
			alert("Failed to copy system log file. Dmesg will not be included in the log. ");
		//	completeSaveUp();
		//	return;
		}
		var args = new Array();
		args.push(top.getSystemFile("createLog"));
		var currentDate = (new Date()).getTime();
		logFileName = "UpdateGui_" + currentDate + ".tgz";
		if (top.gl_base_path[top.gl_base_path.length - 1] != "/") {
			logFileFullName = top.gl_base_path + "/" + logFileName;
		} else {
			logFileFullName = top.gl_base_path + logFileName;
		}
		args.push(top.gl_base_path);
		args.push(logFileFullName);
		runProgram(args, null, startSaveUpLog);
	}

	function copyLogFileToUsb() {
		chosedUsb = document.getElementById("deviceOptions").value;
		var args = new Array();
		args.push(top.getSystemFile("copyLog"));
		args.push(mountPoint + usbPartition);
		args.push(logFileFullName);
		args.push(chosedUsb + usbPartition);
		runProgram(args, null, copyToUsbCb);
	}

	function copyToUsbCb(success) {
		if (!success) {
			if (usbPartition > 9) {
				saveLogSuccess = false;
				if (!needUpLog) completeSaveUp();
				else tagLogSFTPCheckDefault?upLogToSftpSvr():getLogSFTPCert();
			} else {
				usbPartition++;
				copyLogFileToUsb();
			}
		} else {
			saveLogSuccess = true;
			if (!needUpLog) completeSaveUp();
			else tagLogSFTPCheckDefault?upLogToSftpSvr():getLogSFTPCert();
		}
	}

	function upLogToSftpSvr() {
		var localPath = logFileFullName;
		if (sftpPath[sftpPath.length - 1] != "/") {
			sftpPath += "/";
		}
		var remotePath = sftpPath + logFileName;
		var args = new Array();
		args.push("curl");
		args.push("-u");
		args.push(sftpUser+":"+sftpPass);
		args.push("-T");
		args.push(localPath);
		if (sftpAddr[0] != "[" && sftpAddr.indexOf(":") != -1) {
			args.push("sftp://["+sftpAddr+"]:"+sftpPort+remotePath);
		} else {
			args.push("sftp://"+sftpAddr+":"+sftpPort+remotePath);
		}
		args.push("-k");
		runProgram(args, null, copyToSftpCb);
	}

	function copyToSftpCb(success) {
		upLogSuccess = success;
		completeSaveUp();
	}

	function completeSaveUp() {
		if (needSaveLog) {
			if (saveLogSuccess) {
				$("#saveSuccessMsg").show();
				$("#saveFailMsg").hide();
			} else {
				$("#saveSuccessMsg").hide();
				$("#saveFailMsg").show();
			}
		} else {
			$("#saveSuccessMsg").hide();
			$("#saveFailMsg").hide();
		}
		if (needUpLog) {
			if (upLogSuccess) {
				$("#upSuccessMsg").show();
				$("#upFailMsg").hide();
			} else {
				$("#upSuccessMsg").hide();
				$("#upFailMsg").show();
			}
		} else {
			$("#upSuccessMsg").hide();
			$("#upFailMsg").hide();
		}
		$("#upLogFinish").show();
		$("#progressPic").hide();
		$("#contentDiv").hide();
	}

	function saveUpLogConfirm() {
		$("#progressDiv").hide();
		$("#saveSuccessMsg").hide();
		$("#saveFailMsg").hide();
		$("#upSuccessMsg").hide();
		$("#upFailMsg").hide();
		$("#upLogFinish").hide();
		hideSaveUpLogModal();
	}

	function checkLogSFTPDefault() {
		$("#acceptLogSFTPCertDefault").attr("checked", !$("#acceptLogSFTPCertDefault").attr("checked"));
		tagLogSFTPCheckDefault = !tagLogSFTPCheckDefault;
		printLog("INFO","check box 'Accept SFTP server's key fingerprint by default.' " + (tagLogSFTPCheckDefault?"checked.":"unchecked."));
	}

	function getLogSFTPCert() {
		var args = new Array();
    	args.push(top.getSystemFile("oneCli"));
    	args.push("misc");
    	args.push("gettrust");
    	args.push("--host");
    	args.push(sftpAddr);
    	args.push("--port");
    	if (sftpPort == "" || sftpPort == undefined || sftpPort == null) {
    		args.push("22");
    	} else {
    		args.push(sftpPort);
    	}
    	args.push("--type");
    	args.push("sftp");
    	args.push("--result");
    	certLogSFTPSaveFile = "LogSFTP_" + sftpAddr + ".txt";
    	certLogSFTPSaveFile = top.pathJoin(top.getSupportDir(), certLogSFTPSaveFile);
    	top.deleteFile(certLogSFTPTempFile);
		args.push(certLogSFTPTempFile);
		args.push(...add_output_log5());
    	printLog("INFO","run command:" + getRunProgramCommend(args));
    	runProgram(args, null, getLogSFTPCertCB);
	}

	function getLogSFTPCertCB(success) {
		if (!success || !top.fileExists(certLogSFTPTempFile)) {
			alert("Failed to get SFTP server's key fingerprint.");
			completeSaveUp();
			return;
		} else {
			try {
				certLogSFTPTempContent = top.readTextFile(certLogSFTPTempFile);
			} catch (e) {
				alert("Failed to get SFTP server's key fingerprint.");
				completeSaveUp();
				return;
			}
			try {
				certLogSFTPSaveContent = top.readTextFile(certLogSFTPSaveFile);
			} catch (e) {
				certLogSFTPSaveContent = null;
			}

			certLogNewSFTP = (certLogSFTPTempContent != '' && certLogSFTPTempContent != certLogSFTPSaveContent);

			if (certLogNewSFTP) {
				$("#certLogConfirmDiv").show();
				$("#sftpLogCertSection").show();
				$("#sftpLogCertArea").html(certLogSFTPTempContent);
			}
			else {
				upLogToSftpSvr();
			}
		}
	}

	function cleanCertContent() {
		$("#certLogConfirmDiv").hide();
		$("#sftpLogCertSection").hide();
		$("#sftpLogCertArea").html("");
	}

	function acceptCert() {
		cleanCertContent();
		if (top.fileExists(certLogSFTPSaveFile)) top.deleteFile(certLogSFTPSaveFile);
		top.writeTextFile(certLogSFTPSaveFile, certLogSFTPTempContent);
		upLogToSftpSvr();
	}

	function noAcceptCert() {
		cleanCertContent();
		completeSaveUp();
	}

	return {
		name: "Finish",
		index: 0,
		init: finish_init,
		nextAction: function() { printLog("INFO","Next was clicked."); return true; },
		importId: '#import_finish',
		selectorId: '.finish',
		title: "Navi.Finish",
		localizedTitle: tr("Navi.Finish"),
		dumpLog: dumpLog,
		checkTotalInput: checkTotalInput,
		toggleUsbDiv: toggleUsbDiv,
		toggleSftpDiv: toggleSftpDiv,
		createLogFile: createLogFile,
		saveUpLogConfirm: saveUpLogConfirm,
		showSaveUpLogModal: showSaveUpLogModal,
		hideSaveUpLogModal: hideSaveUpLogModal,
		checkLogSFTPDefault: checkLogSFTPDefault,
		acceptCert: acceptCert,
		noAcceptCert: noAcceptCert,
		needRefresh: true
	}
}();
