// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Machine_Types = function() {

	var updateListResultFile = "";
	
	function machine_types_init()
	{
		printLog("INFO","Machine Types page init.");
		init_vue();
		lenovoTable.filterString = "";

	    updateListResultFile = top.pathJoin(top.getSupportDir(), top.BUILD_FIX_ID+".xml");

	    try
	    {
			if(!fileExists(top.getSupportFile("configList")) && !fileExists(top.getSystemFile("mtList")))
			{
				printLog("INFO","both file " + top.getSupportFile("configList") + " and " + fileExists(top.getSystemFile("mtList")) + " are not exists."); 
				alert($.i18n.prop("MachineType.NoFile"));
			}
			else
			{
				restoreDefault(false);
			}
	    }
	    catch (e)  						//load config sys file failed, load default one
	    {
			printLog("INFO","load file exception:" + e);
	    }
		showaddsystem(false);
	}

	function getSelectMts(mt_list)
	{
		printLog("INFO","get selected Mts.");
		for (var i = 0; i < lenovoTable.total(); i++)
		{
			if(lenovoTable.data[i].visible && lenovoTable.data[i].selected)
			{
				mt_list.push(lenovoTable.data[i].mt);
			}
		}
	}

	function clickNextCollect()
	{
		printLog("INFO","Next was clicked.");

		m_mtlist = new Array();
		top.gl_mt_list = new Array();
	    top.gl_config_list = new Array();

		printLog("INFO","start collect selected mts. totals:" + lenovoTable.total());

	    for (var i = 0; i < lenovoTable.total(); ++i)
	    {
			var a = new Array();
			a.push(lenovoTable.data[i].productFamily);
			a.push(lenovoTable.data[i].mt);
			if(lenovoTable.data[i].selected == true)
			{
				a.push("1");
				m_mtlist.push(lenovoTable.data[i].mt);
			}
			else
			{
				a.push("0");
			}
			a.push(lenovoTable.data[i].nouxsp);
			top.gl_config_list.push(a);
		}

		for(var j = 0; j < m_mtlist.length; ++j)
		{
			if(isExistInSelectedMts(top.gl_mt_list, m_mtlist[j]) == false)
			{
				top.gl_mt_list.push(m_mtlist[j]);
			}
		}

	    if (top.gl_mt_list.length < 1)
	    {
	        alert($.i18n.prop("MachineType.WarnMsg1"));
	        return false;
	    }
	    else
	    {
	        top.gl_mt_list.sort();			//sort mt_list
	        sortConfigList();
	    }

		reWriteConfigFile(lenovoTable.data)
		printLog("INFO", "click Next end.");
	    return true;
	}

	function populateSystemList(dom, checkselected=true)
	{
		/*
		var root = dom.documentElement;
	    var allSystems = root.getElementsByTagName("system");	
		*/
	    var allSystems = dom.getElementsByTagName("system");
		for (i = 0; i < allSystems.length; i++) {
			/*
			var xname = allSystems.item(i).firstChild.firstChild.nodeValue.toLowerCase();
			if (xname == "legacy option" || xname == "storage") {
				continue;
			}
			*/
			let family = allSystems.item(i).childNodes[0].firstChild.nodeValue;
			let mt = allSystems.item(i).childNodes[1].firstChild.nodeValue;
			
			let nodeval = allSystems.item(i).childNodes[2].firstChild.nodeValue;
			let beselected = false;
			if(nodeval != "0" && checkselected)
			{
				beselected = true;
			}
			//let noUxsp = allSystems.item(i).childNodes[3].firstChild.nodeValue;
			let noUxsp = "0";
			
			if(!isInMTList(mt))
			{
				lenovoTable.data.push({
					mt: mt,
					mtDisplay: mt,
					productFamily: family,
					productFamilyDisplay: family,
					selected: beselected,
					nouxsp: noUxsp,
					visible: true
				});
			}
		}
	}

	function showaddsystem(status)
	{
	    if (status)
	    {
			printLog("INFO","module 'addSystem' was shown.");
	        document.getElementById("mechineList").style.height = "15em";
	        document.getElementById("addSystem").style.display = "";
	    }
	    else
	    {
			printLog("INFO","module 'addSystem' was Hidden.");
	        document.getElementById("mechineList").style.height = "20em";
	        document.getElementById("addSystem").style.display = "none";
	        clearUserInputForAddSystem();
	    }
	}

	function addsystemitem()
	{
		printLog("INFO","button 'Ok' was clicked.");
	    var family = document.getElementById("txtfamily").value;
	    family = family.trim();
	    if (family == "")
	    {
	        alert($.i18n.prop("MachineType.WarnMsg2"));
	        document.getElementById("txtfamily").value = "";
	        return;
	    }
		var regExp = /^[a-zA-Z\d/ ]*$/gi;
		if (!family.match(regExp))
	    {
	        alert(tr("Product family can only contain digit numbers, letters, spaces or forward slashes."));
	        document.getElementById("txtfamily").value = "";
	        return;
	    }
	    var mt = document.getElementById("txtmachinetype").value;
	    mt = mt.trim();
	    regExp = /^[a-zA-Z\d]{4}$/gi;
	    if (!mt.match(regExp))
	    {
	        alert($.i18n.prop("MachineType.WarnMsg3"));
	        document.getElementById("txtmachinetype").value = "";
	        return;
	    }

	    if (isInMTList(mt)) 		//already in the list
	    {
	        alert($.i18n.prop("MachineType.WarnMsg4",family,mt));
	        return;
	    }

		showaddsystem(false);

		lenovoTable.data.unshift({
			mt: mt,
			mtDisplay: mt,
			productFamily: family,
			productFamilyDisplay: family,
			nouxsp: "0",
			visible: true,
			selected: true
		})
	    
	    clearUserInputForAddSystem();
		reWriteConfigFile(lenovoTable.data);
		lenovoTable.onRowSelectedChanged();
		//this.filterChanged(this.filterString);
	}

	function clearUserInputForAddSystem() {
		document.getElementById("txtfamily").value = "";
		document.getElementById("txtmachinetype").value = "";
	}

	/*
	 * check if the family-mt already exists in the list
	 */
	function isInMTList(mt)
	{
		for (var i = 0; i < lenovoTable.total(); ++i)
		{
			if(lenovoTable.data[i].mt.toLowerCase() == mt.toLowerCase())
				return true;
		}
	    return false;
	}

	function isExistInSelectedMts(mts, mt)
	{
		for (var i = 0; i < mts.length; ++i)
		{
			if(mts[i] == mt)
				return true;
		}

		return false;
	}

	function deleteitem()
	{
		printLog("INFO","button 'Remove' was clicked.");

		var mt_list = new Array();
		getSelectMts(mt_list);
		if (mt_list.length == 0)
			return;

	    if (!window.confirm($.i18n.prop("MachineType.TipsMsg1")))
	        return;

		printLog("INFO", "selected count:" + mt_list.length + " list:" + mt_list);

		var tmp_mts1 = new Array();
		tmp_mts1 = lenovoTable.data;

		var tmp_mts2 = new Array();
		for (var j = 0; j < tmp_mts1.length; ++j)
		{
			if(!isExistInSelectedMts(mt_list, tmp_mts1[j].mt))
			{
				tmp_mts2.push(tmp_mts1[j]);
			}
		}

		printLog("INFO", "after delete count:" + tmp_mts2.length);
		lenovoTable.data = tmp_mts2;
		printLog("INFO", "after delete count:" + lenovoTable.data.length);
		lenovoTable.checkAll=false;
		reWriteConfigFile(lenovoTable.data);
		lenovoTable.onRowSelectedChanged();
	}

	function toggleElementsStatus(disable) {
		/*
	    var buttons = document.getElementsByTagName("input");
	    for (var i = 0; i < buttons.length; ++i) {
	        if (buttons[i].type == "button") {
	            buttons[i].disabled = disable;
	        }
	    }
		*/
		
	    togglePrevious(!disable);
	    toggleNext(!disable);
	}

	function reWriteConfigFile(data) {

		var root = '<?xml version="1.0" ?>\n';
		root += "<root>\n";
		for (var i = 0; i < data.length; i++) {
			var xName = data[i].productFamily;
			var machineType = data[i].mt;
			var selected = data[i].selected?"1":"0";
			var noUxsp = data[i].nouxsp;
			root += "<system><xname>" + xName + "</xname><machineType>" + machineType + "</machineType><selected>" + selected + "</selected><noUXSP>" + noUxsp + "</noUXSP></system>\n"
		}
		root += "</root>\n";
		deleteFile(top.getSupportFile("configList"));
		top.writeTextFile(top.getSupportFile("configList"), root);
	}

	function updateListCallback(success) {
		top.hideBmcWaitingMsg();
		// get update list fail:
		if (!success) {
			toggleElementsStatus(false);
			alert($.i18n.prop("MachineType.FailedToGetSystemList"));
		} else {
			try {
				var resultFile = top.readTextFile(updateListResultFile);
				var resultDom = ezJsLib.XmlDom.parse(resultFile);
				var resultProperty = ezJsLib.XmlDom.getValueByTagFromNode("PROPERTY.ARRAY", resultDom.documentElement);
				var resultStr = resultProperty.toString();
				resultStr = resultStr.trim();
				var resultArray = resultStr.split("\n");
				for (var i = 0; i < resultArray.length; i++) {
					resultArray[i] = resultArray[i].trim();
					resultArray[i] = resultArray[i].replace("-[", ",");
					resultArray[i] = resultArray[i].replace("]-", "");
				}

				updateLenovoTableData(resultArray);
				reWriteConfigFile(lenovoTable.data);
				toggleElementsStatus(false);
				alert($.i18n.prop("MachineType.RestoreDefaultDone"));
			} catch(e) {
				toggleElementsStatus(false);
				alert($.i18n.prop("MachineType.FailedToGetSystemList"));
			}
		}
		lenovoTable.onRowSelectedChanged();
	}

	function updateLenovoTableData(resultArray)
	{
		for (var i = 0; i < resultArray.length; ++i) {
			var commaIndex = resultArray[i].indexOf(",");
			var xName = resultArray[i].substr(0, commaIndex);
			var machineType = resultArray[i].substr(commaIndex + 1);

			if(isInMTList(machineType))
			{
				printLog("INFO", xName + ":" + machineType + "exist in current mts table.");
				continue;
			}

			lenovoTable.data.push({
				mt: machineType,
				mtDisplay: machineType,
				productFamily: xName,
				productFamilyDisplay: xName,
				selected: false,
				nouxsp: "0",
				visible: true
			});
		}
	}

	/**
	 * update machinetype list.  */
	function UpdateList()
	{
		printLog("INFO","button 'Update List' was clicked.");
		
	    var args = new Array();
	    args.push(top.getSystemFile("oneCli"));
        args.push("update");
        args.push("acquire");
        args.push("--xml");
        args.push("--scope");
        args.push("individual");
        args.push("--metaonly");
        args.push("--dir");
        args.push(top.getSupportDir());
        args.push(...add_output_log5());

	    args.push(...add_proxy_para());

	    args.push("--includeid");
	    args.push(top.BUILD_FIX_ID);
	    args.push("--nosupersede");

	    // delete the previous result file
	    deleteFile(updateListResultFile);
		toggleElementsStatus(true);
		top.showBmcWaitingMsg();
		printLog("INFO","run command:" + getRunProgramCommend(args));
	    runProgram(args, null, updateListCallback);
	}

	/**
	 * show the default machinetype list. However, until real acquisition begins, the config xml file won't be changed
	 */
	function restoreDefault(isManual)
	{
		printLog("INFO","function restoreDefault begin.");
		try{
			var defaultFile;
			lenovoTable.data = new Array();
			if(isManual)
			{
				printLog("INFO","reset table data to init. load data from " + top.getSystemFile("mtList"));
				deleteFile(top.getSupportFile("configList"));
				defaultFile = top.readTextFile(top.getSystemFile("mtList"));
				populateSystemList(ezJsLib.XmlDom.parse(defaultFile), false);
				alert($.i18n.prop("MachineType.RestoreDefaultDone"));
			}
			else
			{
				if(fileExists(top.getSupportFile("configList")))
				{
					printLog("INFO", "parse config file " + top.getSupportFile("configList"));
					defaultFile = top.readTextFile(top.getSupportFile("configList"));
				}
				else
				{
					printLog("INFO", "no config file, so load data from " + top.getSystemFile("mtList"));
					defaultFile = top.readTextFile(top.getSystemFile("mtList"));
				}
				populateSystemList(ezJsLib.XmlDom.parse(defaultFile), false);
			}
		}
		catch(e)
		{
			printLog("INFO", "exception happen. " + e);
		}
		lenovoTable.onRowSelectedChanged();
		printLog("INFO","function restoreDefault end.");
	}
	

	/**
	 * according to sorted top.gl_mt_list, get a sorted top.gl_config_list
	 */
	function sortConfigList()
	{
	    top.gl_xname_mt_list = new Array();
	    for (var i = 0; i < top.gl_mt_list.length; i++)
	    {
	        var a = new Array();
	        var marketN = "";
	        for (var j = 0; j < top.gl_config_list.length; j++)
	        {
	            if (top.gl_mt_list[i] == top.gl_config_list[j][1] && top.gl_config_list[j][2] == "1")
	            {
	                marketN += top.gl_config_list[j][0] + "/";
	            }
	        }
	        a.push(marketN.substr(0, marketN.length - 1));
	        a.push(top.gl_mt_list[i]);
	        a.push("1");
	        top.gl_xname_mt_list.push(a);
	    }
	}


	function onRowSelectedChanged() {
		let allChecked = true;
		let allUnCheckted = true;
		for (let item of this.data) {
			if (item.selected) {
				allUnCheckted = false;
			} else {
				allChecked = false;
			}
		}
		if (allChecked) {
			this.checkAll = true;
			this.checkAllIndeterminate = true;
			setTimeout(() => { this.checkAllIndeterminate = false; }, 1);
		} else if (allUnCheckted) {
			this.checkAll = false;
			this.checkAllIndeterminate = true;
			setTimeout(() => { this.checkAllIndeterminate = false; }, 1);
		} else {
			this.checkAllIndeterminate = false;
			setTimeout(() => { this.checkAllIndeterminate = true; }, 1);
		}
	}

	function onCheckAllChanged() {
		for (let item of this.data) {
			if (item.visible) {
				item.selected = this.checkAll;
			}
			else
			{
				item.selected =false;
			}
		}
		this.onRowSelectedChanged();
	}

	function onSortByFamily(val) {
		if (val === "asc") {
			this.mtSortType = undefined;
			this.data.sort((x, y) => {
				if (x.productFamily > y.productFamily) {
					return 1;
				}
				if (x.productFamily < y.productFamily) {
					return -1;
				}
				return 0;
			});
		} else if (val === "dsc") {
			this.mtSortType = undefined;
			this.data.sort((y, x) => {
				if (x.productFamily > y.productFamily) {
					return 1;
				}
				if (x.productFamily < y.productFamily) {
					return -1;
				}
				return 0;
			});
		}
	}

	function onSortByMt(val) {
		if (val === "asc") {
			this.sortType = undefined;
			this.data.sort((x, y) => {
				if (x.mt > y.mt) {
					return 1;
				}
				if (x.mt < y.mt) {
					return -1;
				}
				return 0;
			});
		} else if (val === "dsc") {
			this.sortType = undefined;
			this.data.sort((y, x) => {
				if (x.mt > y.mt) {
					return 1;
				}
				if (x.mt < y.mt) {
					return -1;
				}
				return 0;
			});
		}
	}

	let lenovoTable = Vue.reactive({
		filterString: "",
		checkAll: false,
		checkAllIndeterminate: false,
		data: [
		],
		onCheckAllChanged: onCheckAllChanged,
		onRowSelectedChanged: onRowSelectedChanged,
		selectedCount: function () {
			let selCount = 0;
			for (let item of this.data) {
				if(item.selected)
				{
					selCount++;
				}
			}
			return selCount;
		},
		total: function () {
			return this.data.length;
		},
		sortByFamily: onSortByFamily,
		sortByMt: onSortByMt,
		filterChanged: onFilterChanged
	});

	function onFilterChanged(value) {
		let key = value.toLowerCase();
		let regex = new RegExp(key, "ig");
		for (let item of this.data) {
			if (item.productFamily.toLowerCase().includes(key) && item.mt.toLowerCase().includes(key)) {
				let tempVal = item.productFamily.match(regex);
                item.productFamilyDisplay = item.productFamily.replace(regex, "<b style='color:rgb(235, 103, 103)'>" + tempVal[0] + "</b>");
				let tempValMt = item.mt.match(regex);
				item.mtDisplay = item.mt.replace(regex, "<b style='color:rgb(235, 103, 103)'>" + tempValMt[0] + "</b>");
				item.visible = true;
			}
			else if (item.productFamily.toLowerCase().includes(key)) {
				let tempVal = item.productFamily.match(regex);
                item.productFamilyDisplay = item.productFamily.replace(regex, "<b style='color:rgb(235, 103, 103)'>" + tempVal[0] + "</b>");
				item.mtDisplay = item.mt;
				item.visible = true;
			} else if (item.mt.toLowerCase().includes(key)) {
				item.productFamilyDisplay = item.productFamily;
				let tempValMt = item.mt.match(regex);
				item.mtDisplay = item.mt.replace(regex, "<b style='color:rgb(235, 103, 103)'>" + tempValMt[0] + "</b>");
				item.visible = true;
			} else {
				item.productFamilyDisplay = item.productFamily;
				item.mtDisplay = item.mt;
				item.visible = false;
			}
			this.onRowSelectedChanged();
		}
	}

	var MachineTypeVueApp = undefined;

	function init_vue() {
		
		if (MachineTypeVueApp != undefined) {
			return;
		}
		
		MachineTypeVueApp = Vue.createApp({
			data() {
				return {
					lenovoTable: lenovoTable,
				};
			},
			methods: {
				tr: tr
			},
			watch: {
				"lenovoTable.filterString": (val) => { lenovoTable.filterChanged(val); },
				"lenovoTable.sortType": (val) => { lenovoTable.sortByFamily(val); },
				"lenovoTable.mtSortType": (val) => { lenovoTable.sortByMt(val); },
			},
			directives: {
				focus: {
					mounted(el) {
						el.focus();
					}
				}
			}
		});
		MachineTypeVueApp.mount("#vue_supported_systems");
	}

	function free_mount()
	{
		if(MachineTypeVueApp != undefined)
		{
			MachineTypeVueApp.unmount("");
			MachineTypeVueApp = undefined;
		}
	}
	
	return {
		index: 0,
		name: "Machine_Types",
        init: machine_types_init, 
        addsystemitem: addsystemitem,
        showaddsystem: showaddsystem,
        deleteitem: deleteitem,
        UpdateList: UpdateList,
        restoreDefault: restoreDefault,
        nextAction: clickNextCollect,

		previousAction: function(){
			printLog("INFO","Previous was clicked.");
			return true;
		},
		
		importId: '#import_machine_types',
        selectorId: '.machine_types',
        title: "Navi.MachineTypes",
		localizedTitle: tr("Navi.MachineTypes"),
		uninit: free_mount
	}
}();