// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
OOB_Setting = function(){
	let vue_app = undefined;

	var userCanceled = false;
	var certRemoteTempFile = '';
	var certRemoteSaveFile = '';
	var certRemoteTempContent;
	var certRemoteSaveContent;
	var certNewRemote = false;
	var scan_status = "init";

	const remoteServer = Vue.reactive({
		// ui
		isTagCheckDefaultShow: false,
		textAcceptCertDefault: "",
		textRemoteTitle: "",
		textRemoteSubtitle: "",
		textRemotePortHint: "",
		textRemotePayloadHint: "",
		textRemoteIpInputTitle: "",
		isRemoteUserNameRequired: false,
		isRemotePasswordRequired: false,
		// args
		tagCheckDefault: false,
		Use_Sep_protocol: "",
		Use_Sep_Remote: false,
		Use_Sep_SFTP: false,
		Use_Sep_HTTPS: false,
		Use_Sep_FTP: false,
		Use_Sep_HTTP: false,
		Remote_Address: "",
		Remote_Port: "",
		Remote_UserName: "",
		Remote_Password: "",
		Remote_Location: "",
		errMsg: "",
		isBackup: false,
		// protocol
		supportedProtocol: [],
		isSupportNoRemote: false,
		setAvaProtocolOptions(protocols, isSupportNoRemote) {
			this.supportedProtocol = protocols.concat();
			this.isSupportNoRemote = isSupportNoRemote;
			// Instead invalid option
			if (protocols.length > 0 && !protocols.includes(this.Use_Sep_protocol)) {
				this.Use_Sep_protocol = protocols[0];
			}
		},
		getAvaProtocolOptions() {
			return this.supportedProtocol.concat();
		},
		isSupportNoRemoteServer() {
			return this.isSupportNoRemote;
		}
	});

	let vue_class = {
		data() {
			return {
				remoteServer: remoteServer
			}
		},
		computed: {
			isEnableRemoteShow() {
				// Support both NoRemote and AnyProtocol
				return remoteServer.getAvaProtocolOptions().length > 0 && remoteServer.isSupportNoRemoteServer();
			},
			isMendatoryTipShow() {
				// Support only AnyProtocol
				return remoteServer.getAvaProtocolOptions().length > 0 && !remoteServer.isSupportNoRemoteServer();
			},
			isProtocolBlockShow() {
				return (this.isEnableRemoteShow && remoteServer.Use_Sep_Remote) || this.isMendatoryTipShow;
			}
		},
		methods: {
			checkIsMultiServer() {
				return top.gl_multi_server_management;
			},
			tr: top.tr
		},
		watch: {
			"remoteServer.Use_Sep_Remote": (val) => {
				printLog("INFO","check box 'Use a seperate remote server " + (val? "checked.": "unchecked."));
				remoteServer.errMsg = "";
			},
			"remoteServer.isBackup": (val) => {
				printLog("INFO","check box 'Only update the backup image of the BMC(and UEFI where applicable)'" + (val? "checked.": "unchecked."));
				top.gl_optionBackup = val;
			},
			"remoteServer.Use_Sep_protocol": (val) => {
				if (val == "SFTP") {
					remoteServer.Use_Sep_SFTP = true;
					remoteServer.Use_Sep_HTTPS = false;
					remoteServer.Use_Sep_FTP = false;
					remoteServer.Use_Sep_HTTP = false;
					// UI
					remoteServer.isTagCheckDefaultShow = true;
					remoteServer.textAcceptCertDefault = $.i18n.prop("OOBSetting.ConfirmTrust.Option.SFTP");
					remoteServer.textRemoteTitle = $.i18n.prop("OOBSetting.SFTP.Title");
					remoteServer.textRemoteSubtitle = $.i18n.prop("OOBSetting.SFTP.SubTitle");
					remoteServer.textRemotePortHint = $.i18n.prop("OOBSetting.SFTP.Port.Hint");
					remoteServer.textRemotePayloadHint = $.i18n.prop("OOBSetting.SFTP.Payload.Hint");
					remoteServer.textRemoteIpInputTitle = $.i18n.prop("Common.IPorHostName");
					remoteServer.isRemoteUserNameRequired = true;
					remoteServer.isRemotePasswordRequired = true;
				} else if (val == "HTTPS") {
					remoteServer.Use_Sep_SFTP = false;
					remoteServer.Use_Sep_HTTPS = true;
					remoteServer.Use_Sep_FTP = false;
					remoteServer.Use_Sep_HTTP = false;
					remoteServer.isTagCheckDefaultShow = true;
					remoteServer.textAcceptCertDefault = $.i18n.prop("OOBSetting.ConfirmTrust.Option.HTTPS");
					remoteServer.textRemoteTitle = $.i18n.prop("OOBSetting.HTTPS.Title");
					remoteServer.textRemoteSubtitle = $.i18n.prop("OOBSetting.HTTPS.SubTitle");
					remoteServer.textRemotePortHint = $.i18n.prop("OOBSetting.HTTPS.Port.Hint");
					remoteServer.textRemotePayloadHint = $.i18n.prop("OOBSetting.HTTPS.Payload.Hint");
					remoteServer.textRemoteIpInputTitle = $.i18n.prop("OOBSetting.SFTP.HostOnly");
					remoteServer.isRemoteUserNameRequired = false;
					remoteServer.isRemotePasswordRequired = false;
				} else if (val == "FTP") {
					remoteServer.Use_Sep_SFTP = false;
					remoteServer.Use_Sep_HTTPS = false;
					remoteServer.Use_Sep_FTP = true;
					remoteServer.Use_Sep_HTTP = false;
					remoteServer.isTagCheckDefaultShow = false;
					remoteServer.textRemoteTitle = $.i18n.prop("OOBSetting.FTP.Title");
					remoteServer.textRemoteSubtitle = $.i18n.prop("OOBSetting.FTP.SubTitle");
					remoteServer.textRemotePortHint = $.i18n.prop("OOBSetting.FTP.Port.Hint");
					remoteServer.textRemotePayloadHint = $.i18n.prop("OOBSetting.FTP.Payload.Hint");
					remoteServer.textRemoteIpInputTitle = $.i18n.prop("Common.IPorHostName");
					remoteServer.isRemoteUserNameRequired = false;
					remoteServer.isRemotePasswordRequired = false;
				} else if (val == "HTTP") {
					remoteServer.Use_Sep_SFTP = false;
					remoteServer.Use_Sep_HTTPS = false;
					remoteServer.Use_Sep_FTP = false;
					remoteServer.Use_Sep_HTTP = true;
					remoteServer.isTagCheckDefaultShow = false;
					remoteServer.textRemoteTitle = $.i18n.prop("OOBSetting.HTTP.Title");
					remoteServer.textRemoteSubtitle = $.i18n.prop("OOBSetting.HTTP.SubTitle");
					remoteServer.textRemotePortHint = $.i18n.prop("OOBSetting.HTTP.Port.Hint");
					remoteServer.textRemotePayloadHint = $.i18n.prop("OOBSetting.HTTP.Payload.Hint");
					remoteServer.textRemoteIpInputTitle = $.i18n.prop("Common.IPorHostName");
					remoteServer.isRemoteUserNameRequired = false;
					remoteServer.isRemotePasswordRequired = false;
				}
			}
		}
	}

	function init_vue() {
		if (vue_app != undefined) {
			return;
		}
		vue_app = Vue.createApp(vue_class);
		vue_app.mount('#vue-oob-setting');
	}

	function oob_init(){
		printLog("INFO","Setting page init.");
		scan_status = "init";
		certNewRemote = false;
		certRemoteTempFile = top.pathJoin(top.getSupportDir(), "Remote_Cert.txt");
		init_vue();

		/**
		 * About remote server
		 * OOB case:
		 * line 		  None  	SFTP	FTP		HTTPS	HTTP
		 * 1	CFC		   Y		 N		 Y		  Y		 N
		 * 2	Grantly	   N		 Y		 N		  N		 N
		 * 3	Amd		   Y		 N		 N		  N		 N
		 * 4	Others	   Y		 Y		 N		  Y		 Y
		 *  *************************************************
		 * inband case:
		 * 				  None  	SFTP	FTP		HTTPS	HTTP
		 * 5	CFC		   Y		 N		 Y		  Y		 N
		 * 6	Others	   Y		 N		 N		  N		 N
		 *  *************************************************
		 * direct connect:
		 * 				  None  	SFTP	FTP		HTTPS	HTTP
		 * 7			   Y		 N		 N		  N		 N
		 */
		if (top.isCFC() || top.gl_multi_server_management) { // Assume multi case as CFC server
			// line 1, 5
			remoteServer.setAvaProtocolOptions(["FTP", "HTTPS"], true);
		} else if ((top.gl_OOB_Params.Enabled && top.isAmd()) || (top.gl_Inband_Params.Enabled && !top.isCFC()) || top.gl_direct_connect) {
			// line 3, 6, 7
			remoteServer.setAvaProtocolOptions([], true);
			remoteServer.Use_Sep_Remote = false;
		} else if (top.gl_OOB_Params.Enabled && top.isGrantly()) {
			// line 2
			remoteServer.setAvaProtocolOptions(["SFTP"], false);
			remoteServer.Use_Sep_Remote = true;
		} else {
			// line 4
			remoteServer.setAvaProtocolOptions(["SFTP", "HTTPS", "HTTP"], true);
		}

		if (top.gl_uxlite_bootable) {
			if (top.is_autorun() || top.is_unattend()) {
				setTimeout(() => {
					gl_wizard.steps("next");
				}, 1000);
			}
		}
		
		if (top.gl_multi_server_management) {
			remoteServer.isBackup = false;
		}

		printLog("DEBUG","function oob_init end.");
	}

	function getRemoteCert() {
		if (userCanceled) {
			return "waiting";
		}
		var args = new Array();
    	args.push(top.getSystemFile("oneCli"));
    	args.push("misc");
    	args.push("gettrust");
    	args.push("--host");
    	args.push(remoteServer.Remote_Address);
    	args.push("--port");
    	if (remoteServer.Remote_Port == "" || remoteServer.Remote_Port == undefined || remoteServer.Remote_Port == null) {
			if (remoteServer.Use_Sep_SFTP) {
				args.push("22");
			} else if (remoteServer.Use_Sep_HTTPS) {
				args.push("443");
			}
    	} else {
    		args.push(remoteServer.Remote_Port);
    	}
    	args.push("--type");
    	if (remoteServer.Use_Sep_SFTP) {
			args.push("sftp");
		} else if (remoteServer.Use_Sep_HTTPS) {
			args.push("https");
		}
    	args.push("--result");
    	certRemoteSaveFile = "Remote_" + remoteServer.Remote_Address + ".txt";
    	certRemoteSaveFile = top.pathJoin(top.getSupportDir(), certRemoteSaveFile);
    	top.deleteFile(certRemoteTempFile);
		args.push(certRemoteTempFile);
		args.push(...add_output_log5());
    	printLog("INFO","run command:" + getRunProgramCommend(args));
    	runProgram(args, null, getRemoteCertCB);
    	return "waiting";
	}

	function getRemoteCertCB(success) {
		if (userCanceled) {
			return "waiting";
		}
		if (!success || !top.fileExists(certRemoteTempFile)) {
			scan_status = "ssh_fail";
			goNextStep();
		} else {
			scan_status = "ssh_success";
			goNextStep();
		}
	}

	function checkRemoteInputOnly() {
		let remoteHostName = remoteServer.Remote_Address;
		let remotePort = remoteServer.Remote_Port;
		let remoteUser = remoteServer.Remote_UserName;
		let remotePass = remoteServer.Remote_Password;
		let remoteLocation = remoteServer.Remote_Location;
		if (!remoteHostName || !remoteLocation) {
			remoteServer.errMsg = $.i18n.prop("Common.RquiredField");
			return false;
		}
		// username/password is unnecessary for https/ftp/http
		if (remoteServer.Use_Sep_SFTP) {	
			if (!remoteUser || !remotePass) {
				remoteServer.errMsg = $.i18n.prop("Common.RquiredField");
				return false;
			} 
		}
		if(!checkHostName(remoteHostName)){
			remoteServer.errMsg = $.i18n.prop("OOBSetting.TipsInfo6");
			return false;
		} 
		if(remotePort && (isNaN(remotePort) || remotePort<1 || remotePort>65535) ){
			remoteServer.errMsg = $.i18n.prop("Common.Port.Warning");
			return false;
		}
		return true;
	}

	function isNeedGetCert() {
		if (!remoteServer.tagCheckDefault) {
			if (remoteServer.Use_Sep_Remote && (remoteServer.Use_Sep_HTTPS || remoteServer.Use_Sep_SFTP)) {
				return true;
			}
		}
		return false;
	}

	function startGetCert() {
		printLog("INFO","Next was clicked.");
		syncRemoteServerSetting();
		if(remoteServer.Use_Sep_Remote) {
			if (scan_status == "init") {
				remoteServer.errMsg = "";
				userCanceled = false;
				if (!checkRemoteInputOnly()) return false;
				if (isNeedGetCert()) {
					top.showRemoteCertWaitMsg();
					return getRemoteCert();
				}
				scan_status = "init";
				return true;
			} else if (scan_status == "ssh_fail") {
				top.hideRemoteCertWaitMsg();
				scan_status = "init";
				if (!userCanceled) {
					remoteServer.errMsg = $.i18n.prop("OOBSetting.GetTrust.Remote.Failed");
					return false;
				} else {
					return "waiting";
				}
			} else if (scan_status == "ssh_success") {
				top.hideRemoteCertWaitMsg();
				try {
					certRemoteTempContent = top.readTextFile(certRemoteTempFile);
				} catch (e) {
					remoteServer.errMsg = $.i18n.prop("OOBSetting.GetTrust.Remote.Failed");
					return false;
				}
				try {
					certRemoteSaveContent = top.readTextFile(certRemoteSaveFile);
				} catch (e) {
					certRemoteSaveContent = null;
				}

				certNewRemote = false;

				if (certRemoteSaveContent == null || certRemoteSaveContent == '') {
					top.writeTextFile(certRemoteSaveFile, certRemoteTempContent);
					certRemoteSaveContent = certRemoteTempContent;
				}
				if (certRemoteTempContent == '') certNewRemote = false;
				if (certRemoteTempContent != '' && certRemoteTempContent != certRemoteSaveContent) certNewRemote = true;

				if (!certNewRemote) {
					scan_status = "init";
					return true;
				} else {
					document.getElementById("remoteCertDialog").style.height = "295px";
				}
				if (certNewRemote) {
					$("#remoteCertSection").show();
					$("#remoteCertArea").html(certRemoteTempContent);
				}
		
				if (!userCanceled) {
					showCertContentMsg();
				} else {
					scan_status = "init";
				}
				return "waiting";
			} else if (scan_status == "cert_no_accept") {
				scan_status = "init";
				return "waiting";
			} else if (scan_status == "done") {
				if (certNewRemote) {
					if (top.fileExists(certRemoteSaveFile)) {
						top.deleteFile(certRemoteSaveFile);
					}
					top.writeTextFile(certRemoteSaveFile, certRemoteTempContent);
				}
				scan_status = "init";
				return true;
			}
		}
		scan_status = "init";
		return true;
	}

	function showCertContentMsg() {
		$("#remoteCertConfirmDiv").show();
	}

	function hideCertContentMsg() {
		$("#remoteCertConfirmDiv").hide();
	}

	function acceptCert() {
		hideCertContentMsg();
		cleanCertContent();
		scan_status = "done";
		goNextStep();
	}

	function noAcceptCert() {
		hideCertContentMsg();
		cleanCertContent();
		scan_status = "cert_no_accept";
		goNextStep();
	}

	function cleanCertContent() {
		$("#remoteCertSection").hide();
		$("#remoteCertArea").html("");
	}

	function checkHostName(hostName) {
		var expHostName = /((^\s*((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))\s*$)|(^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$))|(^\s*((?=.{1,255}$)(?=.*[A-Za-z].*)[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?)*)\s*$)/;
		var flag = expHostName.test(hostName);
		if (flag) return true;
		else return false;
	}

    function userCancelGetCert(value) {
    	scan_status = "init";
    	userCanceled = true;
    }

	function uninit() {
		if (vue_app != undefined) {
			vue_app.unmount();
			vue_app = undefined;
		}
	}

	function syncRemoteServerSetting() {
		// Used by other pages
		top.gl_Remote_Params.Use_Sep_Remote = remoteServer.Use_Sep_Remote;
		top.gl_Remote_Params.Use_Sep_SFTP = remoteServer.Use_Sep_SFTP;
		top.gl_Remote_Params.Use_Sep_HTTPS = remoteServer.Use_Sep_HTTPS;
		top.gl_Remote_Params.Use_Sep_FTP = remoteServer.Use_Sep_FTP;
		top.gl_Remote_Params.Use_Sep_HTTP = remoteServer.Use_Sep_HTTP;
		top.gl_Remote_Params.Remote_Address = remoteServer.Remote_Address;
		top.gl_Remote_Params.Remote_Port = remoteServer.Remote_Port;
		top.gl_Remote_Params.Remote_UserName = remoteServer.Remote_UserName;
		top.gl_Remote_Params.Remote_Password = remoteServer.Remote_Password;
		top.gl_Remote_Params.Remote_Location = remoteServer.Remote_Location;
	}

	return {
		index: 0,
		name: "OOB_Setting",
        init: oob_init, 
        nextAction: startGetCert,
        previousAction: function(){
			printLog("INFO","Previous was clicked.");
        	remoteServer.errMsg = "";
			syncRemoteServerSetting();
        	return true;
        },
        userCancelGetCert: userCancelGetCert,
        acceptCert: acceptCert,
        noAcceptCert: noAcceptCert,
        needReInit: true,
		importId: '#import_oob_setting',
        selectorId: '.oob_setting',
        title: "Navi.OOBSetting",
		localizedTitle: tr("Navi.OOBSetting"),
		uninit: uninit
	}
}();
