// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Proxy_Setting = function() {
    var userCanceled = false;
    var urlToTest;

    // Collect param and goto Next page.
    function proxy_collect() {
        printLog("INFO","Next was clicked.");
        var ret = "success";
        if (top.gl_url_custom && top.gl_url_specify_cert) {
            ret = checkUrlCert();
            if (ret != "success") {
                switch(ret)
                {
                    case 'url_cert_empty':
                        alert($.i18n.prop('ProxySetting.WarningNoCert'));
                        break;
                    case 'url_invalid_cert':
                        alert($.i18n.prop('ProxySetting.WarningNoCertFile'));
                        break;
                    default:
                }
                return ret;
            }
        }
        if (top.gl_isProxy) {
            ret = checkProxyInput();
            if (ret != "success") {
                switch(ret)
                {
                    case 'add_empty':
                        alert($.i18n.prop('ProxySetting.EmptyAddr'));
                        break;
                    case 'invalid_add':
                        alert($.i18n.prop('ProxySetting.InvalidAddr'));
                        break;
                    case 'port_empty':
                        alert($.i18n.prop('ProxySetting.EmptyPort'));
                        break;
                    case 'invalid_port':
                        alert($.i18n.prop('ProxySetting.WarningPortRange'));
                        break;
                    case 'user_empty':
                        alert($.i18n.prop('ProxySetting.WarningNoUserName'));
                        break;
                    case 'pwd_empty':
                        alert($.i18n.prop('ProxySetting.WarningNoPassword'));
                        break;
                    case 'proxy_cert_empty':
                        alert($.i18n.prop('ProxySetting.WarningNoCert'));
                        break;
                    case 'proxy_invalid_cert':
                        alert($.i18n.prop('ProxySetting.WarningNoCertFile'));
                        break;
                    default:
                }
                return ret;
            }
        }
        return "success";
    }

    function try_proxy_collect() {
        var ret = proxy_collect();
        if("success" != ret)
        {
            restore_focus(ret);
            return false;
        }
        return true;
    }

    function restore_focus(err){
        var obj = null;
        switch(err)
        {
            case 'url_empty':
                obj = $("#testUrl");
                break;
            case 'url_cert_empty':
            case 'url_invalid_cert':
                obj = $('#URLCertFile');
                break;
            case 'add_empty':
            case 'invalid_add':
                obj = $('#pAdd');
                break;
            case 'port_empty':
            case 'invalid_port':
                obj = $('#pPort');
                break;
            case 'user_empty':
                obj = $('#pUid');
                break;
            case 'pwd_empty':
                obj = $('#pPwd');
                break;
            case 'proxy_cert_empty':
            case 'proxy_invalid_cert':
                obj = $('#proxyCertFile');
                break;
            default:
        }
        if (obj != null) setTimeout(function(){ obj.focus(); }, 1);
    }

    function resetUrl() {
        if (gl_syncEdgeStatus == getTaskName() || gl_portal_activate == getTaskName()) {
            document.getElementById("testUrl").value = "https://portal.naea1.uds.lenovo.com";
        } else {
            document.getElementById("testUrl").value = "https://support.lenovo.com/services/ContentService/SearchDrivers";
        }
        setUrl();
    }

    function enableProxy() {
        var check = document.getElementById("proxy").checked;
        printLog("INFO","check box 'Proxy Server' "+(check?"checked.":"unchecked."));
        check?$("#proxyTable").show():$("#proxyTable").hide();
        top.gl_isProxy = check;
        printLog("DEBUG","function enableProxy end.");
    }

    function setProxy(obj) {
        // TODO:address must be number & can be " "
        let objVal = "";
        if (obj.value != null && obj.value != undefined) {
            objVal = obj.value.toString().trim();
        }
        if (obj.id == "URLCertFile") {
            obj.value = objVal;
            top.gl_url_cert = obj.value;
            printLog("INFO","set URLCertFile as " + obj.value);
        } else if (obj.id == "pAdd") {
            obj.value = objVal;
            top.gl_proxy_address = obj.value;
            printLog("INFO","set IP address or Hostname as " + obj.value);
        } else if (obj.id == "pPort") {
            obj.value = objVal;
            top.gl_proxy_port = obj.value;
            printLog("INFO","set Port as " + obj.value);
        } else if (obj.id == "pUid") {
            obj.value = objVal;
            top.gl_proxy_username = obj.value;
            printLog("INFO","set UserName as " + obj.value);
        } else if (obj.id == "pPwd") {
            obj.value = objVal;
            top.gl_proxy_password = obj.value;
            printLog("INFO","set Password as " + passwordCode(obj.value));
        } else if (obj.id == "proxyCertFile") {
            obj.value = objVal;
            top.gl_proxy_cert = obj.value;
            printLog("INFO","set proxyCertFile as " + obj.value);
        }
    }

    
    function configProxySetting(){
        document.getElementById("testUrl").value = urlToTest;
        document.getElementById("checkURLCustom").checked = top.gl_url_custom;
        document.getElementById("checkURLSkipCertificate").checked = top.gl_url_insecure;
        document.getElementById("checkURLSpecifyCertificate").checked = top.gl_url_specify_cert;
        document.getElementById("URLCertFile").value = top.gl_url_cert;
        document.getElementById("proxy").checked = top.gl_isProxy;
        document.getElementById("ProxyType").value = top.gl_proxyType.toUpperCase();
        document.getElementById("checkAccount").checked = top.gl_proxy_account;
        document.getElementById("pAdd").value = top.gl_proxy_address;
        document.getElementById("pPort").value = top.gl_proxy_port;
        document.getElementById("pUid").value = top.gl_proxy_username;
        document.getElementById("pPwd").value = top.gl_proxy_password;
        document.getElementById("checkProxyCustom").checked = top.gl_proxy_custom;
        document.getElementById("checkProxySkipCertificate").checked = top.gl_proxy_insecure;
        document.getElementById("checkProxySpecifyCertificate").checked = top.gl_proxy_specify_cert;
        document.getElementById("proxyCertFile").value = top.gl_proxy_cert;
    }

    function proxy_init() {
        printLog("INFO","Network Access page init.");
        document.getElementById("pInstructionalText").innerText = $.i18n.prop('ProxySetting.InstructionalText');
        if (gl_syncEdgeStatus == getTaskName() || gl_portal_activate == getTaskName()) {
            urlToTest = "https://portal.naea1.uds.lenovo.com";
            if (gl_portal_activate == getTaskName()) {
                document.getElementById("pInstructionalText").innerText = $.i18n.prop('ProxySetting.InstructionalText2');
            }
        } else {
            urlToTest = "https://support.lenovo.com/services/ContentService/SearchDrivers";
        }
        document.getElementById("resetUrlBtn").title = $.i18n.prop('ProxySetting.resetUrlBtnSub');
        userCanceled = false;
        configProxySetting();
        showURLCustom();
        if(document.getElementById("checkURLSkipCertificate").checked) showURLSpecifyCertificate(0);
        else if(document.getElementById("checkURLSpecifyCertificate").checked) showURLSpecifyCertificate(1);
        enableProxy();
        setProxyType(document.getElementById("ProxyType").value);
        showAccount();
        showProxyCustom();
        if(document.getElementById("checkProxySkipCertificate").checked) showProxySpecifyCertificate(0);
        else if(document.getElementById("checkProxySpecifyCertificate").checked) showProxySpecifyCertificate(1);
        printLog("DEBUG","function proxy_init end.");
    }

    function showAccount() {
        var check = document.getElementById("checkAccount").checked;
        printLog("INFO","check box 'Proxy Authentication' "+(check?"checked.":"unchecked."));
        check?$("#ProxyAcountTable").show():$("#ProxyAcountTable").hide();
        top.gl_proxy_account = check;
        printLog("DEBUG","function showAccount end.");
    }

    function TestConnectionError(retCode){
        switch(retCode)
        {
            case 'url_empty':
                DisplayInnerText('Proxy_InfoText', $.i18n.prop('ProxySetting.WarnNoUrl'));;
                break;
            case 'url_cert_empty':
                DisplayInnerText('Proxy_InfoText', $.i18n.prop('ProxySetting.WarningNoCert'));
                break;
            case 'url_invalid_cert':
                DisplayInnerText('Proxy_InfoText', $.i18n.prop('ProxySetting.WarningNoCertFile'));
                break;
            case 'add_empty':
                DisplayInnerText('Proxy_InfoText', $.i18n.prop('ProxySetting.EmptyAddr'));
                break;
            case 'invalid_add':
                DisplayInnerText('Proxy_InfoText', $.i18n.prop('ProxySetting.InvalidAddr'));
                break;
            case 'port_empty':
                DisplayInnerText('Proxy_InfoText', $.i18n.prop('ProxySetting.EmptyPort'));
                break;
            case 'invalid_port':
                DisplayInnerText('Proxy_InfoText', $.i18n.prop('ProxySetting.WarningPortRange'));
                break;
            case 'user_empty':
                DisplayInnerText('Proxy_InfoText', $.i18n.prop('ProxySetting.WarningNoUserName'));
                break;
            case 'pwd_empty':
                DisplayInnerText('Proxy_InfoText', $.i18n.prop('ProxySetting.WarningNoPassword'));
                break;
            case 'proxy_cert_empty':
                DisplayInnerText('Proxy_InfoText', $.i18n.prop('ProxySetting.WarningNoCert'));
                break;
            case 'proxy_invalid_cert':
                DisplayInnerText('Proxy_InfoText', $.i18n.prop('ProxySetting.WarningNoCertFile'));
                break;
            default:
        }
        $(".statusImg").html("<img src=\"images/StatusCritical.gif\" >");
        togglePrevious(true);
        toggleNext(true);
    }

    function TestConnection() {
        printLog("INFO","button 'Test Connection' was clicked.");
        userCanceled = false;
        togglePrevious(false);
        toggleNext(false);

        $(".statusImg").html("");
        DisplayInnerText("Proxy_InfoText", "");
        $("#testOtherStatus").html("");
        $("#testOtherMsg").html("");

        var retCode = "success";

        retCode = checkUrlInput();
        if (retCode != "success") { TestConnectionError(retCode); return;}

        if (top.gl_url_custom && top.gl_url_specify_cert) retCode = checkUrlCert();
        if (retCode != "success") { TestConnectionError(retCode); return;}

        if (top.gl_isProxy) retCode = checkProxyInput();
        if (retCode != "success") { TestConnectionError(retCode); return;}

        deleteFile(top.getSupportFile("proxyTemp"));
        var args = new Array();
        args.push(top.getSystemFile("oneCli"));
        args.push("misc");
        args.push("testconnection");

        args.push("--url");
        args.push(urlToTest);
        
        args.push("--file");
        args.push(top.getSupportFile("proxyTemp"));
        args.push(...add_output_log5());
        args.push(...add_proxy_para());

        top.showProxyWaitingMsg();

        printLog("INFO","run command:" + getRunProgramCommend(args));
        runProgram(args, null, showChkProxyCallback);
    }

    function showChkProxyCallback() {
        top.hideProxyWaitingMsg();
        if (userCanceled) {
            top.togglePrevious(true);
            top.toggleNext(true);
            return;
        }
        var retMsg = parseCheckProxyResult();
        if (retMsg == "" || retMsg == null || retMsg == undefined) {
            retMsg = "Unknown error";
        }
        if (retMsg.toLowerCase() == "success." || retMsg.toLowerCase() == "succeed.") {
            $("#testOtherStatus").html("<img src=\"images/statusSuccess.gif\" >");
            $("#testOtherMsg").html("Success");
        } else {
            $("#testOtherStatus").html("<img src=\"images/StatusCritical.gif\" >");
            $("#testOtherMsg").html(retMsg);
        }
        togglePrevious(true);
        toggleNext(true);
    }

    function checkHostName(hostName) {
        var expHostName = /((^\s*((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))\s*$)|(^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$))|(^\s*((?=.{1,255}$)(?=.*[A-Za-z].*)[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?)*)\s*$)/;
        var flag = expHostName.test(hostName);
        if (flag) return true;
        else return false;
    }


    function checkUrlInput() {
        if (urlToTest == "") {
            $("#testUrl").focus();
            return "url_empty";
        }
        return "success";
    }

    function checkUrlCert(){
        if (top.gl_url_cert == "") {
            $('#URLCertFile').focus();
            return 'url_cert_empty';
        }
        else if (!top.fileExists(top.gl_url_cert))
        {
            $('#URLCertFile').focus();
            return 'url_invalid_cert';
        }
        return 'success';
    }

    function checkProxyInput() {
        if (top.gl_proxy_address == "") {
            $('#pAdd').focus();
            return 'add_empty';
        }
        if (!checkHostName(top.gl_proxy_address)) {
            $('#pAdd').focus();
            return 'invalid_add';
        }
        if (top.gl_proxy_port == "") {
            $('#pPort').focus();
            return 'port_empty';
        }
        if (isNaN(top.gl_proxy_port) || parseInt(top.gl_proxy_port) < 1 || parseInt(top.gl_proxy_port) > 65535) {
            $('#pPort').focus();
            return 'invalid_port';
        }
        if (top.gl_proxy_account) {
            if (top.gl_proxy_username == "") {
                $('#pUid').focus();
                return 'user_empty';
            }
            if (top.gl_proxy_password == "") {
                $('#pPwd').focus();
                return 'pwd_empty';
            }
        }
        if (top.gl_proxy_custom && top.gl_proxy_specify_cert) {
            if (top.gl_proxy_cert == "") {
                $('#proxyCertFile').focus();
                return 'proxy_cert_empty';
            }
            else if (!top.fileExists(top.gl_proxy_cert))
            {
                $('#proxyCertFile').focus();
                return 'proxy_invalid_cert';
            }
        }
        return 'success';
    }

    function parseCheckProxyResult() {
        var fileLines;
        try {
            fileLines = top.readTextFile(top.getSupportFile("proxyTemp"));
        } catch(e) {
            return "Unknown error";
        }
        if (fileLines == "" || fileLines == null || fileLines == undefined) {
            return "Unknown error";
        } 
        return fileLines;
    }

    function setUserCancel(value) {
        userCanceled = value;
    } 

    function DisplayInnerText(pTagName, textVal) {
        document.getElementById(pTagName).innerText = textVal;
    }

    function setUrl() {
        urlToTest = $("#testUrl").val();
        printLog("INFO","set URL as " + urlToTest);
    }

    function openURLCertDir() {
        printLog("INFO","button 'Browse...' was clicked.");
        openFileDirectory("URLCertFile", getURLCertDir, 
		[{ name: 'File Type', extensions: ['pem'] }]);
    }

    function getURLCertDir(path){
        var cert=path;
        if(cert!=null && cert!=""){
            $("#URLCertFile").val(cert);
            top.gl_url_cert = cert;
        }
    }

    function showURLCustom() {
        var check = document.getElementById("checkURLCustom").checked;
        printLog("INFO","Custom URL security configuration. "+(check?"checked.":"unchecked."));
        check?$("#checkURLCustomDiv").show():$("#checkURLCustomDiv").hide();
        top.gl_url_custom = check;
        printLog("DEBUG","function showAccount end.");
    }

    function showURLSpecifyCertificate(val) {
        if (val == 0) {
            printLog("INFO","radio 'Accept Target server's certificate by default' was selected.");
            $("#URLSpecifyCertificateTable").hide();
            top.gl_url_specify_cert = false;
            top.gl_url_insecure = true;
        } else if (val == 1) {
            printLog("INFO","radio 'Specify the Certificate (PEM)' was selected.");
            $("#URLSpecifyCertificateTable").show()
            top.gl_url_specify_cert = true;
            top.gl_url_insecure = false;
        }
    }

    function openProxyCertDir() {
        printLog("INFO","button 'Browse...' was clicked.");
        openFileDirectory("proxyCertFile", getProxyCertDir, 
		[{ name: 'File Type', extensions: ['pem'] }]);
    }

    function getProxyCertDir(path){
        var cert=path;
        if(cert!=null && cert!=""){
            $("#proxyCertFile").val(cert);
            top.gl_proxy_cert = cert;
        }
    }

    function showProxyCustom() {
        var check = document.getElementById("checkProxyCustom").checked;
        printLog("INFO","Custom Proxy security configuration. "+(check?"checked.":"unchecked."));
        check?$("#checkProxyCustomDiv").show():$("#checkProxyCustomDiv").hide();
        top.gl_proxy_custom = check;
        printLog("DEBUG","function showAccount end.");
    }

    function showProxySpecifyCertificate(val) {
        if (val == 0) {
            printLog("INFO","radio 'Accept Proxy Server's Certificate by default' was selected.");
            $("#ProxySpecifyCertificateTable").hide();
            top.gl_proxy_specify_cert = false;
            top.gl_proxy_insecure = true;
        } else if (val == 1) {
            printLog("INFO","radio 'Specify the Certificate (PEM) for Proxy Server' was selected.");
            $("#ProxySpecifyCertificateTable").show()
            top.gl_proxy_specify_cert = true;
            top.gl_proxy_insecure = false;
        }
    }

    function setProxyType(value) {
        top.gl_proxyType = value.toLowerCase();
        printLog("INFO","set ProxyType as " + value);
        
        switch (value)
        {
            case "HTTP":
            case "SOCKS4":
            case "SOCKS4A":
            case "SOCKS5":
            case "SOCKS5H":
                document.getElementById("checkProxyCustom").checked = false;
                showProxyCustom();
                $("#proxyCustomDiv").hide();
                break;
            case "HTTPS":
                $("#proxyCustomDiv").show();
                break;
            default:
                break;
        }
    }

    return {
        name: "Proxy_Setting",
        index: 0,
        init: proxy_init,
        setUserCancel: setUserCancel,
        setUrl: setUrl,
        enableProxy: enableProxy,
        setProxy: setProxy,
        showAccount: showAccount,
        TestConnection: TestConnection,
        nextAction: try_proxy_collect,
        showURLSpecifyCertificate: showURLSpecifyCertificate,
        openProxyCertDir: openProxyCertDir,
        showProxySpecifyCertificate: showProxySpecifyCertificate,
        openURLCertDir: openURLCertDir,
        getURLCertDir: getURLCertDir,
        getProxyCertDir: getProxyCertDir,
        setProxyType: setProxyType,
        showURLCustom: showURLCustom,
        showProxyCustom: showProxyCustom,
        resetUrl: resetUrl,
        importId: '#import_proxy_setting',
        selectorId: '.proxy_setting',
        title: "Navi.NetworkAccess",
        localizedTitle: tr("Navi.NetworkAccess")
    }
}();