// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Security_Task = function () {

    let mode = gl_MachineMode[7];
    let availTasks = [];
    let normalTaskNum;
    let flag = false;
    let formerLogFiles;
    let formerCmdStrs;
    let formerSteps;
    let formerTaskId;
    let agreement = false;
    let roleID = '';

    function disableItem(id) {
        $('#' + id).prop('disabled', true);
        $('#' + id).prop('checked', false);
        $('#' + id).parent().addClass("DisabledText");
    }

    function enableItem(id) {
        $('#' + id).prop('disabled', false);
        $('#' + id).parent().removeClass("DisabledText");
    }

    function isItemChecked(id) {
        return $('#' + id).prop("checked");
    }

    function preCheck() {
        $(".SecurityTask").children(':first-child').prop('disabled', false);
        $(".SecurityTask").removeClass('DisabledText');
        // [SED Management] will be grey out if user doesn't have Admin or Admin+ permission
        if (roleID != "Administrator" && roleID != "Administrator+") {
            disableItem("securityTasksSEDManagement");
            disableItem("securityTasksPortalActivation");
            $('#PermissionNotAllowedWarning').show();
        }
        switch (mode) {
            case gl_MachineMode[1]: // ThinkEdge_Enabled_Inactive
                if (!isItemChecked("securityTasksPortalActivate")) {
                    disableItem("securityTasksSEDManagement");
                }
                break;
            case gl_MachineMode[2]: // ThinkEdge_Enabled_Active
                disableItem("securityTasksPortalActivate");
                break;
            case gl_MachineMode[3]: // ThinkEdge_Local_Inactive
                if (!isItemChecked("securityTasksLocalActivate")) {
                    disableItem("securityTasksSEDManagement");
                    disableItem("securityTasksPortalActivation");
                    disableItem("securityTasksSyncEdgeStatus");
                }
                if (!isItemChecked('securityTasksPortalActivation')) {
                    $("#SecurityWarning").hide();
                }
                if ($("#SecurityWarning").css('display') == 'block') {
                    $('#securityTasksSyncEdgeStatus').prop('disabled', true);
                    $('#securityTasksSyncEdgeStatus').parent().addClass("DisabledText");
                }
                break;
            case gl_MachineMode[4]: // ThinkEdge_Local_Active
                if (!isItemChecked('securityTasksPortalActivation')) {
                    $("#SecurityWarning").hide();
                }
                if ($("#SecurityWarning").css('display') == 'block') {
                    $('#securityTasksSyncEdgeStatus').prop('disabled', true);
                    $('#securityTasksSyncEdgeStatus').parent().addClass("DisabledText");
                }
                break;
            case gl_MachineMode[5]: // ThinkEdge_Portal_Inactive
                if (!isItemChecked("securityTasksPortalActivate")) {
                    disableItem("securityTasksSEDManagement");
                }
                break;
            case gl_MachineMode[6]: // ThinkEdge_Portal_Active
                break;
            default: // ThinkEdge_Disabled (deprecated)
                break;
        }
    }

    function updateNavItems(toggledTaskName) {
        let checkboxidTaskLists = [
            "",                                 // 0
            "updateTasksUpdateOnly",            // 1
            "manageStagedTasks",                // 2
            "updateTasksRaidConfig",            // 3
            "updateTasksBiosConfig",            // 4
            "configSecurityTask",               // 5
            "securityTasksPortalActivate",      // 6
            "securityTasksLocalActivate",       // 7
            "securityTasksSyncEdgeStatus",      // 8
            "securityTasksEnableSecurity",      // 9
            "securityTasksSEDManagement",       // 10
            "securityTasksPortalActivation",    // 11
            "securityTasksSensorConfiguration", // 12
        ]

        if (toggledTaskName) {
            printLog("INFO", "toggle checkbox " + toggledTaskName + ".");
        }

        // update items with pre-check logic
        preCheck();

        top.onecliCommandStrings = formerCmdStrs.concat();
        top.logFiles = formerLogFiles.concat();
        top.gl_steps_current = formerSteps.concat();
        top.gl_task = formerTaskId.concat();

        let insertIndex = top.gl_steps_current.length - 1;
        availTasks.forEach(function (val, key) {
            if (document.getElementById(checkboxidTaskLists[val]).checked) {
                top.gl_steps_current.splice(insertIndex, 0, ...gl_taskLists[val]);
                top.gl_task.push(val);
                top.onecliCommandStrings.push("");
                top.logFiles.push("");
                insertIndex += gl_taskLists[val].length;
            }
        });

        // if claim/sync selected, insert proxy and TS account validation
        if (!top.bCheckForLatest) {
            if (top.gl_task.indexOf(top.gl_portal_activate) != -1 || top.gl_task.indexOf(top.gl_syncEdgeStatus) != -1) {
                top.gl_steps_current.splice(top.gl_steps_current.indexOf(Security_Task) + 1, 0, Proxy_Setting);
            }
        }

        // if sync and enable SP are selected simultaneously, delete sync task and page, add sync task into enable SP task
        if (top.gl_task.indexOf(top.gl_syncEdgeStatus) != -1 && top.gl_task.indexOf(top.gl_portalActivation) != -1) {
            top.gl_task.splice(top.gl_task.indexOf(top.gl_syncEdgeStatus), 1);
            top.gl_steps_current.splice(top.gl_steps_current.indexOf(TShield_Setting), 2);
            top.gl_steps_current.splice(top.gl_steps_current.indexOf(Portal_Activation), 0, TShield_Setting);
        }

        configSteps(top.gl_steps_current);

        // configSteps will renew the page so change content here
        // show server mode in title
        /* let header = $('#MtMode');
        let headerTitle = header.text();
        switch (mode) {
        case gl_MachineMode[1]:
            header.text(headerTitle + " -- Premium (Deactivated)");
            break;
        case gl_MachineMode[2]:
            header.text(headerTitle + " -- Premium (Activated)");
            break;
        case gl_MachineMode[0]:
            header.text(headerTitle + " -- Standard");
            break;
        } */

        printLog("DEBUG", "function updateNavItems end.");
    }

    function obtainTaskListWithMode(mtMode) {
        printLog("INFO", "Begin to obtain corresponding security operations.");
        let opsList = top.loadSetting("operation_defines.json");
        if (mtMode != null && mtMode != undefined) {
            // we can get here only in OOB mode
            return opsList["OOB"][mtMode].concat();
        }
        return opsList["OOB"][mode].concat();
    }

    function getSecurityTaskNum() {
        return top.loadSetting("operation_defines.json")["SecurityTaskNum"];
    }

    function ShowIntroduction() {
        let btn = $("#IntroductionBtn");
        let nodes = $("#IntroductionBtn").parent().parent().children();
        if (nodes[1].style.display == "none") {
            nodes[1].style.display = "block";
            btn.addClass("collapsiblebtn_active");
        } else {
            nodes[1].style.display = "none";
            btn.removeClass("collapsiblebtn_active");
        }
    }

    function waitingForAgreement() {
        let btn = $("#IntroductionBtn");
        while (!btn.hasClass("collapsiblebtn_active")) {
            btn.trigger('click');
        }
        btn.prop('disabled', true);
        $(".SecurityTask").children(':first-child').prop('disabled', true);
        $(".SecurityTask").addClass('DisabledText');
    }

    function AgreementReceived(obj) {
        let btn = $("#IntroductionBtn");
        while (btn.hasClass("collapsiblebtn_active")) {
            btn.trigger('click');
        }
        btn.prop('disabled', false);
        top.writeTextFile(top.getSupportFile("agreementFile"), 'agree');
        $("#AgreeBtn").prop('disabled', true);
        $("#AgreeBtn").hide();
        updateNavItems();
    }

    function createATag(content, url) {
        let aTag = document.createElement("a");
        aTag.href = url;
        aTag.target = "_blank";
        aTag.innerText = content;
        return aTag.outerHTML;
    }
    function setUrlContainer(id, content) {
        document.getElementById(id).innerHTML = content;
        setExternalExplorer(document.getElementById(id).getElementsByTagName("a")[0]);
    }

    function checkItems() {
        if ($('.SecurityTask input:checked').length == 0) {
            printLog("INFO", "Security Task: no item has been selected");
            alert($.i18n.prop("Task.needSelected"));
            return false;
        }

        if ($("#SecurityWarning").css('display') != 'block' &&
            // isItemChecked('securityTasksEnableSecurity') &&
            !isItemChecked('securityTasksSyncEdgeStatus') &&
            isItemChecked('securityTasksPortalActivation')) {
            $("#SecurityWarning").show();
            $('#securityTasksSyncEdgeStatus').prop('disabled', true);
            $('#securityTasksSyncEdgeStatus').parent().addClass("DisabledText");
            return false;
        }

        if ($("#SecurityWarning").css('display') == 'block' && $("#SecurityWarning").find('input:checked').length == 0) {
            alert($.i18n.prop("SecurityTask.needConfirm"));
            return false;
        }
        return true;
    }

    function HandleWarningOption(obj) {
        let yes = $('#SecurityWarningYes');

        // Claim must be chosen or canceled at the same time
        if (yes.prop('checked')) {
            $('#securityTasksSyncEdgeStatus').prop('checked', true);
        } else {
            $('#securityTasksSyncEdgeStatus').prop('checked', false);
        }

        updateNavItems();
    }

    function edgeGetInfo() {
        let edgeserverStatusPath = top.getSupportFile("edgeserverStatus");
        let ret = gl_MachineMode[7]; // Default
        if (top.fileExists(edgeserverStatusPath)) {
            try {
                let xccInfo = JSON.parse(top.readTextFile(edgeserverStatusPath));
                let xccWave = xccInfo["Wave"];
                let xccStatus;
                if (xccWave.toLowerCase() == "wave1") {
                    let xccMode = xccInfo["Mode"]; // enabled/disabled/unsupported
                    xccStatus = xccInfo["Status"]; // inactive/active (only presented when mode = enabled)
                    if (xccMode.toLowerCase() == "enabled") {
                        if (xccStatus.toLowerCase() != "active") {
                            ret = gl_MachineMode[1]; // ThinkEdge_Enabled_Inactive
                        } else {
                            ret = gl_MachineMode[2]; // ThinkEdge_Enabled_Active
                        }
                    } else if (xccMode.toLowerCase() == "disabled") {
                        ret = gl_MachineMode[0] // ThinkEdge_Disabled
                    }
                } else {
                    let xccActivationMethod = xccInfo["Activation Method"];
                    xccStatus = xccInfo["Status"];
                    if (xccActivationMethod.toLowerCase() == "local") {
                        ret = xccStatus.toLowerCase() != "active" ? gl_MachineMode[3] : gl_MachineMode[4];
                    } else if (xccActivationMethod.toLowerCase() == "portal") {
                        ret = xccStatus.toLowerCase() != "active" ? gl_MachineMode[5] : gl_MachineMode[6];
                    }
                }
                top.gl_Edge_Machine_Params.ActivationCode = xccInfo["Active Code"];
                top.gl_Edge_Machine_Params.ChallengeText = xccInfo["Challenge Text"];
                top.gl_Edge_Machine_Params.SN = xccInfo["Serial Number"];
                top.gl_Edge_Machine_Params.roleID = xccInfo["User Role ID"];
                top.gl_Edge_Machine_Params.SEDEnabled = xccInfo["SED Encryption"];
                top.gl_Edge_Machine_Params.SEDEncryptionMethod = xccInfo["SED Generate method"];
                top.gl_Edge_Machine_Params.Wave = xccWave;
                top.gl_Edge_Machine_Params.ChassisIntrusionDetectionEnable = xccInfo["Chassis Intrusion Detection Enable"];
                top.gl_Edge_Machine_Params.GSensor.MotionDetectionMode = xccInfo["MotionDetection"]["Motion Detection Mode"];
                top.gl_Edge_Machine_Params.GSensor.StepCounter = xccInfo["MotionDetection"]["StepCounter"];
                top.gl_Edge_Machine_Params.GSensor.ThresholdLevel = xccInfo["MotionDetection"]["ThresholdLevel"];
            } catch (e) {
                printLog("ERROR", "Failed to read edgeserverStatus json.");
                ret = gl_MachineMode[7]; // Default
                printLog("DEBUG", "Current machine mode is ", ret);
                console.log("Current machine mode is", ret);
                return ret;
            }
        }
        printLog("DEBUG", "Current machine mode is ", ret);
        console.log("Current machine mode is", ret);
        top.gl_Edge_Machine_Params.MachineMode = ret;
        return ret;
    }

    function edgeGetInfoCmd() {
        let edgeserverStatusPath = top.getSupportFile("edgeserverStatus");
        if (top.fileExists(edgeserverStatusPath)) {
            top.deleteFile(edgeserverStatusPath);
        }
        let args = [];
        args.push(top.getSystemFile("oneCli"));
        args.push("edgeserver");
        args.push("getsecurityinfo");
        args.push("--bmc");
        args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
        args.push(...add_output_log5());
        printLog("INFO", "run command:" + getRunProgramCommend(args));
        return new Promise((resolve) => {
            runProgram(args, null, (res) => {
                resolve(res);
            })
        });
    }

    let gl_htmlTaskLists = null;

    function Init() {
        printLog("INFO", "Security task page init");

        top.gl_isAccountValidated = false;
        top.TShield_Setting.setTaskUnDone();

        top.togglePrevious(false);
        top.toggleNext(false);
        top.showUnstoppableWaitMsg();
        edgeGetInfoCmd().then(res => {
            edgeGetInfo();
            mode = top.gl_Edge_Machine_Params.MachineMode;
            roleID = top.gl_Edge_Machine_Params.roleID

            if (mode == gl_MachineMode[1] || // ThinkEdge_Enabled_Inactive
                mode == gl_MachineMode[3] || // ThinkEdge_Local_Inactive
                mode == gl_MachineMode[5]) { // ThinkEdge_Portal_Inactive
                $('#LockDownHint').show();
            } else {
                $('#LockDownHint').hide();
            }

            $("#SecurityWarning").find('input').prop('checked', false);
            $("#SecurityWarning").hide();
            $('#SecurityWarning').find('p').eq(0).html($.i18n.prop("SecurityTask.ClaimWarning"));
            let link1 = createATag($.i18n.prop("TShieldSetting.Pattern3"), "https://lenovopress.lenovo.com/lp1725-thinkedge-security");
            setUrlContainer("SecurityFeatureIntro", $.i18n.prop("SecurityTask.TsIntro", link1));
            let link2 = createATag($.i18n.prop("TShieldSetting.Pattern1"), "https://lenovopress.lenovo.com/lp1725-thinkedge-security");
            setUrlContainer("PermissionNotAllowedMessage", $.i18n.prop("SecurityTask.PermissionNotAllowedMessage", link2));

            if (false == flag) {
                formerCmdStrs = top.onecliCommandStrings.concat();
                formerLogFiles = top.logFiles.concat();
                formerSteps = top.gl_steps_current.concat();
                formerTaskId = top.gl_task.concat();
                flag = true;
            }

            /*
            * display tasks according to security mode (get task list from operation_defines.json)
            * ThinkEdge_Locked: [Activate, Config, BackUpSEDKey, RecoverSEDKey]
            * ThinkEdge_Activated: [Activate(grey out), Config, BackUpSEDKey, RecoverSEDKey]
            * ThinkEdge_Upgradeable: [Claim, Enable, Config, BackUpSEDKey] back up sed supported in standard mode?
            */

            availTasks = obtainTaskListWithMode(null);

            if (!gl_htmlTaskLists) {
                gl_htmlTaskLists = [
                /*gl_createRepo*/"",
                /*gl_isUpdate*/"",
                /*gl_stagedTask*/"",
                /*gl_configRaid*/"",
                /*gl_biosConfigure*/"",
                /*gl_configSecurity*/"",
                /*gl_portal_activate*/document.getElementById("TaskWrapper5").innerHTML,
                /*gl_local_activate*/document.getElementById("TaskWrapper6").innerHTML,
                /*gl_syncEdgeStatus*/document.getElementById("TaskWrapper7").innerHTML,
                /*gl_enableSecurity*/document.getElementById("TaskWrapper8").innerHTML,
                /*gl_sedManagement*/document.getElementById("TaskWrapper9").innerHTML,
                /*gl_portalActivation*/document.getElementById("TaskWrapper10").innerHTML,
                /*gl_sensorConfiguration*/document.getElementById("TaskWrapper11").innerHTML
                ];
            }

            normalTaskNum = gl_htmlTaskLists.length - getSecurityTaskNum() - 1; // minus 1 because configRaid does not count
            // Display available operations by pre-defined order, hide unavailable operations
            availTasks.forEach(function (val, key) {
                /* document.getElementById("TaskWrapper" + (normalTaskNum+key)).innerHTML = gl_htmlTaskLists[val];
                document.getElementById("TaskWrapper" + (normalTaskNum+key)).style.display = "block"; */
                $("#TaskWrapper" + (normalTaskNum + key)).html(gl_htmlTaskLists[val]);
                $("#TaskWrapper" + (normalTaskNum + key)).show();
            });
            // gl_htmlTaskLists.length - 1 because task createRepo does not exist in this page
            for (let i = normalTaskNum + availTasks.length; i < gl_htmlTaskLists.length - 1; ++i) {
                document.getElementById("TaskWrapper" + i).style.display = "none";
            }

            updateNavItems();

            try {
                agreement = top.fileExists(top.getSupportFile("agreementFile"));
            } catch (e) { }

            // if it's the first time launch, force to show introduction and grey out all items
            if (false == agreement) {
                waitingForAgreement();
            } else {
                AgreementReceived();
            }

            top.togglePrevious(true);
            top.toggleNext(true);
            top.hideUnstoppableWaitMsg();
            $(".SecurityTask").children(':first-child').prop('checked', false);
        })
    }

    function showHelpPage(task) {
        printLog("INFO", "Show help info of '" + task + "' was clicked.");
        let mywidth = 600;
        let myheight = 400;
        let myleft = (screen.width - mywidth) / 2;
        let mytop = (screen.height - myheight) / 2;
        let pageOpts = 'width=' + mywidth + ', height=' + myheight;
        pageOpts += ', top=' + mytop + ', left=' + myleft;
        pageOpts += ', directories=no';
        pageOpts += ', location=no';
        pageOpts += ', menubar=yes';
        pageOpts += ', resizable=yes';
        pageOpts += ', scrollbars=yes';
        pageOpts += ', status=no';
        pageOpts += ', toolbar=no';
        pageOpts += ', close=yes';
        pageOpts += ', show=true';
        pageOpts += ', title=Lenovo XClarity Essentials UpdateXpress';
        let helpContent = "";
        if ("EnableSecurity" == task) {
            helpContent = "<HTML><BODY style='white-space:normal;'>" + $.i18n.prop("UpdateTask.HelpInfo.EnableSecurity") + "<\/BODY><\/HTML>";
        } else if ("Portal Activate" == task) {
            helpContent = "<HTML><BODY style='white-space:normal;'>" + $.i18n.prop("UpdateTask.HelpInfo.PortalActivate") + "<\/BODY><\/HTML>";
        } else if ("Local Activate" == task) {
            helpContent = "<HTML><BODY style='white-space:normal;'>" + $.i18n.prop("UpdateTask.HelpInfo.LocalActivate") + "<\/BODY><\/HTML>";
        } else if ("SyncEdgeStatus" == task) {
            if (gl_Edge_Machine_Params.MachineMode == gl_MachineMode[3] || gl_Edge_Machine_Params.MachineMode == gl_MachineMode[4]) {
                helpContent = "<HTML><BODY style='white-space:normal;'>" + $.i18n.prop("UpdateTask.HelpInfo.SyncEdgeStatusInLocal") + "<\/BODY><\/HTML>";
            } else if (gl_Edge_Machine_Params.MachineMode == gl_MachineMode[5] || gl_Edge_Machine_Params.MachineMode == gl_MachineMode[6]) {
                helpContent = "<HTML><BODY style='white-space:normal;'>" + $.i18n.prop("UpdateTask.HelpInfo.SyncEdgeStatusInPortal") + "<\/BODY><\/HTML>";
            }
        } else if ("SEDManagement" == task) {
            helpContent = "<HTML><BODY style='white-space:normal;'>" + $.i18n.prop("UpdateTask.HelpInfo.SEDManagement") + "<\/BODY><\/HTML>";
        } else if ("PortalActivation" == task) {
            // PortalActivation help info
            helpContent = "<HTML><BODY style='white-space:normal;'>" + $.i18n.prop("UpdateTask.HelpInfo.PortalActivation") + "<\/BODY><\/HTML>";
        } else if ("SensorConfiguration" == task) {
            helpContent = "<HTML><BODY style='white-space:normal;'>" + $.i18n.prop("Sensor configuration content") + "<\/BODY><\/HTML>";
        }
        top.writeTextFile(top.getSupportFile("helpHtml"), helpContent);

        let helpWindow = window.open("file://" + top.getSupportFile("helpHtml"), "", pageOpts);
        if (window.focus) helpWindow.focus();
    }

    return {
        index: 0,
        name: "Security_Task",
        init: Init,
        nextAction: checkItems,
        previousAction: function () {
            top.toggleNext(true);
            return true;
        },
        updateNavItems: updateNavItems,
        ShowIntroduction: ShowIntroduction,
        AgreementReceived: AgreementReceived,
        HandleWarningOption: HandleWarningOption,
        showHelpPage: showHelpPage,
        importId: '#import_security_task',
        selectorId: '.security_task',
        title: "Navi.SecurityTask",
        localizedTitle: tr("Navi.SecurityTask"),
        needReInit: true
    }
}();