// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
export let sedBackup = function () {
    return {
        created () {
            this.path = top.getSupportDir() + "backup.txt";
        },
        data () {
            return {
                iconStyle: clone(Sed_Management.iconStyle),
                iconFalseImg: clone(Sed_Management.iconFalseImg),
                iconTrueImg: clone(Sed_Management.iconTrueImg),
                floatingStyle: clone(Sed_Management.floatingStyle),
                passwdInputStyle: clone(Sed_Management.passwdInputStyle),

                path: '',
                setPassword: '',
                confirmPassword: '',
                isStart: false,
                imgPath: '',
                showFloating_a: false,
                showFloating_b: false,
                errmsg: '',
                isFailed: true,
                isRunning: false,
                isFinished: false,
                isBackupDisabled: true,
                setOk: false,
                confirmOk: false,
                tips_a: [
                    { id: 0, text: $.i18n.prop("SEDManagement.TipFieldRequired"), show: false },
                    { id: 1, text: $.i18n.prop("SEDManagement.TipPasswdNumberLimit"), show: false },
                ],
                tips_b: [
                    { id: 0, text: $.i18n.prop("SEDManagement.TipFieldRequired"), show: false },
                    { id: 1, text: $.i18n.prop("SEDManagement.TipConfirmNeedSame"), show: false },
                    { id: 2, text: $.i18n.prop("SEDManagement.TipNotNull"), show: false },
                    { id: 3, text: $.i18n.prop("SEDManagement.TipPasswdNumberLimit"), show: false },
                ],
            }
        },
        emits: ['afterBackup'],
        methods: {
            openWorkingDir (filename) {
                printLog("INFO", "button 'Browse...' was clicked.");
                this.path = getFileParentdir(filename);
            },
            checkBackupPasswd () {
                let isCompliantPassword = true;
                let isCompliantComfirm = true;
                let set = this.setPassword;
                let confirm = this.confirmPassword;
                let tips_a = this.tips_a;
                let tips_b = this.tips_b;
                tips_a.forEach(element => {
                    element.show = false;
                });
                tips_b.forEach(element => {
                    element.show = false;
                });
                this.isBackupDisabled = false;
                // SetPassword input box
                if (set.length == 0) {
                    isCompliantPassword = false;
                    tips_a[0].show = true;
                    tips_a[1].show = true;
                } else if (set.length < 9 || set.length > 64) {
                    isCompliantPassword = false;
                    tips_a[1].show = true;
                }
                if (isCompliantPassword) {
                    this.setOk = true;
                    this.showFloating_a = false;
                } else {
                    this.setOk = false;
                    this.showFloating_a = true && $('#sedbak_password').is(":focus");
                }
                // ConfirmPassword input box
                if (confirm.length == 0) {
                    isCompliantComfirm = false;
                    tips_b[0].show = true;
                    tips_b[3].show = true;
                } else if (confirm.length < 9 || confirm.length > 64) {
                    isCompliantComfirm = false;
                    tips_b[3].show = true;
                }
                if (set.length == 0) {
                    isCompliantComfirm = false;
                    tips_b[2].show = true;
                } else if (confirm != set) {
                    isCompliantComfirm = false;
                    tips_b[1].show = true;
                }
                if (isCompliantComfirm) {
                    this.confirmOk = true;
                    this.showFloating_b = false;
                } else {
                    this.confirmOk = false;
                    this.showFloating_b = true && $('#sedbak_password_repeat').is(":focus");
                }
                // button
                if (isCompliantPassword && isCompliantComfirm) {
                    this.isBackupDisabled = false;
                } else {
                    this.isBackupDisabled = true;
                }
            },
            checkBckupDirPath () {
                let path = this.path;
                if (path.endsWith("\\") || path.endsWith("/")) {
                    alert($.i18n.prop("SEDManagement.NotAFilePath"));
                    return false;
                }
                let dir = top.dirname(path);
                let ret = validatePath(dir);
                if (ret != "success") {
                    if (ret == $.i18n.prop("Common.UnavailablePath")) {
                        if (confirm($.i18n.prop("SEDManagement.DirectoryNotExist"))) {
                            createDirectory(dir);
                            if (!directoryExists(dir)) {
                                alert($.i18n.prop("Common.CreatePathFailure"));
                                return false;
                            }
                        } else {
                            return false;
                        }
                    } else {
                        alert(ret);
                        return false;
                    }
                }
                if (top.fileExists(path)) {
                    if (!confirm($.i18n.prop("SEDManagement.OverwriteFile", top.basename(path)))) {
                        return false;
                    }
                }
                return true;
            },
            startBackup () {
                printLog("INFO", "SED Backup begin.");
                if (!this.checkBckupDirPath()) {
                    return false;
                }
                Sed_Management.startProcess(this);
                deleteFile(top.getSupportFile("commonResult"));
                let args = [];
                args.push(top.getSystemFile("oneCli"));
                args.push("config");
                args.push("backup");
                args.push("Security.SED_AK");
                args.push("--file");
                args.push(this.path);
                args.push("--passphrase");
                args.push(this.setPassword);
                args.push("--bmc");
                args.push(SplitFullConnInfo());
                args.push("--never-check-trust");
                args.push("--redfish");
                args.push(...add_output_log5());
                top.store_onecli_command(args);
                printLog("INFO", "run command:" + getRunProgramCommend(args));
                // The function need to bind this object to use the data
                const cb = Sed_Management.onProcessFinished.bind(this);
                runProgram(args, null, (res)=>{
                    cb(res);
                    if(res){
                        this.$emit('afterBackup');
                    }
                });
            },
            hideFormatTips () {
                this.showFloating_a = false;
                this.showFloating_b = false;
            },
            showFormatTips (e) {
                this.checkBackupPasswd();
                this.floatingStyle = clone(Sed_Management.floatingStyle);
                let factor = 1.5;
                let elemRect = e.currentTarget.getBoundingClientRect();
                this.floatingStyle.top = (elemRect.bottom + 3) + "px";
                this.floatingStyle.left = (elemRect.left) + "px";
                this.floatingStyle.width = (elemRect.width * factor) + "px";
            },
            hideFormatTips () {
                this.showFloating_a = false;
                this.showFloating_b = false;
            },
            tr: tr,
        },
        watch: {
            'setPassword' (passwd) {
                this.checkBackupPasswd();
            },
            'confirmPassword' (passwd) {
                this.checkBackupPasswd();
            },
        },
        computed: {
            BackupRunning () {
                return this.isRunning;
            },
            BackupFailed () {
                return this.isFailed;
            },
            BackupFinished () {
                return this.isFinished;
            },
        },
        // Read template file
        template: readTextFile(appBasePath() + '/js/ext/Sed_Management/components/Sed_Backup.html')
    }
}();