// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
export let sedGenerate = function () {
    return {
        data () {
            return {
                iconStyle: clone(Sed_Management.iconStyle),
                iconFalseImg: clone(Sed_Management.iconFalseImg),
                iconTrueImg: clone(Sed_Management.iconTrueImg),
                floatingStyle: clone(Sed_Management.floatingStyle),
                passwdInputStyle: clone(Sed_Management.passwdInputStyle),

                selId: 1,
                imgPath: '',
                setPassword: '',
                confirmPassword: '',
                showFloating_a: false,
                showFloating_b: false,
                isGenDisabled: false,
                errmsg: '',
                isFailed: true,
                isRunning: false,
                isFinished: false,
                setOk: false,
                confirmOk: false,
                opts: [
                    { id: 1, title: $.i18n.prop("SEDManagement.Change.PassphraseMethod") },
                    { id: 2, title: $.i18n.prop("SEDManagement.Change.RandomMethod") },
                ],
                regex: /^(?!.*(.)\1\1)(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\W_]+$)(?![a-z0-9]+$)(?![a-z\W_]+$)(?![0-9\W_]+$)(?![a-zA-Z\W_]+$)[a-zA-Z0-9\W_]{10,32}$/,
                rules: [
                    { exp: /^[a-zA-Z0-9~`!@#$%^&*\(\)\-\+={}[\]\|:;"'<>,?/._]+$/, pass: true },
                    { exp: /^[^a-zA-Z]+$/, pass: false },
                    { exp: /^[^0-9]+$/, pass: false },
                    { exp: /.*(.)\1\1/, pass: false },
                    { exp: /(?![A-Z]+$)(?![a-z]+$)(?![\W_]+$)([A-Z]|[a-z]|[~`!@#$%^&*\(\)\-\+={}[\]\|:;"'<>,?/._])+/, pass: true },
                    { exp: /.{10,32}/, pass: true }
                ],
                tips_a: [
                    { id: 0, text: $.i18n.prop("SEDManagement.TipFieldRequired"), show: false },
                    { id: 1, text: $.i18n.prop("SEDManagement.Tip1"), show: false },
                    { id: 2, text: $.i18n.prop("SEDManagement.Tip2"), show: false },
                    { id: 3, text: $.i18n.prop("SEDManagement.Tip2"), show: false },
                    { id: 4, text: $.i18n.prop("SEDManagement.Tip4"), show: false },
                    { id: 5, text: $.i18n.prop("SEDManagement.Tip5"), show: false },
                    { id: 6, text: $.i18n.prop("SEDManagement.Tip6"), show: false },
                ],
                tips_b: [
                    { id: 0, text: $.i18n.prop("SEDManagement.TipFieldRequired"), show: false },
                    { id: 1, text: $.i18n.prop("SEDManagement.TipConfirmNeedSame"), show: false },
                    { id: 2, text: $.i18n.prop("SEDManagement.TipNotNull"), show: false },
                    { id: 3, text: $.i18n.prop("SEDManagement.Tip6"), show: false },
                ],
            }
        },
        methods: {
            startGenerate () {
                Sed_Management.startProcess(this);
                const cb = Sed_Management.onProcessFinished.bind(this);
                deleteFile(top.getSupportFile("commonResult"));
                let args = [];
                switch (this.selId) {
                    case 1:
                        // generate SED AK using passphrase
                        printLog("INFO", "Generate SED AK using passphrase.")
                        args.length = 0;
                        args.push(top.getSystemFile("oneCli"));
                        args.push("config");
                        args.push("generate");
                        args.push("Security.SED_AK");
                        args.push("--passphrase");
                        args.push(this.setPassword);
                        args.push("--bmc");
                        args.push(SplitFullConnInfo());
                        args.push("--never-check-trust");
                        args.push("--redfish");
                        args.push(...add_output_log5());
                        top.store_onecli_command(args);
                        printLog("INFO", "run command:" + getRunProgramCommend(args));
                        runProgram(args, null, (res)=>{
                            cb(res);
                            if(res){
                                this.$emit("afterGenerate", false);
                            }
                        });
                        break;
                    case 2:
                        // run random method
                        printLog("INFO", "Generate a random SED AK.")
                        args.length = 0;
                        args.push(top.getSystemFile("oneCli"));
                        args.push("config");
                        args.push("generate");
                        args.push("Security.SED_AK");
                        args.push("--bmc");
                        args.push(SplitFullConnInfo());
                        args.push("--never-check-trust");
                        args.push("--redfish");
                        args.push(...add_output_log5());
                        top.store_onecli_command(args);
                        printLog("INFO", "run command:" + getRunProgramCommend(args));
                        runProgram(args, null, (res)=>{
                            cb(res);
                            if(res){
                                this.$emit("afterGenerate", true);
                                // this.imgPath = "images/statusWarning_obj16.gif"
                            }
                        });
                    default:
                        break;
                }
            },
            checkGenPasswdFormat () {
                let tips_a = this.tips_a;
                let rules = this.rules;
                let passwd = this.setPassword;
                let res = true;
                if (passwd == '') {
                    tips_a.forEach(e => {
                        e.show = true;
                    })
                    return false;
                }
                for (let i = 0; i < rules.length; ++i) {
                    if (rules[i].pass != rules[i].exp.test(passwd)) {
                        tips_a[i + 1].show = true;
                        res = false;
                    }
                }
                res &= this.regex.test(passwd);
                return res;
            },
            checkGenPasswd () {
                let a = this.setPassword;
                let b = this.confirmPassword;
                let tips_a = this.tips_a;
                let tips_b = this.tips_b;
                let setRes = true;
                let confirmRes = true;
                tips_a.forEach(e => {
                    e.show = false;
                })
                tips_b.forEach(e => {
                    e.show = false;
                })
                if (a == '') {
                    tips_a[0].show = true;
                    tips_b[2].show = true;
                    setRes = false;
                }
                if (b == '') {
                    tips_b[0].show = true;
                    confirmRes = false;
                }
                if (b.length < 10 || b.length > 32) {
                    tips_b[3].show = true;
                    confirmRes = false;
                }
                if (a != b) {
                    tips_b[1].show = true;
                    confirmRes = false;
                }
                setRes = this.checkGenPasswdFormat();
                if (setRes) {
                    this.setOk = true;
                    this.showFloating_a = false;
                } else {
                    this.setOk = false;
                    this.showFloating_a = true && $('#sedgen_password').is(":focus");
                }
                if (confirmRes) {
                    this.confirmOk = true;
                    this.showFloating_b = false;
                } else {
                    this.confirmOk = false;
                    this.showFloating_b = true && $('#sedgen_password_repeat').is(":focus");
                }
                if (confirmRes && setRes) {
                    this.isGenDisabled = false;
                } else {
                    this.isGenDisabled = true;
                }
                return setRes && confirmRes;
            },
            showFormatTips (e) {
                this.checkGenPasswd();
                this.floatingStyle = clone(Sed_Management.floatingStyle);
                let factor = 1.5;
                if ($('#sedgen_password').is(":focus")) {
                    factor = 2;
                }
                let elemRect = e.currentTarget.getBoundingClientRect();
                this.floatingStyle.top = (elemRect.bottom + 3) + "px";
                this.floatingStyle.left = (elemRect.left) + "px";
                this.floatingStyle.width = (elemRect.width * factor) + "px";
            },
            hideFormatTips () {
                this.showFloating_a = false;
                this.showFloating_b = false;
            },
            tr: tr
        },
        emits: ['methodChange', "afterGenerate"],
        watch: {
            'setPassword' (passwd) {
                this.checkGenPasswd();
            },
            'confirmPassword' (passwd) {
                this.checkGenPasswd();
            },
        },
        computed: {
            IsGenerateDisabled () {
                if (!this.GenerateUsingPassphrase) {
                    return false;
                }
                return !this.checkGenPasswd();
            },
            GenerateUsingPassphrase () {
                return this.selId == 1;
            },
            GenerateRunning () {
                return this.isRunning;
            },
            GenerateFailed () {
                return this.isFailed;
            },
            GenerateFinished () {
                return this.isFinished;
            },
        },
        // Read template file
        template: readTextFile(appBasePath() + '/js/ext/Sed_Management/components/Sed_Generate.html')
    }
}();