// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
export let sedRecover = function () {

    function getBackupFileDir (path) {
        if (path != null && path != "") {
            this.path = path;
        }
    }

    return {
        created () {
            this.path = top.getSupportDir() + "backup.txt";
        },
        data () {
            return {
                iconStyle: clone(Sed_Management.iconStyle),
                iconFalseImg: clone(Sed_Management.iconFalseImg),
                iconTrueImg: clone(Sed_Management.iconTrueImg),
                floatingStyle: clone(Sed_Management.floatingStyle),
                passwdInputStyle: clone(Sed_Management.passwdInputStyle),

                opts: [
                    { id: 1, title: $.i18n.prop("SEDManagement.Recover.FromBakMethod") },
                    { id: 2, title: $.i18n.prop("SEDManagement.Recover.UsingPassphrase") },
                ],
                selId: 1,
                bakPasswd: '',
                pasPasswd: '',
                showFloating_a: false,
                showFloating_b: false,
                isRecBakDisabled: true,
                isRecPasDisabled: true,
                imgPath: '',
                errmsg: '',
                isFailed: true,
                isRunning: false,
                isFinished: false,
                bakOk: false,
                pasOk: false,
                path: '',
                bakRegex: /^.{9,}$/,
                pasRegex: /^(?!.*(.)\1\1)(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\W_]+$)(?![a-z0-9]+$)(?![a-z\W_]+$)(?![0-9\W_]+$)(?![a-zA-Z\W_]+$)[a-zA-Z0-9\W_]{10,32}$/,
                rules: [
                    { exp: /^[a-zA-Z0-9~`!@#$%^&*\(\)\-\+={}[\]\|:;"'<>,?/._]+$/, pass: true },
                    { exp: /^[^a-zA-Z]+$/, pass: false },
                    { exp: /^[^0-9]+$/, pass: false },
                    { exp: /.*(.)\1\1/, pass: false },
                    { exp: /(?![A-Z]+$)(?![a-z]+$)(?![\W_]+$)([A-Z]|[a-z]|[~`!@#$%^&*\(\)\-\+={}[\]\|:;"'<>,?/._])+/, pass: true },
                    { exp: /.{10,32}/, pass: true }
                ],
                tips_a: [
                    { id: 0, text: $.i18n.prop("SEDManagement.TipFieldRequired"), show: false },
                    { id: 1, text: $.i18n.prop("SEDManagement.TipPasswdNumberLimit"), show: false },
                ],
                tips_b: [
                    { id: 0, text: $.i18n.prop("SEDManagement.TipFieldRequired"), show: false },
                    { id: 1, text: $.i18n.prop("SEDManagement.Tip1"), show: false },
                    { id: 2, text: $.i18n.prop("SEDManagement.Tip2"), show: false },
                    { id: 3, text: $.i18n.prop("SEDManagement.Tip2"), show: false },
                    { id: 4, text: $.i18n.prop("SEDManagement.Tip4"), show: false },
                    { id: 5, text: $.i18n.prop("SEDManagement.Tip5"), show: false },
                    { id: 6, text: $.i18n.prop("SEDManagement.Tip6"), show: false },
                ],
            }
        },
        methods: {
            checkRecPasswdFormat () {
                let tips_b = this.tips_b;
                let rules = this.rules;
                let passwd = this.pasPasswd;
                let res = true;
                if (passwd == '') {
                    tips_b.forEach(e => {
                        e.show = true;
                    })
                    return false;
                }
                // Check with each rule to see if the results meet expectations. (i.e., rules[i].pass)
                for (let i = 0; i < rules.length; ++i) {
                    if (rules[i].pass != rules[i].exp.test(passwd)) {
                        tips_b[i + 1].show = true;
                        res = false;
                    }
                }
                // Verify the password with a complete regular expression
                res &= this.pasRegex.test(passwd);
                return res;
            },
            checkRecBakPasswd () {
                let passwd = this.bakPasswd;
                let tips_a = this.tips_a;
                let res = true;
                tips_a.forEach(e => {
                    e.show = false;
                });
                if (passwd == '') {
                    tips_a[0].show = true;
                    res = false;
                }
                if (!this.bakRegex.test(passwd)) {
                    tips_a[1].show = true;
                    res = false;
                }
                if (res) {
                    this.bakOk = true;
                    this.isRecBakDisabled = false;
                    this.showFloating_a = false;
                } else {
                    this.bakOk = false;
                    this.isRecBakDisabled = true;
                    this.showFloating_a = true && $('#sedrec_bak_password').is(":focus");
                }
                return res;
            },
            checkRecPasPasswd () {
                let passwd = this.pasPasswd;
                let tips_b = this.tips_b;
                let res = true;
                tips_b.forEach(e => {
                    e.show = false;
                });
                if (passwd == '') {
                    tips_b[0].show = true;
                    res = false;
                }
                res &= this.checkRecPasswdFormat();
                if (res) {
                    this.pasOk = true;
                    this.isRecPasDisabled = false;
                    this.showFloating_b = false;
                } else {
                    this.pasOk = false;
                    this.isRecPasDisabled = true;
                    this.showFloating_b = true && $('#sedrec_pas_password').is(":focus");
                }
                return res;
            },
            checkBckupFilePath () {
                let path = this.path;
                if (path.endsWith("\\") || path.endsWith("/")) {
                    alert($.i18n.prop("SEDManagement.NotAFilePath"));
                    return false;
                }
                let dir = top.dirname(path);
                let ret = validatePath(dir);
                if (ret != "success") {
                    alert(ret);
                    return false;
                }
                if (!top.fileExists(path)) {
                    alert($.i18n.prop("SEDManagement.FileNotExsit"));
                    return false;
                }
                return true;
            },
            openBackupFileDir (id) {
                printLog("INFO", "button 'Browse...' was clicked.");
                const cb = getBackupFileDir.bind(this);
                openFileDirectory(id, cb,
                    [{ name: 'File Type', extensions: ['bak', 'txt'] }]);
            },
            startRestoreSEDAK () {
                printLog("INFO", "Start restore SED AK.");
                if (!this.checkBckupFilePath()) {
                    return;
                }
                Sed_Management.startProcess(this);
                // The function need to bind this object to use the data
                const cb = Sed_Management.onProcessFinished.bind(this);
                deleteFile(top.getSupportFile("commonResult"));
                let args = [];
                switch (this.selId) {
                    case 1:
                        printLog("INFO", "Recover SED AK using backup file.")
                        args.length = 0;
                        args.push(top.getSystemFile("oneCli"));
                        args.push("config");
                        args.push("restore");
                        args.push("Security.SED_AK");
                        args.push("--file");
                        args.push(this.path);
                        args.push("--passphrase");
                        args.push(this.bakPasswd);
                        args.push("--bmc");
                        args.push(SplitFullConnInfo());
                        args.push("--redfish");
                        args.push("--never-check-trust");
                        args.push(...add_output_log5());
                        top.store_onecli_command(args);
                        printLog("INFO", "run command:" + getRunProgramCommend(args));
                        runProgram(args, null, cb);
                        break;
                    case 2:
                        printLog("INFO", "Recover SED AK using passphrase.")
                        args.length = 0;
                        args.push(top.getSystemFile("oneCli"));
                        args.push("config");
                        args.push("restore");
                        args.push("Security.SED_AK");
                        args.push("--passphrase");
                        args.push(this.pasPasswd);
                        args.push("--bmc");
                        args.push(SplitFullConnInfo());
                        args.push("--redfish");
                        args.push("--never-check-trust");
                        args.push(...add_output_log5());
                        top.store_onecli_command(args);
                        printLog("INFO", "run command:" + getRunProgramCommend(args));
                        runProgram(args, null, cb);
                        break;
                }
            },
            showFormatTips (e) {
                this.checkRecBakPasswd();
                this.checkRecPasPasswd();
                this.floatingStyle = clone(Sed_Management.floatingStyle);
                let factor = 1.5;
                if ($('#sedgen_password').is(":focus") || $('#sedrec_pas_password').is(":focus")) {
                    factor = 2;
                }
                let elemRect = e.currentTarget.getBoundingClientRect();
                this.floatingStyle.top = (elemRect.bottom + 3) + "px";
                this.floatingStyle.left = (elemRect.left) + "px";
                this.floatingStyle.width = (elemRect.width * factor) + "px";
            },
            hideFormatTips () {
                this.showFloating_a = false;
                this.showFloating_b = false;
            },
            tr: tr
        },
        watch: {
            'bakPasswd' (passwd) {
                this.checkRecBakPasswd();
            },
            'pasPasswd' (passwd) {
                this.checkRecPasPasswd();
            },
        },
        computed: {
            RecoverUsingFile () {
                return this.selId == 1;
            },
            RecoverRunning () {
                return this.isRunning;
            },
            RecoverFailed () {
                return this.isFailed;
            },
            RecoverFinished () {
                return this.isFinished;
            }
        },
        // Read template file
        template: readTextFile(appBasePath() + '/js/ext/Sed_Management/components/Sed_Recover.html')
    }
}();