// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Sensor_Configuration = function () {

    const { reactive, ref, watch, computed } = Vue

    let sensorConfigApp = undefined;

    /* GSensor: {
        MotionDetectionMode: "Disabled",
        StepCounter: 0,
        ThresholdLevel: 0
    } */
    const sensorState = reactive({
        gSensor: null,
        chassisIntrusionDetectionEnable: top.gl_Edge_Machine_Params.ChassisIntrusionDetectionEnable
    });

    const modeOptions = reactive([
        { label: "Disabled", value: "Disabled", id:0 },
        { label: "Step Counter", value: "StepCounter", id:1 },
        { label: "Significant Motion", value: "SignificantMotion", id:2 }
    ]);

    const step2Value = {
        4: 0,
        10: 1,
        20: 2,
        50: 3,
        100: 4,
        500: 5,
    };

    const marks = reactive({
        0: {
            style: {
                color: 'black',
                'font-size': '12px'
            },
            label: '4 Steps\n(~2 meters)',
        },
        1: {
            style: {
                color: 'black',
                'font-size': '12px'
            },
            label: '10 Steps\n(~5 m)',
        },
        2: {
            style: {
                color: 'black',
                'font-size': '12px'
            },
            label: '20 Steps\n(~10 m)',
        },
        3: {
            style: {
                color: 'black',
                'font-size': '12px'
            },
            label: '50 Steps\n(~25 m)',
        },
        4: {
            style: {
                color: 'black',
                'font-size': '12px'
            },
            label: '100 Steps\n(~50 m)',
        },
        5: {
            style: {
                color: 'black',
                'font-size': '12px'
            },
            label: '500 Steps\n(~250 m)',
        }
    });

    const value2Step = reactive([4, 10, 20, 50, 100, 500]);

    const taskTool = TaskTool();

    const tipsStyle = reactive({
        'position': 'fixed'
    });

    const show = ref(false);

    const showFloatingIntro = function (e) {
        let elemRect = e.currentTarget.getBoundingClientRect();
        tipsStyle.top = (elemRect.top + 20) + "px";
        tipsStyle.left = (elemRect.left + 20) + "px";
        tipsStyle.width = (document.body.clientWidth - elemRect.left - 40) + "px";
        show.value = true;
    }

    const hideFloatingIntro = function () {
        show.value = false;
    }

    let vue_obj = {
        setup () {
            const sliderValue = computed({
                get () {
                    return step2Value[sensorState.gSensor.ThresholdLevel];
                },
                set (newValue) {
                    sensorState.gSensor.ThresholdLevel = value2Step[newValue];
                }
            });

            const content = reactive({
                title: tr("Sensor configuration intro"),
                intro: tr("Sensor configuration content")
            });


            const chassisIntrusionBtnSettings = reactive({
                name: tr("SecurityPack.IntrusionDetection"),
                label: ['Enable', 'Disable'],
                value: sensorState.chassisIntrusionDetectionEnable,
                hasTip: true,
                tip: tr("SecurityPack.ChassisIntrusionTips"),
            });

            let resetStepCounter = ref(false);
            const taskInfos = reactive([]);

            let applyConfig = function () {
                console.log(`MotionDetectionMode ${sensorState.gSensor.MotionDetectionMode}\n` +
                    `ThresholdLevel ${sensorState.gSensor.ThresholdLevel}\n` +
                    `StepCounter ${sensorState.gSensor.StepCounter}\n` +
                    `ChassisIntrusionDetectionEnable ${sensorState.chassisIntrusionDetectionEnable}`);

                taskInfos.length = 0;

                let args = [];
                args.push(top.getSystemFile("oneCli"));
                args.push("edgeserver");
                args.push("configmotiondetection");
                args.push("--mode");
                args.push(sensorState.gSensor.MotionDetectionMode);
                if (sensorState.gSensor.MotionDetectionMode) {
                    args.push("--thresholdlevel");
                    args.push(sensorState.gSensor.ThresholdLevel);
                }
                if (resetStepCounter.value && sensorState.gSensor.MotionDetectionMode) {
                    args.push("--reset-step-counter");
                }
                args.push("--bmc");
                args.push(SplitFullConnInfo());
                args.push("--never-check-trust");
                args.push(...add_output_log5());
                taskInfos.push(new taskTool.TaskInfo("ConfigMotionDetection", args, (res) => {
                    if (res) {
                        gl_Edge_Machine_Params.GSensor = clone(sensorState.gSensor);
                    } else {
                        sensorState.gSensor = clone(gl_Edge_Machine_Params.GSensor);
                    }
                }, new taskTool.TaskStatus(tr("Configure Motion Detection"), tr("Configure Motion Detection"))));

                args = [];
                args.push(top.getSystemFile("oneCli"));
                args.push("edgeserver");
                args.push("configintrusiondetection");
                args.push(sensorState.chassisIntrusionDetectionEnable ? "--enable" : "--disable");
                args.push("--bmc");
                args.push(SplitFullConnInfo());
                args.push("--never-check-trust");
                args.push(...add_output_log5());
                taskInfos.push(new taskTool.TaskInfo("ConfigChassisIntrusion", args, (res) => {
                    if (res) {
                        gl_Edge_Machine_Params.ChassisIntrusionDetectionEnable = sensorState.chassisIntrusionDetectionEnable;
                    } else {
                        sensorState.chassisIntrusionDetectionEnable = gl_Edge_Machine_Params.ChassisIntrusionDetectionEnable;
                    }
                }, new taskTool.TaskStatus(tr("Configure Chassis Intrusion"), tr("Configure Chassis Intrusion"))));

                taskTool.runOrderedTasksSync(taskInfos);
            }

            let cancelConfiguration = function() {
                sensorState.gSensor = clone(gl_Edge_Machine_Params.GSensor);
                sensorState.chassisIntrusionDetectionEnable = gl_Edge_Machine_Params.ChassisIntrusionDetectionEnable;
                chassisIntrusionBtnSettings.value = sensorState.chassisIntrusionDetectionEnable;
            }

            const warningSettings = reactive({
                show: false,
                warningContent: '',
                yesContent: '',
                noContent: '',
                hasYes: false,
                hasNo: false,
                level: 'warning'
            });

            watch(sensorState, (v)=>{
                warningSettings.show = v.gSensor.MotionDetectionMode == "Disabled" || !v.chassisIntrusionDetectionEnable;
                warningSettings.warningContent = (v.gSensor.MotionDetectionMode == "Disabled" ? tr('WarningWithoutMotionDetection')+'\<br>' : '') + (!v.chassisIntrusionDetectionEnable ? tr('WarningWithoutChassisIntrusion') : '');
            }, { immediate: true })

            return {
                sensorState,
                sliderValue,
                modeOptions,
                taskInfos,
                clickable : taskTool.clickable,
                content,
                chassisIntrusionBtnSettings,
                marks,
                value2Step,
                resetStepCounter,
                warningSettings,
                tipsStyle,
                show,
                applyConfig,
                cancelConfiguration,
                showFloatingIntro,
                hideFloatingIntro,
                tr,
            }
        }
    }

    let init_vue = async function () {
        if (sensorConfigApp == undefined) {
            sensorConfigApp = Vue.createApp(vue_obj);
            const { taskStatus } = await import('../Common_Components/Task_Status/Task_Status.js');
            const { collapsibleButton } = await import('../Common_Components/Collapsible_Button/Collapsible_Button.js');
            const { switchButton } = await import('../Common_Components/Switch_Button/Switch_Button.js');
            const { alert } = await import('../Common_Components/Alert/Alert.js');
            sensorConfigApp.component("taskstatus", taskStatus).component("collapsiblebutton", collapsibleButton).component("switchbutton", switchButton).component("alert", alert);
            sensorConfigApp.use(ElementPlus);
            sensorConfigApp.mount('#sensor_configuration_vue');
        }
    }

    let uninit = function () {
        if (sensorConfigApp != null || sensorConfigApp != undefined) {
            sensorConfigApp.unmount();
            sensorConfigApp = undefined;
        }
    }

    let init = function () {
        printLog("DEBUG", "Init sensor configuration app.");
        if (taskTool.stage.value == "done") {
            top.toggleNext(true);
            top.togglePrevious(true);
        } else {
            top.toggleNext(false);
            top.togglePrevious(true);
        } 
        sensorState.gSensor = clone(top.gl_Edge_Machine_Params.GSensor);
        sensorState.chassisIntrusionDetectionEnable = top.gl_Edge_Machine_Params.ChassisIntrusionDetectionEnable;
        init_vue();
    }

    return {
        index: 0,
        name: "Sensor_Configuration",
        init: init,
        uninit: uninit,
        nextAction: function () {
            return true;
        },
        previousAction: function () {
            return true;
        },
        importId: '#import_sensor_configuration',
        selectorId: '.sensor_configuration',
        title: "Navi.SensorConfiguration",
        localizedTitle: tr("Navi.SensorConfiguration"),
        needReInit: true
    }
}();