// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
//***********************************************************************************
// slide content for acqusition & selection
//***********************************************************************************
var TABLE_DIV_PRE = "table_div";
var TABLE_PRE = "table";
var TITLE_PRE = "title";
var CONTENT_DIV_PRE = "contentDiv";

var timer = 0;
var INTERVAL_TIME = 10; 		//ms
var SLIDE_TIME = 0.1 * 1000;	//ms
var moving_contentIndex = null;

// debug: no _doc
var _doc = document;

/**
 * instead of calling hide/display method immediately, hide or show the content slowly
 */
	
function slideContent(contentIndex){
	var content = _doc.getElementById(TABLE_DIV_PRE + contentIndex);
	var table = _doc.getElementById(TABLE_PRE + contentIndex);
	moving_contentIndex = contentIndex;
	if(content.style.display != "none"){		//to hide
		printLog("INFO","shown --> hidden");
		clearTimeout(timer);
		content.style.height = content.offsetHeight + "px";
		ac_moving_hide = true;
		move();
	} else {									//hidden --> show
		printLog("INFO","hidden --> shown");
		clearTimeout(timer);
		content.style.display = "";
		content.style.height = "1px";
		ac_moving_hide = false;
		move();
	}
//	_doc.getElementById(TITLE_PRE + contentIndex).style.width = table.offsetWidth + "px";				//align the title and table
}
/**
 * move a step
 */
function move(){
	var content = _doc.getElementById(TABLE_DIV_PRE + moving_contentIndex);
	var table = _doc.getElementById(TABLE_PRE + moving_contentIndex);
	var speed = table.offsetHeight / SLIDE_TIME * INTERVAL_TIME;
	if(speed < 1){
		speed = 1;
	}
	if(ac_moving_hide){
		var tmp = parseFloat(content.style.height.replace("px", "")) - speed;
		if(tmp > 1){
			content.style.height = tmp + "px";
			timer = setTimeout("move()", INTERVAL_TIME);
		}
		else {
			hideContent(moving_contentIndex);
			clearTimeout(timer);
			moving_contentIndex = null;
		}
	}
		else {
		var tmp = parseFloat(content.style.height.replace("px", "")) + speed;
		if(tmp < table.offsetHeight){
			content.style.height = tmp + "px";
			timer = setTimeout("move()", INTERVAL_TIME);
		}
		else {
			displayContent(moving_contentIndex);
			clearTimeout(timer);
			moving_contentIndex = null;
		}
	}
}
/**
 * hide the content after all packages 'Done' or 'Already Downloaded', except the last content
 */
function hideContent(contentIndex){
	_doc.getElementById(TABLE_DIV_PRE + contentIndex).style.display = "none";
	/*var img = _doc.getElementById(TITLE_PRE + contentIndex).childNodes[0];	
	img.src = "images/treeExpand_plus.gif";
	img.title = "display";*/
	var orginal_button = _doc.getElementById(TITLE_PRE + contentIndex).childNodes[0];
	orginal_button.className = "Expander";
	orginal_button.title = "display";
}

/**
 * display content table
 */
function displayContent(contentIndex){	
	_doc.getElementById(TABLE_DIV_PRE + contentIndex).style.height = "";
	_doc.getElementById(TABLE_DIV_PRE + contentIndex).style.display = "";
	/*var img = _doc.getElementById(TITLE_PRE + contentIndex).childNodes[0];	
	img.src = "images/treeExpand_mius.gif";
	img.title = "hide";*/
	var orginal_button = _doc.getElementById(TITLE_PRE + contentIndex).childNodes[0];
	orginal_button.className = "Contracter";
	orginal_button.title = "hide";
}

/**
 * response to click the content bar
 * ref is a reference of title bar
 */
function toggleContent(ref){
	if(moving_contentIndex){					//still moving...
		return;
	}

	var buttons = ref.getElementsByTagName("button");
	if(buttons.length < 1 || (buttons[0].className !== "Expander" && buttons[0].className !== "Contracter")) {			//no real content in xml yet
		return;
	}
	var contentIndex = ref.id.substring(TITLE_PRE.length);		//remove the prefix - "title"
	slideContent(contentIndex);
}

/**
 * response to click the expand button
 */
function toggleButton(index){
	return function(){
		if(moving_contentIndex){					//still moving...
			return;
		}
		slideContent(index);
	}
}

/**
 * when here comes a new content, add a content to the div
 */
function createContent(xname, mt, os, index, callback){
	var contentDiv = _doc.createElement("div");
	contentDiv.className = "ContentTableContainer";
	contentDiv.id = CONTENT_DIV_PRE + index;
	_details.insertBefore(contentDiv, null);
	callback(xname, mt, os, index, contentDiv);
	//createTable(index, contentDiv);
}

/**
 * create a table containing a content of packs
 */
function createTable(index, tableOwner){
	//insert a 'div'
	var tableDiv = _doc.createElement("div");
	tableDiv.id = TABLE_DIV_PRE + index;
	tableDiv.className = "ContentTableDiv";
	tableDiv.style.display = "none";
	_doc.getElementById(CONTENT_DIV_PRE + index).insertBefore(tableDiv, null);
	//insert a table
	var table = _doc.createElement("table");
	table.className = "EntityTable";
	table.cellSpacing = "0";
	table.style.width = "100%";
	table.id = TABLE_PRE + index;
	tableDiv.insertBefore(table, null);
	//create header
	var thr = table.insertRow(-1);
	if (tableOwner == "acquire") {
		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.style.width = "16%";
		th.innerHTML = header[0];
		
		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.innerHTML = header[1];
		th.style.width = "36%";
		
		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.innerHTML = header[2];
		th.style.width = "10%";
		
		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.innerHTML = header[3];
		th.style.width = "18%";

		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.innerHTML = header[4];
		th.style.width = "20%";
	} else if (tableOwner == "comparison") {
		if (header.length == 6) {
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "0%";
			th.innerHTML = header[0];
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "32%";
			th.innerHTML = header[1];
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[2];
			th.style.width = "13%";
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[3];
			th.style.width = "11%";
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[4];
			th.style.width = "14%";

			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[5];
			th.style.width = "30%";
		} else if (header.length == 7) { // with parent id
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "0%";
			th.innerHTML = header[0];
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "auto";
			th.innerHTML = header[1];
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[2];
			th.style.width = "11%";
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[3];
			th.style.width = "80px";
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[4];
			th.style.width = "100px";

			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[5];
			th.style.width = "auto";

			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[6];
			th.style.width = "auto";
		}
	} else if (tableOwner == "multiflash") {
		if (header.length == 6) {
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "28px";
			th.innerHTML = header[0];
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "auto";
			th.innerHTML = header[1];
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[2];
			th.style.width = "10%";
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[3];
			th.style.width = "17%";
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[4];
			th.style.width = "7%";

			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[5];
			th.style.width = "auto";
		} else if (header.length == 7){ // with parent id
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "21px";
			th.innerHTML = header[0];
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "auto";
			th.innerHTML = header[1];
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[2];
			th.style.width = "6%";
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[3];
			th.style.width = "11%";
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[4];
			th.style.width = "7%";

			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[5];
			th.style.width = "auto";

			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[6];
			th.style.width = "auto";
		}
	} else if (tableOwner == "selection") {
		//remove two columns which are Size and Location at 2016.12.22
		if(header.length == 4){//fix coverity issue 46955
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "4%";
			th.innerHTML = header[0];
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "24%";
			th.innerHTML = header[1];

			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[2];
			th.style.width = "52%";

			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[3];
			th.style.width = "20%";
		}else{
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "5%";
			th.innerHTML = header[0];
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.style.width = "22%";
			th.innerHTML = header[1];
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[2];
			th.style.width = "40%";
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[3];
			th.style.width = "13%";
			
			var th = thr.insertCell(-1);
			th.className = "EntityTableHeader";
			th.innerHTML = header[4];
			th.style.width = "20%";
		}
	}
	
	return table;
}

/**
 * update the status of the whole content.
 * if all packs done/already downloaded, change the title status to "Done";
 * if the previous one is "done/already downloaded", while the current one is "not started", the title status should be "Acquiring"
 * if any pack is Acquiring, the title status should be "Acquiring";
 * if all packs are not started, the title should show "not started".
 */
function updateTitle(index, stt){
	var title = _doc.getElementById(TITLE_PRE + index);
	var imgs = title.getElementsByTagName("img");
	if (stt == "Acquiring") {		
		imgs[imgs.length - 1].src = "images/progress_anim2_small.gif";
		imgs[imgs.length - 1].alt = "Acquiring...";
	} else if (stt == "Not Started") {
		imgs[imgs.length - 1].src = "images/statusStopped_obj16.gif";
		imgs[imgs.length - 1].alt = "Not Started";
	} else if (stt == "None") {
		imgs[imgs.length - 1].src = "images/statusInformation_obj16.gif";
		imgs[imgs.length - 1].alt = "No applicable updates";
	} else if (stt == "Done"){
		imgs[imgs.length - 1].src = "images/statusSuccess_obj16.gif";
		imgs[imgs.length - 1].alt = "Done";
	} else if (stt == "Error"){
		imgs[imgs.length - 1].src = "images/statusCritical_obj16.gif";
		imgs[imgs.length - 1].alt = "Error";
	} else if (stt == "Warning") {
		imgs[imgs.length - 1].src = "images/statusWarning_obj16.gif";
		imgs[imgs.length - 1].alt = "Warning";
	} else if (stt == "Nopic") {
		imgs[imgs.length - 1].alt = "";
		imgs[imgs.length - 1].src = "";
	}
}

/**
 * when there is a non-empty content, insert a 'plus'icon
 */
function showPlusIcon(index){
	var title = _doc.getElementById(TITLE_PRE + index);
	var imgs = title.getElementsByTagName("img");
	if(imgs.length > 1)
		return;
	imgs[0].style.marginLeft = "0px";
	/*var plus_img = _doc.createElement("img");
	plus_img.src = "images/treeExpand_plus.gif";
	plus_img.alt = "display";
	plus_img.height = "18";
	plus_img.width = "18";*/
	var plus_button = _doc.createElement("button");
	plus_button.className = "Expander";
	plus_button.onclick = toggleButton(index);
	plus_button.title = "display";
	// Add for accessibility
	plus_button.setAttribute("aria-labelledby", TITLE_PRE + index);

	title.insertBefore(plus_button, imgs[0]);
}
