// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Staged_Task = function () {
    var taskId = "";
    var stagedType = null;
    var auto_checked = false;
    var auto_check_proc = null;
    var auto_check_proc_running = false;
    var auto_check_timer = null;
    var skip_generator_reporter = false;

    function st_init() {
        console.log("init staged task");

        $("#st_task_table").hide();
        $("#st_job_table").hide();
        $("#st_step_table").hide();
        $("#st-auto-check").parent().hide();
        document.getElementById("input-taskid").value = taskId;
        if(skip_generator_reporter){
            var resultFile = top.readTextFile(top.getSupportFile("commonResult"));
            var resultDom, resultMsg, resultError;
            if (resultFile != null) {
                resultDom = ezJsLib.XmlDom.parse(resultFile);
                setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
            }
        } else {
            setLogFile("");
        }     
        
        if("1" == top.gl_uxlite_bootable || top.gl_Inband_Params.Enabled){
            enableUsbLan();
        }

        checkTask();
        if(top.fileExists(top.getSupportFile("flashResult"))) {
            content = top.readTextFile(top.getSupportFile("flashResult"));
            if (content != null) {
                var dom = ezJsLib.XmlDom.parse(content);
                let taskid_temp = ezJsLib.XmlDom.getValueByTag("TASKID", dom);
                let applytime = ezJsLib.XmlDom.getValueByTag("APPLYTIME", dom);
                if(taskid_temp == taskId){
                    stagedType = applytime;
                }
            }
        }
        setErrorMsg();
        
    }

    function waitFinished(operate){
        if(auto_check_proc_running){
            setTimeout(waitFinished, 1000, operate);
            return;
        }
        if(operate == "next"){
            gl_wizard.steps(operate);
        } else {
            top.hideUnstoppableWaitMsg();
        }
    }

    function next() {
        $("#st-auto-check").parent().hide();
        if(auto_check_timer != null){
            clearInterval(auto_check_timer);
            auto_check_timer = null;
        }
        if(auto_check_proc_running){
            top.showUnstoppableWaitMsg([$.i18n.prop("StagedTask.CheckTip")]);
            setTimeout(waitFinished, 1000, "next");
            return false;
        }
        top.hideUnstoppableWaitMsg();
        getCommonResult();
        return true;
    }

    function previous(){
        $("#st-auto-check").parent().hide();
        if(auto_check_timer != null){
            clearInterval(auto_check_timer);
            auto_check_timer = null;
        }
        if(auto_check_proc_running){
            top.showUnstoppableWaitMsg([$.i18n.prop("StagedTask.CheckTip")]);
            setTimeout(waitFinished, 1000, "previous");
            return;
        }
        top.hideUnstoppableWaitMsg();
        return true;
    }

    function getCommonResult() {
        if(skip_generator_reporter){
            return;
        }
        var resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg, resultError;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
        }
    }

    function getOnecliErrorInfo() {
        var resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg, resultError;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            return ezJsLib.XmlDom.getValueByTag("MESSAGE", resultDom);
        }
        return "No common result file founded.";
    }

    function onCancelTaskFinished(success){
        top.hideUnstoppableWaitMsg();
        if (!success) {
            console.warn("Cancel task failed.");
            setErrorMsg("Cancel task failed");
            return;
        }
        checkTask();
    }

    function onAcceptCancel(){
        $("#cancelTaskConfirmDiv").hide();
        let args = [];
        args.push(top.getSystemFile("oneCli"));
        args.push("update");
        args.push("canceltask");
        args.push("--taskid");
        args.push(taskId);
        if(SplitFullConnInfo() != "@"){
            args.push("--bmc");
            args.push(SplitFullConnInfo());
        }
        args.push("--never-check-trust");
        args.push(...add_output_log5());
        args.push("--quiet");
        top.store_onecli_command(args);
        printLog("INFO", "run command:" + getRunProgramCommend(args));
        runProgram(args, null, onCancelTaskFinished);
        top.showUnstoppableWaitMsg([$.i18n.prop("StagedTask.CancelTip")]);
    }

    function onNoAcceptCancel(){
        $("#cancelTaskConfirmDiv").hide();
    }

    function onCancelClick(value){
        taskId = value;
        if (taskId == "") {
            return;
        }
        document.getElementById("cancelTaskConfirmDiv-TaskId").innerText = taskId;
        $("#cancelTaskConfirmDiv").show();
    }

    function onStartTaskFinished(success){
        top.hideUnstoppableWaitMsg();
        if (!success) {
            console.warn("Start staged task failed.");
            setErrorMsg("Start staged task failed.");
            return;
        }
        document.getElementById("st-auto-check").checked = true;
        $("#st-auto-check").parent().show();
        onAutoCheckClick();
    }

    function onStartClick(){
        $("button[onclick='Staged_Task.StartClick();']").attr("disabled", true);
        let args = [];
        args.push(top.getSystemFile("oneCli"));
        args.push("update");
        args.push("startstaged");
        if(SplitFullConnInfo() != "@"){
            args.push("--bmc");
            args.push(SplitFullConnInfo());
        }
        args.push("--never-check-trust");
        args.push(...add_output_log5());
        args.push("--quiet");
        top.store_onecli_command(args);
        printLog("INFO", "run command:" + getRunProgramCommend(args));
        runProgram(args, null, onStartTaskFinished);
        top.showUnstoppableWaitMsg([$.i18n.prop("StagedTask.StartTaskTip")]);
    }

    function updateCheckResult(){
        let table = document.getElementById("st_task_table");
        while (table.rows.length > 1) {
            table.deleteRow(1);
        }
        table = document.getElementById("st_job_table");
        while (table.rows.length > 1) {
            table.deleteRow(1);
        }
        table = document.getElementById("st_step_table");
        while (table.rows.length > 1) {
            table.deleteRow(1);
        }
        let data = [
            {
                "TaskId": "112321-232312-2323123-123213123",
                "State": "Pending",
                "StartTime": "2023-01-23 11:42:12"
            }
        ];
        var compareCheck = getSupportFile("checkTaskResult");
        var compareContent;
        if (top.fileExists(compareCheck)) {
            compareContent = top.readTextFile(compareCheck);
        }
        if (!compareContent) {
            return;
        } else {
            var domCheck = ezJsLib.XmlDom.parse(compareContent);
            var taskNode = domCheck.getElementsByTagName("Task")[0];
            taskId = ezJsLib.XmlDom.getValueByTagFromNode("ID", taskNode);
            var state = ezJsLib.XmlDom.getValueByTagFromNode("State", taskNode);
            var startTime = ezJsLib.XmlDom.getValueByTagFromNode("StartTime", taskNode);
            data = [
                {
                    "TaskId": taskId,
                    "State": state,
                    "StartTime": startTime
                }
            ];
            console.log(data);
            let table = document.getElementById("st_task_table").tBodies[0];                
            for (var i = 0; i < data.length; i++) {
                var temp = data[i];
                var newRow = table.insertRow(-1);
                var newCell1 = newRow.insertCell(-1);
                var taskid_i = temp["TaskId"];
                newCell1.innerHTML = temp["TaskId"];
                newCell1.title = temp["TaskId"];
                newCell1 = newRow.insertCell(-1);
                newCell1.innerHTML = temp["State"];
                newCell1.title = temp["State"];
                newCell1 = newRow.insertCell(-1);
                newCell1.innerHTML = temp["StartTime"];
                newCell1.title = temp["StartTime"];
                if(state != "Completed"){
                    newCell1 = newRow.insertCell(-1);
                    var htmlData = `<div><button name="cancelButton" onclick=\"Staged_Task.CancelClick(\'${taskid_i}\');\">Cancel</button>`;
                    if(stagedType != "OnReset" && state == "Pending"){
                        htmlData += "<button onclick='Staged_Task.StartClick();'>Start</button>";
                    }
                    htmlData += "</div>";
                    newCell1.innerHTML = htmlData;
                    top.toggleNext(true);
                    top.togglePrevious(true);
                } else {
                    if(auto_check_timer != null){
                        top.toggleNext(false);
                        top.togglePrevious(false);
                    }
                }
            }

            if(state == "Completed"){

                var jobNode = domCheck.getElementsByTagName("Job")[0];

                if(jobNode == null){
                    return;
                }

                data = [
                    {
                        "ID": ezJsLib.XmlDom.getValueByTagFromNode("ID", jobNode),
                        "Percent": ezJsLib.XmlDom.getValueByTagFromNode("Percent", jobNode),
                        "StartTime": ezJsLib.XmlDom.getValueByTagFromNode("StartTime", jobNode),
                        "EndTime": ezJsLib.XmlDom.getValueByTagFromNode("EndTime", jobNode),
                        "State": ezJsLib.XmlDom.getValueByTagFromNode("State", jobNode)
                    }
                ]

                console.log(data);
                
                table = document.getElementById("st_job_table").tBodies[0];
                var jobId = null;
                var jobState = "";
                for (var i = 0; i < data.length; i++) {
                    var temp = data[i];
                    console.log(temp);
                    var newRow = table.insertRow(-1);
                    var newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = temp["ID"];
                    newCell1.title = temp["ID"];
                    jobId = temp['ID'];
                    newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = temp["Percent"];
                    newCell1.title = temp["Percent"];
                    newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = temp["StartTime"];
                    newCell1.title = temp["StartTime"];
                    newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = temp["EndTime"];
                    newCell1.title = temp["EndTime"];
                    newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = temp["State"];
                    jobState = temp["State"];
                    newCell1.title = temp["State"];
                }

                document.getElementById("st-step-jobid").innerText = jobId;
                data = [];
                stepNodeList = domCheck.getElementsByTagName("Step");
                for(var i=0;i<stepNodeList.length;i++){
                    data.push({
                        "ID": ezJsLib.XmlDom.getValueByTagFromNode("ID", stepNodeList[i]),
                        "Percent": ezJsLib.XmlDom.getValueByTagFromNode("Percent", stepNodeList[i]),
                        "Message": ezJsLib.XmlDom.getValueByTagFromNode("Message", stepNodeList[i]),
                        "StartTime": ezJsLib.XmlDom.getValueByTagFromNode("StartTime", stepNodeList[i]),
                        "EndTime": ezJsLib.XmlDom.getValueByTagFromNode("EndTime", stepNodeList[i]),
                        "State": ezJsLib.XmlDom.getValueByTagFromNode("State", stepNodeList[i]),
                        "UpdateUnit": ezJsLib.XmlDom.getValueByTagFromNode("UpdateUnit-ForDisplay", stepNodeList[i]),
                        "Slot": ezJsLib.XmlDom.getValueByTagFromNode("Slot", stepNodeList[i]),
                    });
                }

                console.log(data);

                if(jobState == "Completed"){
                    document.getElementById("st-auto-check").checked = false;
                    onAutoCheckClick();
                    $("#st-auto-check").parent().hide();
                }

                table = document.getElementById("st_step_table").tBodies[0];
                for (var i = 0; i < data.length; i++) {
                    var temp = data[i];
                    console.log(temp);
                    var newRow = table.insertRow(-1);
                    var newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = i;
                    newCell1.title = i;
                    newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = temp["UpdateUnit"];
                    newCell1.title = temp["UpdateUnit"];
                    newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = temp["Percent"];
                    newCell1.title = temp["Percent"];
                    newCell1 = newRow.insertCell(-1);
                    var slot = temp["Slot"] == null?"N/A":temp['Slot'];
                    newCell1.innerHTML = slot;
                    newCell1.title = slot;
                    newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = temp["StartTime"];
                    newCell1.title = temp["StartTime"];
                    newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = temp["EndTime"];
                    newCell1.title = temp["EndTime"];
                    newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = temp["State"];
                    newCell1.title = temp["State"];
                    newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = temp["ID"];
                    newCell1.title = temp["ID"];
                }
            }

            if(taskId != null && taskId.length > 0){
                document.getElementById("input-taskid").value = taskId;
                if(state != "Completed"){
                    $("#st_task_table").show();
                    $("#st_job_table").hide();
                    $("#st_step_table").hide();
                } else {
                    $("#st_task_table").hide();
                    $("#st_job_table").show();
                    $("#st_step_table").show();
                }
            }
        }
    }

    function onFetchPendingTaskFinished(success) {
        top.hideUnstoppableWaitMsg();
        if (!success) {
            console.warn("Fetch pending task failed.");
            return;
        }
        updateCheckResult();
    }

    function fetchPendingTask() {
        deleteFile(top.getSupportFile("checkTaskResult"));
        let args = [];
        args.push(top.getSystemFile("oneCli"));
        args.push("update");
        args.push("checktask");
        if (taskId != "") {
            args.push("--taskid");
            args.push(taskId);
        }
        if(SplitFullConnInfo() != "@"){
            args.push("--bmc");
            args.push(SplitFullConnInfo());
        }
        // args.push("USERID:Passw0rd12@10.240.199.92");
        args.push("--never-check-trust");
        args.push(...add_output_log5());
        top.store_onecli_command(args);
        printLog("INFO", "run command:" + getRunProgramCommend(args));
        runProgram(args, null, onFetchPendingTaskFinished);
        top.showUnstoppableWaitMsg([$.i18n.prop("StagedTask.CheckTip")]);
    }

    function checkTask() {
        console.log("Begin check task...");
        $("#st_task_table").hide();
        $("#st_job_table").hide();
        $("#st_step_table").hide();
        taskId = document.getElementById("input-taskid").value;
        fetchPendingTask();
    }

    function setTaskId(id){
        taskId = id;
    }

    function setSkipRepoter(value){
        skip_generator_reporter = value;
    }


    function onAutoCheckProcFinished(success){
        $("#auto-check-div>img").hide();
        auto_check_proc_running=false;
        if(!success){
            console.warn("Auto Check task failed.")
            setErrorMsg("Auto Check task failed.");
            document.getElementById("st-auto-check").checked = false;
            onAutoCheckClick();
            $("#st-auto-check").parent().hide();
            return;
        }
        setErrorMsg();
        updateCheckResult();
    }

    function setErrorMsg(msg){
        if(msg==null || msg==""){
            $("#st-error-message").parent().hide();
            return;
        }
        document.getElementById("st-error-message").innerText = msg + ", " + getOnecliErrorInfo();
        $("#st-error-message").parent().show();
    }

    function autoCheckInterval(){
        if(auto_check_proc_running){
            return;
        }
        deleteFile(top.getSupportFile("checkTaskResult"));
        let args = [];
        args.push(top.getSystemFile("oneCli"));
        args.push("update");
        args.push("checktask");
        if (taskId != "") {
            args.push("--taskid");
            args.push(taskId);
        }
        if(SplitFullConnInfo() != "@"){
            args.push("--bmc");
            args.push(SplitFullConnInfo());
        }
        args.push("--never-check-trust");
        args.push(...add_output_log5());
        top.store_onecli_command(args);
        printLog("INFO", "run command:" + getRunProgramCommend(args));
        runProgram(args, null, onAutoCheckProcFinished);
        $("#auto-check-div>img").show();
        auto_check_proc_running = true;
    }

    function onAutoCheckClick(){
        auto_checked = document.getElementById("st-auto-check").checked;
        if(auto_checked && (auto_check_timer == null)){
            auto_check_proc_running = false;
            auto_check_timer = setInterval(autoCheckInterval, 5000);
            autoCheckInterval();
        } else {
            clearInterval(auto_check_timer);
            auto_check_timer=null;
            top.toggleNext(true);
            top.togglePrevious(true);
        }
    }

    return {
        index: 0,
        name: "Staged_Task",        
        init: st_init,
        nextAction: next,
        previousAction: previous,
        check: checkTask,
        CancelClick: onCancelClick,
        StartClick: onStartClick,
        noAcceptCancel: onNoAcceptCancel,
        acceptCancel: onAcceptCancel,
        setTaskId: setTaskId,
        setSkipRepoter: setSkipRepoter,
        AutoCheckClick: onAutoCheckClick,
        importId: "#import_staged_task",
        selectorId: ".staged_task",
        title: "Navi.StagedTask",
        localizedTitle: tr("Navi.StagedTask")
    }
}();