// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Update_Type = function(){

	let vue_app = undefined;

	let updateTypeOption = Vue.ref("UXSP");

	let vue_class = {
		data() {
			return {
				updateTypeOption
			}
		},
		watch: {
			updateTypeOption: {
				immediate: true,
				handler (newVal) {
					printLog("INFO","radio '" + newVal + "' was selected.");
					switch (newVal)
					{
					case "UXSP":
						top.gl_isUXSP = true;
						break;
			
					case "latest":
						top.gl_isUXSP = false;
			
						break;
					}
				}
			}
		}
	}

	function init() {
		printLog("INFO", "UpdateType page init.");		
		init_vue();
	};

	async function init_vue() {
		if (vue_app != undefined) {
			return;
		}
		vue_app = Vue.createApp(vue_class);
		vue_app.mount('#vue-update-type');
	}

	function uninit() {
		if (vue_app != undefined) {
			vue_app.unmount();
			vue_app = undefined;
		}
	}

	return {
		index: 0,
		name: "Update_Type",
        init: init,
        nextAction: function() { printLog("INFO","Next was clicked."); return true;},
		importId: '#import_update_type',
        selectorId: '.update_type',
        title: "Navi.UpdateType",
        localizedTitle: tr("Navi.UpdateType"),
		uninit: uninit
	}
}();