// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
const fs = require('fs');
const path = require('path');
const process = require('process');
const os = require('os');
const readline = require('node:readline');
const { clipboard, dialog } = require('electron');

//const gl_base_path = "F:\\code\\gitlab\\LXCE\\updategui\\US\\windows\\imagefull\\updatexpress";
const gl_base_path = path.dirname(process.execPath);
const gl_support_dir = path.join(gl_base_path, "Lenovo_Support") + path.sep
const gl_app_base_path = path.join(__dirname, '..');
const lanCfgFile = path.join(__dirname, '../../../languages.json');

var gl_languages_cfg = JSON.parse(fs.readFileSync(lanCfgFile).toString());
const gl_build_cfg = JSON.parse(fs.readFileSync(path.join(__dirname, '../../../build.json')).toString());
var gl_onecli_process = [];
var mainWindow = null;

var gl_bmc_usblan_state = null;
var gl_os_usblan_state = null;
var gl_usblan_flag = false;

//const gl_basePath = process.execPath;
const logStream = function initLog() {
    if (!fs.existsSync(gl_support_dir)) {
        fs.mkdirSync(gl_support_dir)
    }
    var date = new Date();
    var month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
    var strDate = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
    var strHour = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
    var strMinute = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
    var strSecond = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();
    var curDate = "" + date.getFullYear() + month + strDate + strHour + strMinute + strSecond;
    var logPath = path.join(gl_support_dir, "updateXpress" + curDate + ".log");
    const lf = fs.createWriteStream(logPath, { flags: 'a' });
    lf.write(logPath + "\n");
    return lf;
}();


function setMainWindow(win){
    mainWindow = win;
}


function confirm(msg){
    var button = dialog.showMessageBoxSync(mainWindow, {
        type: 'warning',
        title: global.sharedObject.messageBoxTitle,
        message: msg,
        buttons: ["Yes", "No"],
        defaultId: 2
    });
    if (button === 0) {
        return true;
    }
    return false;
}


fsUtils = {
    createDirectory: function (dirpath) {
        if (!fs.existsSync(dirpath)) {
            try {
                if (!fs.mkdirSync(dirpath, { recursive: true })) {
                    return false;
                }
            } catch (e) {
                _ux_log("WARN", "Failed to create dir: " + dirpath)
                return false;
            }
        }
        return true;
    },
    fileExists: function (filepath) {
        return fs.existsSync(filepath);
    },
    directoryExists: function (directory) {
        return fs.existsSync(directory);
    },
    isFile: function (filepath) {
        if (fs.existsSync(filepath)) {
            let stat = fs.statSync(filepath);
            if (stat.isFile()) {
                return true;
            }
        }
        return false;
    },
    isDirectory: function (directory) {
        if (fs.existsSync(directory)) {
            let stat = fs.statSync(directory);
            if (stat.isDirectory()) {
                return true;
            }
        }
        return false;
    },
    isAbsolutePath: function (dir) {
        return path.isAbsolute(dir);
    },
    deleteFile: function (file) {
        if (fs.existsSync(file)) {
            fs.unlinkSync(file);
        }
        return true;
    },
    del_dir: function (dir_path, isRecursive) {
        if (fs.existsSync(dir_path)) {
            if (isRecursive === true) {
                fs.rmSync(dir_path, { recursive: true, force: true });
            } else {
                fs.rmdirSync(dir_path);
            }
        }
    },
    // read an external file
    // fileName: string - full native file name or URL
    // returns: string - contents of file if readable, null otherwise
    readTextFile: function (fileName, charset) {
        if (!path.isAbsolute(fileName)) {
            fileName = path.join(gl_support_dir, fileName)
        }
        if (fileName == null || !fs.existsSync(fileName))
            return null;
        if (!charset)
            charset = "utf8"
        if (charset == "null")
            charset = null
        return fs.readFileSync(fileName, charset);
    },
    // write a text file
    // fileName: string - full native file name
    // text:  string - content of text file
    // append: boolean - true = append text to end of file,  false = overwrite existing file
    // returns: true if file was written successfully, false otherwise
    writeTextFile: function (fileName, fileContent, append) {
        if (!path.isAbsolute(fileName)) {
            fileName = path.join(gl_support_dir, fileName)
        }
        if (!fileContent) {
            console.error("No fileContent.");
            return false;
        }
        try {
            if (append && fs.existsSync(fileName)) {
                fs.appendFileSync(fileName, fileContent);
            } else {
                fs.writeFileSync(fileName, fileContent);
            }
        } catch (exp) {
            _ux_log("error", exp);
            return exp;
        }
        return true;
    },
    /* 
    0: all files
    1: All files, depth=1
    2: All directories, depth=1
    */
    readDirectorySync: function (dir, mode = 0) {
        if(!fs.existsSync(dir)) {
            return null;
        }
        const lists = new Array();
        files = fs.readdirSync(dir);
        for (const file of files) {
            const filePath = path.join(dir, file);
            let stat = fs.statSync(filePath)
            if (mode == 0) {
                if (stat.isDirectory()) {
                    fsUtils.readDirectorySync(filePath);
                } else if (stat.isFile()) {
                    lists.push(filePath);
                }
            } else if(mode == 1) {
                if (stat.isFile()) {
                    lists.push(filePath);
                }
            } else if(mode == 2) {
                if (stat.isDirectory()) {
                    lists.push(filePath);
                }
            }
        }
        return lists;
    },
    copyPathSync: function (src, dest, isRecursive) {
        return isRecursive? fs.cpSync(src, dest, {recursive: true}): fs.cpSync(src, dest);
    },
    isFloderEmpty: function (path) {
        return fs.readdirSync(path).length === 0;
    },
    join: function (...args) {
        return path.join(...args);
    },
    rename: function (oldPath, newPath) {
        return fs.renameSync(oldPath, newPath)
    },
    dirname: function (filepath) {
        return path.dirname(filepath);
    },
    basename: function (filepath) {
        return path.basename(filepath);
    },
    basePath: () => {
        return gl_base_path;
    },
    appBasePath: () => {
        return gl_app_base_path;
    },
    loadFile: function (filePath) {
        if (!path.isAbsolute(filePath)) {
            filePath = path.join(__dirname, filePath)
        }
        return fs.readFileSync(filePath).toString();
    },
    loadSetting: function (settingName) {
        const settingFile = path.join(__dirname, "../settings", settingName);
        if (!fs.existsSync(settingFile)) {
            return {}
        }
        return JSON.parse(fs.readFileSync(settingFile).toString());
    },
    getConfigFileFullPath: function(file) {
        return path.join(__dirname, "../settings", file);
    }
};

commonUtils = {
    getEnv: function (name) {
        return process.env[name];
    },
    parsePropertiesFile: function (filename) {
        var prop = require("../js/libs/properties/index.js");
        return prop.read(filename);
    },
    buildCfg: () => {
        return gl_build_cfg;
    },
    languagesCfg: () => {
        return gl_languages_cfg
    },
    updateLanguagesCfg: (cfg) => {
        fs.writeFileSync(lanCfgFile, Buffer.from(JSON.stringify(cfg)));
        gl_languages_cfg = cfg;
    },
    logPathCfg: () => {
        return gl_logPath_cfg
    },
    getGenericOSType: () => {
        var osName = os.type().toLowerCase();
        if (osName.indexOf("windows") >= 0) {
            return "windows";
        }
        return "unix";
    },
    getOS: () => {
        return os.type() + " " + os.release();
    },
    printLog: function (level, caller, msg) {
        const getNowFormatDate = function () {
            var date = new Date();
            var seperator1 = "-";
            var seperator2 = ":";
            var month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
            var strDate = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
            var strHour = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
            var strMinute = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
            var strSecond = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();

            var currentdate = date.getFullYear() + seperator1 + month + seperator1 + strDate
                + " " + strHour + seperator2 + strMinute + seperator2 + strSecond;
            return currentdate;
        };
        logStream.write(getNowFormatDate() + " [" + level + "]" + caller + msg + "\n");
    },
    openExternal: function (link) {
        require('electron').shell.openExternal(link);
    },
    getSupportDir: function () {
        return gl_support_dir;
    },
    killOneCli: function () {
        for(let proc of gl_onecli_process){
            proc.kill();
        }
    },
    copyToClipBoard: function(data){
        clipboard.writeText(data);
    },
    runProgramSync: function(args, workingDirectory, callback, msgs) {
        process.env["LD_PRELOAD"] = "";
        var cmd = args[0];
        args.shift();
        if (workingDirectory == null) {
            workingDirectory = path.dirname(cmd);
        }
        var options = { cwd: workingDirectory, maxBuffer: 2048000000 };
        var execFile = require('child_process').execFileSync;
        try{
            var buffer = execFile(cmd, args, options);
            return [true, buffer];
        }catch(e){
            return [false,e];
        }    
    },
    setCleanCommand: function(args) {
        commonUtils.cleanCommandArgs = args;
    },
    cleanEnv: function(){
        if(commonUtils.cleanCommandArgs){
            commonUtils.runProgramSync(commonUtils.cleanCommandArgs);
        }
    },
    getSystemFile: function(fileId) {
        var commands = fsUtils.loadSetting("system_files.json");
        if (commands[fileId].win == undefined && commands[fileId].linux == undefined) {
          return fsUtils.join(gl_base_path, commands[fileId].toString());
        }
        if (commonUtils.getGenericOSType() == "windows") {
          return fsUtils.join(gl_base_path, commands[fileId].win.toString());
        } else {
          return fsUtils.join(gl_base_path, commands[fileId].linux.toString());
        }
    },
    getSupportFile: function(fileId, type) {
        let files = fsUtils.loadSetting("support_files.json");
        let baseDir = commonUtils.getSupportDir();
        if (type) {
          return fsUtils.join(baseDir, files[fileId][type].toString());
        } else {
          return fsUtils.join(baseDir, files[fileId].toString());
        }
      }
};

usblanUtils = {
    enableUsbLan: function(){
        gl_usblan_flag = true;
        if(null != gl_os_usblan_state && null != gl_bmc_usblan_state)
        {
            _ux_log("debug", "no need enable usblan state.");
            gl_usblan_flag = false;
            return 0;
        }

        if(fsUtils.fileExists(commonUtils.getSupportFile("usblanQueryFile")))
        {
            fsUtils.deleteFile(commonUtils.getSupportFile("usblanQueryFile"));
        }

        //query
        let args = [
            commonUtils.getSystemFile("oneCli"),
            "misc",
            "usblan",
            "query",
            "--log",
            "5",
            "--includebmc",
            "--output",
            commonUtils.getSupportDir()
        ];
        _ux_log("debug", "query cmd:" + args.toString());
        _run_onecli_command(args, _query_usblan_callback);
    },
    disableUsbLan: function(){
        _ux_log("debug", "origin os usblan state:" + gl_os_usblan_state);
        _ux_log("debug", "origin bmc usblan state:" + gl_bmc_usblan_state);
        if("1" == gl_os_usblan_state || null == gl_os_usblan_state || null == gl_bmc_usblan_state)
        {
            _ux_log("debug", "no need restore usblan state.");
            return 0;
        }

        let disable_args = Array();
        disable_args.push(commonUtils.getSystemFile("oneCli"));
        disable_args.push("misc");
        disable_args.push("usblan");
        disable_args.push("disable");
        disable_args.push("--log");
        disable_args.push("5");
        disable_args.push("--output");
        disable_args.push(commonUtils.getSupportDir());

        if("0" == gl_os_usblan_state)
        {
            if("1" != gl_bmc_usblan_state && null != gl_bmc_usblan_state)
            {
                disable_args.push("--includebmc");
            }
            _ux_log("debug", "disable cmd:" + disable_args.toString());
            
            var ostype = os.type().toLowerCase();
            if(ostype.indexOf("win") != -1)
            {
                _run_onecli_command_sync(disable_args);
                return;
            }
            _run_onecli_command(disable_args, _usblan_common_callback);
        }
    }
};

function _query_usblan_callback()
{
    //parse Onecli-misc-usblan-query.xml
    var usblanQueryData;
    if(fsUtils.fileExists(commonUtils.getSupportFile("usblanQueryFile"))) {
        usblanQueryData = fsUtils.readTextFile(commonUtils.getSupportFile("usblanQueryFile"));    
    }
    if (usblanQueryData != null) {

        _ux_log("debug", "query result:" + usblanQueryData);
        var pos1 = usblanQueryData.indexOf('<BMCUSBLAN>');
        var pos2 = usblanQueryData.indexOf('</BMCUSBLAN>');
        if(-1 != pos1 && -1 != pos2)
        {
            gl_bmc_usblan_state = usblanQueryData.substring(pos1 + "<BMCUSBLAN>".length, pos2);
        }

        pos1 = usblanQueryData.indexOf('<OSUSBLAN>');
        pos2 = usblanQueryData.indexOf('</OSUSBLAN>');
        if(-1 != pos1 && -1 != pos2)
        {
            gl_os_usblan_state = usblanQueryData.substring(pos1 + "<OSUSBLAN>".length, pos2);
        }

        _ux_log("debug", "current os usblan state:" + gl_os_usblan_state);
        _ux_log("debug", "current bmc usblan state:" + gl_bmc_usblan_state);

        //enable usblan
        let enable_args = Array();
        enable_args.push(commonUtils.getSystemFile("oneCli"));
        enable_args.push("misc");
        enable_args.push("usblan");
        enable_args.push("enable");
        enable_args.push("--log");
        enable_args.push("5");
        enable_args.push("--output");
        enable_args.push(commonUtils.getSupportDir());

        if("0" == gl_os_usblan_state)
        {
            if("1" != gl_bmc_usblan_state && null != gl_bmc_usblan_state)
            {
                enable_args.push("--includebmc");
            }
            _ux_log("debug", "enable cmd:" + enable_args.toString());
            _run_onecli_command(enable_args, _usblan_special_callback);
        }
        else
        {
            gl_usblan_flag = false;
            _ux_log("debug", "enable usblan not perform.");
        }
    }
    else
    {
        gl_usblan_flag = false;
    }
}

function _usblan_special_callback()
{
    gl_usblan_flag = false;
    var usblanCommonData;
    if(fsUtils.fileExists(commonUtils.getSupportFile("commonResult"))) {
        usblanCommonData = fsUtils.readTextFile(commonUtils.getSupportFile("commonResult"));    
    }
    _ux_log("debug", "result:" + usblanCommonData);
}

function _usblan_common_callback()
{
    var usblanCommonData;
    if(fsUtils.fileExists(commonUtils.getSupportFile("commonResult"))) {
        usblanCommonData = fsUtils.readTextFile(commonUtils.getSupportFile("commonResult"));    
    }
    _ux_log("debug", "result:" + usblanCommonData);
}

function _run_onecli_command(args, callback)
{
    var cmd = args[0];
    args.shift();
    var workingDirectory = path.dirname(cmd);
    var options = { cwd: workingDirectory, maxBuffer: 2048000000 };
    var execFile = require('child_process').execFile;
    try{
        var buffer = execFile(cmd, args, options, callback);
    }catch(e){
        _ux_log("error", "exception:" + e);
    } 
}

function _run_onecli_command_sync(args)
{
    var cmd = args[0];
    args.shift();
    var workingDirectory = path.dirname(cmd);
    var options = { cwd: workingDirectory, maxBuffer: 2048000000 };
    var execFile = require('child_process').execFileSync;
    try{
        var buffer = execFile(cmd, args, options);
        _ux_log("debug", "run onecli result:" + buffer);
    }catch(e){
        _ux_log("error", "exception:" + e);
    } 
}

function runProgram(event, args, workingDirectory, callback, msgs) {

    if(gl_usblan_flag)
    {
        _ux_log("debug", "wait for usblan perform finished.");
        setTimeout(()=>{
            runProgram(event, args, workingDirectory, callback, msgs)
        }, 10*1000);
        return 0;
    } 

    process.env["LD_PRELOAD"] = "";
    var cmd = args[0];
    args.shift();
    if (workingDirectory == null) {
        workingDirectory = path.dirname(cmd);
    }
    var options = { cwd: workingDirectory, maxBuffer: 2048000000 };
    var execFile = require('child_process').execFile;
    JSON.stringify()
    var subProcess = execFile(cmd, args, options, function (error, stdout, stderr) {
        for(let i=0;i<gl_onecli_process.length;i++){
            if(gl_onecli_process[i] == subProcess){
                gl_onecli_process.splice(i,1);
            }
        }
        if (!event.sender.isDestroyed()) {
            let extInfo = {
                "code": error?error.code:0,
                "killed": error?error.killed:false,
                "signal": error ? error.signal :""
            };
            if (error) {
                if (callback) {
                    event.sender.send(callback, false, error, stdout, stderr, subProcess.pid, subProcess.exitCode, extInfo);
                }
                return error.code;
            }
            if (callback) {
                event.sender.send(callback, true, error, stdout, stderr, subProcess.pid, subProcess.exitCode, extInfo);
            }
        }
        return 0;
    });
    if (path.basename(cmd).toLowerCase().startsWith('onecli')) {
        gl_onecli_process.push(subProcess);
    }
    subProcess.stdout.on('data', (data) => {
        var data_string = data.toString();
        _ux_log("debug", data_string);
        console.log(data_string);
        event.sender.send("logConsole", data_string);
        if (msgs && msgs.length != 0) {
            msgs.forEach(msg => {
                if (data_string.indexOf(msg) != -1) {
                    if (confirm(msg)) {
                        subProcess.stdin.write("yes\n");
                    } else {
                        subProcess.stdin.write("no\n");
                    }
                }
            });
        }
    });
    subProcess.stderr.on('data', (data) => {
        var data_string = data.toString();
        _ux_log("debug", data_string);
        console.error(data_string);
        if (msgs && msgs.length != 0) {
            msgs.forEach(msg => {
                if (data_string.indexOf(msg) != -1) {
                    if (confirm(msg)) {
                        subProcess.stdin.write("yes\n");
                    } else {
                        subProcess.stdin.write("no\n");
                    }
                }
            });
        }
    });
}

function write_config_batch_file_sync(event, config_items, cmd, prefix, config_batch_file) {
    fsUtils.deleteFile(config_batch_file);
    let content = "";
    for(let item of config_items) {
        let value = isNaN(Number(item.Value)) ? `"${item.Value}"` : item.Value;
        content = content + cmd + " " + prefix + item.AttributeName + " " + value + "\r\n";
    }
    return fsUtils.writeTextFile(config_batch_file, content);
}

// TODO: use regex
function read_config_batch_file_sync(event, cmd, prefix, config_batch_file) {
    if (!fsUtils.fileExists(config_batch_file)) {
        return null;
    }
    let data = new Array();
    try{
        const lines = fsUtils.readTextFile(config_batch_file).split('\r\n');
        for(let line of lines) {
            let arr = line.split(' ');
            if (arr.length < 3) {
                continue;
            }
            let _cmd = arr[0];
            let _prefix = arr[1].split('.')[0];
            let _attribute = arr[1].split('.')[1];
            let _value = '';
            if (3 == arr.length) {
                _value = arr[2];
            } else {
                for(let i = 2; i < arr.length; i++) {
                    _value += (arr[i]+' ');
                }
            }
            _value = _value.trim();
            if(_value.endsWith('"') && _value.startsWith('"')) {
                _value = _value.substring(1, _value.length-1);
            }
            if (_cmd == cmd && _prefix == prefix) {
                data.push({
                    HelpText: '',
                    DisplayName: _attribute,
                    AttributeName: _attribute,
                    OldValue: '',
                    Value: _value,
                    Type: undefined
                })
            }
        }
    } catch(e) {
        return null;
    }
    return data;
}

function generate_multi_server_task_file_sync(event, server_list, multi_task_file) {
    fsUtils.deleteFile(multi_task_file);

    let target_bmc = new Array();
    let bmc_credential = {};

    for(let server of server_list) {
        target_bmc.push(server.userName+"@"+server.ip+(server.port!="" ? (":" + server.port) : ""));
        bmc_credential[server.userName] = server.userName;
    }

    let content = {
        "parallel_number": 1,
        "parallel_order": 10,
        "password_decrypt_mode": 1,
        "bmc_credential": bmc_credential,
        "target_bmc": target_bmc,
        "EndOfFile":"Please keep this line as end of this file, do not add any valid statement after here"
    }

    return fsUtils.writeTextFile(multi_task_file, JSON.stringify(content));
}

function merge_compare_result(event, multi_compare_result, callback, compare_rewrite_xml, compare_xml) {
    let updateIdSet = new Set();
    let packagesContent = "<PACKAGES>\n";
    for (let server of multi_compare_result) {
        for (let package of server.packages) {
            let updateId = package.id;
            if (!updateIdSet.has(updateId)) {
                updateIdSet.add(updateId);
                packagesContent += `<PACKAGE>
                            <NAME/>
                            <MACROPACKAGEID>${package.parentID}</MACROPACKAGEID>
                            <UPDATEID>${updateId}</UPDATEID>
                            <SELECTED>1</SELECTED>
                            <FORCEID>0</FORCEID>
                            <PACKAGEXML>${package.pkgXML}</PACKAGEXML>
                            <INVENTORYJSON>${package.inventoryJSON}</INVENTORYJSON>
                            <SIGNATUREJSON>${package.signatureJSON}</SIGNATUREJSON>
                            <PAYLOADFILE>${package.payload}</PAYLOADFILE>
                        </PACKAGE>\n`;
            }
        }
    }
    packagesContent += "</PACKAGES>"

    fsUtils.deleteFile(compare_rewrite_xml);
    var tag_packages = false;
    var instream = fs.createReadStream(compare_xml);
    var nullstream = new (require('stream'))();
    var outstream = fs.createWriteStream(compare_rewrite_xml);
    var rl = readline.createInterface(instream, nullstream);
    rl.on('line', function (line) {
        if (line.indexOf('<TOTAL>') != -1 || line.indexOf('<TOTAL/>') != -1) {
            line = `<TOTAL>${updateIdSet.size}</TOTAL>`;
        }
        if (line.indexOf('<PACKAGES>') != -1) {
            tag_packages = true;
        }
        if (line.indexOf('</PACKAGES>') != -1 || line.indexOf('<PACKAGES/>') != -1) {
            tag_packages = false;
            line = packagesContent;
        }
        if (!tag_packages) {
            line = line + '\n';
            outstream.write(line);
        }
    });
    rl.on('close', function (_) {
        outstream.close();
        if (callback) {
            event.sender.send(callback);
        }
    });
}

function write_acquire_xml(event, includeid_list, callback, acquire_xml) {
    let includeids = '';
    let tmp = new Set(); // use to remove repeated items
    for (let id of includeid_list) {
        if (!tmp.has(id)) {
            tmp.add(id);
            includeids += '<INCLUDEID>' + id + '</INCLUDEID>\n';
        }
    }
    let xmlContent = 
    `<?xml version="1.0" encoding="utf-8"?>
    <ACQUIREXML>
        <XMLVERSION>1.0</XMLVERSION>
        <CONTENT>
            <INCLUDEIDS>
                ${includeids}
            </INCLUDEIDS>
        </CONTENT>
    </ACQUIREXML>`;
    fsUtils.writeTextFile(acquire_xml, xmlContent, false);
    if (callback) {
        event.sender.send(callback);
    }
}

module.exports.RegisterUtilsFunctions = function (ipcMain) {
    for (var m in fsUtils) {
        if (fsUtils.hasOwnProperty(m) && typeof fsUtils[m] == "function") {
            const funcName = m;
            ipcMain.on(m, (event, ...args) => {
                event.returnValue = fsUtils[funcName](...args);
            });
        }
    }
    for (var m in commonUtils) {
        if (commonUtils.hasOwnProperty(m) && typeof commonUtils[m] == "function") {
            const funcName = m;
            ipcMain.on(m, function (event, ...args) {
                event.returnValue = commonUtils[funcName](...args);
            });
        }
    }
    ipcMain.on("runProgram", function (event, args, workingDirectory, callback, msgs) {
        runProgram(event, args, workingDirectory, callback, msgs);
    });
    ipcMain.on("merge_compare_result", function (event, selected_list, callback, compare_rewrite_xml, compare_xml) {
        merge_compare_result(event, selected_list, callback, compare_rewrite_xml, compare_xml);
    });
    ipcMain.on("write_acquire_xml", function (event, includeid_list, callback, acquire_xml) {
        write_acquire_xml(event, includeid_list, callback, acquire_xml);
    });
    ipcMain.on("write_config_batch_file_sync", function (event, config_items, cmd, prefix, config_batch_file) {
        event.returnValue = write_config_batch_file_sync(event, config_items, cmd, prefix, config_batch_file);
    });
    ipcMain.on("read_config_batch_file_sync", function (event, cmd, prefix, config_batch_file) {
        event.returnValue = read_config_batch_file_sync(event, cmd, prefix, config_batch_file);
    });
    ipcMain.on("generate_multi_server_task_file_sync", function (event, server_list, multi_task_file) {
        event.returnValue = generate_multi_server_task_file_sync(event, server_list, multi_task_file);
    });
    ipcMain.on("enable_usblan", function (event) {
        usblanUtils.enableUsbLan();
    });

}

function _ux_log(level, msg) {
    function getCallerFileNameAndLine() {
        function getException() {
            try {
                throw Error('');
            } catch (err) {
                return err;
            }
        }
        const err = getException();
        const stack = err.stack;
        const stackArr = stack.split('\n');
        let callerLogIndex = 0;
        for (let i = 0; i < stackArr.length; i++) {
            if (stackArr[i].indexOf("_ux_log") > 0 && i + 1 < stackArr.length) {
                callerLogIndex = i + 1;
                break;
            }
        }
        if (callerLogIndex !== 0) {
            const callerStackLine = stackArr[callerLogIndex];
            const lastDash = callerStackLine.lastIndexOf("/");
            const lastBackslash = callerStackLine.lastIndexOf("\\");
            return `[${callerStackLine.substring((lastDash > lastBackslash ? lastDash : lastBackslash) + 1, callerStackLine.lastIndexOf(':'))}]`;
        } else {
            return '[-]';
        }
    }
    return commonUtils.printLog(level, getCallerFileNameAndLine(), msg)
}

module.exports.ux_log = _ux_log;
module.exports.setMainWindow = setMainWindow;
module.exports.commonUtils = commonUtils;
module.exports.usblanUtils = usblanUtils;
