// Copyright © 2017 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
const { app, BrowserWindow, dialog } = require('electron');
const path = require('path');
const url = require('url');
const ipcMain = require('electron').ipcMain;
const Menu = require('electron').Menu;
const os = require('os');
const fs = require('fs');
const utils = require('./js_main/utils');
const process = require('process');

var win;
var close_flg = true;
var froce_close = false;

global.sharedObject = {
    showExitPrompt: true,
    exitConfirmMessage: "",
    messageBoxTitle: "",
};

utils.RegisterUtilsFunctions(ipcMain);
function init() {
    createWindow();
}

function createWindow() {
    if(!process.argv.join(" ").endsWith("debug")){
        Menu.setApplicationMenu(null);
    }
    var icon_path = os.type().match(/windows/i) ? '/images/l-favicon.ico' : '/images/l-favicon.png';
    win = new BrowserWindow({
        width: 1020,
        height: 780,
        minWidth: 800,
        minHeight: 600,
        resizable: true,
        frame: true,
        icon: __dirname + icon_path,
        show: false,
        webPreferences: {
            nodeIntegration: false,
            preload: `${__dirname}/preload.js`,
            spellcheck: false,
            contextIsolation: true,
        }
    });
    utils.ux_log(1, "create windows");
    utils.setMainWindow(win);
    win.on('close', function (e) {
        if (global.sharedObject.showExitPrompt && !froce_close) {
            if (close_flg) {
                close_flg = false;
                var button = dialog.showMessageBoxSync(this, {
                    title: global.sharedObject.messageBoxTitle,
                    message: global.sharedObject.exitConfirmMessage,
                    buttons: ["Yes", "No"]
                });
                if (button != 0) {
                    e.preventDefault();
                }
                close_flg = true;
            } else {
                e.preventDefault();
            }
        }
    });
    win.on('closed', () => {
        win = null;
        utils.usblanUtils.disableUsbLan();
        utils.commonUtils.cleanEnv();
    });
    win.on('ready-to-show', () => {
        if(process.env['UXSPI_BOOTABLE']) {
            // this is a workaround for hide the gui when the steps isn't initialized finished.
            // set a timeout to show windows incase there is some issue will not maximize windows that will caused windows never to be shown.
            setTimeout(()=>{win.show();}, 5000);
        } else {
            win.show();
        }
    });

    const enforceInheritance = (topWebContents) => {
        const handle = (webContents) => {
            webContents.setWindowOpenHandler((details) => {
                return {
                    action: 'allow',
                    overrideBrowserWindowOptions: {
                        webPreferences: topWebContents.getLastWebPreferences()
                    }
                };
            });
        }
        handle(topWebContents);
    }
    enforceInheritance(win.webContents);

    ipcMain.on('reload', function (_) {
        win.reload();
    });
    ipcMain.on('close', function (_) {
        win.close();
    });
    ipcMain.on('maximize', function (_) {
        win.maximize();
    });

    win.loadURL(url.format({
        pathname: path.join(__dirname, 'index.html'),
        protocol: 'file',
        slashes: true
    }));
    if(process.argv.join(" ").endsWith("debug")){
        win.webContents.openDevTools();
    }
}
app.commandLine.appendSwitch('ignore-certificate-errors');
app.on('ready', init);
app.on('window-all-closed', () => {
    if (process.platform !== 'darwin') {
        app.quit();
    }
});
app.on('activate', () => {
    if (win === null) {
        init();
    }
});
app.on('before-quit', ()=>{
    utils.commonUtils.killOneCli()
});

ipcMain.on('alertMsg', function (event, msg) {
    if (close_flg) {
        close_flg = false;
        event.returnValue = dialog.showMessageBoxSync(win, {
            title: global.sharedObject.messageBoxTitle,
            message: msg,
            buttons: ["Ok"]
        });
        close_flg = true;
    }
});

ipcMain.on('confirmMsg', function (event, msg) {
    if (close_flg) {
        close_flg = false;
        event.returnValue = dialog.showMessageBoxSync(win, {
            title: global.sharedObject.messageBoxTitle,
            message: msg,
            buttons: ["Yes", "No"]
        });
        close_flg = true;
    }
});

ipcMain.on('confirmMsgWithCheckBox', async function (event, msg, checkboxMsg) {
    if (close_flg) {
        close_flg = false;
        event.returnValue = await dialog.showMessageBox(win, {
            title: global.sharedObject.messageBoxTitle,
            message: msg,
            buttons: ["Yes", "No"],
            checkboxLabel: checkboxMsg
        });
        close_flg = true;
    }
});

ipcMain.on('showOpenDialog', function (event, msg) {
    if (close_flg) {
        close_flg = false;
        event.returnValue = dialog.showOpenDialogSync(win, {
            properties: ['openDirectory']
        });
        close_flg = true;
    }
});

ipcMain.on('showOpenDialogFile', function (event, _defaultPath, _filterType) {
    if (close_flg) {
        close_flg = false;
        event.returnValue = dialog.showOpenDialogSync(win, {
            defaultPath: _defaultPath,
            properties: ['openFile'],
            filters: _filterType
        });
        close_flg = true;
    }
});

ipcMain.on('showSaveDialog', function (event, _defaultPath, _filterType) {
    if (close_flg) {
        close_flg = false;
        event.returnValue = dialog.showSaveDialogSync(win, {
            defaultPath: _defaultPath,
            filters: _filterType
        });
        close_flg = true;
    }
});

ipcMain.on('quitMsg', function (event, msg) {
    froce_close = true;
    app.quit();
});

ipcMain.on('setMessageBoxTitle', function (_, title) {
    global.sharedObject.messageBoxTitle = title;
});

ipcMain.on('setExitConfirmFlag', function (_, flag) {
    global.sharedObject.showExitPrompt = flag;
});

ipcMain.on('setExitConfirmMessage', function (_, msg) {
    global.sharedObject.exitConfirmMessage = msg;
});
