// preload with contextIsolation enabled
const { contextBridge, ipcRenderer } = require('electron')

function getUuid() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = (Math.random() * 16) | 0,
        v = c == 'x' ? r : (r & 0x3) | 0x8;
        return v.toString(16);
    });
}

contextBridge.exposeInMainWorld('xpress', {
    alertMsg: (msg) => ipcRenderer.sendSync('alertMsg', msg),
    showOpenDialog: (msg) => ipcRenderer.sendSync('showOpenDialog', msg),
    showOpenDialogFile: (_defaultPath, _filterType) => ipcRenderer.sendSync('showOpenDialogFile', _defaultPath, _filterType),
    showSaveDialog: (_defaultPath, _filterType) => ipcRenderer.sendSync('showSaveDialog', _defaultPath, _filterType),
    confirmMsg: (msg) => ipcRenderer.sendSync('confirmMsg', msg),
    confirmMsgWithCheckBox: (msg, checkboxMsg) => ipcRenderer.sendSync('confirmMsgWithCheckBox', msg, checkboxMsg),
    quitMsg: (msg) => ipcRenderer.sendSync('quitMsg', msg),
    setMessageBoxTitle: (title) => ipcRenderer.send('setMessageBoxTitle', title),
    setExitConfirmFlag: (flag) => ipcRenderer.send('setExitConfirmFlag', flag),
    setExitConfirmMessage: (msg) => ipcRenderer.send('setExitConfirmMessage', msg),
    runProgram: (args, workingDirectory, callback, msgs) => {
        const callbackName = "runProgram" + Date.now().toString() + getUuid();
        ipcRenderer.once(
            callbackName,
            (_, ...args) => {
                callback(...args)
            }
        )
        console.log(JSON.stringify(args));
        ipcRenderer.send('runProgram', args, workingDirectory, callbackName, msgs)
    },
    merge_compare_result:  (selected_list, callback, compare_rewrite_xml, compare_xml) => {
        const callbackName = "merge_compare_result" + Date.now().toString();
        ipcRenderer.once(
            callbackName,
            (_, ...args) => {
                callback(...args)
            }
        )
        ipcRenderer.send('merge_compare_result', selected_list, callbackName, compare_rewrite_xml, compare_xml)
    },
    write_acquire_xml:  (includeid_list, callback, acquire_xml) => {
        const callbackName = "write_acquire_xml" + Date.now().toString();
        ipcRenderer.once(
            callbackName,
            (_, ...args) => {
                callback(...args)
            }
        )
        ipcRenderer.send('write_acquire_xml', includeid_list, callbackName, acquire_xml)
    },
    write_config_batch_file_sync: (config_items, cmd, prefix, config_batch_file) => {
        return ipcRenderer.sendSync('write_config_batch_file_sync', config_items, cmd, prefix, config_batch_file);
    },
    read_config_batch_file_sync: (cmd, prefix, config_batch_file) => {
        return ipcRenderer.sendSync('read_config_batch_file_sync', cmd, prefix, config_batch_file);
    },
    generate_multi_server_task_file_sync: (server_list, multi_task_file) => {
        return ipcRenderer.sendSync('generate_multi_server_task_file_sync', server_list, multi_task_file);
    },
    enable_usblan: () => {
        ipcRenderer.send('enable_usblan');
    },

    utils: (funcName, ...args) => ipcRenderer.sendSync(funcName, ...args),
    reload: () => ipcRenderer.send('reload'),
    maximize: () => ipcRenderer.send('maximize'),
    close: () => ipcRenderer.send('close')
})
