﻿# =======================================================================================================================
# Script:    RVToolsPasswordEncryption.ps1
# Version:   1.0
# Date:      November, 2023
# By:        Dell Technologies
# ========================================================================================================================
#
# Note: PowerShell uses the Windows Data Protection API to encrypt/decrypt your password. 
# This effectively means that only the same user account on the same computer will be able to use this encrypted password.
#
# ========================================================================================================================


# Read password as secure string from host
$securepwd = Read-Host "Please enter your password" -AsSecureString

# Encrypt password
$encryptedpwd = $securepwd | ConvertFrom-SecureString

# Prefix the encrypted password with the string "_RVToolsV3PWD" so that RVTools understands what needs to be done
$encryptedpwd = '_RVToolsV3PWD' + $encryptedpwd

# Display encrypted password
write-host $encryptedpwd



# SIG # Begin signature block
# MIIrBwYJKoZIhvcNAQcCoIIq+DCCKvQCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCBnFZtTbgRs9/BM
# Q1l6npU+hQhoRRsIb2Vr7nknI08YqaCCEqIwggXfMIIEx6ADAgECAhBOQOQ3VO3m
# jAAAAABR05R/MA0GCSqGSIb3DQEBCwUAMIG+MQswCQYDVQQGEwJVUzEWMBQGA1UE
# ChMNRW50cnVzdCwgSW5jLjEoMCYGA1UECxMfU2VlIHd3dy5lbnRydXN0Lm5ldC9s
# ZWdhbC10ZXJtczE5MDcGA1UECxMwKGMpIDIwMDkgRW50cnVzdCwgSW5jLiAtIGZv
# ciBhdXRob3JpemVkIHVzZSBvbmx5MTIwMAYDVQQDEylFbnRydXN0IFJvb3QgQ2Vy
# dGlmaWNhdGlvbiBBdXRob3JpdHkgLSBHMjAeFw0yMTA1MDcxNTQzNDVaFw0zMDEx
# MDcxNjEzNDVaMGkxCzAJBgNVBAYTAlVTMRYwFAYDVQQKDA1FbnRydXN0LCBJbmMu
# MUIwQAYDVQQDDDlFbnRydXN0IENvZGUgU2lnbmluZyBSb290IENlcnRpZmljYXRp
# b24gQXV0aG9yaXR5IC0gQ1NCUjEwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIK
# AoICAQCngY/3FEW2YkPy2K7TJV5IT1G/xX2fUBw10dZ+YSqUGW0nRqSmGl33VFFq
# gCLGqGZ1TVSDyV5oG6v2W2Swra0gvVTvRmttAudFrnX2joq5Mi6LuHccUk15iF+l
# OhjJUCyXJy2/2gB9Y3/vMuxGh2Pbmp/DWiE2e/mb1cqgbnIs/OHxnnBNCFYVb5Cr
# +0i6udfBgniFZS5/tcnA4hS3NxFBBuKK4Kj25X62eAUBw2DtTwdBLgoTSeOQm3/d
# vfqsv2RR0VybtPVc51z/O5uloBrXfQmywrf/bhy8yH3m6Sv8crMU6UpVEoScRCV1
# HfYq8E+lID1oJethl3wP5bY9867DwRG8G47M4EcwXkIAhnHjWKwGymUfe5SmS1dn
# DH5erXhnW1XjXuvH2OxMbobL89z4n4eqclgSD32m+PhCOTs8LOQyTUmM4OEAwjig
# nPqEPkHcblauxhpb9GdoBQHNG7+uh7ydU/Yu6LZr5JnexU+HWKjSZR7IH9Vybu5Z
# HFc7CXKd18q3kMbNe0WSkUIDTH0/yvKquMIOhvMQn0YupGaGaFpoGHApOBGAYGuK
# Q6NzbOOzazf/5p1nAZKG3y9I0ftQYNVc/iHTAUJj/u9wtBfAj6ju08FLXxLq/f0u
# DodEYOOp9MIYo+P9zgyEIg3zp3jak/PbOM+5LzPG/wc8Xr5F0wIDAQABo4IBKzCC
# AScwDgYDVR0PAQH/BAQDAgGGMBIGA1UdEwEB/wQIMAYBAf8CAQEwHQYDVR0lBBYw
# FAYIKwYBBQUHAwMGCCsGAQUFBwMIMDsGA1UdIAQ0MDIwMAYEVR0gADAoMCYGCCsG
# AQUFBwIBFhpodHRwOi8vd3d3LmVudHJ1c3QubmV0L3JwYTAzBggrBgEFBQcBAQQn
# MCUwIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLmVudHJ1c3QubmV0MDAGA1UdHwQp
# MCcwJaAjoCGGH2h0dHA6Ly9jcmwuZW50cnVzdC5uZXQvZzJjYS5jcmwwHQYDVR0O
# BBYEFIK61j2Xzp/PceiSN6/9s7VpNVfPMB8GA1UdIwQYMBaAFGpyJnrQHu995ztp
# UdRsjZ+QEmarMA0GCSqGSIb3DQEBCwUAA4IBAQAfXkEEtoNwJFMsVXMdZTrA7LR7
# BJheWTgTCaRZlEJeUL9PbG4lIJCTWEAN9Rm0Yu4kXsIBWBUCHRAJb6jU+5J+Nzg+
# LxR9jx1DNmSzZhNfFMylcfdbIUvGl77clfxwfREc0yHd0CQ5KcX+Chqlz3t57jpv
# 3ty/6RHdFoMI0yyNf02oFHkvBWFSOOtg8xRofcuyiq3AlFzkJg4sit1Gw87kVlHF
# VuOFuE2bRXKLB/GK+0m4X9HyloFdaVIk8Qgj0tYjD+uL136LwZNr+vFie1jpUJuX
# bheIDeHGQ5jXgWG2hZ1H7LGerj8gO0Od2KIc4NR8CMKvdgb4YmZ6tvf6yK81MIIG
# RzCCBC+gAwIBAgIQKaK749v5RVZbhLuh2B/9HTANBgkqhkiG9w0BAQ0FADBPMQsw
# CQYDVQQGEwJVUzEWMBQGA1UEChMNRW50cnVzdCwgSW5jLjEoMCYGA1UEAxMfRW50
# cnVzdCBDb2RlIFNpZ25pbmcgQ0EgLSBPVkNTMjAeFw0yMzA1MjUxNTQ3MDlaFw0y
# NDA1MjUxNTQ3MDlaMIGKMQswCQYDVQQGEwJVUzEOMAwGA1UECBMFVGV4YXMxEzAR
# BgNVBAcTClJvdW5kIFJvY2sxHzAdBgNVBAoTFkRlbGwgVGVjaG5vbG9naWVzIElu
# Yy4xFDASBgNVBAsTC0xpdmUgT3B0aWNzMR8wHQYDVQQDExZEZWxsIFRlY2hub2xv
# Z2llcyBJbmMuMIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAvI1gH/3i
# Z1Uu92C/HXV6NjaFXwsOHHt2/nqmGkedwD5bamx4G1y96nfRLfUhPtvv0V+Nhj/7
# Es+YgXp4JoTHrbCrNThBf9/Rd/ZfcPCfgm1z7hZA65WpB9D3XWvfl992gF6hTNGc
# hCDX9SafKXBsuDeH6JuAzX+ktRO9Dk5uD1t/yItOM7BFUdycv7MzIb1UBtlFOJSE
# MsK8PQ0EnCcL3Q6pvZVoUv5yjNhwhO5HP2XBbvUClFtRpneWijWrlRv7r2riy9pT
# 96NMwNbhKbsIEiRWQbbDaV8z5y9XW9kS2wcsAXYEXNZUVhH8QCx3Z9VssTdr9DjP
# ZqtFhR6gZy97OCn4pgzcSGzoV+JAwKyVJoaLuE77I9HZWrzaWwPBmzJzKaAd55Hf
# 3EsRI4yFXO6KTHkCqOtjFuvLW1kUr7KNlmczt2zk/MfUg1jEjwkshgZAoqYVUnFG
# voVnmLB7HkkPXz0Yt2yfwHtEa27SWgVErwnTRyK5fdasdTfM4Bqw5f0/AgMBAAGj
# ggFhMIIBXTAMBgNVHRMBAf8EAjAAMB0GA1UdDgQWBBSPxKikPJ2NILZ9vVw3dvm5
# fqtJPjAfBgNVHSMEGDAWgBTvn7p5sHPyJR54nANSnBtThN6N7TBnBggrBgEFBQcB
# AQRbMFkwIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLmVudHJ1c3QubmV0MDIGCCsG
# AQUFBzAChiZodHRwOi8vYWlhLmVudHJ1c3QubmV0L292Y3MyLWNoYWluLnA3YzAx
# BgNVHR8EKjAoMCagJKAihiBodHRwOi8vY3JsLmVudHJ1c3QubmV0L292Y3MyLmNy
# bDAOBgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwTAYDVR0gBEUw
# QzA3BgpghkgBhvpsCgEDMCkwJwYIKwYBBQUHAgEWG2h0dHBzOi8vd3d3LmVudHJ1
# c3QubmV0L3JwYTAIBgZngQwBBAEwDQYJKoZIhvcNAQENBQADggIBAGrQbnjgLv6x
# JLtLYwqz6bKTkHeH3j9FlDdVn3uIpGOtgSuaI6CBal0Vy30bazihhPmYOArhTbWX
# o0TXsIxQG0KeBPpvrQMSC6Al+ZuOfj7jRglhwzpNLocWg5VRW0DbPBzK4Sar3Z91
# obFnhNQQogqWxktuU4UTU7vGbSjWOlOcBbx9EYZGWblGp2lBuq3E+ckucE5Sr/GV
# MNP8rhZTaJVwVVtCj8LtfbaMe7pMgX5OC/VPlpu237wZDVSiUIwZGC3wbb3zar7S
# 5eWOgYXyw2Vj+0zft+8mkeN286WO0MUCR7NojUUtY81mpXpiHOMvhhBuXbqquw+/
# ZAzXQwn4sgkS6HI1/FdF8xWngRercpAv6JeT+I8MJ5kv5MVIZE9cElGuYb58bXwB
# 7dtHuuj6Y2chHFKxQP9G2KP4DXM1RVWp5ZJvSfIC9kdSsjRUdpYb017WuAgAncTO
# PCLuGkor/gyxAqKd+LQuzx7vv70gyRfQ7ZPbx8zMwR2jicbcuB+3veEF+WwwbHG1
# W3QP/+ENkeqI7ar2SU5SjGa/q9s1R+4IbeWAxfGlxSkYCo5TGlX5HVmLX+JsM6UV
# qdX5OPdxQdnwJcDvbiTVcLOtezKLgASJtDSMhfllVRFfoTIKBzBQ5G0pxIM0mFm7
# sYZlvW7yah+4aw9T2Sr46zZurMVJRIzBMIIGcDCCBFigAwIBAgIQce9VdK81VMNa
# LGn2b0trzTANBgkqhkiG9w0BAQ0FADBpMQswCQYDVQQGEwJVUzEWMBQGA1UECgwN
# RW50cnVzdCwgSW5jLjFCMEAGA1UEAww5RW50cnVzdCBDb2RlIFNpZ25pbmcgUm9v
# dCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIENTQlIxMB4XDTIxMDUwNzE5MjA0
# NVoXDTQwMTIyOTIzNTkwMFowTzELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1
# c3QsIEluYy4xKDAmBgNVBAMTH0VudHJ1c3QgQ29kZSBTaWduaW5nIENBIC0gT1ZD
# UzIwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCemXYXGp5WFwhjLJNN
# g2GEMzQCttlioN7CDrkgTMhXnQ/dVFsNDNYB3S9I4ZEJ4dvIFQSCtnvw2NYwOxlx
# cPuoppf2KV2kDKn0Uz5X2wxObvx2218k6apfQ+OT5w7PyiW8xEwwC1oP5gb05W4M
# mWZYT4NhwnN8XCJvAUXFD/dAT2RL0BcKqQ4eAi+hj0zyZ1DbPuSfwk8/dOsxpNCU
# 0Jm8MJIJasskzaLYdlLQTnWYT2Ra0l6D9FjAXWp1xNg/ZDqLFA3YduHquWvnEXBJ
# EThjE27xxvq9EEU1B+Z2FdB1FqrCQ1f+q/5jc0YioLjz5MdwRgn5qTdBmrNLbB9w
# cqMH9jWSdBFkbvkC1cCSlfGXWX4N7qIl8nFVuJuNv83urt37DOeuMk5QjaHf0XO/
# wc5/ddqrv9CtgjjF54jtom06hhG317DhqIs7DEEXml/kW5jInQCf93PSw+mfBYd5
# IYPWC+3RzAif4PHFyVi6U1/Uh7GLWajSXs1p0D76xDkJr7S17ec8+iKH1nP5F5Vq
# wxz1VXhf1PoLwFs/jHgVDlpMOm7lJpjQJ8wg38CGO3qNZUZ+2WFeqfSuPtT8r0XH
# OrOFBEqLyAlds3sCKFnjhn2AolhAZmLgOFWDq58pQSa6u+nYZPi2uyhzzRVK155z
# 42ZMsVGdgSOLyIZ3srYsNyJwIQIDAQABo4IBLDCCASgwEgYDVR0TAQH/BAgwBgEB
# /wIBADAdBgNVHQ4EFgQU75+6ebBz8iUeeJwDUpwbU4Teje0wHwYDVR0jBBgwFoAU
# grrWPZfOn89x6JI3r/2ztWk1V88wMwYIKwYBBQUHAQEEJzAlMCMGCCsGAQUFBzAB
# hhdodHRwOi8vb2NzcC5lbnRydXN0Lm5ldDAxBgNVHR8EKjAoMCagJKAihiBodHRw
# Oi8vY3JsLmVudHJ1c3QubmV0L2NzYnIxLmNybDAOBgNVHQ8BAf8EBAMCAYYwEwYD
# VR0lBAwwCgYIKwYBBQUHAwMwRQYDVR0gBD4wPDAwBgRVHSAAMCgwJgYIKwYBBQUH
# AgEWGmh0dHA6Ly93d3cuZW50cnVzdC5uZXQvcnBhMAgGBmeBDAEEATANBgkqhkiG
# 9w0BAQ0FAAOCAgEAXvOGmTXBee7wEK/XkkPShdBb4Jig4HFRyRTLUJpgDrAEJkmx
# z+m6mwih2kNd1G8jorn4QMdH/k0BC0iQP8jcarQ+UzUovkBKR4VqHndAzIB/YbQ8
# T3mo5qOmoH5EhnG/EhuVgXL3DaXQ3mefxqK48Wr5/P50ZsZk5nk9agNhTksfzCBi
# ywIY7GPtfnE/lroLXmgiZ+wfwNIFFmaxsqTq/MWVo40SpfWN7xsgzZn35zLzWXEf
# 3ZTmeeVSIxBWKvxZOL+/eSWSasf9q2d3cbEEfTWtFME+qPwjF1YIGHzXeiJrkWrM
# NUVtTzudQ50FuJ3z/DQhXAQYMlc4NMHKgyNGpogjIcZ+FICrse+7C6wJP+5TkTGz
# 4lREqrV9MDwsI5zoP6NY6kAIF6MgX3rADNuq/wMWAw10ZCKalF4wNXYT9dPh4+AH
# ytnqRYhGnFTVEOLzMglAtudcFzL+zK/rbc9gPHXz7lxgQFUbtVmvciNoTZx0BAwQ
# ya9QW6cNZg+W5ZqV4CCiGtCw7jhJnipnnpGWbJjbxBBtYHwebkjntn6vMwcSce+9
# lTu+qYPUQn23pzTXX4aRta9WWNpVfRe927zNZEEVjTFRBk+0LrKLPZzzTeNYA1TM
# rIj4UjxOS0YJJRn/FeenmEYufbrq4+N8//m5GZW+drkNebICURpKyJ+IwkMxghe7
# MIIXtwIBATBjME8xCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1FbnRydXN0LCBJbmMu
# MSgwJgYDVQQDEx9FbnRydXN0IENvZGUgU2lnbmluZyBDQSAtIE9WQ1MyAhAporvj
# 2/lFVluEu6HYH/0dMA0GCWCGSAFlAwQCAQUAoHwwEAYKKwYBBAGCNwIBDDECMAAw
# GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
# AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIEbUc0vln/5cD9YUkHOS7Y4BM5yKTMhm
# uuTImrRu8LSNMA0GCSqGSIb3DQEBAQUABIIBgId5YWk4UhCP1dkiqW1rCJImlLwD
# R2ZA9Scaht6FuG/F/2OPku+wGS8EUWPV4vNTrpARrwZ1Uj5FW8ZCQJpqFGMtAHsq
# fS/BK5SdbBuh/M5MtdmwQ4ieHvwdf/L2jKwCfTbGXgLJEuWRMwmVaOuCEOYbXdCO
# VFr4E1J4Ywvjnrmt6uMsuyJz6rqkkJk6hjhDhiUAm5in/2y9HxgImRuTSHR5b06H
# 1zkDhGe/IUl9agRJ5OFlcuV+Sza3+VWd1zNyEhdAG+ROSwRqNhjrBE/uHtdHndjp
# ZpnnfPTcrqiaVnZ68dtx+ofC+xArYYubO/+kbRsPdmk+tuYUKPTIlV+kcQSA7HGT
# 89aoBsP41is1woN0tvcuXk06rQNiF5Dn0+rZ968EBSp+GunDgMtgDJM8cFKXCKrW
# aWMiZF+D+C03k9nJjnSYf530sfeuVbzJD1IWxAyK8K87CJ2Sgs+14ybjzLQEQ9r+
# UZKuaojIf1Tg84u+AbbdULCMNmHaUfguMJNG4qGCFSswghUnBgorBgEEAYI3AwMB
# MYIVFzCCFRMGCSqGSIb3DQEHAqCCFQQwghUAAgEDMQ0wCwYJYIZIAWUDBAIBMIHz
# BgsqhkiG9w0BCRABBKCB4wSB4DCB3QIBAQYKYIZIAYb6bAoDBTAxMA0GCWCGSAFl
# AwQCAQUABCByBr1B5QuPDnHz0uDWgp3FUmBXT7taTy6ZsTe1LZ0TQQIIa/RZMd7J
# IBQYDzIwMjMxMTMwMTc0ODA5WjADAgEBoHmkdzB1MQswCQYDVQQGEwJDQTEQMA4G
# A1UECBMHT250YXJpbzEPMA0GA1UEBxMGT3R0YXdhMRYwFAYDVQQKEw1FbnRydXN0
# LCBJbmMuMSswKQYDVQQDEyJFbnRydXN0IFRpbWVzdGFtcCBBdXRob3JpdHkgLSBU
# U0ExoIIPWDCCBCowggMSoAMCAQICBDhj3vgwDQYJKoZIhvcNAQEFBQAwgbQxFDAS
# BgNVBAoTC0VudHJ1c3QubmV0MUAwPgYDVQQLFDd3d3cuZW50cnVzdC5uZXQvQ1BT
# XzIwNDggaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwo
# YykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTMwMQYDVQQDEypFbnRydXN0Lm5l
# dCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAoMjA0OCkwHhcNOTkxMjI0MTc1MDUx
# WhcNMjkwNzI0MTQxNTEyWjCBtDEUMBIGA1UEChMLRW50cnVzdC5uZXQxQDA+BgNV
# BAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBpbmNvcnAuIGJ5IHJlZi4gKGxp
# bWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0
# ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRpZmljYXRpb24gQXV0aG9yaXR5
# ICgyMDQ4KTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK1NS6kShrLq
# oyAHFRZkKitL0b8LSk2O7YB2pWe3eEDAc0LIaMDbUyvdXrh2mDWTixqdfBM6Dh9b
# tx7P5SQUHrGBqY19uMxrSwPxAgzcq6VAJAB/dJShnQgps4gL9Yd3nVXN5MN+12pk
# q4UUhpVblzJQbz3IumYM4/y9uEnBdolJGf3AqL2Jo2cvxp+8cRlguC3pLMmQdmZ7
# lOKveNZlU1081pyyzykD+S+kULLUSM4FMlWK/bJkTA7kmAd123/fuQhVYIUwKfl7
# SKRphuM1Px6GXXp6Fb3vAI4VIlQXAJAmk7wOSWiRv/hH052VQsEOTd9vJs/DGCFi
# ZkNw1tXAB+ECAwEAAaNCMEAwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMB
# Af8wHQYDVR0OBBYEFFXkgdERgL7YibkIozH5oSQJFrlwMA0GCSqGSIb3DQEBBQUA
# A4IBAQA7m49WmzDnU5l8enmnTZfXGZWQ+wYfyjN8RmOPlmYk+kAbISfK5nJz8k/+
# MZn9yAxMaFPGgIITmPq2rdpdPfHObvYVEZSCDO4/la8Rqw/XL94fA49XLB7Ju5oa
# RJXrGE+mH819VxAvmwQJWoS1btgdOuHWntFseV55HBTF49BMkztlPO3fPb6m5ZUa
# w7UZw71eW7v/I+9oGcsSkydcAy1vMNAethqs3lr30aqoJ6b+eYHEeZkzV7oSsKng
# QmyTylbe/m2ECwiLfo3q15ghxvPnPHkvXpzRTBWN4ewiN8yaQwuX3ICQjbNnm29I
# CBVWz7/xK3xemnbpWZDFfIM1EWVRMIIFEzCCA/ugAwIBAgIMWNoT/wAAAABRzg33
# MA0GCSqGSIb3DQEBCwUAMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UE
# CxQ3d3d3LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGlt
# aXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRl
# ZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
# KDIwNDgpMB4XDTE1MDcyMjE5MDI1NFoXDTI5MDYyMjE5MzI1NFowgbIxCzAJBgNV
# BAYTAlVTMRYwFAYDVQQKEw1FbnRydXN0LCBJbmMuMSgwJgYDVQQLEx9TZWUgd3d3
# LmVudHJ1c3QubmV0L2xlZ2FsLXRlcm1zMTkwNwYDVQQLEzAoYykgMjAxNSBFbnRy
# dXN0LCBJbmMuIC0gZm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxJjAkBgNVBAMTHUVu
# dHJ1c3QgVGltZXN0YW1waW5nIENBIC0gVFMxMIIBIjANBgkqhkiG9w0BAQEFAAOC
# AQ8AMIIBCgKCAQEA2SPmFKTofEuFcVj7+IHmcotdRsOIAB840Irh1m5WMOWv2mRQ
# fcITOfu9ZrTahPuD0Cgfy3boYFBpm/POTxPiwT7B3xLLMqP4XkQiDsw66Y1JuWB0
# yN5UPUFeQ18oRqmmt8oQKyK8W01bjBdlEob9LHfVxaCMysKD4EdXfOdwrmJFJzEY
# CtTApBhVUvdgxgRLs91oMm4QHzQRuBJ4ZPHuqeD347EijzRaZcuK9OFFUHTfk5em
# NObQTDufN0lSp1NOny5nXO2W/KW/dFGI46qOvdmxL19QMBb0UWAia5nL/+FUO7n7
# RDilCDkjm2lH+jzE0Oeq30ay7PKKGawpsjiVdQIDAQABo4IBIzCCAR8wEgYDVR0T
# AQH/BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAQYwOwYDVR0gBDQwMjAwBgRVHSAA
# MCgwJgYIKwYBBQUHAgEWGmh0dHA6Ly93d3cuZW50cnVzdC5uZXQvcnBhMDMGCCsG
# AQUFBwEBBCcwJTAjBggrBgEFBQcwAYYXaHR0cDovL29jc3AuZW50cnVzdC5uZXQw
# MgYDVR0fBCswKTAnoCWgI4YhaHR0cDovL2NybC5lbnRydXN0Lm5ldC8yMDQ4Y2Eu
# Y3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMB0GA1UdDgQWBBTDwnHSe9doBa47OZs0
# JQxiA8dXaDAfBgNVHSMEGDAWgBRV5IHREYC+2Im5CKMx+aEkCRa5cDANBgkqhkiG
# 9w0BAQsFAAOCAQEAHSTnmnRbqnD8sQ4xRdcsAH9mOiugmjSqrGNtifmf3w13/SQj
# /E+ct2+P8/QftsH91hzEjIhmwWONuld307gaHshRrcxgNhqHaijqEWXezDwsjHS3
# 6FBD08wo6BVsESqfFJUpyQVXtWc26Dypg+9BwSEW0373LRFHZnZgghJpjHZVcw/f
# L0td6Wwj+Af2tX3WaUWcWH1hLvx4S0NOiZFGRCygU6hFofYWWLuRE/JLxd8LwOeu
# KXq9RbPncDDnNI7revbTtdHeaxOZRrOL0k2TdbXxb7/cACjCJb+856NlNOw/DR2X
# jPqqiCKkGDXbBY524xDIKY9j0K6sGNnaxJ9REjCCBg8wggT3oAMCAQICEFarlXUo
# nKWfDhfUC+oFwx8wDQYJKoZIhvcNAQELBQAwgbIxCzAJBgNVBAYTAlVTMRYwFAYD
# VQQKEw1FbnRydXN0LCBJbmMuMSgwJgYDVQQLEx9TZWUgd3d3LmVudHJ1c3QubmV0
# L2xlZ2FsLXRlcm1zMTkwNwYDVQQLEzAoYykgMjAxNSBFbnRydXN0LCBJbmMuIC0g
# Zm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxJjAkBgNVBAMTHUVudHJ1c3QgVGltZXN0
# YW1waW5nIENBIC0gVFMxMB4XDTIyMTAwNDE3MjEwM1oXDTI5MDEwMTAwMDAwMFow
# dTELMAkGA1UEBhMCQ0ExEDAOBgNVBAgTB09udGFyaW8xDzANBgNVBAcTBk90dGF3
# YTEWMBQGA1UEChMNRW50cnVzdCwgSW5jLjErMCkGA1UEAxMiRW50cnVzdCBUaW1l
# c3RhbXAgQXV0aG9yaXR5IC0gVFNBMTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC
# AgoCggIBAMHqoyWORTQXyvWzxRnMCLMLE06gcvbupHZQWA9G2BfpuHdUaYBxuopf
# WGc+Z1jvTlDN+sbZbhMzj63Drkb2Z05tQzeLid34F53T0un5YkP+pKRU6cq3muBK
# KvliEdCtZ1xY/hpMSWpfFh+0ZZQeEBaUm3ft850bUl8ZGXXb7s9nWa3LLkpjDrGC
# d1pvY03ouCLsLwrbTJslnoMrZBm2t3Slw7pMDU2vA+YWbeTwGLOjZ8VXrO6zL69+
# fCuGem2yydoUUjK2MVAm6vZPMAqpOBXDqop0SC9Gd/8FhMin5GCF+bzZhiCqDNyp
# oz/8k5RLlazbVLWvw/19LkHjoyCGUEVB1C42MSj2Ci/3wTrNBhQ++qdJwVRKusB+
# 50kHhEpcma5nAgRIqbTlxR3tjx2xPyTCBwdiHEvFNulU6otrnXRL+qoBJydPuvp9
# J83tZo0neBcOvIdzzm19yY6WOKJLFexXQHimwIHZyQNs2+Mv8cqCq0B9rJpwGuLf
# PptYZCtrbw9oHiVnPnrdAb5jlFHTWoR0so8p2i8kurbPbkvNDb+B3pG3NeaShS0D
# wZ8UwsVc33koOgh4Y+4hqzJ1gN/1BA7fRtzGqbOazXbbc1cfDA0w/W91CbyfizO7
# 8GQ8/LndYoOyvJeslzHoOcXMsku/l2SY3S4q/sQn8FcVTVFPhK0DAgMBAAGjggFb
# MIIBVzAMBgNVHRMBAf8EAjAAMB0GA1UdDgQWBBRKDtGm6oLNjldj7P2+AzdAkCSj
# 2DAfBgNVHSMEGDAWgBTDwnHSe9doBa47OZs0JQxiA8dXaDBoBggrBgEFBQcBAQRc
# MFowIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLmVudHJ1c3QubmV0MDMGCCsGAQUF
# BzAChidodHRwOi8vYWlhLmVudHJ1c3QubmV0L3RzMS1jaGFpbjI1Ni5jZXIwMQYD
# VR0fBCowKDAmoCSgIoYgaHR0cDovL2NybC5lbnRydXN0Lm5ldC90czFjYS5jcmww
# DgYDVR0PAQH/BAQDAgeAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMEIGA1UdIAQ7
# MDkwNwYKYIZIAYb6bAoBBzApMCcGCCsGAQUFBwIBFhtodHRwczovL3d3dy5lbnRy
# dXN0Lm5ldC9ycGEwDQYJKoZIhvcNAQELBQADggEBALHAWjNiHGozMuYkMD5vxuaw
# UjQdqUg7Bw3ukGTEqsqtexpHb4H3zzHEwvoGKLkXvC6EDtJHNf6ueOdjFeDaJQSx
# Y9MLw+ujjEEpEeXqmO7I3cUV9sdUGv5Ujbso9gUbBIKoM4aWyI+0wiAFRAsCW6Mm
# WuxMtGm+2PxARF3Fx0FuPze1eBPmlRTt3s7KhLPQ288roPzus/6IAF+msHnZmg8/
# XZfln0IPHOfvsOmvcw24eZoCV5prbEsUKs6uVabPseuxoWDebdwvJlPhPXMusQic
# cocpyIVQiMzqXwickHqqyrCb6upAM+IiFdLRd36/GJgivr3ySD/MAtLStuubSaQx
# ggSYMIIElAIBATCBxzCBsjELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1c3Qs
# IEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50cnVzdC5uZXQvbGVnYWwtdGVybXMx
# OTA3BgNVBAsTMChjKSAyMDE1IEVudHJ1c3QsIEluYy4gLSBmb3IgYXV0aG9yaXpl
# ZCB1c2Ugb25seTEmMCQGA1UEAxMdRW50cnVzdCBUaW1lc3RhbXBpbmcgQ0EgLSBU
# UzECEFarlXUonKWfDhfUC+oFwx8wCwYJYIZIAWUDBAIBoIIBpTAaBgkqhkiG9w0B
# CQMxDQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTIzMTEzMDE3NDgwOVow
# KQYJKoZIhvcNAQk0MRwwGjALBglghkgBZQMEAgGhCwYJKoZIhvcNAQELMC8GCSqG
# SIb3DQEJBDEiBCDZcnz4hBZlwIcJMQ2wZ76Vmln6E2K4b8rHUqS58l2srjCCAQsG
# CyqGSIb3DQEJEAIvMYH7MIH4MIH1MIHyBCDuYRmrup3Fu4wsgb75vu6ODiX92F6z
# 8aY1NSaB2baLrzCBzTCBuKSBtTCBsjELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVu
# dHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50cnVzdC5uZXQvbGVnYWwt
# dGVybXMxOTA3BgNVBAsTMChjKSAyMDE1IEVudHJ1c3QsIEluYy4gLSBmb3IgYXV0
# aG9yaXplZCB1c2Ugb25seTEmMCQGA1UEAxMdRW50cnVzdCBUaW1lc3RhbXBpbmcg
# Q0EgLSBUUzECEFarlXUonKWfDhfUC+oFwx8wCwYJKoZIhvcNAQELBIICAKE0s8VU
# rTjUFLbEaU/JwKzQybPDAM6FW1bX2asJ1fmyjpDOT7Ne+7aFqUyPlr0iTkXy45W6
# 8qqabAwoiujCpCnF4y2Wfbf0cFZqAzv2TLXgiOadbooBq2kNC37ZwjJBylZ1Q8vq
# vp7od6YKuDx+e7TEI8Lh+gvYB2TUzbcL94Ds98Uo7PCd8Sp/zhwntNMeVTvRL3vX
# KQ0JY8jXVpDqUCgjrnTkQYvVGJcm3+eSPtFvZrNmoOUPJ6Ks+yfcHUn52UBVWzjG
# pQAXLOuGqZziq/gqYdi+rd2dbqVGVcckD8ylXsh+ZkV+bKHNRWmHcWazv/gvCv41
# COKNp620UEWfieQJHnaWs4uVUsiwvDoT4mgGeYnd1bCbfu4ZOKvBfXt5qjKw1uW8
# r26a9aGrXzguU215xbi4DnRsn+848f6JI7xez6BMegx4ofOb3ReQ7MCZ7TpLr6MB
# lPokmxOlgvCXX3RjfFOpOUdXLhKxuvTkxKDCHYaHRNumyhe12XyAl+EhDoYS6i3W
# Wv69mzZs5pruPlkd4w1/UvxXEIc3ql6i4fSC5l8aLJr9kUz8xQC553GqMAxlNI7k
# RRydqUDR7v84c4XrvZxfGJ8xG3ZZ6NysHPiKd778N+SJ9O1E9LfhaPIjp38TTWAK
# awYDPG1ZzjC67rjwWqC4IpXT2485AI1sJOkc
# SIG # End signature block
