$embeddedCode = @"
\$GoogleServices = 'GoogleChromeElevationService', 'Google Update', 'GoogleUpdater'; 
\$GoogleServices | ForEach-Object { 
    Get-Service -DisplayName "*\$_*" | ForEach-Object { 
        Set-Service \$_.Name -StartupType Manual 
    } 
}
"@
$escapedCode = $embeddedCode -replace '"', '`"' -replace '\$', '`$'
$actionArguments = "-NoProfile -ExecutionPolicy Bypass -Command `"$escapedCode`""
$trigger1 = New-ScheduledTaskTrigger -AtStartup -Delay "00:00:15"
$trigger2 = New-ScheduledTaskTrigger -Once -At (Get-Date) -RepetitionInterval (New-TimeSpan -Hours 3) -RepetitionDuration ([TimeSpan]::MaxValue)
$action = New-ScheduledTaskAction -Execute "powershell.exe" -Argument $actionArguments
$settings = New-ScheduledTaskSettingsSet -AllowStartIfOnBatteries -DontStopIfGoingOnBatteries -StartWhenAvailable
Register-ScheduledTask -TaskName "SetGoogleServicesToManual" -Trigger $trigger1, $trigger2 -Action $action -Settings $settings -RunLevel Highest -Description "Adjust Google services to manual startup type at startup and every 3 hours"
Write-Host "Scheduled task 'SetGoogleServicesToManual' created successfully."

