Import-Module -Name 'NetSecurity'
 
# Setup windows update service to manual
$wuauserv = Get-WmiObject Win32_Service -Filter "Name = 'wuauserv'"
$wuauserv_starttype = $wuauserv.StartMode
Set-Service wuauserv -StartupType Manual
 
# Install OpenSSH
Add-WindowsCapability -Online -Name OpenSSH.Server~~~~0.0.1.0
 
# Set service to automatic and start
Set-Service sshd -StartupType Automatic
Start-Service sshd
 
# Setup windows update service to original
Set-Service wuauserv -StartupType $wuauserv_starttype
 
# Configure PowerShell as the default shell
New-ItemProperty -Path "HKLM:\SOFTWARE\OpenSSH" -Name DefaultShell -Value "$Env:SystemRoot\System32\WindowsPowerShell\v1.0\powershell.exe" -PropertyType String -Force
 
# Restart the service
Restart-Service sshd
 
# Configure SSH public key
$content = @"
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQDD35liaNzMHqhrCSQ5jHVpINJHQ3/Ym6Z5v28rwjpEbDhtgiIvknPg8oi6LTFlbWW/1vXjKnoqy6Dm0mOM+U2aO9OVc0J2gNZ+l2QNh0Jyf4Ra0X0mt2Cue3EHoGR2RogusmO+wovI4cD/bYHTcsK9vBLAOwSgeixQcZqXIUUnG3eLXd8HrMd9hse+Z3ClwxWXEQgxXbukT1b80oWrIzZRmr+XWklDJZYbnR6IFsIAiCkikDLO5ylVGn19xh+FExw+09ylgjFA8cXLLtYsOwx6XU2EJPNLRhQkwnsALUo08wJAcFcKuEnFvwcVBKT6Z9rmSEWq8LS16ri98B8SZmjdgNSacprAyoRC+N3b5VVdzTPV4oQtDMpTb8iwPKPuK9rCY1csVgsmTB7pv1WpuNJWsaqHUi/5R041ftLX7BTTrMz6t22fuHRJBJ0/FZOSqiL1nEsQGVoL+UsRmWA7P3X8W8kpwGGV58CQfiv14d9KMQU+NJbJ8L3+VAUsgXj+iG8= kladmin@hcc05
"@
 
# Write public key to file
$content | Set-Content -Path "$Env:ProgramData\ssh\administrators_authorized_keys"
 
# set acl on administrators_authorized_keys
$admins = ([System.Security.Principal.SecurityIdentifier]'S-1-5-32-544').Translate( [System.Security.Principal.NTAccount]).Value
$acl = Get-Acl $Env:ProgramData\ssh\administrators_authorized_keys
$acl.SetAccessRuleProtection($true, $false)
$administratorsRule = New-Object system.security.accesscontrol.filesystemaccessrule($admins,"FullControl","Allow")
$systemRule = New-Object system.security.accesscontrol.filesystemaccessrule("SYSTEM","FullControl","Allow")
$acl.SetAccessRule($administratorsRule)
$acl.SetAccessRule($systemRule)
$acl | Set-Acl
 
# Open firewall port 22
$FirewallParams = @{ 
  "DisplayName"       = 'OpenSSH SSH Server (sshd)'
  "Direction"         = 'Inbound'
  "Action"            = 'Allow'
  "Protocol"          = 'TCP'
  "LocalPort"         = '22'
  "Program"           = '%SystemRoot%\system32\OpenSSH\sshd.exe'
}
New-NetFirewallRule @FirewallParams