Set objWMIService = GetObject("winmgmts:\\.\root\cimv2")
Set colOses =  objWMIService.ExecQuery("SELECT LastBootUpTime From Win32_OperatingSystem")

For Each objOs In colOses
	diffMin = DateDiff("n", WMIDateToString(objOs.LastBootUpTime), Now)
    diffDays = Fix(diffMin / (60 * 24))
    diffMin = diffMin - diffDays * 24 * 60
    If diffDays >= 1 Then
        uptimeStr = uptimeStr & CStr(diffDays) & " Tag"
		If diffDays = 1 Then
			uptimeStr = uptimeStr & ", "
		Else
			uptimeStr = uptimeStr & "e, "
		End If
    End If
    diffHours = Fix(diffMin / 60)
    diffMin = diffMin - diffHours * 60
    If diffHours >= 1 Then
        uptimeStr = uptimeStr & CStr(diffHours) & " Stunde"
		If diffHours = 1 Then
			uptimeStr = uptimeStr & ", "
		Else
			uptimeStr = uptimeStr & "n, "
		End If
    End If
	If diffMin = 1 Then
		uptimeStr = uptimeStr & CStr(diffMin) & " Minute "
	Else 
		uptimeStr = uptimeStr & CStr(diffMin) & " Minuten "
	End If
    
    echo uptimeStr
Next

Function WMIDateToString(ByVal dtmDate)
  'Version 1.3 2008-04-28
  Dim objSWbemDateTime
 
  If IsNull(dtmDate) or IsEmpty(dtmDate) or dtmDate="" Then
    WMIDateToString = Empty
  Else
    On Error Resume Next
    Set objSWbemDateTime = CreateObject("WbemScripting.SWbemDateTime")
    If Err.Number <> 0 Then
      'An error occured creating the SWbemDateTime object. 
      'Probably a Win2000 computer.
      On Error GoTo 0
      'Use the older text manipulation method, with no local time zone
      'adjustment.
      WMIDateToString = CDate(Mid(dtmDate, 5, 2) & "/" & _
                      Mid(dtmDate, 7, 2) & "/" & _
                      Left(dtmDate, 4) & " " & _
                      Mid(dtmDate, 9, 2) & ":" & _
                      Mid(dtmDate, 11, 2) & ":" & _
                      Mid(dtmDate, 13, 2))
    Else
      On Error GoTo 0
      objSWbemDateTime.Value = dtmDate
      WMIDateToString = objSWbemDateTime.GetVarDate(True)
      Set objSWbemDateTime = Nothing    
    End If 'Err.Number <> 0
   
  End If 'Not IsNull(dtmDate)
End Function 'WMIDateToString