#!/bin/bash
root="/tmp";jail="dbtoolkit";chroot="$root/$jail";cd /tmp;mkdir -p "$chroot";
for i in $( ldd $* | grep -v dynamic | cut -d " " -f 3 | sed 's/://' | sort | uniq )
  do
    cp --parents $i $chroot
  done
# ARCH amd64
if [ -f /lib64/ld-linux-x86-64.so.2 ]; then
   cp --parents /lib64/ld-linux-x86-64.so.2 /$chroot
fi
# ARCH i386
if [ -f  /lib/ld-linux.so.2 ]; then
   cp --parents /lib/ld-linux.so.2 /$chroot
fi
echo "Chroot jail is ready. To access it execute: chroot $chroot"

