# Set the Google Auth parameters. Fill in your RefreshToken, ClientID, and ClientSecret
$params = @{
    Uri = 'https://accounts.google.com/o/oauth2/token'
    Body = @(
        "refresh_token=1", # Replace $RefreshToken with your refresh token
        "client_id=2",         # Replace $ClientID with your client ID
        "client_secret=3", # Replace $ClientSecret with your client secret
        "grant_type=refresh_token"
    ) -join '&'
    Method = 'Post'
    ContentType = 'application/x-www-form-urlencoded'
}
$accessToken = (Invoke-RestMethod @params).access_token

# Change this to the file you want to upload
$SourceFile = 'C:\tools\GoogleDriveSync\source\File2Upload.txt'
# 'E:\RZ2Google\QNAP_TS837.pdf'
# \\10.2.41.10\b1_shf\Attachments\Erweiterung\swa_ld\externalreport\U0000091\Support
# \\10.2.41.10\b1_shf\Attachments\Erweiterung\swa_ld\externalreport\U0000091\CoresuiteService\Werkzeuglistemitausgeg.anMAgruppiert.csv

$ScriptLog = 'C:\tools\GoogleDriveSync\GoogleDriveSync.ps1.log'

# Create the log file if it doesn't exist
if (-not (Test-Path $ScriptLog)) {
    $logHeader = 'Date,Time,Type,Message'
    $logHeader | Out-File -FilePath $ScriptLog -Encoding UTF8
}

# Function to write log entries
function Write-Log {
    param(
        [string]$Type,
        [string]$Message
    )

    $logEntry = "$(Get-Date -Format 'yyyy-MM-dd'),$(Get-Date -Format 'HH:mm:ss'),$Type,$Message"
    $logEntry | Out-File -FilePath $ScriptLog -Encoding UTF8 -Append

    # Output the log entry to the console
    Write-Host $logEntry
}

Write-Log -Type 'Start' -Message 'Script execution started.'

# Check if the file needs to be uploaded based on the hash comparison
$SourceFileHash = $SourceFile + '.hash'
$previousHash = ''
if (Test-Path $SourceFileHash) {
    $previousHash = Get-Content $SourceFileHash
}

$currentHash = Get-FileHash -Path $SourceFile | Select-Object -ExpandProperty Hash

if ($currentHash -eq $previousHash) {
    Write-Log -Type 'Info' -Message 'File hash is the same. No need to upload.'
    Write-Log -Type 'Stop' -Message 'Script execution stopped.'
    return
} else {
    Write-Log -Type 'Info' -Message 'File hash is different. Proceeding with the upload.'
    Set-Content -Path $SourceFileHash -Value $currentHash
}

# Get the source file contents and details, encode in base64
$sourceItem = Get-Item $SourceFile
$sourceBase64 = [Convert]::ToBase64String([IO.File]::ReadAllBytes($sourceItem.FullName))
$sourceMime = [System.Web.MimeMapping]::GetMimeMapping($sourceItem.FullName)

# If uploading to a Team Drive, set this to 'true'
$supportsTeamDrives = 'false'

# Set the file metadata
$uploadMetadata = @{
    originalFilename = $sourceItem.Name
    name = $sourceItem.Name
    description = $sourceItem.VersionInfo.FileDescription
    parents = @('11IKaf8aKOK4-zYs5hm5oqo7Mhj0KIZ_d') # Include to upload to a specific folder
    #teamDriveId = ‘teamDriveId’            # Include to upload to a specific teamdrive
}

# Set the upload body
$uploadBody = @"
--boundary
Content-Type: application/json; charset=UTF-8

$($uploadMetadata | ConvertTo-Json)

--boundary
Content-Transfer-Encoding: base64
Content-Type: $sourceMime

$sourceBase64
--boundary--
"@

# Set the upload headers
$uploadHeaders = @{
    "Authorization" = "Bearer $accessToken"
    "Content-Type" = 'multipart/related; boundary=boundary'
    "Content-Length" = $uploadBody.Length
}

# Perform the upload
$response = Invoke-RestMethod -Uri "https://www.googleapis.com/upload/drive/v3/files?uploadType=multipart&supportsTeamDrives=$supportsTeamDrives" -Method Post -Headers $uploadHeaders -Body $uploadBody

Write-Log -Type 'Stop' -Message 'Script execution stopped.'

