﻿Function Get-MDTIssues{
    $eventLog = Get-EventLog -LogName Application -Source MDT_Monitor -EntryType Warning,Error
    $eventLog.Message | ForEach-Object {$Event = $_ -replace "\s\{2}" -split 'for Computer ' -split ': '
    New-object psobject -property @{
        Computer = $($Event[1])
        Notification = $($Event[0])
        Message = $($Event[2])
        }
    }
}

#Header
#It is possible to use CSS instead, i'm just to lazy
$Head = "<style>"
$Head = $Head + "BODY{background-color:peachpuff;}"
$Head = $Head + "TABLE{border-width: 2px;border-style: solid;border-color: black;border-collapse: collapse;}"
$Head = $Head + "TH{border-width: 1px;padding: 0px;border-style: solid;border-color: black;background-color:thistle}"
$Head = $Head + "TD{border-width: 1px;padding: 0px;border-style: solid;border-color: black}"
$Head = $Head + "</style>"

#Title
$Title = "Deployment Issues"

#Converting output to HTML
$Output = Get-MDTIssues | Select @{n='Link';e={"<a href='$($_.Computer)'>$($_.Computer)</a>"}},Notification,Message | Sort-Object -Property Link |
ConvertTo-Html `
-Title $Title  `
-Head $Head  `
-Body (Get-Date -UFormat "%Y-%m-%d - %T ")  `
-PreContent "<H2>Deployment Status for: $ENV:COMPUTERNAME </H2><P>Generated by Power of the Shell</P>"  `
-PostContent "<P>For details, contact support@internet.com</P>"  `
-Property Link,Notification,Message 

#Converting HTML Output, since Convertto-html don't like HTML and mess it up
$OutputMod = $Output | `
ForEach {$_ -replace "&lt;a href=&#39;","<a href=http://$ENV:COMPUTERNAME/Logs/"} | `
ForEach {$_ -replace '&#39;&gt;','>'} | `
ForEach {$_ -replace '&lt;/a&gt;','</a>'}
$OutputMod > C:\MDTWeb\MDTIssues.htm
