function DisableIpHelper {
 $osVersion = [System.Environment]::OSVersion.Version
 if ($osVersion.Major -ne 10 -or $osVersion.Minor -ne 0 -or $osVersion.Build -ne 14393) {
  Write-Host "This script is intended for Windows Server 2016 only."
  Exit
 }
 $iphlpsvcStatus = Get-Service -Name "iphlpsvc" -ErrorAction SilentlyContinue
 if ($iphlpsvcStatus -eq $null -or $iphlpsvcStatus.Status -ne "Running") {
  Write-Host "The iphlpsvc service is not running."
  Exit
 }
 $iphlpsvcStartType = (Get-Service -Name "iphlpsvc").StartType
 if ($iphlpsvcStartType -ne "Automatic" -and $iphlpsvcStartType -ne "Automatic (Delayed Start)") {
  Write-Host "The iphlpsvc service is not set to start automatically (either Automatic or Automatic (Delayed Start))."
  Exit
 }
 $continue = Read-Host "All conditions are met. Do you want to continue? (Y/N)"
 if ($continue -ne "Y" -and $continue -ne "y") {
  Write-Host "Script execution aborted."
  Exit
 }
 Set-Service -Name "iphlpsvc" -StartupType Disabled
 Stop-Service -Name "iphlpsvc" -Force
 $iphlpsvcStatus = Get-Service -Name "iphlpsvc" -ErrorAction SilentlyContinue
 if ($iphlpsvcStatus -eq $null -or $iphlpsvcStatus.Status -ne "Stopped") {
  Write-Host "Failed to stop the iphlpsvc service."
 } else {
  Write-Host "The iphlpsvc service has been set to Disabled and stopped successfully."
 }
}
;
DisableIpHelper
;
