<#https://charbelnemnom.com/how-to-log-off-remote-desktop-user-sessions-in-remote-desktop-services-via-powershell-rds-ws12-ws12r2-vdi/
 #https://github.com/CharbelNemnom/Power-MVP-Elite/blob/master/Windows%20Server/Remote%20Desktop%20Services/RD-SessionSupportV2.0.zip
.SYNOPSIS
Select Remote Session State and log off the user sessions.

.DESCRIPTION
Select Remote Session State (Disconnected/Active/Idle/All) and log off the user sessions.

.NOTES
File Name: RDSessionSupport.ps1
Author : Charbel Nemnom
Version : 1.0
Requires : PowerShell Version 3.0 or above
OS : Windows Server 2012/R2 or above with Remote Desktop Connection Broker Role

.LINK
To provide feedback or for further assistance visit:
Cover Page


.EXAMPLE
Run the script as administrator and select your desired choice.
#>

Write-Host "=================================================="
Write-Host ""
Write-Host " PLEASE SELECT YOUR CHOICE "
Write-Host ""
Write-Host "=================================================="
Write-Host ""
Write-Host " A. End All Disconnected Remote User Sessions"
Write-Host " B. End All Active Remote User Sessions"
Write-Host " C. End All Idle Remote User Sessions"
Write-Host " D. End All Remote User Sessions"
Write-Host " X. Cancel and quit"
$choice = Read-Host "`nEnter your Selection"

Switch ($choice) {
"A" {$RDSessions = Get-RDUserSession | Where-Object -Filter {$_.SessionState -eq 'STATE_DISCONNECTED'} }
"B" {$RDSessions = Get-RDUserSession | Where-Object -Filter {$_.SessionState -eq 'STATE_ACTIVE'} }
"C" {$RDSessions = Get-RDUserSession | Where-Object -Filter {$_.SessionState -eq 'STATE_IDLE'} }
"D" {$RDSessions = Get-RDUserSession}
"X" {Exit}
}

If (!$RDSessions)
{
Write-Output "No Remote User Sessions found with Choice:" $choice
}
Else
{ # Start Loop
Foreach ($RDSession in $RDSessions)
{
Invoke-RDUserLogoff -UnifiedSessionID $RDSession.SessionId -HostServer $RDSession.HostServer -Force
Write-Output "The user" $RDSession.UserName "is logged off from" $RDSession.HostServer "server"
} # End Loop
} # End If

Read-Host "`nPress Enter to Exit <|"